/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.tools.lint.model.LintModelAndroidArtifact;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.DomExtensions;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/WearableConfigurationActionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "duplicateAction", "Lorg/w3c/dom/Element;", "foundAction", "foundCategory", "foundMetaData", "afterScanningManifest", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "beforeScanningManifest", "checkMergedProject", "visitIntentFilterTag", "intentFilter", "visitManifestElement", "", "element", "visitMetaData", "metaData", "Issues", "lint-checks"})
public final class WearableConfigurationActionDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @Nullable
    private Element duplicateAction;
    @Nullable
    private Element foundAction;
    @Nullable
    private Element foundCategory;
    @Nullable
    private Element foundMetaData;
    @NotNull
    public static final String WEARABLE_CONFIGURATION_ACTION = "com.google.android.wearable.watchface.wearableConfigurationAction";
    @NotNull
    public static final String CATEGORY_WEARABLE_CONFIGURATION = "com.google.android.wearable.watchface.category.WEARABLE_CONFIGURATION";
    @NotNull
    public static final String WATCH_FACE_EDITOR_ACTION = "androidx.wear.watchface.editor.action.WATCH_FACE_EDITOR";
    @JvmField
    @NotNull
    public static final Issue ACTION_DUPLICATE;
    @JvmField
    @NotNull
    public static final Issue CONFIGURATION_ACTION;

    public void checkMergedProject(@NotNull Context context) {
        LintModelAndroidArtifact lintModelAndroidArtifact;
        LintModelLibrary lintModelLibrary;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        LintModelVariant lintModelVariant = context.getProject().getBuildVariant();
        LintModelLibrary lintModelLibrary2 = lintModelVariant == null ? null : (lintModelLibrary = (lintModelAndroidArtifact = lintModelVariant.getMainArtifact()) == null ? null : lintModelAndroidArtifact.findCompileDependency("androidx.wear.watchface:watchface"));
        if (lintModelLibrary == null) {
            return;
        }
        this.beforeScanningManifest();
        Document document = context.getMainProject().getMergedManifest();
        Element element = document == null ? null : document.getDocumentElement();
        if (element == null) {
            return;
        }
        Element document2 = element;
        DomExtensions.visitElements((Element)document2, (Function1)((Function1)new Function1<Element, Boolean>(this){
            final /* synthetic */ WearableConfigurationActionDetector this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Element it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return WearableConfigurationActionDetector.access$visitManifestElement(this.this$0, it);
            }
        }));
        this.afterScanningManifest(context);
    }

    private final void beforeScanningManifest() {
        this.duplicateAction = null;
        this.foundAction = null;
        this.foundCategory = null;
        this.foundMetaData = null;
    }

    private final void afterScanningManifest(Context context) {
        Element duplicateAction = this.duplicateAction;
        Element foundAction = this.foundAction;
        Element foundMetaData = this.foundMetaData;
        Element foundCategory = this.foundCategory;
        if (duplicateAction != null) {
            context.report(new Incident(ACTION_DUPLICATE, (Object)duplicateAction, Context.getLocation$default((Context)context, (Object)duplicateAction, null, (int)2, null), "Duplicate watch face configuration activities found"));
        }
        if (foundMetaData != null && foundAction == null) {
            context.report(new Incident(CONFIGURATION_ACTION, (Object)foundMetaData, Context.getLocation$default((Context)context, (Object)foundMetaData.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name"), null, (int)2, null), "Watch face configuration activity is missing"));
        } else if (foundMetaData != null && foundAction != null && foundCategory == null) {
            context.report(new Incident(CONFIGURATION_ACTION, (Object)foundAction, Context.getLocation$default((Context)context, (Object)foundAction, null, (int)2, null), "Watch face configuration tag is required"), Constraints.minSdkLessThan((int)30));
        } else if (foundAction != null && foundMetaData == null) {
            context.report(new Incident(CONFIGURATION_ACTION, (Object)foundAction, Context.getLocation$default((Context)context, (Object)foundAction.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name"), null, (int)2, null), "`wearableConfigurationAction` metadata is missing"), Constraints.minSdkLessThan((int)30));
        }
    }

    private final boolean visitManifestElement(Element element) {
        String string = element.getTagName();
        if (Intrinsics.areEqual((Object)string, (Object)"meta-data")) {
            this.visitMetaData(element);
        } else if (Intrinsics.areEqual((Object)string, (Object)"intent-filter")) {
            this.visitIntentFilterTag(element);
        }
        return false;
    }

    private final void visitMetaData(Element metaData) {
        if (Intrinsics.areEqual((Object)metaData.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)WEARABLE_CONFIGURATION_ACTION) && Intrinsics.areEqual((Object)metaData.getAttributeNS("http://schemas.android.com/apk/res/android", "value"), (Object)WATCH_FACE_EDITOR_ACTION)) {
            this.foundMetaData = metaData;
        }
    }

    private final void visitIntentFilterTag(Element intentFilter) {
        Element tmpCategory = null;
        Element tmpAction = null;
        Iterator iterator = DomExtensions.childrenIterator((Node)intentFilter);
        while (iterator.hasNext()) {
            Node child = (Node)iterator.next();
            if ((child instanceof Element ? (Element)child : null) == null) continue;
            String string = ((Element)child).getTagName();
            if (Intrinsics.areEqual((Object)string, (Object)"action")) {
                if (!Intrinsics.areEqual((Object)((Element)child).getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)WATCH_FACE_EDITOR_ACTION)) continue;
                tmpAction = (Element)child;
                continue;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"category") || !Intrinsics.areEqual((Object)((Element)child).getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)CATEGORY_WEARABLE_CONFIGURATION)) continue;
            tmpCategory = (Element)child;
        }
        if (tmpAction != null && this.foundAction != null) {
            this.duplicateAction = tmpAction;
        } else if (tmpAction != null && this.foundAction == null) {
            this.foundAction = tmpAction;
            this.foundCategory = tmpCategory;
        }
    }

    public static final /* synthetic */ boolean access$visitManifestElement(WearableConfigurationActionDetector $this, Element element) {
        return $this.visitManifestElement(element);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(WearableConfigurationActionDetector.class, Scope.MANIFEST_SCOPE);
        ACTION_DUPLICATE = Issue.Companion.create$default((Issue.Companion)companion, (String)"WearableActionDuplicate", (String)"Duplicate watch face configuration activities found", (String)"\n                If and only if a watch face service defines `wearableConfigurationAction` metadata, with the value `WATCH_FACE_EDITOR`, \\\n                there should be an activity in the same package, which has an intent filter for `WATCH_FACE_EDITOR` \\\n                (with com.google.android.wearable.watchface.category.WEARABLE_CONFIGURATION if minSdkVersion is less than 30).\n            ", (Implementation)implementation, (String)"https://developer.android.com/training/wearables/watch-faces/configuration", (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = new Implementation(WearableConfigurationActionDetector.class, Scope.MANIFEST_SCOPE);
        CONFIGURATION_ACTION = Issue.Companion.create$default((Issue.Companion)companion, (String)"WearableConfigurationAction", (String)"Wear configuration action metadata must match an activity", (String)"\n                Only when a watch face service defines `wearableConfigurationAction` metadata, with the value `WATCH_FACE_EDITOR`, \\\n                there should be an activity in the same package, which has an intent filter for `WATCH_FACE_EDITOR` \\\n                (with `com.google.android.wearable.watchface.category.WEARABLE_CONFIGURATION` if `minSdkVersion` is less than 30).\n            ", (Implementation)implementation, (String)"https://developer.android.com/training/wearables/watch-faces/configuration", (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/WearableConfigurationActionDetector$Issues;", "", "()V", "ACTION_DUPLICATE", "Lcom/android/tools/lint/detector/api/Issue;", "CATEGORY_WEARABLE_CONFIGURATION", "", "CONFIGURATION_ACTION", "WATCH_FACE_EDITOR_ACTION", "WEARABLE_CONFIGURATION_ACTION", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

