/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/ExtraTextDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "errors", "", "warnings", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "visitDocument", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "document", "Lorg/w3c/dom/Document;", "visitNode", "node", "Lorg/w3c/dom/Node;", "Issues", "lint-checks"})
public final class ExtraTextDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Issues Issues = new Issues(null);
    private int warnings;
    private int errors;
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType != ResourceFolderType.VALUES && folderType != ResourceFolderType.XML && folderType != ResourceFolderType.RAW;
    }

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.warnings = 0;
        this.errors = 0;
        this.visitNode(context, document);
    }

    private final void visitNode(XmlContext context, Node node) {
        int n;
        int i;
        if (this.errors > 0) {
            return;
        }
        short nodeType = node.getNodeType();
        if (nodeType == 3) {
            String text = node.getNodeValue();
            i = 0;
            n = text.length();
            while (i < n) {
                char c = text.charAt(i);
                if (!Character.isWhitespace(c)) {
                    int n2;
                    String string;
                    boolean warnOnly;
                    Location location;
                    String snippet;
                    block13: {
                        boolean bl;
                        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                        CharSequence charSequence = StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)text)).toString(), (char)'\n', (char)' ', (boolean)false, (int)4, null);
                        Object object = new Regex("\\s+");
                        String string2 = " ";
                        snippet = object.replace(charSequence, string2);
                        int maxLength = 100;
                        if (snippet.length() > maxLength) {
                            object = snippet;
                            int n3 = 0;
                            Object object2 = object;
                            if (object2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string3 = ((String)object2).substring(n3, maxLength);
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            snippet = Intrinsics.stringPlus((String)string3, (Object)"...");
                        }
                        location = context.getLocation(node);
                        CharSequence $this$none$iv = text;
                        boolean $i$f$none = false;
                        CharSequence charSequence2 = $this$none$iv;
                        for (int j = 0; j < charSequence2.length(); ++j) {
                            char element$iv;
                            char it = element$iv = charSequence2.charAt(j);
                            boolean bl2 = false;
                            if (!Character.isJavaIdentifierPart(it)) continue;
                            bl = false;
                            break block13;
                        }
                        bl = warnOnly = true;
                    }
                    if (warnOnly && this.warnings != 0) break;
                    ResourceFolderType resourceFolderType = context.getResourceFolderType();
                    if (resourceFolderType == null) {
                        string = "manifest";
                    } else {
                        string = resourceFolderType.getName();
                        if (string == null) {
                            string = "manifest";
                        }
                    }
                    String type = string;
                    Incident incident = new Incident(ISSUE, (Object)node, location, "Unexpected text found in " + type + " file: \"" + snippet + '\"');
                    if (warnOnly) {
                        incident.overrideSeverity(Severity.WARNING);
                        n2 = this.warnings;
                        this.warnings = n2 + 1;
                    } else {
                        n2 = this.errors;
                        this.errors = n2 + 1;
                    }
                    context.report(incident);
                    break;
                }
                int n4 = i;
                i = n4 + 1;
            }
        }
        NodeList childNodes = node.getChildNodes();
        i = 0;
        n = childNodes.getLength();
        while (i < n) {
            Node child = childNodes.item(i);
            Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
            this.visitNode(context, child);
            int n5 = i;
            i = n5 + 1;
        }
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.RESOURCE_FILE_SCOPE, Scope.MANIFEST_SCOPE};
        ISSUE = Issue.Companion.create("ExtraText", "Extraneous text in resource files", "\n            Non-value resource files should only contain elements and attributes. Any XML text content found \\\n            in the file is likely accidental (and potentially dangerous if the text resembles XML and the \\\n            developer believes the text to be functional).\n            ", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(ExtraTextDetector.class, Scope.MANIFEST_AND_RESOURCE_SCOPE, enumSetArray));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/ExtraTextDetector$Issues;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

