/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.XmlUtils;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/NamespaceDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "unusedNamespaces", "", "", "Lorg/w3c/dom/Attr;", "checkCustomNamespace", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "checkRedundant", "checkUnused", "visitDocument", "document", "Lorg/w3c/dom/Document;", "Companion", "lint-checks"})
public final class NamespaceDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Map<String, Attr> unusedNamespaces;
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue TYPO;
    @JvmField
    @NotNull
    public static final Issue UNUSED;
    @JvmField
    @NotNull
    public static final Issue REDUNDANT;
    @JvmField
    @NotNull
    public static final Issue CUSTOM_VIEW;
    @JvmField
    @NotNull
    public static final Issue RES_AUTO;
    @NotNull
    private static final String XMLNS_A = "xmlns:a";

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        boolean haveCustomNamespace = false;
        Element root = document.getDocumentElement();
        NamedNodeMap attributes = root.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            Attr attribute;
            Node item = attributes.item(i);
            String prefix = item.getNodeName();
            Intrinsics.checkNotNullExpressionValue((Object)prefix, (String)"prefix");
            if (!StringsKt.startsWith$default((String)prefix, (String)"xmlns:", (boolean)false, (int)2, null)) continue;
            String value = item.getNodeValue();
            if (!Intrinsics.areEqual((Object)value, (Object)"http://schemas.android.com/apk/res/android")) {
                Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type org.w3c.dom.Attr");
                attribute = (Attr)item;
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                if (StringsKt.startsWith$default((String)value, (String)"http://schemas.android.com/apk/res/", (boolean)false, (int)2, null)) {
                    haveCustomNamespace = true;
                    Map map = this.unusedNamespaces;
                    if (map == null) {
                        NamespaceDetector $this$visitDocument_u24lambda_u2d0 = this;
                        boolean bl = false;
                        HashMap hashMap = new HashMap();
                        $this$visitDocument_u24lambda_u2d0.unusedNamespaces = hashMap;
                        map = hashMap;
                    }
                    Map namespaces = map;
                    String string = prefix.substring("xmlns:".length());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    namespaces.put((String)string, (Attr)attribute);
                } else {
                    if (StringsKt.startsWith$default((String)value, (String)"urn:", (boolean)false, (int)2, null)) continue;
                    if (!StringsKt.startsWith$default((String)value, (String)"http://", (boolean)false, (int)2, null)) {
                        if (!context.isEnabled(TYPO) || context.getResourceFolderType() == ResourceFolderType.XML) continue;
                        LintFix fix = null;
                        if (StringsKt.startsWith$default((String)value, (String)"https://", (boolean)false, (int)2, null)) {
                            LintFix.ReplaceStringBuilder replaceStringBuilder = this.fix().replace().text("https").with("http");
                            String string = value.substring(8);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                            fix = replaceStringBuilder.name("Replace with http://" + string).build();
                        }
                        context.report(TYPO, (Node)attribute, context.getValueLocation(attribute), "Suspicious namespace: should start with `http://`", fix);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)value, (Object)"http://schemas.android.com/apk/res-auto") && StringsKt.contains$default((CharSequence)value, (CharSequence)"auto", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)value, (String)"http://schemas.android.com/", (boolean)false, (int)2, null)) {
                        XmlContext.report$default((XmlContext)context, (Issue)RES_AUTO, (Node)attribute, (Location)context.getValueLocation(attribute), (String)"Suspicious namespace: Did you mean `http://schemas.android.com/apk/res-auto`?", null, (int)16, null);
                    } else if (Intrinsics.areEqual((Object)value, (Object)"http://schemas.android.com/tools") && (Intrinsics.areEqual((Object)prefix, (Object)"xmlns:android") || StringsKt.endsWith$default((String)prefix, (String)"app", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)prefix, (Object)"xmlns:app"))) {
                        XmlContext.report$default((XmlContext)context, (Issue)TYPO, (Node)attribute, (Location)context.getValueLocation(attribute), (String)"Suspicious namespace and prefix combination", null, (int)16, null);
                    }
                }
                if (!context.isEnabled(TYPO)) continue;
                String name = attribute.getName();
                if (!Intrinsics.areEqual((Object)name, (Object)"xmlns:android") && !Intrinsics.areEqual((Object)name, (Object)XMLNS_A)) {
                    String urlPrefix;
                    int resIndex = StringsKt.indexOf$default((CharSequence)value, (String)"/res/", (int)0, (boolean)false, (int)6, null);
                    if (resIndex == -1 || value.length() + 5 <= "http://schemas.android.com/apk/res/".length()) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)value.substring(0, resIndex + 5), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    if (Intrinsics.areEqual((Object)urlPrefix, (Object)"http://schemas.android.com/apk/res/") || !Lint.isEditableTo((String)"http://schemas.android.com/apk/res/", (String)urlPrefix, (int)3)) continue;
                    String string = value.substring(resIndex + 5);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    String correctUri = "http://schemas.android.com/apk/res/" + string;
                    XmlContext.report$default((XmlContext)context, (Issue)TYPO, (Node)attribute, (Location)context.getValueLocation(attribute), (String)("Possible typo in URL: was `\"" + value + "\"`, should probably be `\"" + correctUri + "\"`"), null, (int)16, null);
                    continue;
                }
                if (Intrinsics.areEqual((Object)name, (Object)XMLNS_A) && !Lint.isEditableTo((String)"http://schemas.android.com/apk/res/android", (String)value, (int)4)) continue;
                if (StringsKt.equals((String)value, (String)"http://schemas.android.com/apk/res/android", (boolean)true)) {
                    XmlContext.report$default((XmlContext)context, (Issue)TYPO, (Node)attribute, (Location)context.getValueLocation(attribute), (String)("URI is case sensitive: was `\"" + value + "\"`, expected `\"http://schemas.android.com/apk/res/android\"`"), null, (int)16, null);
                    continue;
                }
                XmlContext.report$default((XmlContext)context, (Issue)TYPO, (Node)attribute, (Location)context.getValueLocation(attribute), (String)("Unexpected namespace URI bound to the `\"android\"` prefix, was `" + value + "`, expected `http://schemas.android.com/apk/res/android`"), null, (int)16, null);
                continue;
            }
            if (Intrinsics.areEqual((Object)prefix, (Object)"xmlns:android") || (!StringsKt.endsWith$default((String)prefix, (String)"tools", (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)prefix, (Object)"xmlns:tools")) && (!StringsKt.endsWith$default((String)prefix, (String)"app", (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)prefix, (Object)"xmlns:app"))) continue;
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type org.w3c.dom.Attr");
            attribute = (Attr)item;
            XmlContext.report$default((XmlContext)context, (Issue)TYPO, (Node)attribute, (Location)context.getValueLocation(attribute), (String)"Suspicious namespace and prefix combination", null, (int)16, null);
        }
        if (haveCustomNamespace) {
            boolean checkUnused;
            boolean checkCustomAttrs;
            Project project = context.getProject();
            boolean bl = checkCustomAttrs = Intrinsics.areEqual((Object)project.getResourceNamespace(), (Object)ResourceNamespace.RES_AUTO) && (context.isEnabled(CUSTOM_VIEW) && project.isLibrary() || context.isEnabled(RES_AUTO) && project.isGradleProject());
            if (checkCustomAttrs) {
                Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
                this.checkCustomNamespace(context, root);
            }
            if (checkUnused = context.isEnabled(UNUSED)) {
                Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
                this.checkUnused(root);
                Map<String, Attr> namespaces = this.unusedNamespaces;
                if (namespaces != null && !namespaces.isEmpty()) {
                    for (Map.Entry<String, Attr> entry : namespaces.entrySet()) {
                        String prefix = entry.getKey();
                        Attr attribute = entry.getValue();
                        XmlContext.report$default((XmlContext)context, (Issue)UNUSED, (Node)attribute, (Location)context.getLocation((Node)attribute), (String)("Unused namespace `" + prefix + "`"), null, (int)16, null);
                    }
                }
            }
        }
        if (context.isEnabled(REDUNDANT)) {
            Element child = XmlUtils.getFirstSubTag((Node)root);
            while (child != null) {
                this.checkRedundant(context, child);
                child = XmlUtils.getNextTag((Node)child);
            }
        }
    }

    private final void checkUnused(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String urlNamespace;
            String attributeValue;
            Node node = attributes.item(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Attr");
            Attr attribute = (Attr)node;
            String prefix = attribute.getPrefix();
            if (prefix != null) {
                Map<String, Attr> map = this.unusedNamespaces;
                if (map != null) {
                    map.remove(prefix);
                }
            }
            if ((attributeValue = attribute.getNodeValue()) == null) continue;
            ResourceUrl resourceUrl = ResourceUrl.parse((String)attributeValue);
            String string = urlNamespace = resourceUrl != null ? resourceUrl.namespace : null;
            if (urlNamespace == null) continue;
            Map<String, Attr> map = this.unusedNamespaces;
            if (map == null) continue;
            map.remove(urlNamespace);
        }
        Element child = XmlUtils.getFirstSubTag((Node)element);
        while (child != null) {
            this.checkUnused(child);
            child = XmlUtils.getNextTag((Node)child);
        }
    }

    private final void checkRedundant(XmlContext context, Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            Element root;
            boolean redundant;
            Node node = attributes.item(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Attr");
            Attr attribute = (Attr)node;
            String name = attribute.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            if (!StringsKt.startsWith$default((String)name, (String)"xmlns:", (boolean)false, (int)2, null) || !(redundant = Intrinsics.areEqual((Object)(root = element.getOwnerDocument().getDocumentElement()).getAttribute(name), (Object)attribute.getValue()))) continue;
            LintFix fix = this.fix().name("Delete namespace").set().remove(name).build();
            context.report(REDUNDANT, (Node)attribute, context.getLocation((Node)attribute), "This namespace declaration is redundant", fix);
        }
        Element child = XmlUtils.getFirstSubTag((Node)element);
        while (child != null) {
            this.checkRedundant(context, child);
            child = XmlUtils.getNextTag((Node)child);
        }
    }

    private final void checkCustomNamespace(XmlContext context, Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String uri;
            Node node = attributes.item(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Attr");
            Attr attribute = (Attr)node;
            String string = attribute.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attribute.name");
            if (!StringsKt.startsWith$default((String)string, (String)"xmlns:", (boolean)false, (int)2, null) || (uri = attribute.getValue()) == null || ((CharSequence)uri).length() == 0 || !StringsKt.startsWith$default((String)uri, (String)"http://schemas.android.com/apk/res/", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)uri, (Object)"http://schemas.android.com/apk/res/android")) continue;
            if (context.getProject().isGradleProject()) {
                XmlContext.report$default((XmlContext)context, (Issue)RES_AUTO, (Node)attribute, (Location)context.getValueLocation(attribute), (String)"In Gradle projects, always use `http://schemas.android.com/apk/res-auto` for custom attributes", null, (int)16, null);
                continue;
            }
            XmlContext.report$default((XmlContext)context, (Issue)CUSTOM_VIEW, (Node)attribute, (Location)context.getValueLocation(attribute), (String)"When using a custom namespace attribute in a library project, use the namespace `\"http://schemas.android.com/apk/res-auto\"` instead", null, (int)16, null);
        }
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.RESOURCE_FILE_SCOPE, Scope.MANIFEST_SCOPE};
        IMPLEMENTATION = new Implementation(NamespaceDetector.class, Scope.MANIFEST_AND_RESOURCE_SCOPE, enumSetArray);
        TYPO = Issue.Companion.create("NamespaceTypo", "Misspelled namespace declaration", "\n                Accidental misspellings in namespace declarations can lead to some very obscure \\\n                error messages. This check looks for potential misspellings to help track these \\\n                down.", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION);
        UNUSED = Issue.Companion.create("UnusedNamespace", "Unused namespace", "\n                Unused namespace declarations take up space and require processing that is \\\n                not necessary", Category.PERFORMANCE, 1, Severity.WARNING, IMPLEMENTATION);
        REDUNDANT = Issue.Companion.create("RedundantNamespace", "Redundant namespace", "\n                In Android XML documents, only specify the namespace on the root/document \\\n                element. Namespace declarations elsewhere in the document are typically \\\n                accidental leftovers from copy/pasting XML from other files or documentation.", Category.PERFORMANCE, 1, Severity.WARNING, IMPLEMENTATION);
        CUSTOM_VIEW = Issue.Companion.create("LibraryCustomView", "Custom views in libraries should use res-auto-namespace", "\n                When using a custom view with custom attributes in a library project, the \\\n                layout must use the special namespace http://schemas.android.com/apk/res-auto instead of a URI which includes \\\n                the library project's own package. This will be used to automatically adjust \\\n                the namespace of the attributes when the library resources are merged into \\\n                the application project.", Category.CORRECTNESS, 6, Severity.FATAL, IMPLEMENTATION);
        RES_AUTO = Issue.Companion.create("ResAuto", "Hardcoded Package in Namespace", "\n                In Gradle projects, the actual package used in the final APK can vary; for \\\n                example,you can add a `.debug` package suffix in one version and not the other. \\\n                Therefore, you should **not** hardcode the application package in the resource; \\\n                instead, use the special namespace `http://schemas.android.com/apk/res-auto` \\\n                which will cause the tools to figure out the right namespace for the resource \\\n                regardless of the actual package used during the build.", Category.CORRECTNESS, 9, Severity.FATAL, IMPLEMENTATION);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/NamespaceDetector$Companion;", "", "()V", "CUSTOM_VIEW", "Lcom/android/tools/lint/detector/api/Issue;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "REDUNDANT", "RES_AUTO", "TYPO", "UNUSED", "XMLNS_A", "", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

