/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/WatchFaceEditorDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "action", "Lorg/w3c/dom/Element;", "Issues", "lint-checks"})
public final class WatchFaceEditorDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    public static final String WATCH_FACE_EDITOR_ACTION = "androidx.wear.watchface.editor.action.WATCH_FACE_EDITOR";

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"action");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element action) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (Intrinsics.areEqual((Object)action.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)WATCH_FACE_EDITOR_ACTION)) {
            Element activity;
            Node node = action.getParentNode();
            Node node2 = node != null ? node.getParentNode() : null;
            Element element = activity = node2 instanceof Element ? (Element)node2 : null;
            if (activity == null || !Intrinsics.areEqual((Object)activity.getNodeName(), (Object)"activity")) {
                return;
            }
            String launchMode = activity.getAttributeNS("http://schemas.android.com/apk/res/android", "launchMode");
            Intrinsics.checkNotNullExpressionValue((Object)launchMode, (String)"launchMode");
            if (((CharSequence)launchMode).length() == 0) {
                return;
            }
            if (!Intrinsics.areEqual((Object)launchMode, (Object)"standard")) {
                LintFix fix = this.fix().set().attribute("launchMode").value("standard").android().build();
                Attr attr = activity.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "launchMode");
                Intrinsics.checkNotNullExpressionValue((Object)attr, (String)"activity.getAttributeNod\u2026NDROID_URI, \"launchMode\")");
                context.report(new Incident(ISSUE, (Object)activity, context.getNameLocation((Node)attr), "Watch face editor must use launchMode=\"standard\"", fix));
            }
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(WatchFaceEditorDetector.class, Scope.MANIFEST_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"WatchFaceEditor", (String)"Watch face editor must use launchMode=\"standard\"", (String)"\n                Watch face editor activities must be able to launch in the Wear OS app activity task \\\n                in order to work correctly. Thus only `launchMode=\"standard\"` is allowed. The watch \\\n                face will not be shown on the watch if it does not satisfy this requirement.\n            ", (Implementation)implementation, null, (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/WatchFaceEditorDetector$Issues;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "WATCH_FACE_EDITOR_ACTION", "", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

