/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.lint.checks.Api;
import com.android.tools.lint.checks.ApiClass;
import com.android.tools.lint.checks.ApiDatabase;
import com.android.tools.lint.checks.ApiMember;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.ExtensionSdk;
import com.android.tools.lint.detector.api.ExtensionSdkRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;

public class ApiLookup
extends ApiDatabase {
    public static final String XML_FILE_PATH = "api-versions.xml";
    public static final int SDK_DATABASE_MIN_VERSION = 26;
    private static final int API_LOOKUP_BINARY_FORMAT_VERSION = 1;
    private static final int CLASS_HEADER_MEMBER_OFFSETS = 1;
    private static final int CLASS_HEADER_API = 2;
    private static final int CLASS_HEADER_DEPRECATED = 3;
    private static final int CLASS_HEADER_REMOVED = 4;
    private static final int CLASS_HEADER_INTERFACES = 5;
    @VisibleForTesting
    static final boolean DEBUG_FORCE_REGENERATE_BINARY = false;
    private static final Map<AndroidVersion, SoftReference<ApiLookup>> instances = new HashMap<AndroidVersion, SoftReference<ApiLookup>>();
    public final File xmlFile;
    private final List<ApiConstraint> apiConstraints = new ArrayList<ApiConstraint>();
    private ExtensionSdkRegistry registry;

    public static ApiLookup get(LintClient client) {
        return ApiLookup.get(client, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApiLookup get(LintClient client, IAndroidTarget target2) {
        Class<ApiLookup> clazz = ApiLookup.class;
        synchronized (ApiLookup.class) {
            ApiLookup db;
            AndroidVersion version = target2 != null ? target2.getVersion() : AndroidVersion.DEFAULT;
            SoftReference<ApiLookup> reference = instances.get(version);
            ApiLookup apiLookup = db = reference != null ? reference.get() : null;
            if (db == null) {
                Object versionKey = null;
                String env = System.getenv("LINT_API_DATABASE");
                if (env == null) {
                    env = System.getProperty("LINT_API_DATABASE");
                }
                File file = null;
                if (env != null) {
                    file = new File(env);
                    if (!file.exists()) {
                        file = null;
                    }
                } else {
                    File folder;
                    File database;
                    IAndroidTarget iAndroidTarget = target2 = target2 != null ? target2 : client.getLatestSdkTarget(26, true);
                    if (target2 != null && (database = new File(folder = new File(target2.getLocation()), "data" + File.separator + XML_FILE_PATH)).isFile()) {
                        file = database;
                        version = target2.getVersion();
                        versionKey = version.getApiString();
                        int revision = target2.getRevision();
                        if (revision != 1) {
                            versionKey = (String)versionKey + "rev" + revision;
                        }
                    }
                    if (file == null) {
                        File database2 = new File(client.getSdkHome(), "platform-tools" + File.separator + "api" + File.separator + XML_FILE_PATH);
                        if (database2.exists()) {
                            file = database2;
                            versionKey = "old-30.0.5";
                        }
                        if (file == null) {
                            file = client.findResource(XML_FILE_PATH);
                        }
                    }
                }
                if (file == null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                if (versionKey == null) {
                    HashFunction hashFunction = Hashing.farmHashFingerprint64();
                    versionKey = hashFunction.newHasher().putLong(file.lastModified()).putString((CharSequence)file.getPath(), Charsets.UTF_8).hash().toString();
                }
                db = ApiLookup.get(client, file, versionKey);
                instances.put(version, new SoftReference<ApiLookup>(db));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return db;
        }
    }

    @VisibleForTesting
    static String getCacheFileName(String xmlFileName, String platformVersion) {
        return StringsKt.removeSuffix((String)xmlFileName, (CharSequence)".xml") + "-" + ApiLookup.getBinaryFormatVersion(1) + "-" + platformVersion.replace(' ', '_') + ".bin";
    }

    private static ApiLookup get(LintClient client, File xmlFile, String version) {
        File binaryData;
        if (!xmlFile.exists()) {
            client.log(null, "The API database file %1$s does not exist", new Object[]{xmlFile});
            return null;
        }
        File cacheDir = client.getCacheDir(null, true);
        if (cacheDir == null) {
            cacheDir = xmlFile.getParentFile();
        }
        if (!((binaryData = new File(cacheDir, ApiLookup.getCacheFileName(xmlFile.getName(), version))).exists() && binaryData.lastModified() >= xmlFile.lastModified() && binaryData.length() != 0L || ApiLookup.cacheCreator(xmlFile).create(client, binaryData))) {
            return null;
        }
        if (!binaryData.exists()) {
            client.log(null, "The API database file %1$s does not exist", new Object[]{binaryData});
            return null;
        }
        return new ApiLookup(client, xmlFile, binaryData);
    }

    private static ApiDatabase.CacheCreator cacheCreator(File xmlFile) {
        return (client, binaryData) -> {
            Api<ApiClass> info;
            long begin = 0L;
            try {
                byte[] bytes = client.readBytes(xmlFile);
                info = Api.parseApi(new ByteArrayInputStream(bytes));
            }
            catch (IOException | RuntimeException e) {
                client.log((Throwable)e, "Can't read API file " + xmlFile.getAbsolutePath(), new Object[0]);
                return false;
            }
            try {
                ApiLookup.writeDatabase(client, binaryData, info, 1, xmlFile);
                return true;
            }
            catch (IOException e) {
                client.log((Throwable)e, "Can't write API cache file", new Object[0]);
                return false;
            }
        };
    }

    private ApiLookup(LintClient client, File xmlFile, File binaryFile) {
        this.xmlFile = xmlFile;
        if (binaryFile != null) {
            this.readData(client, binaryFile, ApiLookup.cacheCreator(xmlFile), 1);
            this.initializeApiConstraints();
        }
    }

    private void initializeApiConstraints() {
        if (this.mData == null) {
            return;
        }
        int offset = this.sdkIndexOffset;
        int count = ApiLookup.get2ByteInt(this.mData, offset);
        offset += 2;
        for (int i = 0; i < count; ++i) {
            int first = ApiLookup.get4ByteInt(this.mData, offset);
            int second = ApiLookup.get4ByteInt(this.mData, offset += 4);
            offset += 4;
            if (second == -1) {
                this.apiConstraints.add((ApiConstraint)ApiConstraint.get((int)first, (int)0));
                continue;
            }
            ArrayList<ApiConstraint.SdkApiConstraint> apis = new ArrayList<ApiConstraint.SdkApiConstraint>();
            apis.add(ApiConstraint.get((int)second, (int)first));
            while (true) {
                int sdk = ApiLookup.get4ByteInt(this.mData, offset);
                offset += 4;
                if (sdk == -1) break;
                int version = ApiLookup.get4ByteInt(this.mData, offset);
                offset += 4;
                assert (version != -1);
                apis.add(ApiConstraint.get((int)version, (int)sdk));
            }
            this.apiConstraints.add(ApiConstraint.MultiSdkApiConstraint.Companion.create(apis, true));
        }
        int extensionCount = ApiLookup.get4ByteInt(this.mData, offset);
        offset += 4;
        ArrayList<ExtensionSdk> sdks = new ArrayList<ExtensionSdk>();
        for (int i = 0; i < extensionCount; ++i) {
            int length = ApiLookup.get4ByteInt(this.mData, offset);
            String s = new String(this.mData, offset += 4, length, Charsets.UTF_8);
            offset += length;
            sdks.add(ExtensionSdk.Companion.deserialize(s));
        }
        this.registry = new ExtensionSdkRegistry(sdks);
    }

    @Deprecated
    public int getClassVersion(String className) {
        return this.getClassVersions(className).min();
    }

    public ApiConstraint getClassVersions(String className) {
        if (this.mData != null) {
            return this.getClassVersions(this.findClass(className));
        }
        return ApiConstraint.UNKNOWN;
    }

    private ApiConstraint getClassVersions(int classNumber) {
        int offset;
        int api2;
        if (classNumber >= 0 && (api2 = this.getApiLevel(offset = this.seekClassData(classNumber, 2), 2)) > 0) {
            return this.apiConstraints.get(api2);
        }
        return ApiConstraint.UNKNOWN;
    }

    @Deprecated
    public int getValidCastVersion(String sourceClass, String destinationClass) {
        return this.getValidCastVersions(sourceClass, destinationClass).min();
    }

    public ApiConstraint getValidCastVersions(String sourceClass, String destinationClass) {
        int interfaceNumber;
        int classNumber;
        if (this.mData != null && (classNumber = this.findClass(sourceClass)) >= 0 && (interfaceNumber = this.findClass(destinationClass)) >= 0) {
            int offset = this.seekClassData(classNumber, 5);
            int interfaceCount = this.mData[offset++];
            for (int i = 0; i < interfaceCount; ++i) {
                int clsNumber = ApiLookup.get3ByteInt(this.mData, offset);
                offset += 3;
                byte api2 = this.mData[offset++];
                if (clsNumber != interfaceNumber) continue;
                return this.apiConstraints.get(api2);
            }
            return this.getClassVersions(classNumber);
        }
        return ApiConstraint.UNKNOWN;
    }

    @Deprecated
    public int getClassDeprecatedIn(String className) {
        ApiConstraint versions = this.getClassDeprecatedInVersions(className);
        if (versions != ApiConstraint.UNKNOWN) {
            return versions.min();
        }
        return -1;
    }

    public ApiConstraint getClassDeprecatedInVersions(String className) {
        int classNumber;
        if (this.mData != null && (classNumber = this.findClass(className)) >= 0) {
            int offset = this.seekClassData(classNumber, 3);
            if (offset < 0) {
                return ApiConstraint.UNKNOWN;
            }
            int deprecatedIn = Byte.toUnsignedInt(this.mData[offset]) & 0xFFFFFF7F;
            return deprecatedIn != 0 ? ApiConstraint.get((int)deprecatedIn, (int)0) : ApiConstraint.UNKNOWN;
        }
        return ApiConstraint.UNKNOWN;
    }

    @Deprecated
    public int getClassRemovedIn(String className) {
        ApiConstraint versions = this.getClassRemovedInVersions(className);
        if (versions != ApiConstraint.UNKNOWN) {
            return versions.min();
        }
        return -1;
    }

    public ApiConstraint getClassRemovedInVersions(String className) {
        int classNumber;
        if (this.mData != null && (classNumber = this.findClass(className)) >= 0) {
            int offset = this.seekClassData(classNumber, 4);
            if (offset < 0) {
                return ApiConstraint.UNKNOWN;
            }
            int removedIn = Byte.toUnsignedInt(this.mData[offset]) & 0xFFFFFF7F;
            return removedIn != 0 ? ApiConstraint.get((int)removedIn, (int)0) : ApiConstraint.UNKNOWN;
        }
        return ApiConstraint.UNKNOWN;
    }

    public boolean containsClass(String className) {
        if (this.mData != null) {
            return this.findClass(className) >= 0;
        }
        return false;
    }

    @Deprecated
    public int getMethodVersion(String owner, String name, String desc) {
        return this.getMethodVersions(owner, name, desc).min();
    }

    public ApiConstraint getMethodVersions(String owner, String name, String desc) {
        int classNumber;
        if (this.mData != null && (classNumber = this.findClass(owner)) >= 0) {
            int api2 = this.findMember(classNumber, name, desc);
            if (api2 < 0) {
                return this.getClassVersions(classNumber);
            }
            return this.apiConstraints.get(api2);
        }
        return ApiConstraint.UNKNOWN;
    }

    @Deprecated
    public int getMethodDeprecatedIn(String owner, String name, String desc) {
        ApiConstraint versions = this.getMethodDeprecatedInVersions(owner, name, desc);
        if (versions != ApiConstraint.UNKNOWN) {
            return versions.min();
        }
        return -1;
    }

    public ApiConstraint getMethodDeprecatedInVersions(String owner, String name, String desc) {
        int classNumber;
        if (this.mData != null && (classNumber = this.findClass(owner)) >= 0) {
            int deprecatedIn = this.findMemberDeprecatedIn(classNumber, name, desc);
            return deprecatedIn == 0 ? ApiConstraint.UNKNOWN : ApiConstraint.get((int)deprecatedIn, (int)0);
        }
        return ApiConstraint.UNKNOWN;
    }

    @Deprecated
    public int getMethodRemovedIn(String owner, String name, String desc) {
        ApiConstraint versions = this.getMethodRemovedInVersions(owner, name, desc);
        if (versions != ApiConstraint.UNKNOWN) {
            return versions.min();
        }
        return -1;
    }

    public ApiConstraint getMethodRemovedInVersions(String owner, String name, String desc) {
        int classNumber;
        if (this.mData != null && (classNumber = this.findClass(owner)) >= 0) {
            int removedIn = this.findMemberRemovedIn(classNumber, name, desc);
            return removedIn == 0 ? ApiConstraint.UNKNOWN : ApiConstraint.get((int)removedIn, (int)0);
        }
        return ApiConstraint.UNKNOWN;
    }

    public Collection<ApiMember> getRemovedFields(String owner) {
        int classNumber;
        if (this.mData != null && (classNumber = this.findClass(owner)) >= 0) {
            return this.getRemovedMembers(classNumber, false);
        }
        return null;
    }

    @Deprecated
    public Collection<ApiMember> getRemovedMethods(String owner) {
        return null;
    }

    private Collection<ApiMember> getRemovedMembers(int classNumber, boolean methods) {
        int curr = this.seekClassData(classNumber, 1);
        int start = ApiLookup.get3ByteInt(this.mData, curr);
        int length = ApiLookup.get2ByteInt(this.mData, curr += 3);
        if (length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ApiMember> result = null;
        int end = start + length;
        for (int index2 = start; index2 < end; ++index2) {
            int deprecatedIn;
            int since;
            byte b;
            int i;
            int offset = this.mIndices[index2];
            boolean methodSignatureDetected = false;
            for (i = offset; i < this.mData.length && (b = this.mData[i]) != 0; ++i) {
                if (b != 40) continue;
                methodSignatureDetected = true;
            }
            if (i >= this.mData.length) {
                assert (false);
                break;
            }
            if (methodSignatureDetected != methods) continue;
            int endOfSignature = i++;
            if (((since = Byte.toUnsignedInt(this.mData[i++])) & 0x80) == 0 || ((deprecatedIn = Byte.toUnsignedInt(this.mData[i++])) & 0x80) == 0) continue;
            int removedIn = Byte.toUnsignedInt(this.mData[i]);
            if (removedIn != 0) {
                StringBuilder sb = new StringBuilder(endOfSignature - offset);
                for (i = offset; i < endOfSignature; ++i) {
                    sb.append((char)Byte.toUnsignedInt(this.mData[i]));
                }
                since &= 0xFFFFFF7F;
                deprecatedIn &= 0xFFFFFF7F;
                if (result == null) {
                    result = new ArrayList<ApiMember>();
                }
                result.add(new ApiMember(sb.toString(), since, deprecatedIn, removedIn));
                continue;
            }
            assert (false);
        }
        return result == null ? Collections.emptyList() : result;
    }

    @Deprecated
    public int getFieldVersion(String owner, String name) {
        return this.getFieldVersions(owner, name).min();
    }

    public ApiConstraint getFieldVersions(String owner, String name) {
        int classNumber;
        if (this.mData != null && (classNumber = this.findClass(owner)) >= 0) {
            int api2 = this.findMember(classNumber, name, null);
            if (api2 < 0) {
                return this.getClassVersions(classNumber);
            }
            return this.apiConstraints.get(api2);
        }
        return ApiConstraint.UNKNOWN;
    }

    @Deprecated
    public int getFieldDeprecatedIn(String owner, String name) {
        ApiConstraint versions = this.getFieldDeprecatedInVersions(owner, name);
        if (versions != ApiConstraint.UNKNOWN) {
            return versions.min();
        }
        return -1;
    }

    public ApiConstraint getFieldDeprecatedInVersions(String owner, String name) {
        int classNumber;
        if (this.mData != null && (classNumber = this.findClass(owner)) >= 0) {
            int deprecatedIn = this.findMemberDeprecatedIn(classNumber, name, null);
            return deprecatedIn == 0 ? ApiConstraint.UNKNOWN : ApiConstraint.get((int)deprecatedIn, (int)0);
        }
        return ApiConstraint.UNKNOWN;
    }

    @Deprecated
    public int getFieldRemovedIn(String owner, String name) {
        ApiConstraint versions = this.getFieldRemovedInVersions(owner, name);
        if (versions != ApiConstraint.UNKNOWN) {
            return versions.min();
        }
        return -1;
    }

    public ApiConstraint getFieldRemovedInVersions(String owner, String name) {
        int classNumber;
        if (this.mData != null && (classNumber = this.findClass(owner)) >= 0) {
            int removedIn = this.findMemberRemovedIn(classNumber, name, null);
            return removedIn == 0 ? ApiConstraint.UNKNOWN : ApiConstraint.get((int)removedIn, (int)0);
        }
        return ApiConstraint.UNKNOWN;
    }

    public boolean isRelevantOwner(String owner) {
        return this.findClass(owner) >= 0;
    }

    public boolean isValidJavaPackage(String classOrPackageName, int packageNameLength) {
        return this.findContainer(classOrPackageName, packageNameLength, true) >= 0;
    }

    public static boolean equivalentName(String name1, String name2) {
        int len2;
        int len1 = name1.length();
        if (len1 != (len2 = name2.length())) {
            return false;
        }
        for (int i = 0; i < len1; ++i) {
            if (ApiLookup.normalizeSeparator(name1.charAt(i)) == ApiLookup.normalizeSeparator(name2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithEquivalentPrefix(String classOrPackageName, String prefix) {
        return ApiLookup.equivalentFragmentAtOffset(classOrPackageName, 0, prefix);
    }

    public static boolean equivalentFragmentAtOffset(String classOrPackageName, int offset, String fragment) {
        int prefixLength = fragment.length();
        if (offset < 0 || offset > classOrPackageName.length() - prefixLength) {
            return false;
        }
        for (int prefixOffset = 0; prefixOffset < prefixLength; ++prefixOffset) {
            if (ApiLookup.normalizeSeparator(classOrPackageName.charAt(offset++)) == ApiLookup.normalizeSeparator(fragment.charAt(prefixOffset))) continue;
            return false;
        }
        return true;
    }

    private static char normalizeSeparator(char c) {
        if (c == '/' || c == '$') {
            c = (char)46;
        }
        return c;
    }

    public static int signatureHashCode(String s1, String s2) {
        int h = 0;
        int n1 = s1.lastIndexOf(41);
        if (n1 == -1) {
            n1 = s1.length();
        }
        for (int i = 0; i < n1; ++i) {
            char c = ApiLookup.normalizeSeparator(s1.charAt(i));
            h = 31 * h + (c & 0xFF);
        }
        if (s2 != null) {
            int n2 = s2.lastIndexOf(41);
            if (n2 == -1) {
                n2 = s2.length();
            }
            for (int i = 0; i < n2; ++i) {
                char c = ApiLookup.normalizeSeparator(s2.charAt(i));
                h = 31 * h + (c & 0xFF);
            }
        }
        return h & Integer.MAX_VALUE;
    }

    private int findMember(int classNumber, String name, String desc) {
        return this.findMember(classNumber, name, desc, 2);
    }

    private int findMemberDeprecatedIn(int classNumber, String name, String desc) {
        return this.findMember(classNumber, name, desc, 3);
    }

    private int findMemberRemovedIn(int classNumber, String name, String desc) {
        return this.findMember(classNumber, name, desc, 4);
    }

    private int seekClassData(int classNumber, int field) {
        int offset = this.mIndices[classNumber];
        offset += this.mData[offset] & 0xFF;
        if (field == 1) {
            return offset;
        }
        offset += 5;
        if (field == 2) {
            return offset;
        }
        byte sinceFirst = this.mData[offset];
        if ((sinceFirst & 0x40) != 0) {
            ++offset;
        }
        boolean hasDeprecatedIn = (sinceFirst & 0x80) != 0;
        boolean hasRemovedIn = false;
        ++offset;
        if (field == 3) {
            return hasDeprecatedIn ? offset : -1;
        }
        if (hasDeprecatedIn) {
            hasRemovedIn = (this.mData[offset] & 0x80) != 0;
            ++offset;
        }
        if (field == 4) {
            return hasRemovedIn ? offset : -1;
        }
        if (hasRemovedIn) {
            ++offset;
        }
        assert (field == 5);
        return offset;
    }

    private int seekMemberData(int classNumber, String name, String desc) {
        boolean useHashCodes;
        int curr = this.seekClassData(classNumber, 1);
        int low = ApiLookup.get3ByteInt(this.mData, curr);
        int length = ApiLookup.get2ByteInt(this.mData, curr += 3);
        if (length == 0) {
            return -1;
        }
        int high = low + length;
        boolean bl = useHashCodes = (this.mIndices[low] & Integer.MIN_VALUE) != 0;
        if (useHashCodes) {
            int hashCode = ApiLookup.signatureHashCode(name, desc);
            while (low < high) {
                int middle = low + high >>> 1;
                int offset = this.mIndices[middle];
                int currentHashCode = ApiLookup.get4ByteInt(this.mData, offset &= Integer.MAX_VALUE);
                int compare = currentHashCode - hashCode;
                if (compare == 0) {
                    return offset += 4;
                }
                if (compare < 0) {
                    low = middle + 1;
                    continue;
                }
                high = middle;
            }
            return -1;
        }
        while (low < high) {
            int compare;
            int nameLength;
            int middle = low + high >>> 1;
            int offset = this.mIndices[middle];
            if (desc != null) {
                int argsEnd;
                nameLength = name.length();
                compare = ApiLookup.compare(this.mData, offset, (byte)40, name, 0, nameLength);
                if (compare == 0 && (compare = ApiLookup.compare(this.mData, offset += nameLength, (byte)41, desc, 0, argsEnd = desc.indexOf(41))) == 0) {
                    offset += argsEnd + 1;
                    if (this.mData[offset++] == 0) {
                        return offset;
                    }
                }
            } else {
                nameLength = name.length();
                compare = ApiLookup.compare(this.mData, offset, (byte)0, name, 0, nameLength);
                if (compare == 0) {
                    offset += nameLength;
                    if (this.mData[offset++] == 0) {
                        return offset;
                    }
                }
            }
            if (compare < 0) {
                low = middle + 1;
                continue;
            }
            if (compare > 0) {
                high = middle;
                continue;
            }
            assert (false);
            return -1;
        }
        return -1;
    }

    private int findMember(int classNumber, String name, String desc, int apiLevelField) {
        int offset = this.seekMemberData(classNumber, name, desc);
        if (offset == -1) {
            return -1;
        }
        return this.getApiLevel(offset, apiLevelField);
    }

    private int getApiLevel(int offset, int apiLevelField) {
        int api2 = Byte.toUnsignedInt(this.mData[offset]);
        if (apiLevelField == 2) {
            if ((api2 & 0x40) != 0) {
                int second = Byte.toUnsignedInt(this.mData[++offset]);
                return (api2 & 0xFFFFFF3F) << 8 | second;
            }
            return api2 & 0xFFFFFF7F;
        }
        if ((api2 & 0x80) == 0) {
            return -1;
        }
        if ((api2 & 0x40) != 0) {
            ++offset;
        }
        api2 = Byte.toUnsignedInt(this.mData[++offset]);
        if (apiLevelField == 3) {
            return (api2 &= 0xFFFFFF7F) == 0 ? -1 : api2;
        }
        assert (apiLevelField == 4);
        if ((api2 & 0x80) == 0 || apiLevelField != 4) {
            return -1;
        }
        return (api2 = Byte.toUnsignedInt(this.mData[++offset])) == 0 ? -1 : api2;
    }

    public String getSdkName(int sdkId) {
        ExtensionSdk sdk = this.registry.find(sdkId);
        if (sdk != null) {
            return sdk.getName();
        }
        return ExtensionSdk.Companion.getSdkExtensionField(sdkId, false);
    }

    public String getSdkExtensionField(int sdkId, boolean fullyQualified) {
        ExtensionSdk sdk = this.registry.find(sdkId);
        if (sdk != null) {
            return sdk.getSdkExtensionField(fullyQualified);
        }
        return ExtensionSdk.Companion.getSdkExtensionField(sdkId, fullyQualified);
    }

    public static String getSdkExtensionField(LintClient client, int sdkId, boolean fullyQualified) {
        return ApiLookup.getSdkExtensionField(ApiLookup.get(client), sdkId, fullyQualified);
    }

    public static String getSdkExtensionField(ApiLookup lookup, int sdkId, boolean fullyQualified) {
        if (lookup != null) {
            return lookup.getSdkExtensionField(sdkId, fullyQualified);
        }
        return ExtensionSdk.Companion.getSdkExtensionField(sdkId, true);
    }

    @VisibleForTesting
    static void dispose() {
        instances.clear();
    }
}

