/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/SecretDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableConstructorTypes", "", "", "visitConstructor", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "constructor", "Lcom/intellij/psi/PsiMethod;", "isLiteralStringKey", "", "expression", "Lorg/jetbrains/uast/UExpression;", "isReferenceToLocalVariableStringKey", "isReferenceToFieldStringKey", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nSecretDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecretDetector.kt\ncom/android/tools/lint/checks/SecretDetector\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n171#2:163\n171#2:164\n1755#3,3:165\n*S KotlinDebug\n*F\n+ 1 SecretDetector.kt\ncom/android/tools/lint/checks/SecretDetector\n*L\n94#1:163\n105#1:164\n130#1:165,3\n*E\n"})
public final class SecretDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String FQN_MODEL = "com.google.ai.client.generativeai.GenerativeModel";
    private static final int CONSTRUCTOR_API_KEY_PARAM_INDEX = 1;
    @NotNull
    private static final String KEY_PREFIX = "AIza";
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableConstructorTypes() {
        return CollectionsKt.listOf((Object)FQN_MODEL);
    }

    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        UExpression uExpression = node.getArgumentForParameter(1);
        if (uExpression == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null) {
            return;
        }
        UExpression keyArg = uExpression;
        if (this.isLiteralStringKey(keyArg) || this.isReferenceToLocalVariableStringKey(keyArg) || this.isReferenceToFieldStringKey(keyArg, context)) {
            context.report(ISSUE, (UElement)keyArg, context.getLocation((UElement)keyArg), "This argument looks like an API key that has come from source code; API keys should not be included in source code", this.fix().url("https://developers.google.com/maps/documentation/android-sdk/secrets-gradle-plugin").build());
        }
    }

    private final boolean isLiteralStringKey(UExpression expression) {
        if (expression instanceof UPolyadicExpression && expression.getSourcePsi() instanceof KtStringTemplateExpression && ((UPolyadicExpression)expression).getOperands().size() == 1) {
            return this.isLiteralStringKey(UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)((UPolyadicExpression)expression).getOperands().get(0))));
        }
        ULiteralExpression uLiteralExpression = expression instanceof ULiteralExpression ? (ULiteralExpression)expression : null;
        if (uLiteralExpression == null) {
            return false;
        }
        ULiteralExpression literal = uLiteralExpression;
        Object object = literal.getValue();
        if (object == null) {
            return false;
        }
        Object value = object;
        return value instanceof String && ((String)value).length() > 30 && StringsKt.startsWith$default((String)((String)value), (String)KEY_PREFIX, (boolean)false, (int)2, null);
    }

    private final boolean isReferenceToLocalVariableStringKey(UExpression expression) {
        UReferenceExpression uReferenceExpression = expression instanceof UReferenceExpression ? (UReferenceExpression)expression : null;
        if (uReferenceExpression == null) {
            return false;
        }
        UReferenceExpression refExpression = uReferenceExpression;
        PsiElement $this$toUElementOfType$iv = refExpression.resolve();
        boolean $i$f$toUElementOfType = false;
        ULocalVariable uLocalVariable = (ULocalVariable)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, ULocalVariable.class);
        if (uLocalVariable == null) {
            return false;
        }
        ULocalVariable localVar = uLocalVariable;
        UExpression uExpression = localVar.getUastInitializer();
        if (uExpression == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null) {
            return false;
        }
        UExpression initializer = uExpression;
        return this.isLiteralStringKey(initializer);
    }

    private final boolean isReferenceToFieldStringKey(UExpression expression, JavaContext context) {
        boolean bl;
        block17: {
            PsiElement psiElement;
            block19: {
                block18: {
                    UReferenceExpression uReferenceExpression = expression instanceof UReferenceExpression ? (UReferenceExpression)expression : null;
                    if (uReferenceExpression == null) {
                        return false;
                    }
                    UReferenceExpression refExpression = uReferenceExpression;
                    psiElement = refExpression.resolve();
                    if (psiElement == null || (psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)psiElement)) == null) break block18;
                    PsiElement $this$toUElementOfType$iv = psiElement;
                    boolean $i$f$toUElementOfType = false;
                    psiElement = (UField)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UField.class);
                    if (psiElement != null) break block19;
                }
                return false;
            }
            PsiElement field = psiElement;
            UExpression uExpression = field.getUastInitializer();
            if (uExpression == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null) {
                return false;
            }
            UExpression initializer = uExpression;
            if (!this.isLiteralStringKey(initializer)) {
                return false;
            }
            PsiElement psiElement2 = field.getSourcePsi();
            if (psiElement2 == null || (psiElement2 = psiElement2.getContainingFile()) == null) {
                return false;
            }
            PsiElement fieldFilePsi = psiElement2;
            String string = fieldFilePsi.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.startsWith$default((String)string, (String)"BuildConfig", (boolean)false, (int)2, null)) {
                return false;
            }
            if (context.getDriver().isSuppressed(context, ISSUE, (UElement)field)) {
                return false;
            }
            PsiElement psiElement3 = expression.getSourcePsi();
            boolean bl2 = psiElement3 != null && (psiElement3 = psiElement3.getContainingFile()) != null ? psiElement3.isEquivalentTo(fieldFilePsi) : false;
            if (bl2) {
                return true;
            }
            Project project = context.getProject();
            if (!project.isGradleProject()) {
                return false;
            }
            VirtualFile virtualFile = fieldFilePsi.getVirtualFile();
            if (virtualFile == null) {
                return false;
            }
            VirtualFile fieldVirtualFile = virtualFile;
            Path path = fieldVirtualFile.getFileSystem().getNioPath(fieldVirtualFile);
            if (path == null) {
                return false;
            }
            Path fieldPath = path;
            List list = project.getJavaSourceFolders();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getJavaSourceFolders(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    File it = (File)element$iv;
                    boolean bl3 = false;
                    if (!fieldPath.startsWith(it.toPath())) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(SecretDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"SecretInSource", (String)"Secret in source code", (String)"\n          Including secrets, such as API keys, in source code is a security risk. \\\n          It is generally best practice to not include API keys in source code, \\\n          and instead use something like the Secrets Gradle Plugin for Android.\n          ", (Implementation)implementation, (String)"https://developers.google.com/maps/documentation/android-sdk/secrets-gradle-plugin", (Category)category, (int)9, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/SecretDetector$Companion;", "", "<init>", "()V", "FQN_MODEL", "", "CONSTRUCTOR_API_KEY_PARAM_INDEX", "", "KEY_PREFIX", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

