/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.BroadcastReceiverUtils;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UnsafeBroadcastReceiverDetector
extends Detector
implements SourceCodeScanner,
XmlScanner {
    public static final Issue ACTION_STRING = Issue.create((String)"UnsafeProtectedBroadcastReceiver", (String)"Unsafe Protected `BroadcastReceiver`", (String)"`BroadcastReceiver`s that declare an intent-filter for a protected-broadcast action string must check that the received intent's action string matches the expected value, otherwise it is possible for malicious actors to spoof intents.", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(UnsafeBroadcastReceiverDetector.class, EnumSet.of(Scope.MANIFEST, Scope.JAVA_FILE), new EnumSet[]{Scope.JAVA_FILE_SCOPE})).addMoreInfo("https://goo.gle/UnsafeProtectedBroadcastReceiver");
    public static final Issue BROADCAST_SMS = Issue.create((String)"UnprotectedSMSBroadcastReceiver", (String)"Unprotected SMS `BroadcastReceiver`", (String)"BroadcastReceivers that declare an intent-filter for `SMS_DELIVER` or `SMS_RECEIVED` must ensure that the caller has the `BROADCAST_SMS` permission, otherwise it is possible for malicious actors to spoof intents.", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(UnsafeBroadcastReceiverDetector.class, Scope.MANIFEST_SCOPE)).addMoreInfo("https://goo.gle/UnprotectedSMSBroadcastReceiver");
    private Set<String> mReceiversWithProtectedBroadcastIntentFilter = null;

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("receiver");
    }

    public void visitElement(XmlContext context, Element element) {
        String tag = element.getTagName();
        if ("receiver".equals(tag)) {
            Element filter;
            String name = Lint.resolveManifestName((Element)element, (Project)context.getProject());
            String permission = element.getAttributeNS("http://schemas.android.com/apk/res/android", "permission");
            if (permission.isEmpty()) {
                Element parent = (Element)element.getParentNode();
                permission = parent.getAttributeNS("http://schemas.android.com/apk/res/android", "permission");
            }
            if ((filter = XmlUtils.getFirstSubTagByName((Node)element, (String)"intent-filter")) != null) {
                for (Element action : XmlUtils.getSubTagsByName((Node)filter, (String)"action")) {
                    String actionName = action.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    if (("android.provider.Telephony.SMS_DELIVER".equals(actionName) || "android.provider.Telephony.SMS_RECEIVED".equals(actionName)) && !"android.permission.BROADCAST_SMS".equals(permission)) {
                        LintFix fix = this.fix().set("http://schemas.android.com/apk/res/android", "permission", "android.permission.BROADCAST_SMS").build();
                        context.report(BROADCAST_SMS, (Node)element, context.getNameLocation((Node)element), "BroadcastReceivers that declare an intent-filter for `SMS_DELIVER` or `SMS_RECEIVED` must ensure that the caller has the `BROADCAST_SMS` permission, otherwise it is possible for malicious actors to spoof intents", fix);
                        continue;
                    }
                    if (!BroadcastReceiverUtils.isProtectedBroadcast(actionName)) continue;
                    if (this.mReceiversWithProtectedBroadcastIntentFilter == null) {
                        this.mReceiversWithProtectedBroadcastIntentFilter = Sets.newHashSet();
                    }
                    this.mReceiversWithProtectedBroadcastIntentFilter.add(name);
                }
            }
        }
    }

    private Set<String> getReceiversWithProtectedBroadcastIntentFilter(Context context) {
        if (this.mReceiversWithProtectedBroadcastIntentFilter == null) {
            Element application;
            Project mainProject;
            Document mergedManifest;
            this.mReceiversWithProtectedBroadcastIntentFilter = Sets.newHashSet();
            if (!context.getScope().contains(Scope.MANIFEST) && (mergedManifest = (mainProject = context.getMainProject()).getMergedManifest()) != null && mergedManifest.getDocumentElement() != null && (application = XmlUtils.getFirstSubTagByName((Node)mergedManifest.getDocumentElement(), (String)"application")) != null) {
                for (Element element : XmlUtils.getSubTags((Node)application)) {
                    Element filter;
                    if (!"receiver".equals(element.getTagName()) || (filter = XmlUtils.getFirstSubTagByName((Node)element, (String)"intent-filter")) == null) continue;
                    for (Element action : XmlUtils.getSubTagsByName((Node)filter, (String)"action")) {
                        String actionName = action.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                        if (!BroadcastReceiverUtils.isProtectedBroadcast(actionName)) continue;
                        String name = Lint.resolveManifestName((Element)element, (Project)mainProject);
                        this.mReceiversWithProtectedBroadcastIntentFilter.add(name);
                    }
                }
            }
        }
        return this.mReceiversWithProtectedBroadcastIntentFilter;
    }

    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.content.BroadcastReceiver");
    }

    public void visitClass(JavaContext context, UClass declaration) {
        String name = declaration.getName();
        if (name == null) {
            return;
        }
        String qualifiedName = declaration.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        if (!this.getReceiversWithProtectedBroadcastIntentFilter((Context)context).contains(qualifiedName)) {
            return;
        }
        JavaEvaluator evaluator = context.getEvaluator();
        for (PsiMethod method : declaration.getJavaPsi().findMethodsByName("onReceive", false)) {
            if (!evaluator.parametersMatch(method, new String[]{"android.content.Context", "android.content.Intent"})) continue;
            UnsafeBroadcastReceiverDetector.checkOnReceive(context, method);
        }
    }

    private static void checkOnReceive(JavaContext context, PsiMethod method) {
        PsiParameter parameter = method.getParameterList().getParameters()[1];
        OnReceiveVisitor visitor2 = new OnReceiveVisitor(context.getEvaluator(), parameter);
        UastFacade.INSTANCE.getMethodBody(method).accept((UastVisitor)visitor2);
        if (!visitor2.getCallsGetAction()) {
            String report2 = !visitor2.getUsesIntent() ? "This broadcast receiver declares an intent-filter for a protected broadcast action string, which can only be sent by the system, not third-party applications. However, the receiver's `onReceive` method does not appear to call `getAction` to ensure that the received Intent's action string matches the expected value, potentially making it possible for another actor to send a spoofed intent with no action string or a different action string and cause undesired behavior." : "This broadcast receiver declares an intent-filter for a protected broadcast action string, which can only be sent by the system, not third-party applications. However, the receiver's onReceive method does not appear to call getAction to ensure that the received Intent's action string matches the expected value, potentially making it possible for another actor to send a spoofed intent with no action string or a different action string and cause undesired behavior. In this case, it is possible that the onReceive method passed the received Intent to another method that checked the action string. If so, this finding can safely be ignored.";
            Location location = context.getNameLocation((PsiElement)method);
            context.report(ACTION_STRING, (PsiElement)method, location, report2);
        }
    }

    private static class OnReceiveVisitor
    extends AbstractUastVisitor {
        private final JavaEvaluator mEvaluator;
        private final PsiParameter mParameter;
        private boolean mCallsGetAction;
        private boolean mUsesIntent;

        public OnReceiveVisitor(JavaEvaluator context, PsiParameter parameter) {
            this.mEvaluator = context;
            this.mParameter = parameter;
        }

        public boolean getCallsGetAction() {
            return this.mCallsGetAction;
        }

        public boolean getUsesIntent() {
            return this.mUsesIntent;
        }

        public boolean visitCallExpression(UCallExpression node) {
            PsiMethod method;
            if (!this.mCallsGetAction && UastExpressionUtils.isMethodCall((UElement)node) && (method = node.resolve()) != null && "getAction".equals(method.getName()) && this.mEvaluator.isMemberInSubClassOf((PsiMember)method, "android.content.Intent", false)) {
                this.mCallsGetAction = true;
            }
            return super.visitCallExpression(node);
        }

        public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
            PsiElement resolved;
            if (!this.mUsesIntent && this.mParameter != null && this.mParameter.isEquivalentTo(resolved = node.resolve())) {
                this.mUsesIntent = true;
            }
            return super.visitSimpleNameReferenceExpression(node);
        }
    }
}

