/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Project;
import com.android.utils.DomExtensions;
import com.android.utils.XmlUtils;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/WatchFaceFormatUtils;", "", "<init>", "()V", "hasWatchFaceFormatVersionProperty", "", "application", "Lorg/w3c/dom/Element;", "hasDeclarativeWatchFaceFile", "project", "Lcom/android/tools/lint/detector/api/Project;", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nWatchFaceFormatUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WatchFaceFormatUtils.kt\ncom/android/tools/lint/checks/WatchFaceFormatUtils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,60:1\n1255#2,2:61\n1374#3:63\n1460#3,5:64\n774#3:69\n865#3,2:70\n1761#3,2:72\n1763#3:76\n12637#4,2:74\n*S KotlinDebug\n*F\n+ 1 WatchFaceFormatUtils.kt\ncom/android/tools/lint/checks/WatchFaceFormatUtils\n*L\n38#1:61,2\n49#1:63\n49#1:64,5\n50#1:69\n50#1:70,2\n51#1:72,2\n51#1:76\n52#1:74,2\n*E\n"})
public final class WatchFaceFormatUtils {
    @NotNull
    public static final WatchFaceFormatUtils INSTANCE = new WatchFaceFormatUtils();

    private WatchFaceFormatUtils() {
    }

    public final boolean hasWatchFaceFormatVersionProperty(@NotNull Element application) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            boolean bl2 = Intrinsics.areEqual((Object)application.getTagName(), (Object)"application");
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Sequence $this$any$iv = SequencesKt.asSequence((Iterator)DomExtensions.subtags((Element)application, (String)"property"));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Element it = (Element)element$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)"com.google.wear.watchface.format.version")) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasDeclarativeWatchFaceFile(@NotNull Project project) {
        boolean bl;
        block7: {
            void $this$filterTo$iv$iv;
            File it;
            Iterable $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List list = project.getResourceFolders();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResourceFolders(...)");
            Iterable $this$flatMap$iv = list;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (File)element$iv$iv;
                boolean bl2 = false;
                File[] fileArray = it.listFiles();
                Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
                Iterable list$iv$iv = ArraysKt.toList((Object[])fileArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (File)element$iv$iv;
                boolean bl3 = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string, (String)"raw", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl4;
                    block6: {
                        File rawFolder = (File)element$iv;
                        boolean bl5 = false;
                        File[] fileArray = rawFolder.listFiles();
                        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"listFiles(...)");
                        Object[] $this$any$iv2 = fileArray;
                        boolean $i$f$any2 = false;
                        for (Object element$iv2 : $this$any$iv2) {
                            String rootTag;
                            File it2 = (File)element$iv2;
                            boolean bl6 = false;
                            String xml = Files.asCharSource((File)it2, (Charset)Charsets.UTF_8).read();
                            Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)false);
                            Node node = document;
                            String string = node != null && (node = node.getDocumentElement()) != null ? node.getTagName() : (rootTag = null);
                            if (!Intrinsics.areEqual((Object)rootTag, (Object)"WatchFace")) continue;
                            bl4 = true;
                            break block6;
                        }
                        bl4 = false;
                    }
                    if (!bl4) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }
}

