/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastCallKind;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0018\u00010\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u0013*\u0004\u0018\u00010\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/ArrayInitDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "checkConstructor", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "isArrayWithOptionalInitializer", "", "", "Issues", "lint-checks"})
public final class ArrayInitDetector
extends Detector
implements SourceCodeScanner,
XmlScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(ArrayInitDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("UnnecessaryArrayInit", "Unnecessary array initialization", "\n          When constructing an array in Kotlin, you don't need to pass \\\n          a lambda to set the initial value if it's identical to the \\\n          default or if you're going to overwrite all the values without \\\n          reading them anyway.\n          ", Category.PERFORMANCE, 6, Severity.INFORMATIONAL, IMPLEMENTATION);

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UCallExpression.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ ArrayInitDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitCallExpression(UCallExpression node) {
                PsiElement sourcePsi;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)node.getKind(), (Object)UastCallKind.CONSTRUCTOR_CALL) && (sourcePsi = node.getSourcePsi()) instanceof KtCallExpression) {
                    KtExpression ktExpression = ((KtCallExpression)sourcePsi).getCalleeExpression();
                    if (ArrayInitDetector.access$isArrayWithOptionalInitializer(this.this$0, ktExpression != null ? ktExpression.getText() : null)) {
                        void this_$iv$iv;
                        void useSiteElement$iv;
                        KtElement ktElement = (KtElement)sourcePsi;
                        ArrayInitDetector arrayInitDetector = this.this$0;
                        JavaContext javaContext = this.$context;
                        boolean $i$f$analyze = false;
                        Project project = useSiteElement$iv.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                        boolean $i$f$analyze2 = false;
                        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)useSiteElement$iv);
                        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)useSiteElement$iv);
                        try {
                            Unit unit;
                            Object lock$iv$iv;
                            Object object = lock$iv$iv = new Object();
                            synchronized (object) {
                                KaConstructorSymbol symbol;
                                boolean bl = false;
                                KaSession $this$visitCallExpression_u24lambda_u240 = analysisSession$iv$iv;
                                boolean bl2 = false;
                                KaCallInfo kaCallInfo = $this$visitCallExpression_u24lambda_u240.resolveToCall((KtElement)sourcePsi);
                                KaConstructorSymbol kaConstructorSymbol = kaCallInfo != null && (kaCallInfo = KaCallInfoKt.successfulConstructorCallOrNull((KaCallInfo)kaCallInfo)) != null ? (KaConstructorSymbol)KaCallKt.getSymbol((KaCallableMemberCall)((KaCallableMemberCall)kaCallInfo)) : (symbol = null);
                                if (symbol != null) {
                                    ClassId classId;
                                    KaClassLikeSymbol kaClassLikeSymbol = TypeUtilsKt.getSymbol((KaType)symbol.getReturnType());
                                    Object object2 = classId = kaClassLikeSymbol != null ? kaClassLikeSymbol.getClassId() : null;
                                    if (classId != null && Intrinsics.areEqual((Object)classId.getPackageFqName().asString(), (Object)"kotlin") && ArrayInitDetector.access$isArrayWithOptionalInitializer(arrayInitDetector, classId.getRelativeClassName().asString())) {
                                        ArrayInitDetector.access$checkConstructor(arrayInitDetector, javaContext, node);
                                    }
                                } else {
                                    ArrayInitDetector.access$checkConstructor(arrayInitDetector, javaContext, node);
                                }
                                unit = Unit.INSTANCE;
                            }
                            Unit unit2 = unit;
                        }
                        catch (Throwable throwable$iv$iv) {
                            this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, (KtElement)useSiteElement$iv);
                            throw new KotlinNothingValueException();
                        }
                        finally {
                            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)useSiteElement$iv);
                        }
                    }
                }
            }
        };
    }

    private final void checkConstructor(JavaContext context, UCallExpression node) {
        UExpression returnExpression;
        UExpression uExpression;
        List expressions;
        Object object = CollectionsKt.lastOrNull((List)node.getValueArguments());
        ULambdaExpression uLambdaExpression = object instanceof ULambdaExpression ? (ULambdaExpression)object : null;
        if (uLambdaExpression == null) {
            return;
        }
        ULambdaExpression lambda = uLambdaExpression;
        if (!(CollectionsKt.lastOrNull((List)node.getValueArguments()) instanceof ULambdaExpression)) {
            return;
        }
        UExpression expression = lambda.getBody();
        if (expression instanceof UBlockExpression && (expressions = ((UBlockExpression)expression).getExpressions()).size() == 1 && (uExpression = (UExpression)expressions.get(0)) instanceof UReturnExpression && (returnExpression = ((UReturnExpression)uExpression).getReturnExpression()) != null) {
            Object object2 = returnExpression.evaluate();
            if (object2 == null) {
                return;
            }
            Object constant = object2;
            if (constant instanceof Number && ((Number)constant).doubleValue() == 0.0) {
                LintFix.ReplaceStringBuilder replaceStringBuilder;
                LintFix.ReplaceStringBuilder replaceStringBuilder2;
                PsiElement sourcePsi;
                PsiElement psiElement = sourcePsi = lambda.getSourcePsi();
                Object reference = psiElement != null ? " (`" + psiElement.getText() + "`)" : "";
                String message2 = "This initialization lambda" + (String)reference + " is unnecessary and is less efficient";
                LintFix.ReplaceStringBuilder $this$checkConstructor_u24lambda_u240 = replaceStringBuilder2 = this.fix().name("Remove initialization").replace();
                boolean bl = false;
                if (sourcePsi != null) {
                    PsiElement psiElement2 = lambda.getSourcePsi();
                    replaceStringBuilder = $this$checkConstructor_u24lambda_u240.pattern("\\s*\\Q" + (psiElement2 != null ? psiElement2.getText() : null) + "\\E").range(context.getLocation((UElement)node));
                } else {
                    replaceStringBuilder = $this$checkConstructor_u24lambda_u240.all().reformat(true);
                }
                LintFix fix = replaceStringBuilder2.with("").autoFix().build();
                context.report(ISSUE, (UElement)lambda, context.getLocation((UElement)lambda), message2, fix);
            }
        }
    }

    private final boolean isArrayWithOptionalInitializer(String $this$isArrayWithOptionalInitializer) {
        return $this$isArrayWithOptionalInitializer != null && StringsKt.endsWith$default((String)$this$isArrayWithOptionalInitializer, (String)"Array", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)$this$isArrayWithOptionalInitializer, (Object)"Array");
    }

    public static final /* synthetic */ boolean access$isArrayWithOptionalInitializer(ArrayInitDetector $this, String $receiver) {
        return $this.isArrayWithOptionalInitializer($receiver);
    }

    public static final /* synthetic */ void access$checkConstructor(ArrayInitDetector $this, JavaContext context, UCallExpression node) {
        $this.checkConstructor(context, node);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/ArrayInitDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

