/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u00012\u00020\u0002:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/AccessibilityForceFocusDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "checkPerformAccessibilityAction", "Companion", "lint-checks"})
public final class AccessibilityForceFocusDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int ACTION_ACCESSIBILITY_FOCUS = 64;
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"performAccessibilityAction");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String[] stringArray = new String[]{"int", "android.os.Bundle"};
        if (AccessibilityForceFocusDetector.visitMethodCall$isViewMethod(method, context, "performAccessibilityAction", stringArray)) {
            this.checkPerformAccessibilityAction(context, node);
        }
    }

    private final void checkPerformAccessibilityAction(JavaContext context, UCallExpression node) {
        UExpression uExpression = node.getArgumentForParameter(0);
        if (uExpression == null) {
            return;
        }
        UExpression firstArg = uExpression;
        if (AccessibilityForceFocusDetector.checkPerformAccessibilityAction$evaluatesToFocusValue(firstArg) || AccessibilityForceFocusDetector.checkPerformAccessibilityAction$containsRefToFocus(firstArg)) {
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getCallLocation(node, true, true), (String)"Do not force accessibility focus, as this interferes with screen readers and gives an inconsistent user experience, especially across apps", null, (int)16, null);
        }
    }

    private static final boolean visitMethodCall$isViewMethod(PsiMethod $method, JavaContext $context, String methodName, String ... argumentTypes) {
        return Intrinsics.areEqual((Object)$method.getName(), (Object)methodName) && $context.getEvaluator().methodMatches($method, "android.view.View", true, Arrays.copyOf(argumentTypes, argumentTypes.length));
    }

    private static final boolean checkPerformAccessibilityAction$evaluatesToFocusValue(UExpression $this$checkPerformAccessibilityAction_u24evaluatesToFocusValue) {
        return Intrinsics.areEqual((Object)$this$checkPerformAccessibilityAction_u24evaluatesToFocusValue.evaluate(), (Object)64);
    }

    private static final boolean checkPerformAccessibilityAction$containsRefToFocus(UExpression $this$checkPerformAccessibilityAction_u24containsRefToFocus) {
        Ref.BooleanRef referencesFocus = new Ref.BooleanRef();
        $this$checkPerformAccessibilityAction_u24containsRefToFocus.accept((UastVisitor)new AbstractUastVisitor(referencesFocus){
            final /* synthetic */ Ref.BooleanRef $referencesFocus;
            {
                this.$referencesFocus = $referencesFocus;
            }

            public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)node.getIdentifier(), (Object)"ACTION_ACCESSIBILITY_FOCUS")) {
                    this.$referencesFocus.element = true;
                    return true;
                }
                return super.visitSimpleNameReferenceExpression(node);
            }
        });
        return referencesFocus.element;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.A11Y;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(AccessibilityForceFocusDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"AccessibilityFocus", (String)"Forcing accessibility focus", (String)"\n          Forcing accessibility focus interferes with screen readers and gives an \\\n          inconsistent user experience, especially across apps.\n          ", (Implementation)implementation, null, (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/AccessibilityForceFocusDetector$Companion;", "", "<init>", "()V", "ACTION_ACCESSIBILITY_FOCUS", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

