/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ApiClass;
import com.android.tools.lint.checks.ApiClassBase;
import com.android.tools.lint.checks.ApiClassOwner;
import com.android.tools.lint.checks.ApiParser;
import com.android.tools.lint.checks.PrivateApiClass;
import com.android.tools.lint.checks.PrivateApiParser;
import com.android.tools.lint.detector.api.ExtensionSdk;
import com.android.utils.XmlUtils;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class Api<C extends ApiClassBase> {
    private final Map<String, C> mClasses;
    private final Map<String, ApiClassOwner<C>> mContainers;
    private final List<ExtensionSdk> mSdks;
    private final Map<Object, Integer> mSdkIndex = new LinkedHashMap<Object, Integer>();
    public static boolean TEST_TWO_BYTE_APIS = false;

    public static Api<ApiClass> parseApi(File apiFile) {
        Api<ApiClass> api2;
        FileInputStream inputStream2 = new FileInputStream(apiFile);
        try {
            api2 = Api.parseApi(inputStream2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream2).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((InputStream)inputStream2).close();
        return api2;
    }

    public static Api<ApiClass> parseApi(InputStream inputStream2) {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            XmlUtils.configureSaxFactory((SAXParserFactory)parserFactory, (boolean)false, (boolean)false);
            SAXParser parser = XmlUtils.createSaxParser((SAXParserFactory)parserFactory);
            ApiParser apiParser = new ApiParser();
            parser.parse(inputStream2, (DefaultHandler)apiParser);
            return new Api<ApiClass>(apiParser.getClasses(), apiParser.getContainers(), apiParser.getExtensionSdks());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public static Api<PrivateApiClass> parseHiddenApi(URL input) {
        Api<PrivateApiClass> api2;
        block8: {
            InputStream inputStream2 = input.openStream();
            try {
                PrivateApiParser privateApiParser = new PrivateApiParser();
                privateApiParser.parse(inputStream2);
                api2 = new Api<PrivateApiClass>(privateApiParser.getClasses(), privateApiParser.getContainers(), Collections.emptyList());
                if (inputStream2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream2.close();
        }
        return api2;
    }

    private Api(Map<String, C> classes, Map<String, ApiClassOwner<C>> containers, List<ExtensionSdk> sdks) {
        int i;
        int next = this.mSdkIndex.size();
        if (TEST_TWO_BYTE_APIS) {
            for (i = 300; i < 500; ++i) {
                this.mSdkIndex.put(ApiParser.toVersionInt(i, 0) + ":1", next++);
            }
        }
        for (i = 0; i <= 37; ++i) {
            this.mSdkIndex.put(ApiParser.toVersionInt(i, 0), next++);
        }
        this.mSdkIndex.put(ApiParser.toVersionInt(10000, 0), next);
        this.mClasses = Collections.unmodifiableMap(new MyHashMap<C>(classes));
        this.mContainers = Collections.unmodifiableMap(new MyHashMap<ApiClassOwner<C>>(containers));
        this.mSdks = Collections.unmodifiableList(sdks);
    }

    C getClass(String fqcn) {
        return (C)((ApiClassBase)this.mClasses.get(fqcn));
    }

    Map<String, C> getClasses() {
        return this.mClasses;
    }

    Map<String, ApiClassOwner<C>> getContainers() {
        return this.mContainers;
    }

    public short getSdkIndex(Object sdks) {
        Integer sdkIndex = this.mSdkIndex.get(sdks);
        if (sdkIndex != null) {
            return sdkIndex.shortValue();
        }
        int index2 = this.mSdkIndex.size();
        this.mSdkIndex.put(sdks, index2);
        return (short)index2;
    }

    public List<String> getSdks() {
        ArrayList<String> list = new ArrayList<String>();
        for (Object key : this.mSdkIndex.keySet()) {
            if (key instanceof Integer) {
                int value = (Integer)key;
                int major = ApiParser.getMajorVersion(value);
                int minor = ApiParser.getMinorVersion(value);
                if (minor > 0) {
                    list.add(Integer.toString(major) + "." + minor);
                    continue;
                }
                list.add(Integer.toString(major));
                continue;
            }
            if (key instanceof String) {
                list.add(key.toString());
                continue;
            }
            throw new RuntimeException(key.toString());
        }
        return list;
    }

    public List<ExtensionSdk> getExtensionSdks() {
        return this.mSdks;
    }

    private static class MyHashMap<V>
    extends Object2ObjectOpenCustomHashMap<String, V> {
        private static final Hash.Strategy<String> myHashingStrategy = new Hash.Strategy<String>(){

            public int hashCode(String str2) {
                if (str2 == null) {
                    return 0;
                }
                int h = 0;
                for (int i = 0; i < str2.length(); ++i) {
                    char c2 = str2.charAt(i);
                    c2 = MyHashMap.normalizeSeparator(c2);
                    h = 31 * h + c2;
                }
                return h;
            }

            public boolean equals(String s1, String s2) {
                if (s1 == null) {
                    return s2 == null;
                }
                if (s2 == null) {
                    return false;
                }
                if (s1.length() != s2.length()) {
                    return false;
                }
                for (int i = 0; i < s1.length(); ++i) {
                    if (MyHashMap.normalizeSeparator(s1.charAt(i)) == MyHashMap.normalizeSeparator(s2.charAt(i))) continue;
                    return false;
                }
                return true;
            }
        };

        private static char normalizeSeparator(char c2) {
            if (c2 == '/' || c2 == '$') {
                c2 = (char)46;
            }
            return c2;
        }

        MyHashMap(Map<String, V> data) {
            super(data, myHashingStrategy);
        }
    }
}

