/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.CutPasteDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0002!\"B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J \u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J(\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0006H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0015H\u0002\u00a8\u0006#"}, d2={"Lcom/android/tools/lint/checks/RecyclerViewDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "applicableSuperClasses", "", "", "getApplicableMethodNames", "visitClass", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "checkMethod", "Lcom/intellij/psi/PsiMethod;", "cls", "Lcom/intellij/psi/PsiClass;", "visitMethodCall", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "reportError", "viewHolder", "Lcom/intellij/psi/PsiParameter;", "parameter", "checkDataBinders", "Lorg/jetbrains/uast/UMethod;", "references", "isExecutePendingBindingsCall", "", "call", "ParameterEscapesVisitor", "Companion", "lint-checks"})
public final class RecyclerViewDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(RecyclerViewDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue FIXED_POSITION;
    @JvmField
    @NotNull
    public static final Issue DATA_BINDER;
    @JvmField
    @NotNull
    public static final Issue CLEAR_ALL_DATA;
    @NotNull
    private static final String ON_BIND_VIEW_HOLDER = "onBindViewHolder";
    @NotNull
    private static final String NOTIFY_DATA_SET_CHANGED = "notifyDataSetChanged";
    @NotNull
    private static final String SUPERCLASS_SUPPORTLIB = "android.support.v7.widget.RecyclerView.Adapter";
    @NotNull
    private static final String SUPERCLASS_ANDROIDX = "androidx.recyclerview.widget.RecyclerView.Adapter";

    @NotNull
    public List<String> applicableSuperClasses() {
        Object[] objectArray = new String[]{SUPERCLASS_SUPPORTLIB, SUPERCLASS_ANDROIDX};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)NOTIFY_DATA_SET_CHANGED);
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        JavaEvaluator evaluator = context.getEvaluator();
        PsiClass psiClass = declaration.getJavaPsi();
        for (PsiMethod method : psiClass.findMethodsByName(ON_BIND_VIEW_HOLDER, false)) {
            Intrinsics.checkNotNull((Object)method);
            int size = evaluator.getParameterCount(method);
            switch (size) {
                case 2: 
                case 3: {
                    this.checkMethod(context, method, psiClass);
                }
            }
        }
    }

    private final void checkMethod(JavaContext context, PsiMethod declaration, PsiClass cls) {
        PsiParameter[] psiParameterArray = declaration.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        PsiParameter[] parameters = psiParameterArray;
        PsiParameter viewHolder = parameters[0];
        PsiParameter parameter = parameters[1];
        Intrinsics.checkNotNull((Object)parameter);
        ParameterEscapesVisitor visitor2 = new ParameterEscapesVisitor(cls, parameter);
        UMethod uMethod = Lint.getUMethod((PsiMethod)declaration);
        if (uMethod == null) {
            return;
        }
        UMethod method = uMethod;
        method.accept((UastVisitor)visitor2);
        if (visitor2.variableEscapes()) {
            Intrinsics.checkNotNull((Object)viewHolder);
            this.reportError(context, viewHolder, parameter);
        }
        this.checkDataBinders(context, method, visitor2.getDataBinders());
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (Intrinsics.areEqual((Object)method.getName(), (Object)NOTIFY_DATA_SET_CHANGED) && (JavaEvaluator.isMemberInSubClassOf$default((JavaEvaluator)context.getEvaluator(), (PsiMember)((PsiMember)method), (String)SUPERCLASS_SUPPORTLIB, (boolean)false, (int)4, null) || JavaEvaluator.isMemberInSubClassOf$default((JavaEvaluator)context.getEvaluator(), (PsiMember)((PsiMember)method), (String)SUPERCLASS_ANDROIDX, (boolean)false, (int)4, null))) {
            Context.report$default((Context)((Context)context), (Issue)CLEAR_ALL_DATA, (Location)context.getLocation((UElement)node), (String)"It will always be more efficient to use more specific change events if you can. Rely on `notifyDataSetChanged` as a last resort.", null, (int)8, null);
        }
    }

    private final void reportError(JavaContext context, PsiParameter viewHolder, PsiParameter parameter) {
        String string = viewHolder.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String variablePrefix = string;
        String message2 = "Do not treat position as fixed; only use immediately and call `" + variablePrefix + ".getAdapterPosition()` to look it up later";
        JavaContext.report$default((JavaContext)context, (Issue)FIXED_POSITION, (PsiElement)((PsiElement)parameter), (Location)context.getLocation((PsiElement)parameter), (String)message2, null, (int)16, null);
    }

    private final void checkDataBinders(JavaContext context, UMethod declaration, List<? extends UCallExpression> references) {
        if (references != null && !((Collection)references).isEmpty()) {
            ArrayList targets = Lists.newArrayList();
            ArrayList sources = Lists.newArrayList();
            for (UCallExpression iterator2 : references) {
                boolean bl = this.isExecutePendingBindingsCall(iterator2) ? targets.add(iterator2) : sources.add(iterator2);
            }
            HashMap parentToChildren = Maps.newHashMap();
            Iterator iterator = sources.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                UCallExpression reference = (UCallExpression)iterator2.next();
                Intrinsics.checkNotNull((Object)reference);
                UExpression statement = (UExpression)UastUtils.getParentOfType((UElement)((UElement)reference), UExpression.class, (boolean)true);
                if (statement == null) continue;
                Intrinsics.checkNotNull((Object)parentToChildren);
                ((Map)parentToChildren).put(statement.getUastParent(), reference);
            }
            for (UCallExpression source : parentToChildren.values()) {
                Iterator iterator3;
                UExpression sourceBinderReference;
                if (source.getReceiver() == null || RecyclerViewDetector.Companion.getDataBinderReference((UElement)sourceBinderReference) == null) continue;
                boolean reachesTarget = false;
                Intrinsics.checkNotNullExpressionValue(targets.iterator(), (String)"iterator(...)");
                while (iterator3.hasNext()) {
                    PsiField sourceDataBinder;
                    UCallExpression target2 = (UCallExpression)iterator3.next();
                    if (!Intrinsics.areEqual((Object)sourceDataBinder, (Object)RecyclerViewDetector.Companion.getDataBinderReference((UElement)target2.getReceiver())) || !CutPasteDetector.isReachableFrom(declaration, (UElement)source, (UElement)target2)) continue;
                    reachesTarget = true;
                    break;
                }
                if (reachesTarget) continue;
                String lhs = sourceBinderReference.asSourceString();
                String message2 = "You must call `" + lhs + ".executePendingBindings()` before the `onBind` method exits, otherwise, the DataBinding library will update the UI in the next animation frame causing a delayed update & potential jumps if the item resizes.";
                Intrinsics.checkNotNull((Object)source);
                Location location = context.getLocation((UElement)source);
                JavaContext.report$default((JavaContext)context, (Issue)DATA_BINDER, (UElement)((UElement)source), (Location)location, (String)message2, null, (int)16, null);
            }
        }
    }

    private final boolean isExecutePendingBindingsCall(UCallExpression call2) {
        return Intrinsics.areEqual((Object)"executePendingBindings", (Object)Lint.getMethodName((UCallExpression)call2));
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        FIXED_POSITION = Issue.Companion.create$default((Issue.Companion)companion, (String)"RecyclerView", (String)"RecyclerView Problems", (String)"\n                `RecyclerView` will **not** call `onBindViewHolder` again when the position \\\n                of the item changes in the data set unless the item itself is invalidated or \\\n                the new position cannot be determined.\n\n                For this reason, you should **only** use the position parameter while \\\n                acquiring the related data item inside this method, and should **not** keep \\\n                a copy of it.\n\n                If you need the position of an item later on (e.g. in a click listener), use \\\n                `getAdapterPosition()` which will have the updated adapter position.\n                ", (Implementation)implementation, null, (Category)category, (int)8, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        DATA_BINDER = Issue.Companion.create$default((Issue.Companion)companion, (String)"PendingBindings", (String)"Missing Pending Bindings", (String)"\n                When using a `ViewDataBinding` in a `onBindViewHolder` method, you **must** \\\n                call `executePendingBindings()` before the method exits; otherwise the data \\\n                binding runtime will update the UI in the next animation frame causing a \\\n                delayed update and potential jumps if the item resizes.\n                ", (Implementation)implementation, null, (Category)category, (int)8, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
        companion = Issue.Companion;
        category = Category.PERFORMANCE;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        CLEAR_ALL_DATA = Issue.Companion.create$default((Issue.Companion)companion, (String)"NotifyDataSetChanged", (String)"Invalidating All RecyclerView Data", (String)"\n                The `RecyclerView` adapter's `onNotifyDataSetChanged` method does not specify what \\\n                about the data set has changed, forcing any observers to assume that all existing \\\n                items and structure may no longer be valid. `LayoutManager`s will be forced to \\\n                fully rebind and relayout all visible views.\n                ", (Implementation)implementation, null, (Category)category, (int)8, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/RecyclerViewDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "FIXED_POSITION", "Lcom/android/tools/lint/detector/api/Issue;", "DATA_BINDER", "CLEAR_ALL_DATA", "ON_BIND_VIEW_HOLDER", "", "NOTIFY_DATA_SET_CHANGED", "SUPERCLASS_SUPPORTLIB", "SUPERCLASS_ANDROIDX", "getDataBinderReference", "Lcom/intellij/psi/PsiField;", "element", "Lorg/jetbrains/uast/UElement;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final PsiField getDataBinderReference(UElement element) {
            PsiElement resolved;
            if (element instanceof UReferenceExpression && (resolved = ((UReferenceExpression)element).resolve()) instanceof PsiField && Intrinsics.areEqual((Object)"dataBinder", (Object)((PsiField)resolved).getName())) {
                return (PsiField)resolved;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0014\u001a\u00020\fJ\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/checks/RecyclerViewDetector$ParameterEscapesVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "bindClass", "Lcom/intellij/psi/PsiClass;", "variable", "Lcom/intellij/psi/PsiParameter;", "<init>", "(Lcom/intellij/psi/PsiClass;Lcom/intellij/psi/PsiParameter;)V", "variables", "", "Lcom/intellij/psi/PsiVariable;", "escapes", "", "foundInnerClass", "dataBinders", "Lorg/jetbrains/uast/UCallExpression;", "getDataBinders", "()Ljava/util/List;", "setDataBinders", "(Ljava/util/List;)V", "variableEscapes", "visitVariable", "node", "Lorg/jetbrains/uast/UVariable;", "visitBinaryExpression", "Lorg/jetbrains/uast/UBinaryExpression;", "visitSimpleNameReferenceExpression", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "visitClass", "Lorg/jetbrains/uast/UClass;", "visitCallExpression", "lint-checks"})
    private static final class ParameterEscapesVisitor
    extends AbstractUastVisitor {
        @NotNull
        private final PsiClass bindClass;
        @NotNull
        private final List<PsiVariable> variables;
        private boolean escapes;
        private boolean foundInnerClass;
        @Nullable
        private List<UCallExpression> dataBinders;

        public ParameterEscapesVisitor(@NotNull PsiClass bindClass, @NotNull PsiParameter variable) {
            Intrinsics.checkNotNullParameter((Object)bindClass, (String)"bindClass");
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            this.bindClass = bindClass;
            Object[] objectArray = new PsiVariable[]{variable};
            ArrayList arrayList = Lists.newArrayList((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
            this.variables = arrayList;
        }

        @Nullable
        public final List<UCallExpression> getDataBinders() {
            return this.dataBinders;
        }

        public final void setDataBinders(@Nullable List<UCallExpression> list) {
            this.dataBinders = list;
        }

        public final boolean variableEscapes() {
            return this.escapes;
        }

        public boolean visitVariable(@NotNull UVariable node) {
            PsiElement resolved;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            UExpression initializer = node.getUastInitializer();
            if (initializer instanceof UReferenceExpression && (resolved = ((UReferenceExpression)initializer).resolve()) != null && CollectionsKt.contains((Iterable)this.variables, (Object)resolved)) {
                if (resolved instanceof ULocalVariable) {
                    this.variables.add((PsiVariable)node);
                } else if (resolved instanceof PsiField) {
                    this.escapes = true;
                }
            }
            return super.visitVariable(node);
        }

        public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.getOperator() instanceof UastBinaryOperator.AssignOperator) {
                PsiElement resolved;
                UExpression rhs = node.getRightOperand();
                boolean clearLhs = true;
                if (rhs instanceof UReferenceExpression && (resolved = ((UReferenceExpression)rhs).resolve()) != null && CollectionsKt.contains((Iterable)this.variables, (Object)resolved)) {
                    clearLhs = false;
                    PsiElement resolvedLhs = UastUtils.tryResolve((UElement)((UElement)node.getLeftOperand()));
                    if (resolvedLhs instanceof PsiLocalVariable) {
                        this.variables.add((PsiVariable)resolvedLhs);
                    } else if (resolvedLhs instanceof PsiField) {
                        this.escapes = true;
                    }
                }
                if (clearLhs && (resolved = UastUtils.tryResolve((UElement)((UElement)node.getLeftOperand()))) != null) {
                    TypeIntrinsics.asMutableCollection((Object)this.variables).remove(resolved);
                }
            }
            return super.visitBinaryExpression(node);
        }

        public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
            UElement outer;
            PsiElement resolved;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (this.foundInnerClass && (resolved = node.resolve()) != null && CollectionsKt.contains((Iterable)this.variables, (Object)resolved) && !Intrinsics.areEqual((Object)this.bindClass, (Object)(outer = UastUtils.getParentOfType((UElement)((UElement)node), UClass.class, (boolean)true)))) {
                this.escapes = true;
            }
            return super.visitSimpleNameReferenceExpression(node);
        }

        public boolean visitClass(@NotNull UClass node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node instanceof UAnonymousClass || !node.isStatic()) {
                this.foundInnerClass = true;
            }
            return super.visitClass(node);
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            UExpression methodExpression;
            PsiField dataBinder;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (UastExpressionUtils.isMethodCall((UElement)((UElement)node)) && (dataBinder = Companion.getDataBinderReference((UElement)(methodExpression = node.getReceiver()))) != null) {
                List list = this.dataBinders;
                if (list == null) {
                    ParameterEscapesVisitor $this$visitCallExpression_u24lambda_u240 = this;
                    boolean bl = false;
                    ArrayList arrayList = Lists.newArrayList();
                    $this$visitCallExpression_u24lambda_u240.dataBinders = arrayList;
                    list = arrayList;
                }
                List list2 = list;
                list2.add((UCallExpression)node);
            }
            return super.visitCallExpression(node);
        }
    }
}

