/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULiteralExpression;

public class StringAuthLeakDetector
extends Detector
implements SourceCodeScanner {
    public static final Issue AUTH_LEAK = Issue.create((String)"AuthLeak", (String)"Code might contain an auth leak", (String)"Strings in java apps can be discovered by decompiling apps, this lint check looks for code which looks like it may contain an url with a username and password", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(StringAuthLeakDetector.class, Scope.JAVA_FILE_SCOPE)).setAndroidSpecific(true).addMoreInfo("https://goo.gle/AuthLeak");

    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(ULiteralExpression.class);
    }

    public UElementHandler createUastHandler(JavaContext context) {
        return new AuthLeakChecker(context);
    }

    private static class AuthLeakChecker
    extends UElementHandler {
        private static final String LEGAL_CHARS = "([\\w_.!~*'()%;&=+$,-]+)";
        private static final Pattern AUTH_REGEXP = Pattern.compile("([\\w+.-]+)://([\\w_.!~*'()%;&=+$,-]+):([\\w_.!~*'()%;&=+$,-]+)@([\\w_.!~*'()%;&=+$,-]+)");
        private final JavaContext context;

        private AuthLeakChecker(JavaContext context) {
            this.context = context;
        }

        public void visitLiteralExpression(ULiteralExpression node) {
            if (node.getValue() instanceof String) {
                String str2 = (String)node.getValue();
                if (str2.length() > 512) {
                    return;
                }
                Matcher matcher = AUTH_REGEXP.matcher(str2);
                if (matcher.find()) {
                    Matcher format2;
                    String password = matcher.group(3);
                    if (password == null) {
                        return;
                    }
                    if (password.startsWith("%") && password.endsWith("s") && (format2 = StringFormatDetector.FORMAT.matcher(password)).matches()) {
                        return;
                    }
                    Location location = this.context.getRangeLocation((UElement)node, matcher.start() + 1, matcher.end() - matcher.start());
                    this.context.report(AUTH_LEAK, (UElement)node, location, "Possible credential leak");
                }
            }
        }
    }
}

