/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.ThreadConstraintDetector;
import com.android.tools.lint.checks.fx.JoinEffectDetector;
import com.android.tools.lint.checks.fx.analysis.ModuleKt;
import com.android.tools.lint.checks.fx.result.ConstraintFailure;
import com.android.tools.lint.checks.fx.result.EffectAnnotation;
import com.android.tools.lint.checks.fx.result.Error;
import com.android.tools.lint.checks.fx.result.MethodId;
import com.android.tools.lint.checks.fx.result.Type;
import com.android.tools.lint.checks.fx.utils.Lattice;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.ULong;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003:\u0002-.B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u0016H\u0014J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002JJ\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u001c2\u0006\u0010\u0013\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u001c2\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u001c0 H\u0016J6\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\"2\u0006\u0010#\u001a\u00020$2\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u001c0 H\u0016J \u0010%\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010&\u001a\u00020'H\u0016J\u001e\u0010(\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00042\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0 H\u0016J\u0018\u0010+\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00042\u0006\u0010,\u001a\u00020*H$R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006/"}, d2={"Lcom/android/tools/lint/checks/ThreadConstraintDetector;", "T", "", "Lcom/android/tools/lint/checks/fx/JoinEffectDetector;", "Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraint;", "lattice", "Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraintLattice;", "<init>", "(Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraintLattice;)V", "getLattice", "()Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraintLattice;", "violationIssue", "Lcom/android/tools/lint/detector/api/Issue;", "getViolationIssue", "()Lcom/android/tools/lint/detector/api/Issue;", "unsatisfiableConstraintIssue", "getUnsatisfiableConstraintIssue", "report", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "error", "Lcom/android/tools/lint/checks/fx/result/Error;", "locationOf", "Lcom/android/tools/lint/detector/api/Location;", "site", "Lorg/jetbrains/uast/UElement;", "resolveAnnotations", "Lcom/android/tools/lint/checks/fx/result/EffectAnnotation$Explicit;", "Lcom/android/tools/lint/detector/api/JavaContext;", "targetAnn", "baseAnns", "", "inheritAnnotations", "Lcom/android/tools/lint/checks/fx/result/EffectAnnotation$Implicit;", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "parseMethodImmediateAnnotations", "method", "Lorg/jetbrains/uast/UMethod;", "parseAnnotations", "annotations", "Lorg/jetbrains/uast/UAnnotation;", "parse", "ann", "ThreadConstraint", "ThreadConstraintLattice", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nThreadConstraintDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadConstraintDetector.kt\ncom/android/tools/lint/checks/ThreadConstraintDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,392:1\n1617#2,9:393\n1869#2:402\n1870#2:404\n1626#2:405\n1504#2:406\n1534#2,3:407\n1537#2,3:417\n774#2:420\n865#2,2:421\n1617#2,9:423\n1869#2:432\n1870#2:434\n1626#2:435\n2783#2,7:436\n1625#2:443\n1869#2:444\n1870#2:446\n1626#2:447\n1#3:403\n1#3:433\n1#3:445\n382#4,7:410\n*S KotlinDebug\n*F\n+ 1 ThreadConstraintDetector.kt\ncom/android/tools/lint/checks/ThreadConstraintDetector\n*L\n145#1:393,9\n145#1:402\n145#1:404\n145#1:405\n188#1:406\n188#1:407,3\n188#1:417,3\n257#1:420\n257#1:421,2\n299#1:423,9\n299#1:432\n299#1:434\n299#1:435\n302#1:436,7\n204#1:443\n204#1:444\n204#1:446\n204#1:447\n145#1:403\n299#1:433\n204#1:445\n188#1:410,7\n*E\n"})
public abstract class ThreadConstraintDetector<T extends Enum<T>>
extends JoinEffectDetector<ThreadConstraint<T>> {
    @NotNull
    private final ThreadConstraintLattice<T> lattice;

    public ThreadConstraintDetector(@NotNull ThreadConstraintLattice<T> lattice) {
        Intrinsics.checkNotNullParameter(lattice, (String)"lattice");
        super((Lattice)lattice);
        this.lattice = lattice;
    }

    @NotNull
    protected final ThreadConstraintLattice<T> getLattice() {
        return this.lattice;
    }

    @NotNull
    protected abstract Issue getViolationIssue();

    @NotNull
    protected abstract Issue getUnsatisfiableConstraintIssue();

    /*
     * WARNING - void declaration
     */
    @Override
    protected void report(@NotNull Context context, @NotNull Error<ThreadConstraint<T>> error) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(error, (String)"error");
        Error<ThreadConstraint<T>> error2 = error;
        if (error2 instanceof Error.ExceedingAnnotation) {
            UDeclaration uDeclaration = UastLintUtils.Companion.tryResolveUDeclaration(((Error.ExceedingAnnotation)error).getSite());
            UMethod uMethod = uDeclaration instanceof UMethod ? (UMethod)uDeclaration : null;
            String callLabel = Intrinsics.areEqual((Object)(uMethod != null ? Boolean.valueOf(ModuleKt.isKtProperty(uMethod)) : null), (Object)true) ? "Property call" : "Call";
            String message2 = Intrinsics.areEqual(((Error.ExceedingAnnotation)error).getCalleeLowerBound(), this.lattice.getNoThread()) ? callLabel + " has an unsatisfiable thread requirement, but context is allowing " + ((Error.ExceedingAnnotation)error).getCallerAnnotation() : callLabel + " must be from " + ((Error.ExceedingAnnotation)error).getCalleeLowerBound() + ", but context is allowing " + ((Error.ExceedingAnnotation)error).getCallerAnnotation();
            Context.report$default((Context)context, (Issue)this.getViolationIssue(), (Location)this.locationOf(context, ((Error.ExceedingAnnotation)error).getSite()), (String)message2, null, (int)8, null);
        } else if (error2 instanceof Error.IntroducingTop) {
            UElement site = ((Error.IntroducingTop)error).getSite();
            ThreadConstraint t1 = (ThreadConstraint)((Error.IntroducingTop)error).getFirst();
            ThreadConstraint t2 = (ThreadConstraint)((Error.IntroducingTop)error).getNext();
            UElement parentSite = site.getUastParent();
            String message3 = parentSite instanceof UIfExpression ? (Intrinsics.areEqual((Object)site, (Object)((UIfExpression)parentSite).getCondition()) ? "Condition must run from " + t1 + ", while branches must run from " + t2 : "Branch must run from " + t2 + ", incompatible with the other that must run from " + t1) : (parentSite instanceof UExpressionList || parentSite instanceof UBlockExpression ? "Statement must run from " + t2 + ", incompatible with earlier code that must run from " + t1 : (parentSite instanceof USwitchExpression ? (Intrinsics.areEqual((Object)site, (Object)((USwitchExpression)parentSite).getExpression()) ? "Condition must run from " + t1 + ", while branches must run from " + t2 : "Branch must run from " + t2 + ", incompatible with the another that must run from " + t1) : "Expression results in an unsatisfiable thread requirement (" + t2 + ", after inferred " + t1 + ")"));
            Context.report$default((Context)context, (Issue)this.getUnsatisfiableConstraintIssue(), (Location)this.locationOf(context, site), (String)message3, null, (int)8, null);
        } else if (error2 instanceof Error.CallingTop) {
            Context.report$default((Context)context, (Issue)this.getUnsatisfiableConstraintIssue(), (Location)this.locationOf(context, ((Error.CallingTop)error).getSource()), (String)"Call results in an unsatisfiable thread requirement", null, (int)8, null);
        } else if (error2 instanceof Error.FailingConstraint) {
            Map map;
            UExpression v;
            Object $this$report_u24lambda_u240;
            Object receiver2;
            UElement method;
            UExpression call2 = ((Error.FailingConstraint)error).getSite();
            UCallExpression uCallExpression = call2 instanceof UCallExpression ? (UCallExpression)call2 : null;
            Object object = method = uCallExpression != null ? UResolvableKt.resolveToUElement((UResolvable)((UResolvable)uCallExpression)) : null;
            if (method instanceof UMethod) {
                List params = ((UMethod)method).getUastParameters();
                receiver2 = ((UCallExpression)call2).getReceiver();
                Map map2 = MapsKt.createMapBuilder();
                $this$report_u24lambda_u240 = map2;
                boolean bl = false;
                if (receiver2 != null) {
                    $this$report_u24lambda_u240.put("this", receiver2);
                }
                for (Pair pair : CollectionsKt.zip((Iterable)params, (Iterable)((UCallExpression)call2).getValueArguments())) {
                    UParameter x = (UParameter)pair.component1();
                    v = (UExpression)pair.component2();
                    PsiElement psiElement = x.getJavaPsi();
                    Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiParameter");
                    String string = ((PsiParameter)psiElement).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    $this$report_u24lambda_u240.put(string, v);
                }
                map = MapsKt.build((Map)map2);
            } else {
                map = MapsKt.emptyMap();
            }
            Map paramToArg = map;
            PersistentSet constraints = ((Error.FailingConstraint)error).getConstraints();
            if (constraints == null) {
                Context.report$default((Context)context, (Issue)this.getViolationIssue(), (Location)this.locationOf(context, (UElement)call2), (String)"Call fails thread requirements on arguments", null, (int)8, null);
            } else {
                void $this$mapNotNullTo$iv$iv;
                boolean params;
                boolean bl = params = !((Collection)constraints).isEmpty();
                if (_Assertions.ENABLED && !params) {
                    receiver2 = "Assertion failed";
                    throw new AssertionError(receiver2);
                }
                Iterable $this$mapNotNull$iv = (Iterable)constraints;
                boolean $i$f$mapNotNull2 = false;
                $this$report_u24lambda_u240 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                v = $this$forEach$iv$iv$iv.iterator();
                while (v.hasNext()) {
                    Pair it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = v.next();
                    boolean bl2 = false;
                    ConstraintFailure failure = (ConstraintFailure)element$iv$iv;
                    boolean bl3 = false;
                    UExpression arg = (UExpression)paramToArg.get(Type.Sym.Companion.getChain$lint_checks(failure.getInvocation()).getFirst());
                    if ((arg != null ? TuplesKt.to((Object)arg, (Object)failure) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List concreteReasons = (List)destination$iv$iv;
                if (concreteReasons.isEmpty()) {
                    String message4 = CollectionsKt.joinToString$default((Iterable)((Iterable)constraints), (CharSequence)" ", null, null, (int)0, null, (Function1)report.message.1.INSTANCE, (int)30, null);
                    Context.report$default((Context)context, (Issue)this.getViolationIssue(), (Location)this.locationOf(context, (UElement)call2), (String)message4, null, (int)8, null);
                } else {
                    for (Pair $i$f$mapNotNull2 : concreteReasons) {
                        UExpression arg = (UExpression)$i$f$mapNotNull2.component1();
                        ConstraintFailure failure = (ConstraintFailure)$i$f$mapNotNull2.component2();
                        Type.Sym symCall = failure.component1();
                        ThreadConstraint expectedUpper = (ThreadConstraint)failure.component2();
                        ThreadConstraint inferredLower = (ThreadConstraint)failure.component3();
                        List chain = (List)Type.Sym.Companion.getChain$lint_checks(symCall).component2();
                        String message5 = chain.size() == 1 && Intrinsics.areEqual((Object)((MethodId)CollectionsKt.first((List)chain)).getName(), (Object)"invoke") ? "Argument must run from " + expectedUpper + ", but is requiring " + inferredLower : "Argument must allow calling `" + CollectionsKt.joinToString$default((Iterable)chain, (CharSequence)".", null, null, (int)0, null, (Function1)report.message.2.INSTANCE, (int)30, null) + "` from " + expectedUpper + ", but that call is requiring " + inferredLower;
                        Context.report$default((Context)context, (Issue)this.getViolationIssue(), (Location)this.locationOf(context, (UElement)arg), (String)message5, null, (int)8, null);
                    }
                }
            }
        } else if (error2 instanceof Error.ConflictingAnnotations) {
            void $this$groupByTo$iv$iv;
            Error<ThreadConstraint<T>> call2 = error;
            EffectAnnotation.Explicit self = ((Error.ConflictingAnnotations)call2).component1();
            Collection bases = ((Error.ConflictingAnnotations)call2).component2();
            Iterable $this$groupBy$iv = bases;
            boolean $i$f$groupBy = false;
            Iterable arg = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it;
                Object object;
                EffectAnnotation.Explicit it2 = (EffectAnnotation.Explicit)element$iv$iv;
                boolean $i$a$-groupBy-ThreadConstraintDetector$report$baseAnnotations$32 = false;
                ThreadConstraint key$iv$iv = (ThreadConstraint)it2.getAnnotated();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                EffectAnnotation.Explicit $i$a$-groupBy-ThreadConstraintDetector$report$baseAnnotations$32 = (EffectAnnotation.Explicit)element$iv$iv;
                List list = list$iv$iv;
                boolean bl = false;
                UElement uElement = it.getOrigin();
                list.add(uElement instanceof UMethod ? (UMethod)uElement : null);
            }
            Map baseAnnotations = destination$iv$iv;
            String baseStr2 = ThreadConstraintDetector.report$join(baseAnnotations.entrySet(), baseAnnotations.size(), report.baseStr.1.INSTANCE);
            Context.report$default((Context)context, (Issue)this.getViolationIssue(), (Location)this.locationOf(context, self.getOrigin()), (String)(self.getAnnotated() + " restricts " + baseStr2), null, (int)8, null);
        } else if (error2 instanceof Error.ConflictingInference) {
            ThreadConstraint baseAnn = (ThreadConstraint)((Error.ConflictingInference)error).getConflictingBase().getAnnotated();
            UElement uElement = ((Error.ConflictingInference)error).getConflictingBase().getOrigin();
            UMethod uMethod = uElement instanceof UMethod ? (UMethod)uElement : null;
            String baseName = uMethod != null && (uMethod = UastUtils.getContainingUClass((UElement)((UElement)uMethod))) != null && (uMethod = uMethod.getJavaPsi()) != null ? uMethod.getName() : null;
            String baseStr3 = baseName == null ? "a super method" : "super method `" + baseName + "." + ((UMethod)((Error.ConflictingInference)error).getConflictingBase().getOrigin()).getName() + "(\u2026)`";
            String message6 = Intrinsics.areEqual((Object)((ThreadConstraint)((Error.ConflictingInference)error).getInferredLowerBound()), this.lattice.getNoThread()) ? "Call has an unsatisfiable thread requirement, but " + baseStr3 + " is allowing " + baseAnn : "Call must be from " + ((Error.ConflictingInference)error).getInferredLowerBound() + ", but " + baseStr3 + " is allowing " + baseAnn;
            Context.report$default((Context)context, (Issue)this.getViolationIssue(), (Location)this.locationOf(context, ((Error.ConflictingInference)error).getSite()), (String)message6, null, (int)8, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final Location locationOf(Context $this$locationOf, UElement site) {
        return $this$locationOf.getClient().getUastParser($this$locationOf.getProject()).createLocation(site);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public EffectAnnotation.Explicit<ThreadConstraint<T>> resolveAnnotations(@NotNull JavaContext context, @NotNull EffectAnnotation.Explicit<ThreadConstraint<T>> targetAnn, @NotNull List<EffectAnnotation.Explicit<ThreadConstraint<T>>> baseAnns) {
        void $this$filterTo$iv$iv;
        EffectAnnotation.Explicit<ThreadConstraint<T>> explicit;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(targetAnn, (String)"targetAnn");
        Intrinsics.checkNotNullParameter(baseAnns, (String)"baseAnns");
        EffectAnnotation.Explicit<ThreadConstraint<T>> it = explicit = targetAnn;
        boolean bl = false;
        Iterable $this$filter$iv = baseAnns;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EffectAnnotation.Explicit it2 = (EffectAnnotation.Explicit)element$iv$iv;
            boolean bl2 = false;
            if (!(!this.lattice.precede(targetAnn.getAnnotated(), (ThreadConstraint)it2.getAnnotated()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List conflicts = (List)destination$iv$iv;
        if (!((Collection)conflicts).isEmpty()) {
            this.report((Context)context, (Error)new Error.ConflictingAnnotations<ThreadConstraint<T>>(targetAnn, conflicts));
        }
        return explicit;
    }

    @Override
    @NotNull
    public EffectAnnotation.Implicit<ThreadConstraint<T>> inheritAnnotations(@NotNull JavaEvaluator evaluator, @NotNull List<EffectAnnotation.Explicit<ThreadConstraint<T>>> baseAnns) {
        Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
        Intrinsics.checkNotNullParameter(baseAnns, (String)"baseAnns");
        return baseAnns.isEmpty() ? EffectAnnotation.Companion.getNone() : new EffectAnnotation.Implicit<ThreadConstraint<T>>(baseAnns);
    }

    @Override
    @Nullable
    public ThreadConstraint<T> parseMethodImmediateAnnotations(@NotNull JavaEvaluator evaluator, @NotNull UMethod method) {
        Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        ThreadConstraint<T> threadConstraint = ThreadConstraintDetector.parseMethodImmediateAnnotations$fromMethod(this, evaluator, method);
        if (threadConstraint == null) {
            threadConstraint = ThreadConstraintDetector.parseMethodImmediateAnnotations$fromClassOrDefault(method, this, evaluator);
        }
        return threadConstraint;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ThreadConstraint<T> parseAnnotations(@NotNull List<? extends UAnnotation> annotations) {
        ThreadConstraint threadConstraint;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Iterable $this$mapNotNull$iv = annotations;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        ThreadConstraint $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ThreadConstraint<T> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UAnnotation p0 = (UAnnotation)element$iv$iv;
            boolean bl2 = false;
            if (this.parse(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List explicitlyAnnotatedEffects = (List)destination$iv$iv;
        if (explicitlyAnnotatedEffects.isEmpty()) {
            threadConstraint = null;
        } else {
            void $this$reduce$iv;
            $this$mapNotNull$iv = explicitlyAnnotatedEffects;
            ThreadConstraintLattice<T> threadConstraintLattice = this.lattice;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void p1;
                $this$forEach$iv$iv$iv = (ThreadConstraint)iterator$iv.next();
                ThreadConstraint p0 = (ThreadConstraint)accumulator$iv;
                boolean bl = false;
                accumulator$iv = threadConstraintLattice.meetOf(p0, (ThreadConstraint<T>)p1);
            }
            threadConstraint = (ThreadConstraint)accumulator$iv;
        }
        return threadConstraint;
    }

    @Nullable
    protected abstract ThreadConstraint<T> parse(@NotNull UAnnotation var1);

    private static final <T> String report$join(Iterable<? extends T> $this$report_u24join, int size, Function1<? super T, String> format2) {
        StringBuilder stringBuilder;
        StringBuilder $this$report_u24join_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterator<T> iterator = $this$report_u24join.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            T elem = iterator.next();
            String sep = i == 0 ? "" : (size > 1 && i == size - 1 ? ", and " : ",");
            $this$report_u24join_u24lambda_u244.append(sep + format2.invoke(elem));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final String report$originStr(List<? extends UMethod> origins) {
        void var3_2;
        void $this$mapNotNullTo$iv;
        Iterable iterable = origins;
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv;
            String baseName;
            PsiClass psiClass;
            UClass uClass;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            UMethod it = (UMethod)element$iv;
            boolean bl2 = false;
            if ((it != null && (uClass = UastUtils.getContainingUClass((UElement)((UElement)it))) != null && (psiClass = uClass.getJavaPsi()) != null && (baseName = psiClass.getName()) != null ? "super method `" + baseName + "." + it.getName() + "(\u2026)`" : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        List originStrs = (List)var3_2;
        if (origins.contains(null)) {
            originStrs.add("a super method");
        }
        return ThreadConstraintDetector.report$join(originStrs, originStrs.size(), report.originStr.1.INSTANCE);
    }

    private static final <T extends Enum<T>> ThreadConstraint<T> parseMethodImmediateAnnotations$fromMethod(ThreadConstraintDetector<T> this$0, JavaEvaluator $evaluator, UMethod $method) {
        return this$0.parseAnnotations(JavaEvaluator.getAnnotations$default((JavaEvaluator)$evaluator, (PsiModifierListOwner)((PsiModifierListOwner)$method.getJavaPsi()), (boolean)false, null, (int)4, null));
    }

    private static final <T extends Enum<T>> ThreadConstraint<T> parseMethodImmediateAnnotations$fromClass(ThreadConstraintDetector<T> this$0, JavaEvaluator $evaluator, UMethod $method) {
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)$method));
        return this$0.parseAnnotations(JavaEvaluator.getAnnotations$default((JavaEvaluator)$evaluator, (PsiModifierListOwner)((PsiModifierListOwner)(uClass != null ? uClass.getJavaPsi() : null)), (boolean)false, null, (int)4, null));
    }

    private static final <T extends Enum<T>> ThreadConstraint<T> parseMethodImmediateAnnotations$fromClassOrDefault(UMethod $method, ThreadConstraintDetector<T> this$0, JavaEvaluator $evaluator) {
        return $method.isConstructor() ? ($method.getUastBody() == null ? this$0.lattice.getAnyThread() : null) : ($method.getSourcePsi() instanceof KtProperty ? ($method.isFinal() ? this$0.lattice.getAnyThread() : ThreadConstraintDetector.parseMethodImmediateAnnotations$fromClass(this$0, $evaluator, $method)) : ($method.getSourcePsi() instanceof KtPropertyAccessor ? ($method.isFinal() ? null : ThreadConstraintDetector.parseMethodImmediateAnnotations$fromClass(this$0, $evaluator, $method)) : ThreadConstraintDetector.parseMethodImmediateAnnotations$fromClass(this$0, $evaluator, $method)));
    }

    public static final /* synthetic */ String access$report$originStr(List origins) {
        return ThreadConstraintDetector.report$originStr(origins);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u0000*\u000e\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u001f\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\r\u0010\u0010\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005H\u00c2\u0003J\u0010\u0010\u0015\u001a\u00020\u0007H\u00c0\u0003\u00a2\u0006\u0004\b\u0016\u0010\u000bJ0\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraint;", "T", "", "", "tag", "Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraintLattice;", "cases", "Lkotlin/ULong;", "<init>", "(Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraintLattice;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getCases-s-VKNKU$lint_checks", "()J", "J", "isMostPermissive", "", "isMostPermissive$lint_checks", "isLeastPermissive", "isLeastPermissive$lint_checks", "toString", "", "component1", "component2", "component2-s-VKNKU$lint_checks", "copy", "copy-2TYgG_w", "(Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraintLattice;J)Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraint;", "equals", "other", "hashCode", "", "lint-checks"})
    public static final class ThreadConstraint<T extends Enum<T>> {
        @NotNull
        private final ThreadConstraintLattice<T> tag;
        private final long cases;

        private ThreadConstraint(ThreadConstraintLattice<T> tag, long cases) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            this.tag = tag;
            this.cases = cases;
        }

        public final long getCases-s-VKNKU$lint_checks() {
            return this.cases;
        }

        public final boolean isMostPermissive$lint_checks() {
            return this.cases == this.tag.getFullCases-s-VKNKU$lint_checks();
        }

        public final boolean isLeastPermissive$lint_checks() {
            return this.cases == 0L;
        }

        @NotNull
        public String toString() {
            String string;
            if (this.isMostPermissive$lint_checks()) {
                string = "`@AnyThread`";
            } else if (this.isLeastPermissive$lint_checks()) {
                string = "`@NoThread`";
            } else {
                Object[] objectArray = this.tag.getThreadTag().getEnumConstants();
                Intrinsics.checkNotNullExpressionValue(objectArray, (String)"getEnumConstants(...)");
                string = SequencesKt.joinToString$default((Sequence)SequencesKt.filterIndexed((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function2)new Function2<Integer, T, Boolean>(this){
                    final /* synthetic */ ThreadConstraint<T> this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final Boolean invoke(int i, T t2) {
                        return ULong.constructor-impl((long)(this.this$0.getCases-s-VKNKU$lint_checks() & ULong.constructor-impl((long)(1L << i)))) != 0L;
                    }
                }), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
            }
            return string;
        }

        private final ThreadConstraintLattice<T> component1() {
            return this.tag;
        }

        public final long component2-s-VKNKU$lint_checks() {
            return this.cases;
        }

        @NotNull
        public final ThreadConstraint<T> copy-2TYgG_w(@NotNull ThreadConstraintLattice<T> tag, long cases) {
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            return new ThreadConstraint<T>(tag, cases, null);
        }

        public static /* synthetic */ ThreadConstraint copy-2TYgG_w$default(ThreadConstraint threadConstraint, ThreadConstraintLattice threadConstraintLattice, long l, int n, Object object) {
            if ((n & 1) != 0) {
                threadConstraintLattice = threadConstraint.tag;
            }
            if ((n & 2) != 0) {
                l = threadConstraint.cases;
            }
            return threadConstraint.copy-2TYgG_w(threadConstraintLattice, l);
        }

        public int hashCode() {
            int result = this.tag.hashCode();
            result = result * 31 + ULong.hashCode-impl((long)this.cases);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThreadConstraint)) {
                return false;
            }
            ThreadConstraint threadConstraint = (ThreadConstraint)other;
            if (!Intrinsics.areEqual(this.tag, threadConstraint.tag)) {
                return false;
            }
            return this.cases == threadConstraint.cases;
        }

        public /* synthetic */ ThreadConstraint(ThreadConstraintLattice tag, long cases, DefaultConstructorMarker $constructor_marker) {
            this(tag, cases);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 +*\u000e\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003:\u0001+B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u001a\"\u00028\u0001\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J$\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J*\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J*\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001c\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0016\u00a8\u0006,"}, d2={"Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraintLattice;", "T", "", "Lcom/android/tools/lint/checks/fx/utils/Lattice;", "Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraint;", "threadTag", "Ljava/lang/Class;", "<init>", "(Ljava/lang/Class;)V", "getThreadTag", "()Ljava/lang/Class;", "numExplicitCases", "", "getNumExplicitCases$lint_checks", "()I", "fullCases", "Lkotlin/ULong;", "getFullCases-s-VKNKU$lint_checks", "()J", "J", "AnyThread", "getAnyThread", "()Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraint;", "NoThread", "getNoThread", "cache", "", "[Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraint;", "of", "cases", "([Ljava/lang/Enum;)Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraint;", "of-VKZWuLQ", "(J)Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraint;", "bottom", "getBottom", "top", "getTop", "precede", "", "first", "second", "joinOf", "meetOf", "Companion", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nThreadConstraintDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadConstraintDetector.kt\ncom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraintLattice\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,392:1\n12883#2,3:393\n*S KotlinDebug\n*F\n+ 1 ThreadConstraintDetector.kt\ncom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraintLattice\n*L\n351#1:393,3\n*E\n"})
    public static final class ThreadConstraintLattice<T extends Enum<T>>
    implements Lattice<ThreadConstraint<T>> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Class<T> threadTag;
        private final int numExplicitCases;
        private final long fullCases;
        @NotNull
        private final ThreadConstraint<T> AnyThread;
        @NotNull
        private final ThreadConstraint<T> NoThread;
        @NotNull
        private final ThreadConstraint<T>[] cache;
        @NotNull
        private final ThreadConstraint<T> bottom;
        @NotNull
        private final ThreadConstraint<T> top;

        public ThreadConstraintLattice(@NotNull Class<T> threadTag) {
            Intrinsics.checkNotNullParameter(threadTag, (String)"threadTag");
            this.threadTag = threadTag;
            this.numExplicitCases = this.threadTag.getEnumConstants().length;
            this.fullCases = ULong.constructor-impl((long)(ULong.constructor-impl((long)(1L << this.numExplicitCases + 1)) - 1L));
            if (!(this.numExplicitCases <= 63)) {
                boolean bl = false;
                String string = "Max 63 thread tags supported, but `" + this.threadTag.getSimpleName() + "` has " + this.numExplicitCases + ".";
                throw new IllegalArgumentException(string.toString());
            }
            this.AnyThread = new ThreadConstraint(this, this.fullCases, null);
            this.NoThread = new ThreadConstraint(this, 0L, null);
            int n = 0;
            int n2 = this.numExplicitCases + 1;
            ThreadConstraint[] threadConstraintArray = new ThreadConstraint[n2];
            ThreadConstraintLattice threadConstraintLattice = this;
            while (n < n2) {
                int n3 = n++;
                threadConstraintArray[n3] = new ThreadConstraint(this, ULong.constructor-impl((long)(1L << n3)), null);
            }
            threadConstraintLattice.cache = threadConstraintArray;
            this.bottom = this.AnyThread;
            this.top = this.NoThread;
        }

        @NotNull
        public final Class<T> getThreadTag() {
            return this.threadTag;
        }

        public final int getNumExplicitCases$lint_checks() {
            return this.numExplicitCases;
        }

        public final long getFullCases-s-VKNKU$lint_checks() {
            return this.fullCases;
        }

        @NotNull
        public final ThreadConstraint<T> getAnyThread() {
            return this.AnyThread;
        }

        @NotNull
        public final ThreadConstraint<T> getNoThread() {
            return this.NoThread;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ThreadConstraint<T> of(T ... cases) {
            void $this$fold$iv;
            void initial$iv;
            Intrinsics.checkNotNullParameter(cases, (String)"cases");
            T[] TArray = cases;
            long l = 0L;
            ThreadConstraintLattice threadConstraintLattice = this;
            boolean $i$f$fold = false;
            long accumulator$iv = initial$iv;
            int n = ((void)$this$fold$iv).length;
            for (int i = 0; i < n; ++i) {
                void case_;
                void element$iv;
                void var11_10 = element$iv = $this$fold$iv[i];
                void acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = ULong.constructor-impl((long)(acc | ULong.constructor-impl((long)(1L << case_.ordinal()))));
            }
            void var16_13 = accumulator$iv;
            return threadConstraintLattice.of-VKZWuLQ((long)var16_13);
        }

        private final ThreadConstraint<T> of-VKZWuLQ(long cases) {
            return cases == 0L ? this.NoThread : (cases == this.fullCases ? this.AnyThread : (Long.bitCount(cases) == 1 ? this.cache[Long.numberOfTrailingZeros(cases)] : new ThreadConstraint<T>(this, cases, null)));
        }

        @Override
        @NotNull
        public ThreadConstraint<T> getBottom() {
            return this.bottom;
        }

        @Override
        @NotNull
        public ThreadConstraint<T> getTop() {
            return this.top;
        }

        @Override
        public boolean precede(@NotNull ThreadConstraint<T> first, @NotNull ThreadConstraint<T> second) {
            Intrinsics.checkNotNullParameter(first, (String)"first");
            Intrinsics.checkNotNullParameter(second, (String)"second");
            return ULong.constructor-impl((long)(first.getCases-s-VKNKU$lint_checks() & second.getCases-s-VKNKU$lint_checks())) == second.getCases-s-VKNKU$lint_checks();
        }

        @Override
        @NotNull
        public ThreadConstraint<T> joinOf(@NotNull ThreadConstraint<T> first, @NotNull ThreadConstraint<T> second) {
            Intrinsics.checkNotNullParameter(first, (String)"first");
            Intrinsics.checkNotNullParameter(second, (String)"second");
            return Intrinsics.areEqual(first, second) ? first : (first.isMostPermissive$lint_checks() ? second : (second.isMostPermissive$lint_checks() ? first : this.of-VKZWuLQ(ULong.constructor-impl((long)(first.getCases-s-VKNKU$lint_checks() & second.getCases-s-VKNKU$lint_checks())))));
        }

        @Override
        @NotNull
        public ThreadConstraint<T> meetOf(@NotNull ThreadConstraint<T> first, @NotNull ThreadConstraint<T> second) {
            Intrinsics.checkNotNullParameter(first, (String)"first");
            Intrinsics.checkNotNullParameter(second, (String)"second");
            return Intrinsics.areEqual(first, second) ? first : (first.isLeastPermissive$lint_checks() ? second : (second.isLeastPermissive$lint_checks() ? first : this.of-VKZWuLQ(ULong.constructor-impl((long)(first.getCases-s-VKNKU$lint_checks() | second.getCases-s-VKNKU$lint_checks())))));
        }

        @Override
        @NotNull
        public ThreadConstraint<T> widen(@NotNull ThreadConstraint<T> prev, @NotNull ThreadConstraint<T> now) {
            return Lattice.super.widen(prev, now);
        }

        @Override
        public boolean precedes(@NotNull ThreadConstraint<T> $this$precedes, @NotNull ThreadConstraint<T> that) {
            return Lattice.super.precedes($this$precedes, that);
        }

        @Override
        @NotNull
        public ThreadConstraint<T> join(@NotNull ThreadConstraint<T> $this$join, @NotNull ThreadConstraint<T> that) {
            return Lattice.super.join($this$join, that);
        }

        @Override
        @NotNull
        public ThreadConstraint<T> meet(@NotNull ThreadConstraint<T> $this$meet, @NotNull ThreadConstraint<T> that) {
            return Lattice.super.meet($this$meet, that);
        }

        @Override
        @NotNull
        public <X> ThreadConstraint<T> joinedOver(@NotNull Iterable<? extends X> $this$joinedOver, @NotNull Function1<? super X, ThreadConstraint<T>> f2) {
            return Lattice.super.joinedOver($this$joinedOver, f2);
        }

        @Override
        @NotNull
        public <X> ThreadConstraint<T> joinedOver(@NotNull Sequence<? extends X> $this$joinedOver, @NotNull Function1<? super X, ThreadConstraint<T>> f2) {
            return Lattice.super.joinedOver($this$joinedOver, f2);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0010\b\u0002\u0010\u0006\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00060\u0007H\u0086\b\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraintLattice$Companion;", "", "<init>", "()V", "of", "Lcom/android/tools/lint/checks/ThreadConstraintDetector$ThreadConstraintLattice;", "T", "", "lint-checks"})
        public static final class Companion {
            private Companion() {
            }

            public final /* synthetic */ <T extends Enum<T>> ThreadConstraintLattice<T> of() {
                boolean $i$f$of = false;
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                return new ThreadConstraintLattice<Enum>(Enum.class);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

