/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationOrigin;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.ApiLevel;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.android.utils.StringHelper;
import com.intellij.lang.Language;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiVariable;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007H\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u001a\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0013H\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020 H\u0002J\u001c\u0010!\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\"\u001a\u00020#2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u000e\u0010$\u001a\u0004\u0018\u00010%*\u00020%H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010\u001f2\u0006\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020#H\u0002J\u0019\u0010)\u001a\u00020*2\b\u0010\u0012\u001a\u0004\u0018\u00010+H\u0002\u00a2\u0006\u0004\b,\u0010-J\u001a\u0010.\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\"\u001a\u00020#H\u0002J \u0010/\u001a\u00020\t2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0007H\u0016\u00a8\u00065"}, d2={"Lcom/android/tools/lint/checks/WindowExtensionsDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "applicableAnnotations", "", "", "isApplicableAnnotationUsage", "", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "inheritAnnotation", "annotation", "visitAnnotationUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "getUsageTypePrefix", "qualifiedName", "getQualifiedName", "member", "Lcom/intellij/psi/PsiMember;", "reference", "getSdkLevel", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "Lorg/jetbrains/uast/UAnnotation;", "currentLevel", "evaluator", "Lcom/android/tools/lint/client/api/JavaEvaluator;", "flip", "Lorg/jetbrains/uast/UastBinaryOperator;", "getWindowsExtensionConstraint", "binary", "Lorg/jetbrains/uast/UBinaryExpression;", "getApiLevel", "Lcom/android/tools/lint/detector/api/ApiLevel;", "Lorg/jetbrains/uast/UExpression;", "getApiLevel-DTtIgKc", "(Lorg/jetbrains/uast/UExpression;)I", "isWindowsExtensionLookup", "sameMessage", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "new", "old", "Issues", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nWindowExtensionsDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowExtensionsDetector.kt\ncom/android/tools/lint/checks/WindowExtensionsDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,461:1\n1#2:462\n*E\n"})
public final class WindowExtensionsDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(WindowExtensionsDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String REQUIRES_WINDOW_SDK_EXTENSION = "androidx.window.RequiresWindowSdkExtension";
    @NotNull
    private static final String WINDOW_SDK_EXTENSIONS_CLASS = "androidx.window.WindowSdkExtensions";
    @NotNull
    private static final String GET_EXTENSION_VERSION = "getExtensionVersion";
    @NotNull
    private static final String ATTR_VERSION = "version";
    private static final int WINDOWS_SDK_ID = -3;

    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object)REQUIRES_WINDOW_SDK_EXTENSION);
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean inheritAnnotation(@NotNull String annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        return false;
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        if (annotationInfo.getOrigin() == AnnotationOrigin.SELF) {
            return;
        }
        UAnnotation annotation = annotationInfo.getAnnotation();
        ApiConstraint apiConstraint = this.getSdkLevel(annotation);
        if (apiConstraint == null) {
            return;
        }
        ApiConstraint api2 = apiConstraint;
        ApiConstraint currentLevel = this.currentLevel(context.getEvaluator(), element);
        if (currentLevel != null && currentLevel.isAtLeast(api2)) {
            return;
        }
        PsiElement psiElement = usageInfo.getReferenced();
        PsiMember member = psiElement instanceof PsiMember ? (PsiMember)psiElement : null;
        Location location = null;
        String qualifiedName = this.getQualifiedName(member, element);
        if (element instanceof UCallExpression && !Intrinsics.areEqual((Object)((UCallExpression)element).getKind(), (Object)UastCallKind.METHOD_CALL) && ((UCallExpression)element).getClassReference() != null) {
            UReferenceExpression uReferenceExpression = ((UCallExpression)element).getClassReference();
            Intrinsics.checkNotNull((Object)uReferenceExpression);
            UReferenceExpression classReference = uReferenceExpression;
            location = context.getRangeLocation(element, 0, (UElement)classReference, 0);
        } else {
            location = context.getNameLocation(element);
        }
        String typeString2 = this.getUsageTypePrefix(usageInfo, qualifiedName);
        ApiConstraint apiConstraint2 = currentLevel;
        Object currentDesc = apiConstraint2 != null ? " (current is " + apiConstraint2.minString() + ")" : "";
        String message2 = typeString2 + " requires window SDK extension level " + api2.minString() + (String)currentDesc + ": `" + qualifiedName + "`";
        JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)element, (Location)context.getLocation(element), (String)message2, null, (int)16, null);
    }

    private final String getUsageTypePrefix(AnnotationUsageInfo usageInfo, String qualifiedName) {
        Object object;
        switch (WhenMappings.$EnumSwitchMapping$0[usageInfo.getType().ordinal()]) {
            case 6: {
                object = "Extending " + qualifiedName;
                break;
            }
            case 4: 
            case 5: {
                object = "Class";
                break;
            }
            case 8: 
            case 9: {
                object = "Method";
                break;
            }
            case 3: 
            case 10: {
                object = "Field";
                break;
            }
            default: {
                object = "Call";
            }
        }
        Object type = object;
        String typeString2 = StringHelper.usLocaleCapitalize((String)type);
        return typeString2;
    }

    private final String getQualifiedName(PsiMember member, UElement reference) {
        String name;
        if (member instanceof PsiClass) {
            String string = ((PsiClass)member).getQualifiedName();
            if (string == null && (string = ((PsiClass)member).getName()) == null) {
                string = "";
            }
            return string;
        }
        PsiMember psiMember = member;
        PsiClass containing = psiMember != null ? psiMember.getContainingClass() : null;
        PsiMember psiMember2 = member;
        String string = name = psiMember2 != null ? psiMember2.getName() : null;
        if (containing != null) {
            String containingClassName;
            String string2 = containing.getQualifiedName();
            if (string2 == null && (string2 = containing.getName()) == null) {
                string2 = containingClassName = "";
            }
            if (Intrinsics.areEqual((Object)name, (Object)"<init>")) {
                String string3 = Lint.isKotlin((Language)reference.getLang()) ? containingClassName + "()" : "new " + containingClassName;
            }
            return containingClassName + "#" + name;
        }
        String string4 = name;
        if (string4 == null) {
            string4 = "";
        }
        return string4;
    }

    private final ApiConstraint getSdkLevel(UAnnotation $this$getSdkLevel) {
        ApiConstraint apiConstraint;
        if (Intrinsics.areEqual((Object)$this$getSdkLevel.getQualifiedName(), (Object)REQUIRES_WINDOW_SDK_EXTENSION)) {
            int from = (int)UastLintUtils.Companion.getLongAttribute($this$getSdkLevel, ATTR_VERSION, -1L);
            apiConstraint = (ApiConstraint)ApiConstraint.Companion.atLeast(from, -3);
        } else {
            apiConstraint = null;
        }
        return apiConstraint;
    }

    private final ApiConstraint currentLevel(JavaEvaluator evaluator, UElement element) {
        UElement prev = element;
        UElement curr = element;
        while (curr != null) {
            if (curr instanceof UAnnotated) {
                for (PsiAnnotation[] annotation : ((UAnnotated)curr).getUAnnotations()) {
                    ApiConstraint apiConstraint;
                    if (!Intrinsics.areEqual((Object)annotation.getQualifiedName(), (Object)REQUIRES_WINDOW_SDK_EXTENSION) || (apiConstraint = this.getSdkLevel((UAnnotation)annotation)) == null) continue;
                    ApiConstraint it = apiConstraint;
                    boolean bl = false;
                    return it;
                }
            }
            if (curr instanceof UFile) {
                PsiPackage pkg;
                PsiElement psiElement = ((UFile)curr).getJavaPsi();
                if (psiElement == null) {
                    psiElement = (PsiElement)((UFile)curr).getSourcePsi();
                }
                if ((pkg = evaluator.getPackage(psiElement)) == null) break;
                for (PsiAnnotation psiAnnotation : pkg.getAnnotations()) {
                    ApiConstraint apiConstraint;
                    UAnnotation annotation;
                    UastLanguagePlugin uastLanguagePlugin = (UastLanguagePlugin)UastFacade.INSTANCE;
                    Intrinsics.checkNotNull((Object)psiAnnotation);
                    UElement uElement = UastLanguagePlugin.convertElement$default((UastLanguagePlugin)uastLanguagePlugin, (PsiElement)((PsiElement)psiAnnotation), null, null, (int)4, null);
                    UAnnotation uAnnotation = uElement instanceof UAnnotation ? (UAnnotation)uElement : null;
                    if (uAnnotation == null || !Intrinsics.areEqual((Object)(annotation = uAnnotation).getQualifiedName(), (Object)REQUIRES_WINDOW_SDK_EXTENSION) || (apiConstraint = this.getSdkLevel(annotation)) == null) continue;
                    ApiConstraint it = apiConstraint;
                    boolean bl = false;
                    return it;
                }
                break;
            }
            if (curr instanceof UIfExpression) {
                if (prev != ((UIfExpression)curr).getCondition()) {
                    ApiConstraint constraint;
                    boolean fromThen = Intrinsics.areEqual((Object)prev, (Object)((UIfExpression)curr).getThenExpression());
                    UExpression condition = UastUtils.skipParenthesizedExprDown((UExpression)((UIfExpression)curr).getCondition());
                    if (condition instanceof UBinaryExpression && (constraint = this.getWindowsExtensionConstraint((UBinaryExpression)condition, evaluator)) != null) {
                        return fromThen ? constraint : constraint.not();
                    }
                }
            } else if (curr instanceof UPolyadicExpression) {
                ApiConstraint constraint;
                UExpression operand;
                UExpression operand2;
                Iterator iterator;
                if (Intrinsics.areEqual((Object)((UPolyadicExpression)curr).getOperator(), (Object)UastBinaryOperator.LOGICAL_AND)) {
                    iterator = ((UPolyadicExpression)curr).getOperands().iterator();
                    while (iterator.hasNext() && (operand2 = (UExpression)iterator.next()) != curr) {
                        operand = UastUtils.skipParenthesizedExprDown((UExpression)operand2);
                        if (!(operand instanceof UBinaryExpression) || (constraint = this.getWindowsExtensionConstraint((UBinaryExpression)operand, evaluator)) == null) continue;
                        return constraint;
                    }
                } else if (Intrinsics.areEqual((Object)((UPolyadicExpression)curr).getOperator(), (Object)UastBinaryOperator.LOGICAL_OR)) {
                    iterator = ((UPolyadicExpression)curr).getOperands().iterator();
                    while (iterator.hasNext() && (operand2 = (UExpression)iterator.next()) != curr) {
                        UBinaryExpression it;
                        operand = UastUtils.skipParenthesizedExprDown((UExpression)operand2);
                        if (!(operand instanceof UBinaryExpression)) continue;
                        constraint = this.getWindowsExtensionConstraint((UBinaryExpression)operand, evaluator);
                        if (constraint != null) {
                            return constraint.not();
                        }
                        if (!Intrinsics.areEqual((Object)((UBinaryExpression)operand).getOperator(), (Object)UastBinaryOperator.LOGICAL_OR)) continue;
                        UExpression uExpression = UastUtils.skipParenthesizedExprDown((UExpression)((UBinaryExpression)operand).getLeftOperand());
                        if ((uExpression instanceof UBinaryExpression ? (UBinaryExpression)uExpression : null) != null) {
                            it = it;
                            boolean bl = false;
                            ApiConstraint apiConstraint = this.getWindowsExtensionConstraint(it, evaluator);
                            if (apiConstraint != null) {
                                ApiConstraint constraint2 = apiConstraint;
                                boolean bl2 = false;
                                return constraint2.not();
                            }
                        }
                        uExpression = UastUtils.skipParenthesizedExprDown((UExpression)((UBinaryExpression)operand).getRightOperand());
                        if ((uExpression instanceof UBinaryExpression ? (UBinaryExpression)uExpression : null) == null) continue;
                        it = it;
                        boolean bl = false;
                        ApiConstraint apiConstraint = this.getWindowsExtensionConstraint(it, evaluator);
                        if (apiConstraint == null) continue;
                        ApiConstraint constraint3 = apiConstraint;
                        boolean bl3 = false;
                        return constraint3.not();
                    }
                }
            }
            prev = curr;
            if (curr.getUastParent() == null) break;
        }
        return null;
    }

    private final UastBinaryOperator flip(UastBinaryOperator $this$flip) {
        UastBinaryOperator uastBinaryOperator = $this$flip;
        return Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER) ? (UastBinaryOperator)UastBinaryOperator.LESS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER_OR_EQUALS) ? (UastBinaryOperator)UastBinaryOperator.LESS_OR_EQUALS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS_OR_EQUALS) ? (UastBinaryOperator)UastBinaryOperator.GREATER_OR_EQUALS : (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS) ? (UastBinaryOperator)UastBinaryOperator.GREATER : null)));
    }

    private final ApiConstraint getWindowsExtensionConstraint(UBinaryExpression binary, JavaEvaluator evaluator) {
        UastBinaryOperator tokenType = null;
        tokenType = binary.getOperator();
        if (tokenType == UastBinaryOperator.GREATER || tokenType == UastBinaryOperator.GREATER_OR_EQUALS || tokenType == UastBinaryOperator.LESS_OR_EQUALS || tokenType == UastBinaryOperator.LESS || tokenType == UastBinaryOperator.EQUALS || tokenType == UastBinaryOperator.IDENTITY_EQUALS || tokenType == UastBinaryOperator.NOT_EQUALS || tokenType == UastBinaryOperator.IDENTITY_NOT_EQUALS) {
            UExpression left = binary.getLeftOperand();
            int level = 0;
            UExpression right = null;
            if (!this.isWindowsExtensionLookup((UElement)left, evaluator)) {
                right = binary.getRightOperand();
                if (!this.isWindowsExtensionLookup((UElement)right, evaluator)) {
                    return null;
                }
                UastBinaryOperator uastBinaryOperator = this.flip(tokenType);
                if (uastBinaryOperator == null) {
                    uastBinaryOperator = tokenType;
                }
                tokenType = uastBinaryOperator;
                level = this.getApiLevel-DTtIgKc(left);
            } else {
                right = binary.getRightOperand();
                level = this.getApiLevel-DTtIgKc(right);
            }
            if (ApiLevel.isValid-impl((int)level)) {
                int sdkId = -3;
                UastBinaryOperator uastBinaryOperator = tokenType;
                if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER_OR_EQUALS)) {
                    return (ApiConstraint)ApiConstraint.Companion.atLeast-kG1hquA(level, sdkId);
                }
                if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.GREATER)) {
                    return (ApiConstraint)ApiConstraint.Companion.above-kG1hquA(level, sdkId);
                }
                if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS_OR_EQUALS)) {
                    return (ApiConstraint)ApiConstraint.Companion.atMost-kG1hquA(level, sdkId);
                }
                if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.LESS)) {
                    return (ApiConstraint)ApiConstraint.Companion.below-kG1hquA(level, sdkId);
                }
                if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.EQUALS) || Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_EQUALS)) {
                    return (ApiConstraint)ApiConstraint.Companion.exactly-kG1hquA(level, sdkId);
                }
                if (Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.NOT_EQUALS) || Intrinsics.areEqual((Object)uastBinaryOperator, (Object)UastBinaryOperator.IDENTITY_NOT_EQUALS)) {
                    return (ApiConstraint)ApiConstraint.Companion.not-kG1hquA(level, sdkId);
                }
                if (_Assertions.ENABLED) {
                    boolean bl = false;
                    UastBinaryOperator uastBinaryOperator2 = tokenType;
                    throw new AssertionError(uastBinaryOperator2);
                }
            }
        } else if (Intrinsics.areEqual((Object)tokenType, (Object)UastBinaryOperator.LOGICAL_AND)) {
            for (UExpression operand : binary.getOperands()) {
                ApiConstraint constraint;
                UExpression operand2 = UastUtils.skipParenthesizedExprDown((UExpression)operand);
                if (!(operand2 instanceof UBinaryExpression) || (constraint = this.getWindowsExtensionConstraint((UBinaryExpression)operand2, evaluator)) == null) continue;
                return constraint;
            }
        }
        return null;
    }

    private final int getApiLevel-DTtIgKc(UExpression element) {
        int level = ApiLevel.Companion.getNONE-wqyE5NY();
        if (element instanceof UReferenceExpression) {
            Object constant;
            String codeName = ((UReferenceExpression)element).getResolvedName();
            if (codeName != null) {
                level = ApiLevel.Companion.get-zulsYdA(codeName, false);
            }
            if (ApiLevel.isMissing-impl((int)level) && (constant = ConstantEvaluator.evaluate(null, (UElement)((UElement)element))) instanceof Number) {
                level = ApiLevel.Companion.get-DTtIgKc(((Number)constant).intValue());
            }
        } else if (element instanceof ULiteralExpression) {
            Object value = ((ULiteralExpression)element).getValue();
            if (value instanceof Integer) {
                level = ApiLevel.Companion.get-DTtIgKc(((Number)value).intValue());
            }
        } else if (element instanceof UParenthesizedExpression) {
            return this.getApiLevel-DTtIgKc(((UParenthesizedExpression)element).getExpression());
        }
        return level;
    }

    private final boolean isWindowsExtensionLookup(UElement element, JavaEvaluator evaluator) {
        if (element instanceof UReferenceExpression) {
            UElement uElement;
            PsiExpression initializer;
            PsiElement psiElement;
            PsiMethod psiMethod;
            String resolvedName = ((UReferenceExpression)element).getResolvedName();
            if (Intrinsics.areEqual((Object)GET_EXTENSION_VERSION, (Object)resolvedName) && Intrinsics.areEqual((Object)((psiMethod = (psiElement = ((UReferenceExpression)element).resolve()) instanceof PsiMethod ? (PsiMethod)psiElement : null) != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)WINDOW_SDK_EXTENSIONS_CLASS)) {
                return true;
            }
            UElement selector = UastLintUtilsKt.findSelector((UElement)element);
            if (selector != element) {
                return this.isWindowsExtensionLookup(selector, evaluator);
            }
            PsiElement resolved = ((UReferenceExpression)element).resolve();
            if (resolved instanceof ULocalVariable) {
                UExpression initializer2 = ((ULocalVariable)resolved).getUastInitializer();
                if (initializer2 != null) {
                    return this.isWindowsExtensionLookup((UElement)initializer2, evaluator);
                }
            } else if (resolved instanceof PsiVariable && (initializer = ((PsiVariable)resolved).getInitializer()) != null && (uElement = UastContextKt.toUElement((PsiElement)((PsiElement)initializer))) != null) {
                UElement it = uElement;
                boolean bl = false;
                return this.isWindowsExtensionLookup(it, evaluator);
            }
        } else if (element instanceof UCallExpression) {
            PsiMethod psiMethod;
            String methodName = Lint.getMethodName((UCallExpression)((UCallExpression)element));
            if (Intrinsics.areEqual((Object)GET_EXTENSION_VERSION, (Object)methodName) && Intrinsics.areEqual((Object)((psiMethod = ((UCallExpression)element).resolve()) != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : null), (Object)WINDOW_SDK_EXTENSIONS_CLASS)) {
                return true;
            }
        } else if (element instanceof UParenthesizedExpression) {
            return this.isWindowsExtensionLookup((UElement)((UParenthesizedExpression)element).getExpression(), evaluator);
        }
        return false;
    }

    public boolean sameMessage(@NotNull Issue issue, @NotNull String string, @NotNull String old) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)string, (String)"new");
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        return LintBaseline.Companion.symbolsMatch(old, string);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"RequiresWindowSdk", (String)"API requires a `WindowSdkExtensions.extensionVersion` check", (String)"\n          Some methods in the window library require explicit checks of the \\\n          `extensionVersion` level:\n          ```kotlin\n          if (WindowSdkExtensions.getInstance().extensionVersion >= n) {\n              val supportedPostures = windowInfoTracker.supportedPostures\n              ...\n          ```\n          This lint check looks for scenarios where you're calling these methods \\\n          without checking the extension version level, or annotating the calling \\\n          method with a sufficient `@RequiresWindowSdkExtension` annotation.\n\n          (This lint check does not tackle more advanced ways of version checks, \\\n          such as extracting the checks into utility methods or constants. Use \\\n          a direct `if` check as shown above.)\n          ", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/WindowExtensionsDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "REQUIRES_WINDOW_SDK_EXTENSION", "", "WINDOW_SDK_EXTENSIONS_CLASS", "GET_EXTENSION_VERSION", "ATTR_VERSION", "WINDOWS_SDK_ID", "", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUsageType.values().length];
            try {
                nArray[AnnotationUsageType.METHOD_CALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.METHOD_REFERENCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.FIELD_REFERENCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.CLASS_REFERENCE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.ANNOTATION_REFERENCE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.EXTENDS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.DEFINITION.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.METHOD_RETURN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.METHOD_OVERRIDE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUsageType.VARIABLE_REFERENCE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

