/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.lint.checks.RemoteViewDetector;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/RemoteViewDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableConstructorTypes", "", "", "isSupportedTag", "", "tag", "min", "", "visitConstructor", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "constructor", "Lcom/intellij/psi/PsiMethod;", "Issues", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nRemoteViewDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteViewDetector.kt\ncom/android/tools/lint/checks/RemoteViewDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n1#2:171\n*E\n"})
public final class RemoteViewDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(RemoteViewDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableConstructorTypes() {
        return CollectionsKt.listOf((Object)"android.widget.RemoteViews");
    }

    public void visitConstructor(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod constructor) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            List arguments = node.getValueArguments();
            if (arguments.size() != 2) {
                return;
            }
            UExpression argument = (UExpression)arguments.get(1);
            ResourceReference resourceReference = ResourceReference.Companion.get((UElement)argument);
            if (resourceReference == null) {
                return;
            }
            ResourceReference resource = resourceReference;
            if (Intrinsics.areEqual((Object)resource.getPackage(), (Object)"android") || resource.getType() != ResourceType.LAYOUT) {
                return;
            }
            LintClient client = context.getClient();
            ResourceRepository resources = context.isGlobalAnalysis() ? client.getResources(context.getMainProject(), ResourceRepositoryScope.LOCAL_DEPENDENCIES) : client.getResources(context.getProject(), ResourceRepositoryScope.PROJECT_ONLY);
            List items = resources.getResources(ResourceNamespace.TODO(), resource.getType(), resource.getName());
            HashSet tags = null;
            Intrinsics.checkNotNullExpressionValue((Object)items, (String)"items");
            Set paths2 = SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)items), (Function1)visitConstructor.paths.1.INSTANCE));
            block7: for (PathString path : paths2) {
                int min = Math.max(context.getProject().getMinSdk(), RtlDetector.getFolderVersion(path.getRawPath()));
                try {
                    if (client.createXmlPullParser(path) == null) continue;
                    block8: while (true) {
                        XmlPullParser parser;
                        int event = parser.next();
                        switch (event) {
                            case 2: {
                                String tag;
                                if (parser.getName() == null || this.isSupportedTag(tag, min)) continue block8;
                                Set set = tags;
                                if (set == null) {
                                    HashSet hashSet;
                                    HashSet it = hashSet = new HashSet();
                                    boolean bl = false;
                                    tags = it;
                                    set = hashSet;
                                }
                                set.add(tag);
                                continue block8;
                            }
                            case 1: {
                                continue block7;
                            }
                        }
                    }
                }
                catch (XmlPullParserException parser) {
                }
                catch (IOException parser) {
                }
            }
            Set set = tags;
            if (set == null) break block13;
            Set set2 = set;
            boolean bl = false;
            SortedSet sorted = CollectionsKt.toSortedSet((Iterable)set2);
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getLocation((UElement)node), (String)("`@layout/" + resource.getName() + "` includes views not allowed in a `RemoteView`: " + CollectionsKt.joinToString$default((Iterable)sorted, null, null, null, (int)0, null, null, (int)63, null)), null, (int)16, null);
        }
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSupportedTag(String tag, int min) {
        if (StringsKt.startsWith$default((String)tag, (String)"android.view.", (boolean)false, (int)2, null)) return this.isSupportedTag(StringsKt.substringAfterLast$default((String)tag, (char)'.', null, (int)2, null), min);
        if (StringsKt.startsWith$default((String)tag, (String)"android.widget.", (boolean)false, (int)2, null)) {
            return this.isSupportedTag(StringsKt.substringAfterLast$default((String)tag, (char)'.', null, (int)2, null), min);
        }
        String string = tag;
        switch (string.hashCode()) {
            case 1280029577: {
                if (string.equals("requestFocus")) return true;
                return false;
            }
            case 1969230692: {
                if (string.equals("RadioGroup")) break;
                return false;
            }
            case 940309185: {
                if (string.equals("TextClock")) return true;
                return false;
            }
            case 886763275: {
                if (string.equals("ViewFlipper")) return true;
                return false;
            }
            case -1822277072: {
                if (string.equals("GridLayout")) return true;
                return false;
            }
            case -937446323: {
                if (string.equals("ImageButton")) return true;
                return false;
            }
            case 1410352259: {
                if (string.equals("ListView")) return true;
                return false;
            }
            case 2001146706: {
                if (string.equals("Button")) return true;
                return false;
            }
            case 103785528: {
                if (string.equals("merge")) return true;
                return false;
            }
            case 1778827486: {
                if (string.equals("AnalogClock")) return true;
                return false;
            }
            case -938935918: {
                if (string.equals("TextView")) return true;
                return false;
            }
            case 1125864064: {
                if (string.equals("ImageView")) return true;
                return false;
            }
            case -563016403: {
                if (string.equals("StackView")) return true;
                return false;
            }
            case -1495589242: {
                if (string.equals("ProgressBar")) return true;
                return false;
            }
            case 1942574248: {
                if (string.equals("include")) return true;
                return false;
            }
            case 776382189: {
                if (string.equals("RadioButton")) break;
                return false;
            }
            case 1204826236: {
                if (string.equals("AdapterViewFlipper")) return true;
                return false;
            }
            case -170947679: {
                if (string.equals("AbsoluteLayout")) return true;
                return false;
            }
            case 1260470547: {
                if (string.equals("ViewStub")) return true;
                return false;
            }
            case -1805606060: {
                if (string.equals("Switch")) break;
                return false;
            }
            case -984371546: {
                if (string.equals("Chronometer")) return true;
                return false;
            }
            case 1601505219: {
                if (string.equals("CheckBox")) break;
                return false;
            }
            case 1310765783: {
                if (string.equals("FrameLayout")) return true;
                return false;
            }
            case -443652810: {
                if (string.equals("RelativeLayout")) return true;
                return false;
            }
            case 382765867: {
                if (string.equals("GridView")) return true;
                return false;
            }
            case 1127291599: {
                if (!string.equals("LinearLayout")) return false;
                return true;
            }
        }
        if (min < 31) return false;
        return true;
        return false;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"RemoteViewLayout", (String)"Unsupported View in RemoteView", (String)"\n            In a `RemoteView`, only some layouts and views are allowed.\n            ", (Implementation)implementation, (String)"https://developer.android.com/reference/android/widget/RemoteViews", (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/RemoteViewDetector$Issues;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

