/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002J>\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J4\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0012H\u0002J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/RestrictionsDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkRequiredAttribute", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "attribute", "validateNestedRestrictions", "", "restrictionType", "keys", "", "depth", "", "validateRestriction", "node", "Lorg/w3c/dom/Node;", "verifyRestrictionTagName", "visitDocument", "document", "Lorg/w3c/dom/Document;", "Companion", "lint-checks"})
public final class RestrictionsDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int MAX_NESTING_DEPTH = 20;
    public static final int MAX_NUMBER_OF_NESTED_RESTRICTIONS = 1000;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    public static final String TAG_RESTRICTIONS = "restrictions";
    @NotNull
    private static final String TAG_RESTRICTION = "restriction";
    @NotNull
    private static final String ATTR_RESTRICTION_TYPE = "restrictionType";
    @NotNull
    private static final String ATTR_KEY = "key";
    @NotNull
    public static final String ATTR_DESCRIPTION = "description";
    @NotNull
    private static final String VALUE_BUNDLE = "bundle";
    @NotNull
    private static final String VALUE_BUNDLE_ARRAY = "bundle_array";
    @NotNull
    private static final String VALUE_CHOICE = "choice";
    @NotNull
    private static final String VALUE_MULTI_SELECT = "multi-select";
    @NotNull
    private static final String VALUE_ENTRIES = "entries";
    @NotNull
    private static final String VALUE_ENTRY_VALUES = "entryValues";
    @NotNull
    private static final String VALUE_HIDDEN = "hidden";
    @NotNull
    private static final String VALUE_DEFAULT_VALUE = "defaultValue";
    @NotNull
    private static final String VALUE_INTEGER = "integer";

    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.XML;
    }

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Element element = document.getDocumentElement();
        if (element == null) {
            return;
        }
        Element root = element;
        if (!Intrinsics.areEqual((Object)TAG_RESTRICTIONS, (Object)root.getTagName())) {
            return;
        }
        HashMap keys = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)keys, (String)"keys");
        this.validateNestedRestrictions(context, root, null, keys, 0);
    }

    private final void validateNestedRestrictions(XmlContext context, Element element, String restrictionType, Map<String, Element> keys, int depth) {
        boolean bl;
        boolean bl2 = bl = depth == 0 || restrictionType != null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        List children = Lint.getChildren((Node)element);
        if (depth == 0 || Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_BUNDLE) || Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_BUNDLE_ARRAY)) {
            Object[] objectArray;
            String string;
            Attr defaultValue = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", VALUE_DEFAULT_VALUE);
            if (defaultValue != null) {
                Node node = element;
                Location location = context.getLocation((Node)defaultValue);
                string = "Restriction type `%1$s` should not have a default value";
                objectArray = new Object[]{restrictionType};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)location, (String)string2, null, (int)16, null);
            }
            for (Element child : children) {
                if (!this.verifyRestrictionTagName(context, child)) continue;
                this.validateRestriction(context, child, depth + 1, keys);
            }
            if (depth != 0) {
                if (Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_BUNDLE_ARRAY)) {
                    if (children.size() != 1) {
                        XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getElementLocation(element), (String)"Expected exactly one child for restriction of type `bundle_array`", null, (int)16, null);
                    }
                } else {
                    boolean bl3 = Intrinsics.areEqual((Object)restrictionType, (Object)VALUE_BUNDLE);
                    if (_Assertions.ENABLED && !bl3) {
                        string = "Assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    if (children.isEmpty()) {
                        XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getElementLocation(element), (String)"Restriction type `bundle` should have at least one nested restriction", null, (int)16, null);
                    }
                }
            }
            if (children.size() > 1000) {
                Node node = element;
                Location location = context.getElementLocation(element);
                string = "Invalid nested restriction: too many nested restrictions (was %1$d, max %2$d)";
                objectArray = new Object[]{children.size(), 1000};
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)location, (String)string3, null, (int)16, null);
            } else if (depth > 20) {
                Node node = element;
                Location location = context.getElementLocation(element);
                string = "Invalid nested restriction: nesting depth %1$d too large (max %2$d";
                objectArray = new Object[]{depth, 20};
                String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)location, (String)string4, null, (int)16, null);
            }
        } else if (!children.isEmpty()) {
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)element, (Location)context.getNameLocation((Node)element), (String)"Only restrictions of type `bundle` and `bundle_array` can have one or multiple nested restriction elements", null, (int)16, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void validateRestriction(XmlContext context, Node node, int depth, Map<String, Element> keys) {
        block17: {
            if (node.getNodeType() != 1) {
                return;
            }
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            element = (Element)node;
            restrictionType = this.checkRequiredAttribute(context, element, "restrictionType");
            key = this.checkRequiredAttribute(context, element, "key");
            title = this.checkRequiredAttribute(context, element, "title");
            if (restrictionType == null || key == null || title == null) {
                return;
            }
            if (StringsKt.startsWith$default((String)key, (String)"@string/", (boolean)false, (int)2, null)) {
                attribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "key");
                Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"attribute");
                valueLocation = context.getValueLocation(attribute);
                XmlContext.report$default((XmlContext)context, (Issue)RestrictionsDetector.ISSUE, (Node)element, (Location)valueLocation, (String)"Keys cannot be localized, they should be specified with a string literal", null, (int)16, null);
            } else if (keys.containsKey(key)) {
                thisAttribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "key");
                Intrinsics.checkNotNullExpressionValue((Object)thisAttribute, (String)"thisAttribute");
                location = context.getValueLocation(thisAttribute);
                v0 = keys.get(key);
                if (v0 == null) {
                    return;
                }
                prev = v0;
                prevAttribute = prev.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "key");
                Intrinsics.checkNotNullExpressionValue((Object)prevAttribute, (String)"prevAttribute");
                previousLocation = context.getValueLocation(prevAttribute);
                previousLocation.setMessage("Previous use of key here");
                location.setSecondary(previousLocation);
                v1 = element;
                var14_16 = "Duplicate key `%1$s`";
                var15_17 = new Object[]{key};
                v2 = String.format(var14_16, Arrays.copyOf(var15_17, var15_17.length));
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"format(...)");
                XmlContext.report$default((XmlContext)context, (Issue)RestrictionsDetector.ISSUE, (Node)v1, (Location)location, (String)v2, null, (int)16, null);
            } else {
                keys.put(key, element);
            }
            switch (restrictionType.hashCode()) {
                case -1217487446: {
                    if (restrictionType.equals("hidden")) break;
                    break;
                }
                case 1123690512: {
                    if (!restrictionType.equals("multi-select")) {
                        break;
                    }
                    ** GOTO lbl53
                }
                case 1958052158: {
                    if (!restrictionType.equals("integer")) {
                        break;
                    }
                    break block17;
                }
                case -1361224287: {
                    if (!restrictionType.equals("choice")) break;
lbl53:
                    // 2 sources

                    if (this.checkRequiredAttribute(context, element, "entries") != null) break;
                    this.checkRequiredAttribute(context, element, "entryValues");
                    break;
                }
            }
            this.checkRequiredAttribute(context, element, "defaultValue");
            ** break;
        }
        defaultValue = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "defaultValue");
        if (defaultValue == null) ** break;
        v3 = defaultValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"defaultValue.value");
        if (StringsKt.startsWith$default((String)v3, (String)"@", (boolean)false, (int)2, null)) ** break;
        try {
            Integer.decode(defaultValue.getValue());
        }
        catch (NumberFormatException e) {
            XmlContext.report$default((XmlContext)context, (Issue)RestrictionsDetector.ISSUE, (Node)element, (Location)context.getValueLocation(defaultValue), (String)"Invalid number", null, (int)16, null);
        }
        {
            break;
        }
lbl74:
        // 12 sources

        this.validateNestedRestrictions(context, element, restrictionType, keys, depth);
    }

    private final boolean verifyRestrictionTagName(XmlContext context, Element element) {
        String tagName = element.getTagName();
        if (!Intrinsics.areEqual((Object)tagName, (Object)TAG_RESTRICTION)) {
            Node node = element;
            Location location = context.getNameLocation((Node)element);
            String string = "Unexpected tag `<%1$s>`, expected `<%2$s>`";
            Object[] objectArray = new Object[]{tagName, TAG_RESTRICTION};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)location, (String)string2, null, (int)16, null);
            return false;
        }
        return true;
    }

    private final String checkRequiredAttribute(XmlContext context, Element element, String attribute) {
        Object fullAttribute = attribute;
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", (String)fullAttribute)) {
            String prefix = element.lookupPrefix("http://schemas.android.com/apk/res/android");
            if (prefix != null) {
                fullAttribute = prefix + ":" + (String)fullAttribute;
            }
            Node node = element;
            Location location = context.getElementLocation(element);
            String string = "Missing required attribute `%1$s`";
            Object[] objectArray = new Object[]{fullAttribute};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)location, (String)string2, null, (int)16, null);
            return null;
        }
        return element.getAttributeNS("http://schemas.android.com/apk/res/android", (String)fullAttribute);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.FATAL;
        Implementation implementation = new Implementation(RestrictionsDetector.class, Scope.RESOURCE_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"ValidRestrictions", (String)"Invalid Restrictions Descriptor", (String)"Ensures that an applications restrictions XML file is properly formed", (Implementation)implementation, (String)"https://developer.android.com/reference/android/content/RestrictionsManager.html", (Category)category, (int)5, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002R\u0016\u0010\f\u001a\u00020\n8\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0002R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/lint/checks/RestrictionsDetector$Companion;", "", "()V", "ATTR_DESCRIPTION", "", "ATTR_KEY", "ATTR_RESTRICTION_TYPE", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "MAX_NESTING_DEPTH", "", "getMAX_NESTING_DEPTH$annotations", "MAX_NUMBER_OF_NESTED_RESTRICTIONS", "getMAX_NUMBER_OF_NESTED_RESTRICTIONS$annotations", "TAG_RESTRICTION", "TAG_RESTRICTIONS", "VALUE_BUNDLE", "VALUE_BUNDLE_ARRAY", "VALUE_CHOICE", "VALUE_DEFAULT_VALUE", "VALUE_ENTRIES", "VALUE_ENTRY_VALUES", "VALUE_HIDDEN", "VALUE_INTEGER", "VALUE_MULTI_SELECT", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getMAX_NESTING_DEPTH$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getMAX_NUMBER_OF_NESTED_RESTRICTIONS$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

