/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/BuildListDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Issues", "lint-checks"})
public final class BuildListDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(BuildListDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("BuildListAdds", "Missing `add` call in `buildList`", "\n          The `buildList { }` standard library function is a convenient way to \\\n          build lists, but you need to actually call `add` on the items.\n          ", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);
    @NotNull
    private static final String BUILD_LIST_OWNER = "kotlin.collections.CollectionsKt__CollectionsKt";

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"buildList");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        JavaEvaluator evaluator = context.getEvaluator();
        if (node.getValueArgumentCount() == 1 && evaluator.isMemberInClass((PsiMember)method, BUILD_LIST_OWNER)) {
            Object e = node.getValueArguments().get(0);
            ULambdaExpression uLambdaExpression = e instanceof ULambdaExpression ? (ULambdaExpression)e : null;
            if (uLambdaExpression == null) {
                return;
            }
            ULambdaExpression argument = uLambdaExpression;
            Ref.BooleanRef isAdding = new Ref.BooleanRef();
            argument.getBody().accept((UastVisitor)new AbstractUastVisitor(isAdding){
                final /* synthetic */ Ref.BooleanRef $isAdding;
                {
                    this.$isAdding = $isAdding;
                }

                public boolean visitCallExpression(@NotNull UCallExpression node) {
                    UExpression receiver;
                    String name;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    String string = node.getMethodName();
                    if (string == null) {
                        UIdentifier uIdentifier = node.getMethodIdentifier();
                        string = uIdentifier != null ? uIdentifier.getName() : null;
                    }
                    if ((Intrinsics.areEqual((Object)(name = string), (Object)"add") || Intrinsics.areEqual((Object)name, (Object)"addAll")) && ((receiver = node.getReceiver()) == null || receiver instanceof UThisExpression)) {
                        String containingClass;
                        PsiMethod psiMethod = node.resolve();
                        String string2 = psiMethod != null && (psiMethod = psiMethod.getContainingClass()) != null ? psiMethod.getQualifiedName() : (containingClass = null);
                        if (containingClass == null || Intrinsics.areEqual((Object)containingClass, (Object)"java.util.List")) {
                            this.$isAdding.element = true;
                        }
                    }
                    return this.$isAdding.element;
                }
            });
            if (!isAdding.element) {
                String message2 = "No `add` calls within `buildList` lambda; this is usually a mistake";
                JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)message2, null, (int)16, null);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/BuildListDetector$Issues;", "", "()V", "BUILD_LIST_OWNER", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

