/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.WearDetectorKt;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.utils.DomExtensions;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/android/tools/lint/checks/WearDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "()V", "isWearProject", "", "()Z", "setWearProject", "(Z)V", "beforeCheckEachProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "Companion", "lint-checks"})
public class WearDetector
extends Detector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isWearProject;

    public final boolean isWearProject() {
        return this.isWearProject;
    }

    public final void setWearProject(boolean bl) {
        this.isWearProject = bl;
    }

    public void beforeCheckEachProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.beforeCheckEachProject(context);
        this.isWearProject = Companion.isWearProject(context);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/WearDetector$Companion;", "", "()V", "containsWearFeature", "", "manifest", "Lorg/w3c/dom/Element;", "isWearProject", "context", "Lcom/android/tools/lint/detector/api/Context;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isWearProject(@NotNull Context context) {
            Element element;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (context.isGlobalAnalysis()) {
                Document document = context.getMainProject().getMergedManifest();
                element = document != null ? document.getDocumentElement() : null;
            } else {
                Document document = context.getProject().getManifestDom();
                element = document != null ? document.getDocumentElement() : null;
            }
            return this.containsWearFeature(element);
        }

        private final boolean containsWearFeature(Element manifest) {
            if (manifest == null) {
                return false;
            }
            Iterator iterator = DomExtensions.iterator((Element)manifest);
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (!WearDetectorKt.access$isWearFeature(element)) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

