/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.repository.NetworkCache;
import com.android.tools.lint.checks.Index;
import com.android.tools.lint.checks.Library;
import com.android.tools.lint.checks.LibraryVersion;
import com.android.tools.lint.checks.LibraryVersionLabels;
import com.android.tools.lint.checks.Sdk;
import com.android.tools.lint.detector.api.LintFix;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 N2\u00020\u0001:\u0005NOPQRB\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u001e\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bJ\u001e\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bJ\u001e\u0010 \u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bJ$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\"2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bJ\u001e\u0010#\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bJ\u001e\u0010$\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bJ\u001e\u0010%\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bJ$\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0\"2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bJ,\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\"\u0010+\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\b\u0010,\u001a\u00020-H\u0007J\"\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u0018\u00100\u001a\b\u0012\u0004\u0012\u00020\u000b0\"2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u001a\u00101\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0018\u00102\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bJ\u001e\u00103\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bJ(\u00104\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\b\u0010)\u001a\u0004\u0018\u00010*J\u001e\u00105\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bJ\u0006\u00106\u001a\u000207J\u0014\u00106\u001a\u0002072\n\b\u0002\u00108\u001a\u0004\u0018\u000109H\u0007J(\u0010:\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\b\u0010)\u001a\u0004\u0018\u00010*J(\u0010;\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\b\u0010)\u001a\u0004\u0018\u00010*J\u0006\u0010<\u001a\u00020\u0006J\u0018\u0010=\u001a\u0002072\u0006\u0010>\u001a\u00020\b2\u0006\u0010?\u001a\u00020-H\u0014J\u0010\u0010@\u001a\u0002072\u0006\u0010>\u001a\u00020\bH\u0014J*\u0010A\u001a\u0002072\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\b\u0010B\u001a\u0004\u0018\u00010*H\u0014J\u0010\u0010C\u001a\u0002072\u0006\u0010?\u001a\u00020-H\u0014J*\u0010D\u001a\u0002072\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\b\u0010B\u001a\u0004\u0018\u00010*H\u0014J*\u0010E\u001a\u0002072\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\b\u0010B\u001a\u0004\u0018\u00010*H\u0014J\u0012\u0010F\u001a\u0004\u0018\u0001092\u0006\u0010G\u001a\u00020\u000bH\u0014J\u0018\u0010H\u001a\u00020\b2\u000e\u0010I\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001090JH\u0002J\u0010\u0010K\u001a\u0002072\u0006\u0010L\u001a\u00020MH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/android/tools/lint/checks/GooglePlaySdkIndex;", "Lcom/android/ide/common/repository/NetworkCache;", "cacheDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "initialized", "", "lastReadResult", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex$ReadDataResult;", "libraryToSdk", "Ljava/util/HashMap;", "", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex$LibraryToSdk;", "Lkotlin/collections/HashMap;", "showPolicyIssues", "getShowPolicyIssues", "()Z", "setShowPolicyIssues", "(Z)V", "status", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex$GooglePlaySdkIndexStatus;", "createCoordinateString", "groupId", "artifactId", "extractPolicyViolations", "", "Lcom/android/tools/lint/checks/LibraryVersionLabels$PolicyIssuesInfo$SdkPolicy;", "labels", "Lcom/android/tools/lint/checks/LibraryVersionLabels;", "generateBlockingCriticalMessage", "versionString", "generateBlockingGenericIssueMessage", "generateBlockingOutdatedMessage", "generateBlockingPolicyMessages", "", "generateCriticalMessage", "generateGenericIssueMessage", "generateOutdatedMessage", "generatePolicyMessages", "generateSdkLinkLintFix", "Lcom/android/tools/lint/detector/api/LintFix;", "buildFile", "Ljava/io/File;", "getLabels", "getLastReadSource", "Lcom/android/ide/common/repository/NetworkCache$DataSourceType;", "getLibraryVersion", "Lcom/android/tools/lint/checks/LibraryVersion;", "getPolicyLabels", "getSdk", "getSdkUrl", "hasLibraryBlockingIssues", "hasLibraryCriticalIssues", "hasLibraryErrorOrWarning", "initialize", "", "overriddenData", "Ljava/io/InputStream;", "isLibraryNonCompliant", "isLibraryOutdated", "isReady", "logCachingError", "readResult", "dataSourceType", "logErrorInDefaultData", "logHasCriticalIssues", "file", "logIndexLoadedCorrectly", "logNonCompliant", "logOutdated", "readDefaultData", "relative", "readIndexData", "readFunction", "Lkotlin/Function0;", "setMaps", "index", "Lcom/android/tools/lint/checks/Index;", "Companion", "GooglePlaySdkIndexStatus", "LibraryToSdk", "ReadDataErrorType", "ReadDataResult", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nGooglePlaySdkIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GooglePlaySdkIndex.kt\ncom/android/tools/lint/checks/GooglePlaySdkIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,511:1\n1549#2:512\n1620#2,3:513\n1549#2:516\n1620#2,3:517\n*S KotlinDebug\n*F\n+ 1 GooglePlaySdkIndex.kt\ncom/android/tools/lint/checks/GooglePlaySdkIndex\n*L\n386#1:512\n386#1:513,3\n397#1:516\n397#1:517,3\n*E\n"})
public abstract class GooglePlaySdkIndex
extends NetworkCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private ReadDataResult lastReadResult;
    private boolean initialized;
    @NotNull
    private GooglePlaySdkIndexStatus status;
    @NotNull
    private final HashMap<String, LibraryToSdk> libraryToSdk;
    private boolean showPolicyIssues;
    @NotNull
    public static final String SDK_INDEX_SNAPSHOT_TEST_BASE_URL_ENV_VAR = "SDK_INDEX_TEST_BASE_URL";
    @NotNull
    private static final String DEFAULT_SDK_INDEX_SNAPSHOT_BASE_URL = "https://dl.google.com/play-sdk/index/";
    public static final boolean DEFAULT_SHOW_POLICY_ISSUES = true;
    @NotNull
    public static final String GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_FILE = "snapshot.gz";
    @NotNull
    public static final String GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_RESOURCE = "sdk-index-offline-snapshot.proto.gz";
    @NotNull
    private static final String GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_URL;
    @NotNull
    public static final String GOOGLE_PLAY_SDK_INDEX_KEY = "sdk_index";
    public static final long GOOGLE_PLAY_SDK_CACHE_EXPIRY_INTERVAL_DAYS = 7L;
    @NotNull
    public static final String GOOGLE_PLAY_SDK_INDEX_URL = "https://developer.android.com/distribute/sdk-index";
    @NotNull
    public static final String VIEW_DETAILS_MESSAGE = "View details in Google Play SDK Index";
    @NotNull
    private static final Map<LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy, String> POLICY_TYPE_TO_TEXT;

    public GooglePlaySdkIndex(@Nullable Path cacheDir) {
        super(GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_URL, GOOGLE_PLAY_SDK_INDEX_KEY, cacheDir, 0, (int)TimeUnit.DAYS.toHours(7L), false, 40, null);
        this.status = GooglePlaySdkIndexStatus.NOT_READY;
        this.libraryToSdk = new HashMap();
        this.showPolicyIssues = true;
    }

    public /* synthetic */ GooglePlaySdkIndex(Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            path = null;
        }
        this(path);
    }

    public final boolean getShowPolicyIssues() {
        return this.showPolicyIssues;
    }

    public final void setShowPolicyIssues(boolean bl) {
        this.showPolicyIssues = bl;
    }

    public final void initialize() {
        this.initialize(null);
    }

    private final ReadDataResult readIndexData(Function0<? extends InputStream> readFunction) {
        ReadDataErrorType readDataErrorType = ReadDataErrorType.DATA_FUNCTION_EXCEPTION;
        try {
            InputStream rawData = (InputStream)readFunction.invoke();
            if (rawData != null) {
                readDataErrorType = ReadDataErrorType.GZIP_EXCEPTION;
                GZIPInputStream gzipData = new GZIPInputStream(rawData);
                readDataErrorType = ReadDataErrorType.INDEX_PARSE_EXCEPTION;
                Index index2 = Index.parseFrom((InputStream)gzipData);
                readDataErrorType = index2 != null ? ReadDataErrorType.NO_ERROR : ReadDataErrorType.INDEX_PARSE_NULL_ERROR;
                return new ReadDataResult(index2, readDataErrorType, null);
            }
        }
        catch (Exception exception) {
            return new ReadDataResult(null, readDataErrorType, exception);
        }
        return new ReadDataResult(null, ReadDataErrorType.DATA_FUNCTION_NULL_ERROR, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void initialize(@Nullable InputStream overriddenData) {
        GooglePlaySdkIndex googlePlaySdkIndex = this;
        synchronized (googlePlaySdkIndex) {
            boolean bl = false;
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            this.status = GooglePlaySdkIndexStatus.NOT_READY;
            Unit $i$a$-synchronized-GooglePlaySdkIndex$initialize$2 = Unit.INSTANCE;
        }
        Index index2 = null;
        NetworkCache.DataSourceType indexDataSource = null;
        if (overriddenData != null) {
            this.setLastReadSourceType(NetworkCache.DataSourceType.TEST_DATA);
            indexDataSource = this.getLastReadSourceType();
            index2 = Index.parseFrom((InputStream)overriddenData);
        } else {
            this.lastReadResult = this.readIndexData((Function0<? extends InputStream>)((Function0)new Function0<InputStream>(this){
                final /* synthetic */ GooglePlaySdkIndex this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final InputStream invoke() {
                    return GooglePlaySdkIndex.access$findData(this.this$0, "snapshot.gz");
                }
            }));
            ReadDataResult readDataResult = this.lastReadResult;
            if (readDataResult == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lastReadResult");
                readDataResult = null;
            }
            if (readDataResult.getIndex() != null) {
                indexDataSource = this.getLastReadSourceType();
                ReadDataResult readDataResult2 = this.lastReadResult;
                if (readDataResult2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lastReadResult");
                    readDataResult2 = null;
                }
                index2 = readDataResult2.getIndex();
            } else if (this.getLastReadSourceType() != NetworkCache.DataSourceType.DEFAULT_DATA) {
                this.setLastReadSourceType(NetworkCache.DataSourceType.UNKNOWN_SOURCE);
                ReadDataResult offlineResult2 = this.readIndexData((Function0<? extends InputStream>)((Function0)new Function0<InputStream>(this){
                    final /* synthetic */ GooglePlaySdkIndex this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final InputStream invoke() {
                        return this.this$0.readDefaultData("sdk-index-offline-snapshot.proto.gz");
                    }
                }));
                if (offlineResult2.getIndex() != null) {
                    indexDataSource = NetworkCache.DataSourceType.DEFAULT_DATA;
                    index2 = offlineResult2.getIndex();
                } else {
                    indexDataSource = NetworkCache.DataSourceType.UNKNOWN_SOURCE;
                    this.logErrorInDefaultData(offlineResult2);
                }
            } else {
                indexDataSource = NetworkCache.DataSourceType.UNKNOWN_SOURCE;
                ReadDataResult readDataResult3 = this.lastReadResult;
                if (readDataResult3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lastReadResult");
                    readDataResult3 = null;
                }
                this.logErrorInDefaultData(readDataResult3);
            }
        }
        if (index2 != null) {
            this.setMaps(index2);
            this.status = GooglePlaySdkIndexStatus.READY;
            this.logIndexLoadedCorrectly(indexDataSource);
        }
    }

    public static /* synthetic */ void initialize$default(GooglePlaySdkIndex googlePlaySdkIndex, InputStream inputStream, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: initialize");
        }
        if ((n & 1) != 0) {
            inputStream = null;
        }
        googlePlaySdkIndex.initialize(inputStream);
    }

    public final boolean isReady() {
        return this.status == GooglePlaySdkIndexStatus.READY;
    }

    public final boolean isLibraryNonCompliant(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File buildFile) {
        boolean isNonCompliant;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        LibraryVersionLabels libraryVersionLabels = this.getLabels(groupId, artifactId, versionString);
        boolean bl = isNonCompliant = libraryVersionLabels != null ? libraryVersionLabels.hasPolicyIssuesInfo() : false;
        if (isNonCompliant) {
            this.logNonCompliant(groupId, artifactId, versionString, buildFile);
        }
        return this.showPolicyIssues && isNonCompliant;
    }

    public final boolean isLibraryOutdated(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File buildFile) {
        boolean isOutdated;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        LibraryVersionLabels libraryVersionLabels = this.getLabels(groupId, artifactId, versionString);
        boolean bl = isOutdated = libraryVersionLabels != null ? libraryVersionLabels.hasOutdatedIssueInfo() : false;
        if (isOutdated) {
            this.logOutdated(groupId, artifactId, versionString, buildFile);
        }
        return isOutdated;
    }

    public final boolean hasLibraryCriticalIssues(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File buildFile) {
        boolean hasCriticalIssues;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        LibraryVersionLabels libraryVersionLabels = this.getLabels(groupId, artifactId, versionString);
        boolean bl = hasCriticalIssues = libraryVersionLabels != null ? libraryVersionLabels.hasCriticalIssueInfo() : false;
        if (hasCriticalIssues) {
            this.logHasCriticalIssues(groupId, artifactId, versionString, buildFile);
        }
        return hasCriticalIssues;
    }

    public final boolean hasLibraryBlockingIssues(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        LibraryVersionLabels libraryVersionLabels = this.getLabels(groupId, artifactId, versionString);
        if (libraryVersionLabels == null) {
            return false;
        }
        LibraryVersionLabels labels = libraryVersionLabels;
        LibraryVersionLabels.Severity severity = labels.getSeverity();
        return severity == LibraryVersionLabels.Severity.BLOCKING_SEVERITY;
    }

    public final boolean hasLibraryErrorOrWarning(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        LibraryVersionLabels libraryVersionLabels = this.getLabels(groupId, artifactId, versionString);
        if (libraryVersionLabels == null) {
            return false;
        }
        LibraryVersionLabels labels = libraryVersionLabels;
        return labels.getSeverity() == LibraryVersionLabels.Severity.BLOCKING_SEVERITY || labels.hasOutdatedIssueInfo() || labels.hasPolicyIssuesInfo();
    }

    @Nullable
    public final String getSdkUrl(@NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        if (!this.isReady()) {
            return null;
        }
        LibraryToSdk libraryToSdk = this.getSdk(groupId, artifactId);
        if (libraryToSdk == null) {
            return null;
        }
        LibraryToSdk sdk = libraryToSdk;
        return sdk.getSdk().getIndexUrl();
    }

    private final LibraryVersionLabels getLabels(String groupId, String artifactId, String versionString) {
        if (!this.isReady()) {
            return null;
        }
        LibraryVersion libraryVersion = this.getLibraryVersion(groupId, artifactId, versionString);
        if (libraryVersion == null) {
            return null;
        }
        LibraryVersion libraryVersion2 = libraryVersion;
        return libraryVersion2.getVersionLabels();
    }

    private final LibraryVersion getLibraryVersion(String groupId, String artifactId, String versionString) {
        String coordinate = this.createCoordinateString(groupId, artifactId);
        LibraryToSdk libraryToSdk = this.libraryToSdk.get(coordinate);
        if (libraryToSdk == null) {
            return null;
        }
        LibraryToSdk sdk = libraryToSdk;
        return sdk.getVersion(versionString);
    }

    private final LibraryToSdk getSdk(String groupId, String artifactId) {
        String coordinate = this.createCoordinateString(groupId, artifactId);
        return this.libraryToSdk.get(coordinate);
    }

    private final void setMaps(Index index2) {
        this.libraryToSdk.clear();
        List sdkList = index2.getSdksList();
        for (Sdk sdk : sdkList) {
            for (Library library : sdk.getLibrariesList()) {
                String string = library.getLibraryId().getMavenId().getGroupId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"library.libraryId.mavenId.groupId");
                String string2 = library.getLibraryId().getMavenId().getArtifactId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"library.libraryId.mavenId.artifactId");
                String coordinate = this.createCoordinateString(string, string2);
                Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"sdk");
                LibraryToSdk currentLibrary = new LibraryToSdk(coordinate, sdk);
                for (LibraryVersion version : library.getVersionsList()) {
                    String string3 = version.getVersionString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"version.versionString");
                    Intrinsics.checkNotNullExpressionValue((Object)version, (String)"version");
                    currentLibrary.addLibraryVersion(string3, version);
                }
                ((Map)this.libraryToSdk).put(currentLibrary.getLibraryId(), currentLibrary);
            }
        }
    }

    private final String createCoordinateString(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    @Nullable
    protected InputStream readDefaultData(@NotNull String relative) {
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        if (this.getLastReadSourceType() != NetworkCache.DataSourceType.UNKNOWN_SOURCE) {
            ReadDataResult readDataResult = this.lastReadResult;
            if (readDataResult == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lastReadResult");
                readDataResult = null;
            }
            this.logCachingError(readDataResult, this.getLastReadSourceType());
        }
        return GooglePlaySdkIndex.class.getResourceAsStream("/sdk-index-offline-snapshot.proto.gz");
    }

    @Nullable
    public LintFix generateSdkLinkLintFix(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File buildFile) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        String url = this.getSdkUrl(groupId, artifactId);
        CharSequence charSequence = url;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : (LintFix)new LintFix.ShowUrl(VIEW_DETAILS_MESSAGE, null, url, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> generateBlockingPolicyMessages(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        Iterable $this$map$iv = this.getPolicyLabels(this.getLabels(groupId, artifactId, versionString));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void label;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("[Prevents app release in Google Play Console] " + groupId + ":" + artifactId + " version " + versionString + " has " + (String)label + " issues that will block publishing of your app to Play Console");
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> generatePolicyMessages(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        Iterable $this$map$iv = this.getPolicyLabels(this.getLabels(groupId, artifactId, versionString));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void label;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(groupId + ":" + artifactId + " version " + versionString + " has " + (String)label + " issues that will block publishing of your app to Play Console in the future");
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String generateBlockingCriticalMessage(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        return "[Prevents app release in Google Play Console] " + groupId + ":" + artifactId + " version " + versionString + " has been reported as problematic by its author and will block publishing of your app to Play Console";
    }

    @NotNull
    public final String generateCriticalMessage(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        return groupId + ":" + artifactId + " version " + versionString + " has an associated message from its author";
    }

    @NotNull
    public final String generateBlockingOutdatedMessage(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        return "[Prevents app release in Google Play Console] " + groupId + ":" + artifactId + " version " + versionString + " has been reported as outdated by its author and will block publishing of your app to Play Console";
    }

    @NotNull
    public final String generateOutdatedMessage(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        return groupId + ":" + artifactId + " version " + versionString + " has been reported as outdated by its author";
    }

    @NotNull
    public final String generateBlockingGenericIssueMessage(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        return groupId + ":" + artifactId + " version " + versionString + " has one or more issues that will block publishing of your app to Play Console";
    }

    @NotNull
    public final String generateGenericIssueMessage(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        return groupId + ":" + artifactId + " version " + versionString + " has one or more issues that could block publishing of your app to Play Console in the future";
    }

    protected void logHasCriticalIssues(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
    }

    protected void logNonCompliant(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
    }

    protected void logOutdated(@NotNull String groupId, @NotNull String artifactId, @NotNull String versionString, @Nullable File file) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
    }

    protected void logCachingError(@NotNull ReadDataResult readResult, @NotNull NetworkCache.DataSourceType dataSourceType) {
        Intrinsics.checkNotNullParameter((Object)readResult, (String)"readResult");
        Intrinsics.checkNotNullParameter((Object)dataSourceType, (String)"dataSourceType");
    }

    protected void logErrorInDefaultData(@NotNull ReadDataResult readResult) {
        Intrinsics.checkNotNullParameter((Object)readResult, (String)"readResult");
    }

    protected void logIndexLoadedCorrectly(@NotNull NetworkCache.DataSourceType dataSourceType) {
        Intrinsics.checkNotNullParameter((Object)dataSourceType, (String)"dataSourceType");
    }

    @VisibleForTesting
    @NotNull
    public final NetworkCache.DataSourceType getLastReadSource() {
        return this.getLastReadSourceType();
    }

    private final List<String> getPolicyLabels(LibraryVersionLabels labels) {
        String defaultLabel = "policy";
        Set<LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy> policyViolations = this.extractPolicyViolations(labels);
        List result = new ArrayList();
        boolean hasUnknown = false;
        for (LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy violation : policyViolations) {
            if (POLICY_TYPE_TO_TEXT.containsKey(violation)) {
                result.add(POLICY_TYPE_TO_TEXT.get(violation) + " policy");
                continue;
            }
            hasUnknown = true;
        }
        if (hasUnknown || result.isEmpty()) {
            result.add(defaultLabel);
        }
        return result;
    }

    private final Set<LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy> extractPolicyViolations(LibraryVersionLabels labels) {
        Set result = new LinkedHashSet();
        if (labels == null || !labels.hasPolicyIssuesInfo()) {
            return result;
        }
        List types = labels.getPolicyIssuesInfo().getViolatedSdkPoliciesList();
        if (types != null) {
            result.addAll(types);
        }
        return result;
    }

    public GooglePlaySdkIndex() {
        this(null, 1, null);
    }

    public static final /* synthetic */ InputStream access$findData(GooglePlaySdkIndex $this, String relative) {
        return $this.findData(relative);
    }

    static {
        String string = System.getenv(SDK_INDEX_SNAPSHOT_TEST_BASE_URL_ENV_VAR);
        if (string == null) {
            string = DEFAULT_SDK_INDEX_SNAPSHOT_BASE_URL;
        }
        GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_URL = string;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy.SDK_POLICY_UNKNOWN, (Object)"unknown"), TuplesKt.to((Object)LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy.SDK_POLICY_ADS, (Object)"Ads"), TuplesKt.to((Object)LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy.SDK_POLICY_DEVICE_AND_NETWORK_ABUSE, (Object)"Device and Network Abuse"), TuplesKt.to((Object)LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy.SDK_POLICY_DECEPTIVE_BEHAVIOR, (Object)"Deceptive Behavior"), TuplesKt.to((Object)LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy.SDK_POLICY_USER_DATA, (Object)"User Data"), TuplesKt.to((Object)LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy.SDK_POLICY_PERMISSIONS, (Object)"Permissions"), TuplesKt.to((Object)LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy.SDK_POLICY_MOBILE_UNWANTED_SOFTWARE, (Object)"Mobile Unwanted Software"), TuplesKt.to((Object)LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy.SDK_POLICY_MALWARE, (Object)"Malware")};
        POLICY_TYPE_TO_TEXT = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00040\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/GooglePlaySdkIndex$Companion;", "", "()V", "DEFAULT_SDK_INDEX_SNAPSHOT_BASE_URL", "", "DEFAULT_SHOW_POLICY_ISSUES", "", "GOOGLE_PLAY_SDK_CACHE_EXPIRY_INTERVAL_DAYS", "", "GOOGLE_PLAY_SDK_INDEX_KEY", "GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_FILE", "GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_RESOURCE", "GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_URL", "getGOOGLE_PLAY_SDK_INDEX_SNAPSHOT_URL", "()Ljava/lang/String;", "GOOGLE_PLAY_SDK_INDEX_URL", "POLICY_TYPE_TO_TEXT", "", "Lcom/android/tools/lint/checks/LibraryVersionLabels$PolicyIssuesInfo$SdkPolicy;", "getPOLICY_TYPE_TO_TEXT", "()Ljava/util/Map;", "SDK_INDEX_SNAPSHOT_TEST_BASE_URL_ENV_VAR", "VIEW_DETAILS_MESSAGE", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getGOOGLE_PLAY_SDK_INDEX_SNAPSHOT_URL() {
            return GOOGLE_PLAY_SDK_INDEX_SNAPSHOT_URL;
        }

        @NotNull
        public final Map<LibraryVersionLabels.PolicyIssuesInfo.SdkPolicy, String> getPOLICY_TYPE_TO_TEXT() {
            return POLICY_TYPE_TO_TEXT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/GooglePlaySdkIndex$GooglePlaySdkIndexStatus;", "", "(Ljava/lang/String;I)V", "NOT_READY", "READY", "lint-checks"})
    private static final class GooglePlaySdkIndexStatus
    extends Enum<GooglePlaySdkIndexStatus> {
        public static final /* enum */ GooglePlaySdkIndexStatus NOT_READY = new GooglePlaySdkIndexStatus();
        public static final /* enum */ GooglePlaySdkIndexStatus READY = new GooglePlaySdkIndexStatus();
        private static final /* synthetic */ GooglePlaySdkIndexStatus[] $VALUES;

        public static GooglePlaySdkIndexStatus[] values() {
            return (GooglePlaySdkIndexStatus[])$VALUES.clone();
        }

        public static GooglePlaySdkIndexStatus valueOf(String value) {
            return Enum.valueOf(GooglePlaySdkIndexStatus.class, value);
        }

        static {
            $VALUES = googlePlaySdkIndexStatusArray = new GooglePlaySdkIndexStatus[]{GooglePlaySdkIndexStatus.NOT_READY, GooglePlaySdkIndexStatus.READY};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u000eJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0003R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/GooglePlaySdkIndex$LibraryToSdk;", "", "libraryId", "", "sdk", "Lcom/android/tools/lint/checks/Sdk;", "(Ljava/lang/String;Lcom/android/tools/lint/checks/Sdk;)V", "latestVersion", "getLibraryId", "()Ljava/lang/String;", "getSdk", "()Lcom/android/tools/lint/checks/Sdk;", "versionToLibraryVersion", "Ljava/util/HashMap;", "Lcom/android/tools/lint/checks/LibraryVersion;", "Lkotlin/collections/HashMap;", "addLibraryVersion", "", "versionString", "libraryVersion", "getVersion", "lint-checks"})
    private static final class LibraryToSdk {
        @NotNull
        private final String libraryId;
        @NotNull
        private final Sdk sdk;
        @NotNull
        private final HashMap<String, LibraryVersion> versionToLibraryVersion;
        @Nullable
        private String latestVersion;

        public LibraryToSdk(@NotNull String libraryId, @NotNull Sdk sdk) {
            Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
            Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
            this.libraryId = libraryId;
            this.sdk = sdk;
            this.versionToLibraryVersion = new HashMap();
        }

        @NotNull
        public final String getLibraryId() {
            return this.libraryId;
        }

        @NotNull
        public final Sdk getSdk() {
            return this.sdk;
        }

        public final void addLibraryVersion(@NotNull String versionString, @NotNull LibraryVersion libraryVersion) {
            Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
            Intrinsics.checkNotNullParameter((Object)libraryVersion, (String)"libraryVersion");
            ((Map)this.versionToLibraryVersion).put(versionString, libraryVersion);
            if (libraryVersion.getIsLatestVersion()) {
                this.latestVersion = versionString;
            }
        }

        @Nullable
        public final LibraryVersion getVersion(@NotNull String versionString) {
            Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
            return this.versionToLibraryVersion.get(versionString);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0084\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/GooglePlaySdkIndex$ReadDataErrorType;", "", "(Ljava/lang/String;I)V", "NO_ERROR", "DATA_FUNCTION_EXCEPTION", "DATA_FUNCTION_NULL_ERROR", "GZIP_EXCEPTION", "INDEX_PARSE_EXCEPTION", "INDEX_PARSE_NULL_ERROR", "lint-checks"})
    protected static final class ReadDataErrorType
    extends Enum<ReadDataErrorType> {
        public static final /* enum */ ReadDataErrorType NO_ERROR = new ReadDataErrorType();
        public static final /* enum */ ReadDataErrorType DATA_FUNCTION_EXCEPTION = new ReadDataErrorType();
        public static final /* enum */ ReadDataErrorType DATA_FUNCTION_NULL_ERROR = new ReadDataErrorType();
        public static final /* enum */ ReadDataErrorType GZIP_EXCEPTION = new ReadDataErrorType();
        public static final /* enum */ ReadDataErrorType INDEX_PARSE_EXCEPTION = new ReadDataErrorType();
        public static final /* enum */ ReadDataErrorType INDEX_PARSE_NULL_ERROR = new ReadDataErrorType();
        private static final /* synthetic */ ReadDataErrorType[] $VALUES;

        public static ReadDataErrorType[] values() {
            return (ReadDataErrorType[])$VALUES.clone();
        }

        public static ReadDataErrorType valueOf(String value) {
            return Enum.valueOf(ReadDataErrorType.class, value);
        }

        static {
            $VALUES = readDataErrorTypeArray = new ReadDataErrorType[]{ReadDataErrorType.NO_ERROR, ReadDataErrorType.DATA_FUNCTION_EXCEPTION, ReadDataErrorType.DATA_FUNCTION_NULL_ERROR, ReadDataErrorType.GZIP_EXCEPTION, ReadDataErrorType.INDEX_PARSE_EXCEPTION, ReadDataErrorType.INDEX_PARSE_NULL_ERROR};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0004\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u00a2\u0006\u0002\u0010\tR\u0019\u0010\u0006\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/GooglePlaySdkIndex$ReadDataResult;", "", "index", "Lcom/android/tools/lint/checks/Index;", "readDataErrorType", "Lcom/android/tools/lint/checks/GooglePlaySdkIndex$ReadDataErrorType;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Lcom/android/tools/lint/checks/Index;Lcom/android/tools/lint/checks/GooglePlaySdkIndex$ReadDataErrorType;Ljava/lang/Exception;)V", "getException", "()Ljava/lang/Exception;", "getIndex", "()Lcom/android/tools/lint/checks/Index;", "getReadDataErrorType", "()Lcom/android/tools/lint/checks/GooglePlaySdkIndex$ReadDataErrorType;", "lint-checks"})
    protected static final class ReadDataResult {
        @Nullable
        private final Index index;
        @NotNull
        private final ReadDataErrorType readDataErrorType;
        @Nullable
        private final Exception exception;

        public ReadDataResult(@Nullable Index index2, @NotNull ReadDataErrorType readDataErrorType, @Nullable Exception exception) {
            Intrinsics.checkNotNullParameter((Object)((Object)readDataErrorType), (String)"readDataErrorType");
            this.index = index2;
            this.readDataErrorType = readDataErrorType;
            this.exception = exception;
        }

        @Nullable
        public final Index getIndex() {
            return this.index;
        }

        @NotNull
        public final ReadDataErrorType getReadDataErrorType() {
            return this.readDataErrorType;
        }

        @Nullable
        public final Exception getException() {
            return this.exception;
        }
    }
}

