/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.gradle.RichVersion;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.VersionCatalogNamingUtilKt;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.LintTomlDocument;
import com.android.tools.lint.client.api.LintTomlLiteralValue;
import com.android.tools.lint.client.api.LintTomlMapValue;
import com.android.tools.lint.client.api.LintTomlValue;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UPolyadicExpression;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010&\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u001az\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00132\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0016\u001a\u00020\u00132\b\b\u0002\u0010\u0017\u001a\u00020\u0013H\u0002\u001a4\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a<\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a@\u0010\"\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u0005\u0018\u00010#2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001\u001a<\u0010$\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u00132\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u0001H\u0002\u001aF\u0010(\u001a\u0004\u0018\u00010%2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010&\u001a\u00020\u0013H\u0002\u001a2\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001f\u0018\u00010.2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010/\u001a\u0004\u0018\u00010\t2\b\u00100\u001a\u0004\u0018\u00010\tH\u0002\u001a\u001c\u00101\u001a\u0004\u0018\u00010\u001f2\b\u00102\u001a\u0004\u0018\u00010\t2\u0006\u0010'\u001a\u00020\u0001H\u0002\u001a\u0010\u00103\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u00104\u001a\u0002052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a&\u00106\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001f\u0018\u00010#2\b\u0010/\u001a\u0004\u0018\u00010\t2\u0006\u0010)\u001a\u00020\u001f\u001a&\u00107\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001f\u0018\u00010#2\b\u0010/\u001a\u0004\u0018\u00010\t2\u0006\u0010)\u001a\u00020\u001f\u001a\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u0001092\u0006\u0010*\u001a\u00020\u0001H\u0002\u001a\u001c\u0010:\u001a\u0004\u0018\u00010\u001f2\u0006\u0010)\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a,\u0010;\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001f0<2\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u001a<\u0010=\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001f\u0018\u00010<2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007\u001a\u0012\u0010>\u001a\u00020\u00132\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0016\u0010?\u001a\u00020\u0013*\u0004\u0018\u00010\t2\u0006\u0010'\u001a\u00020\u0001H\u0002\u001a\u0014\u0010@\u001a\u00020A*\u00020\u001a2\u0006\u0010B\u001a\u00020AH\u0002\u001a\f\u0010C\u001a\u00020\u0013*\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"VC_LIBRARIES", "", "VC_PLUGINS", "VC_VERSIONS", "createAddNewCatalogLibrary", "Lcom/android/tools/lint/detector/api/LintFix;", "dependency", "Lcom/android/ide/common/gradle/Dependency;", "versionsMap", "Lcom/android/tools/lint/client/api/LintTomlMapValue;", "librariesMap", "document", "Lcom/android/tools/lint/client/api/LintTomlDocument;", "context", "Lcom/android/tools/lint/detector/api/GradleContext;", "valueCookie", "", "versionVar", "allowExistingVersionVar", "", "includeVersionInKey", "overrideMessage", "autoFix", "independent", "createAddVersionFix", "source", "", "versionVariable", "createChangeVersionFix", "version", "versionNode", "Lcom/android/tools/lint/client/api/LintTomlValue;", "createInsertLibraryFix", "libraryVariable", "createMoveToTomlFix", "Lkotlin/Pair;", "createReplaceWithLibraryReferenceFix", "Lcom/android/tools/lint/detector/api/LintFix$ReplaceString;", "safe", "name", "createSwitchToLibraryFix", "library", "key", "libraryVersion", "Lcom/android/ide/common/gradle/Version;", "findExistingVariable", "", "versions", "libraries", "getBeforeIfAlphabeticOrder", "mapOwner", "getCatalogName", "getGradleDependencyStringLocation", "Lcom/android/tools/lint/detector/api/Location;", "getLibraryFromTomlEntry", "getPluginFromTomlEntry", "getReservedQuickfixNames", "", "getVersion", "pickLibraryVariableName", "", "pickVersionVariableName", "spaceAroundEquals", "contains", "findNextLineStart", "", "start", "isInAlphabeticalOrder", "lint-checks"})
@JvmName(name="Lint")
@SourceDebugExtension(value={"SMAP\nTomlUtilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TomlUtilities.kt\ncom/android/tools/lint/checks/Lint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,800:1\n1#2:801\n125#3:802\n187#4,3:803\n*S KotlinDebug\n*F\n+ 1 TomlUtilities.kt\ncom/android/tools/lint/checks/Lint\n*L\n500#1:802\n742#1:803,3\n*E\n"})
public final class Lint {
    @NotNull
    public static final String VC_LIBRARIES = "libraries";
    @NotNull
    public static final String VC_PLUGINS = "plugins";
    @NotNull
    public static final String VC_VERSIONS = "versions";

    @Nullable
    public static final Pair<String, LintTomlValue> getLibraryFromTomlEntry(@Nullable LintTomlMapValue versions, @NotNull LintTomlValue library) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (library instanceof LintTomlLiteralValue) {
            Object object2 = library.getActualValue();
            if (object2 == null || (object2 = object2.toString()) == null || (object2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString()) == null) {
                return null;
            }
            Object coordinate = object2;
            return new Pair(coordinate, (Object)library);
        }
        if (!(library instanceof LintTomlMapValue)) {
            return null;
        }
        LintTomlValue lintTomlValue = Lint.getVersion((LintTomlMapValue)library, versions);
        if (lintTomlValue == null) {
            return null;
        }
        LintTomlValue versionNode = lintTomlValue;
        Object object3 = versionNode.getActualValue();
        if (object3 == null || (object3 = object3.toString()) == null || (object3 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString()) == null) {
            return null;
        }
        Object version = object3;
        LintTomlValue module = ((LintTomlMapValue)library).get("module");
        if (module instanceof LintTomlLiteralValue) {
            object = ((LintTomlLiteralValue)module).getActualValue();
            if (object == null || (object = object.toString()) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
                return null;
            }
        } else {
            Object object4 = ((LintTomlMapValue)library).get("group");
            if (object4 == null || (object4 = object4.getActualValue()) == null || (object4 = object4.toString()) == null || (object4 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object4))).toString()) == null) {
                return null;
            }
            Object group = object4;
            Object object5 = ((LintTomlMapValue)library).get("name");
            if (object5 == null || (object5 = object5.getActualValue()) == null || (object5 = object5.toString()) == null || (object5 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object5))).toString()) == null) {
                return null;
            }
            Object name = object5;
            object = (String)group + ":" + (String)name;
        }
        Object artifact = object;
        return new Pair((Object)((String)artifact + ":" + (String)version), (Object)versionNode);
    }

    @Nullable
    public static final Pair<String, LintTomlValue> getPluginFromTomlEntry(@Nullable LintTomlMapValue versions, @NotNull LintTomlValue library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (library instanceof LintTomlLiteralValue) {
            Object object = library.getActualValue();
            if (object == null || (object = object.toString()) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
                return null;
            }
            Object coordinate = object;
            return new Pair(coordinate, (Object)library);
        }
        if (!(library instanceof LintTomlMapValue)) {
            return null;
        }
        LintTomlValue lintTomlValue = Lint.getVersion((LintTomlMapValue)library, versions);
        if (lintTomlValue == null) {
            return null;
        }
        LintTomlValue versionNode = lintTomlValue;
        Object object = versionNode.getActualValue();
        if (object == null || (object = object.toString()) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
            return null;
        }
        Object version = object;
        LintTomlValue id = ((LintTomlMapValue)library).get("id");
        if (id instanceof LintTomlLiteralValue) {
            Object object2 = ((LintTomlLiteralValue)id).getActualValue();
            if (object2 == null || (object2 = object2.toString()) == null || (object2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString()) == null) {
                return null;
            }
            Object artifact = object2;
            return new Pair((Object)((String)artifact + ":" + (String)version), (Object)versionNode);
        }
        return null;
    }

    private static final LintTomlValue getVersion(LintTomlMapValue library, LintTomlMapValue versionsMap) {
        LintTomlValue lintTomlValue = library.get("version");
        if (lintTomlValue == null) {
            return null;
        }
        LintTomlValue version = lintTomlValue;
        LintTomlValue lintTomlValue2 = version;
        if (lintTomlValue2 instanceof LintTomlLiteralValue) {
            return version;
        }
        if (lintTomlValue2 instanceof LintTomlMapValue) {
            LintTomlMapValue lintTomlMapValue;
            LintTomlValue ref = ((LintTomlMapValue)version).get("ref");
            if (ref != null) {
                if (versionsMap == null) {
                    return null;
                }
                Object object = ref.getActualValue();
                if (object == null || (object = object.toString()) == null || (object = ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()) == null) {
                    return null;
                }
                Object versionVariable = object;
                LintTomlValue lintTomlValue3 = versionsMap.get((String)versionVariable);
                if (lintTomlValue3 == null) {
                    return null;
                }
                LintTomlValue referenced = lintTomlValue3;
                if (!(referenced instanceof LintTomlMapValue)) {
                    return referenced;
                }
                lintTomlMapValue = (LintTomlMapValue)referenced;
            } else {
                lintTomlMapValue = (LintTomlMapValue)version;
            }
            LintTomlMapValue richVersion = lintTomlMapValue;
            return richVersion.first();
        }
        return null;
    }

    private static final int findNextLineStart(CharSequence $this$findNextLineStart, int start) {
        int lineEnd = StringsKt.indexOf$default((CharSequence)$this$findNextLineStart, (char)'\n', (int)start, (boolean)false, (int)4, null);
        if (lineEnd != -1) {
            return lineEnd + 1;
        }
        return -1;
    }

    @Nullable
    public static final Pair<String, LintFix> createMoveToTomlFix(@NotNull GradleContext context, @NotNull LintTomlValue librariesMap, @NotNull Dependency dependency, @NotNull Object valueCookie, @Nullable String versionVar) {
        String matchExistingVar;
        LintTomlValue existingVersionNode;
        Object object;
        Object object2;
        LintFix fix;
        String string;
        LintFix[] lintFixArray;
        RichVersion version;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)librariesMap, (String)"librariesMap");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter((Object)valueCookie, (String)"valueCookie");
        if (!(librariesMap instanceof LintTomlMapValue)) {
            return null;
        }
        LintTomlDocument document = librariesMap.getDocument();
        LintTomlValue lintTomlValue = document.getValue(VC_VERSIONS);
        LintTomlMapValue versionsMap = lintTomlValue instanceof LintTomlMapValue ? (LintTomlMapValue)lintTomlValue : null;
        LintTomlValue artifactLibrary = null;
        LintTomlValue artifactVersionNode = null;
        Version artifactVersion = null;
        RichVersion richVersion = version = dependency.getVersion();
        if (richVersion != null) {
            RichVersion richVersion2 = richVersion;
            boolean bl = false;
            String identifier = richVersion2.toIdentifier();
            lintFixArray = (LintFix[])identifier;
            if (lintFixArray == null || StringsKt.isBlank((CharSequence)lintFixArray)) {
                return null;
            }
            string = identifier;
        } else {
            string = null;
        }
        String richVersionIdentifier = string;
        for (Map.Entry entry : ((LintTomlMapValue)librariesMap).getMappedValues().entrySet()) {
            String key = (String)entry.getKey();
            LintTomlValue library = (LintTomlValue)entry.getValue();
            if (Lint.getLibraryFromTomlEntry(versionsMap, library) == null) continue;
            String coordinate = (String)lintFixArray.component1();
            LintTomlValue versionNode = (LintTomlValue)lintFixArray.component2();
            Dependency c = Dependency.Companion.parse(coordinate);
            if (c.getGroup() == null || c.getVersion() == null || !Intrinsics.areEqual((Object)c.getGroup(), (Object)dependency.getGroup()) || !Intrinsics.areEqual((Object)c.getName(), (Object)dependency.getName())) continue;
            if (Intrinsics.areEqual((Object)c.getVersion(), (Object)version)) {
                LintFix.ReplaceString replaceString = Lint.createSwitchToLibraryFix$default(document, library, key, context, valueCookie, null, true, 32, null);
                if (replaceString == null) {
                    return null;
                }
                LintFix.ReplaceString fix2 = replaceString;
                return TuplesKt.to((Object)("Use the existing version catalog reference (`" + fix2.getReplacement() + "`) instead"), (Object)fix2);
            }
            if (artifactLibrary != null) {
                boolean bl;
                if (artifactVersion != null) {
                    Boolean bl2;
                    boolean bl3 = false;
                    RichVersion richVersion3 = c.getVersion();
                    if (richVersion3 != null && (richVersion3 = richVersion3.getLowerBound()) != null) {
                        Version v;
                        RichVersion it2 = richVersion3;
                        boolean bl4 = false;
                        bl2 = it2.compareTo(v) > 0;
                    } else {
                        bl2 = null;
                    }
                    bl = Intrinsics.areEqual(bl2, (Object)true);
                } else {
                    bl = false;
                }
                if (!bl) continue;
            }
            artifactLibrary = library;
            artifactVersionNode = versionNode;
            RichVersion richVersion4 = c.getVersion();
            artifactVersion = richVersion4 != null ? richVersion4.getLowerBound() : null;
        }
        if (artifactLibrary != null) {
            LintFix addNew = Lint.createAddNewCatalogLibrary$default(dependency, versionsMap, (LintTomlMapValue)librariesMap, document, context, valueCookie, versionVar, false, true, null, false, false, 3712, null);
            String string2 = artifactLibrary.getKey();
            Intrinsics.checkNotNull((Object)string2);
            String string3 = string2;
            LintFix.ReplaceString switchToVersion = Lint.createSwitchToLibraryFix(document, artifactLibrary, string3, context, valueCookie, artifactVersion, false);
            lintFixArray = new LintFix[]{addNew, switchToVersion};
            fix = LintFix.Companion.create().alternatives(lintFixArray);
            String artifact = dependency.getGroup() + ":" + dependency.getName();
            String message2 = "Use version catalog instead (" + artifact + " is already available as `" + string3 + "`, but using version " + artifactVersion + " instead)";
            return TuplesKt.to((Object)message2, (Object)fix);
        }
        if (versionVar != null) {
            LintTomlMapValue lintTomlMapValue = versionsMap;
            object2 = lintTomlMapValue != null ? lintTomlMapValue.get(versionVar) : null;
        } else {
            object2 = null;
        }
        String string4 = (object = (existingVersionNode = object2)) != null && (object = object.getActualValue()) != null ? object.toString() : null;
        Map.Entry<String, LintTomlValue> entry = Lint.findExistingVariable(dependency, versionsMap, (LintTomlMapValue)librariesMap);
        String string5 = matchExistingVar = entry != null ? entry.getKey() : null;
        if (string4 == null || Intrinsics.areEqual((Object)string4, (Object)richVersionIdentifier)) {
            lintFixArray = new LintFix[2];
            LintFix lintFix = lintFixArray[0] = matchExistingVar != null ? Lint.createAddNewCatalogLibrary$default(dependency, versionsMap, (LintTomlMapValue)librariesMap, document, context, valueCookie, matchExistingVar, true, false, "Replace with new library catalog declaration, reusing version variable " + matchExistingVar, false, false, 3328, null) : null;
            if (Lint.createAddNewCatalogLibrary$default(dependency, versionsMap, (LintTomlMapValue)librariesMap, document, context, valueCookie, versionVar, true, false, null, true, false, 768, null) == null) {
                LintFix cfr_ignored_0 = lintFixArray[1];
                return null;
            }
            fix = LintFix.Companion.create().alternatives(lintFixArray);
            return TuplesKt.to(null, (Object)fix);
        }
        lintFixArray = new LintFix[]{Lint.createAddNewCatalogLibrary$default(dependency, versionsMap, (LintTomlMapValue)librariesMap, document, context, valueCookie, versionVar, true, false, "Replace with new library catalog declaration, reusing version variable " + versionVar + " (version=" + string4 + ")", false, false, 2304, null), Lint.createChangeVersionFix(richVersionIdentifier, existingVersionNode), Lint.createAddNewCatalogLibrary$default(dependency, versionsMap, (LintTomlMapValue)librariesMap, document, context, valueCookie, versionVar, false, false, null, false, false, 3840, null)};
        fix = LintFix.Companion.create().alternatives(lintFixArray);
        return TuplesKt.to(null, (Object)fix);
    }

    private static final Map.Entry<String, LintTomlValue> findExistingVariable(Dependency dependency, LintTomlMapValue versions, LintTomlMapValue libraries) {
        if (versions == null) {
            return null;
        }
        if (libraries == null) {
            return null;
        }
        Object object = dependency.getVersion();
        if (object == null || (object = object.toIdentifier()) == null) {
            return null;
        }
        Object revision = object;
        String string = dependency.getGroup();
        if (string == null) {
            return null;
        }
        String group = string;
        for (Map.Entry<String, LintTomlValue> entry : versions.getMappedValues().entrySet()) {
            LintTomlValue versionNode = (LintTomlValue)entry.getValue();
            Object value = versionNode.getActualValue();
            if (!Intrinsics.areEqual((Object)value, (Object)revision)) continue;
            for (Map.Entry entry2 : libraries.getMappedValues().entrySet()) {
                Object object2;
                String libraryGroup;
                int index2;
                Object object3;
                String artifact;
                LintTomlValue module;
                LintTomlValue libraryVersion;
                Object v = entry2.getValue();
                LintTomlMapValue lintTomlMapValue = v instanceof LintTomlMapValue ? (LintTomlMapValue)v : null;
                if (lintTomlMapValue == null) continue;
                LintTomlMapValue library = lintTomlMapValue;
                if (Lint.getVersion(library, versions) == null) {
                    return null;
                }
                if (!Intrinsics.areEqual((Object)libraryVersion, (Object)versionNode) || !((module = library.get("module")) instanceof LintTomlLiteralValue ? (artifact = (object3 = ((LintTomlLiteralValue)module).getActualValue()) != null && (object3 = object3.toString()) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString() : null) != null && (index2 = StringsKt.indexOf$default((CharSequence)artifact, (char)':', (int)0, (boolean)false, (int)6, null)) != -1 && StringsKt.regionMatches$default((String)group, (int)0, (String)artifact, (int)0, (int)index2, (boolean)false, (int)16, null) : Intrinsics.areEqual(libraryGroup = (object2 = library.get("group")) != null && (object2 = object2.getActualValue()) != null && (object2 = object2.toString()) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object2))).toString() : null, (Object)group))) continue;
                return entry;
            }
        }
        return null;
    }

    private static final LintFix createChangeVersionFix(String version, LintTomlValue versionNode) {
        LintFix lintFix;
        String string = version;
        if (string != null) {
            String it = string;
            boolean bl = false;
            lintFix = LintFix.Companion.create().name("Change " + versionNode.getKey() + " to " + version).replace().range(versionNode.getLocation()).all().with("\"" + version + "\"").build();
        } else {
            lintFix = null;
        }
        return lintFix;
    }

    private static final LintFix createAddNewCatalogLibrary(Dependency dependency, LintTomlMapValue versionsMap, LintTomlMapValue librariesMap, LintTomlDocument document, GradleContext context, Object valueCookie, String versionVar, boolean allowExistingVersionVar, boolean includeVersionInKey, String overrideMessage, boolean autoFix, boolean independent) {
        LintTomlMapValue lintTomlMapValue = versionsMap;
        String versionVariable = Lint.pickVersionVariableName(dependency, lintTomlMapValue != null ? lintTomlMapValue.getMappedValues() : null, versionVar, allowExistingVersionVar);
        String libraryVariable = Lint.pickLibraryVariableName(dependency, librariesMap.getMappedValues(), includeVersionInKey);
        CharSequence source = document.getSource();
        LintFix versionVariableFix = null;
        String usedVariable = null;
        if (versionsMap == null || !Lint.contains(versionsMap, versionVariable)) {
            versionVariableFix = Lint.createAddVersionFix(versionsMap, source, document, versionVariable, dependency);
            usedVariable = versionVariableFix == null ? null : versionVariable;
        } else {
            versionVariableFix = null;
            usedVariable = versionVariable;
        }
        LintFix lintFix = Lint.createInsertLibraryFix(librariesMap, source, libraryVariable, dependency, usedVariable, document);
        if (lintFix == null) {
            return null;
        }
        LintFix insertLibraryFix = lintFix;
        LintFix.ReplaceString gradleFix = Lint.createReplaceWithLibraryReferenceFix$default(document, context, valueCookie, libraryVariable, true, null, 32, null);
        LintFix.Builder builder = LintFix.Companion.create();
        Object object = overrideMessage;
        if (object == null) {
            object = "Replace with new library catalog declaration for " + libraryVariable;
        }
        LintFix[] lintFixArray = new LintFix[]{versionVariableFix, insertLibraryFix, gradleFix};
        return builder.name((String)object).composite(lintFixArray).autoFix(autoFix, independent);
    }

    static /* synthetic */ LintFix createAddNewCatalogLibrary$default(Dependency dependency, LintTomlMapValue lintTomlMapValue, LintTomlMapValue lintTomlMapValue2, LintTomlDocument lintTomlDocument, GradleContext gradleContext, Object object, String string, boolean bl, boolean bl2, String string2, boolean bl3, boolean bl4, int n, Object object2) {
        if ((n & 0x80) != 0) {
            bl = false;
        }
        if ((n & 0x100) != 0) {
            bl2 = false;
        }
        if ((n & 0x200) != 0) {
            string2 = null;
        }
        if ((n & 0x400) != 0) {
            bl3 = true;
        }
        if ((n & 0x800) != 0) {
            bl4 = bl3;
        }
        return Lint.createAddNewCatalogLibrary(dependency, lintTomlMapValue, lintTomlMapValue2, lintTomlDocument, gradleContext, object, string, bl, bl2, string2, bl3, bl4);
    }

    /*
     * WARNING - void declaration
     */
    private static final LintFix.ReplaceString createSwitchToLibraryFix(LintTomlDocument document, LintTomlValue library, String key, GradleContext context, Object valueCookie, Version libraryVersion, boolean safe) {
        Object object;
        String string;
        boolean bl;
        String string2;
        Object object2;
        GradleContext gradleContext;
        LintTomlDocument lintTomlDocument;
        block5: {
            block4: {
                void it;
                String string3 = library.getFullKey();
                if (string3 == null || (string3 = StringsKt.removePrefix((String)string3, (CharSequence)"libraries.")) == null) {
                    return null;
                }
                String variableName = string3;
                lintTomlDocument = document;
                gradleContext = context;
                object2 = valueCookie;
                string2 = variableName;
                bl = safe;
                string = key;
                object = libraryVersion;
                if (object == null) break block4;
                Version version = object;
                String string4 = string;
                boolean bl2 = bl;
                String string5 = string2;
                Object object3 = object2;
                GradleContext gradleContext2 = gradleContext;
                LintTomlDocument lintTomlDocument2 = lintTomlDocument;
                boolean bl3 = false;
                String string6 = " (version " + (Version)it + ")";
                lintTomlDocument = lintTomlDocument2;
                gradleContext = gradleContext2;
                object2 = object3;
                string2 = string5;
                bl = bl2;
                string = string4;
                String string7 = string6;
                object = string7;
                if (string7 != null) break block5;
            }
            object = "";
        }
        return Lint.createReplaceWithLibraryReferenceFix(lintTomlDocument, gradleContext, object2, string2, bl, "Replace with existing version catalog reference `" + string + "`" + (String)object);
    }

    static /* synthetic */ LintFix.ReplaceString createSwitchToLibraryFix$default(LintTomlDocument lintTomlDocument, LintTomlValue lintTomlValue, String string, GradleContext gradleContext, Object object, Version version, boolean bl, int n, Object object2) {
        if ((n & 0x20) != 0) {
            version = null;
        }
        return Lint.createSwitchToLibraryFix(lintTomlDocument, lintTomlValue, string, gradleContext, object, version, bl);
    }

    private static final LintFix.ReplaceString createReplaceWithLibraryReferenceFix(LintTomlDocument document, GradleContext context, Object valueCookie, String libraryVariable, boolean safe, String name) {
        LintFix.ReplaceStringBuilder replaceStringBuilder;
        String catalogName = Lint.getCatalogName(document);
        StringBuilder gradleKey = new StringBuilder();
        int n = libraryVariable.length();
        for (int i = 0; i < n; ++i) {
            char c = libraryVariable.charAt(i);
            if (c == '-' || c == '_' && (i == 0 || !Character.isDigit(libraryVariable.charAt(i)) && (i == libraryVariable.length() - 1 || !Character.isDigit(libraryVariable.charAt(i + 1))))) {
                gradleKey.append('.');
                continue;
            }
            gradleKey.append(c);
        }
        String replacement = catalogName + "." + gradleKey;
        Location range = Lint.getGradleDependencyStringLocation(context, valueCookie);
        LintFix.ReplaceStringBuilder $this$createReplaceWithLibraryReferenceFix_u24lambda_u245 = replaceStringBuilder = LintFix.Companion.create().replace().range(range).all().with(replacement).autoFix(safe, safe);
        boolean bl = false;
        if (name != null) {
            $this$createReplaceWithLibraryReferenceFix_u24lambda_u245.name(name);
        }
        LintFix lintFix = replaceStringBuilder.build();
        Intrinsics.checkNotNull((Object)lintFix, (String)"null cannot be cast to non-null type com.android.tools.lint.detector.api.LintFix.ReplaceString");
        return (LintFix.ReplaceString)lintFix;
    }

    static /* synthetic */ LintFix.ReplaceString createReplaceWithLibraryReferenceFix$default(LintTomlDocument lintTomlDocument, GradleContext gradleContext, Object object, String string, boolean bl, String string2, int n, Object object2) {
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        return Lint.createReplaceWithLibraryReferenceFix(lintTomlDocument, gradleContext, object, string, bl, string2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Location getGradleDependencyStringLocation(GradleContext context, Object valueCookie) {
        PsiElement sourcePsi;
        UElement uElement = valueCookie instanceof UElement ? (UElement)valueCookie : null;
        Object object = sourcePsi = uElement != null ? uElement.getSourcePsi() : null;
        if (sourcePsi instanceof KtStringTemplateExpression) {
            Object object2 = valueCookie instanceof UPolyadicExpression ? (UPolyadicExpression)valueCookie : null;
            boolean bl = object2 != null && (object2 = object2.getOperands()) != null ? object2.size() == 1 : false;
            if (bl) {
                sourcePsi = ((UExpression)CollectionsKt.single((List)((UPolyadicExpression)valueCookie).getOperands())).getSourcePsi();
            }
        }
        if (sourcePsi instanceof KtLiteralStringTemplateEntry) {
            void $this$getParentOfType$iv;
            PsiElement psiElement = sourcePsi;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            KtValueArgument argument = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtValueArgument.class, (boolean)strict$iv);
            if (argument != null) {
                return context.getLocation((Object)argument);
            }
        }
        return context.getLocation(valueCookie);
    }

    private static final String getCatalogName(LintTomlDocument document) {
        String string = document.getFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.getFile().name");
        return StringsKt.substringBefore$default((String)string, (char)'.', null, (int)2, null);
    }

    private static final boolean isInAlphabeticalOrder(LintTomlMapValue $this$isInAlphabeticalOrder) {
        String lastKey = "";
        int correctCount = 0;
        Map map = $this$isInAlphabeticalOrder.getMappedValues();
        int keyCount = map.size();
        if (keyCount <= 3) {
            return true;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next().getKey();
            if (StringsKt.compareTo((String)key, (String)lastKey, (boolean)true) >= 0) {
                ++correctCount;
            }
            lastKey = key;
        }
        return correctCount - keyCount <= 3 || correctCount * 100 / keyCount >= 90;
    }

    private static final LintTomlValue getBeforeIfAlphabeticOrder(LintTomlMapValue mapOwner, String name) {
        if (mapOwner == null) {
            return null;
        }
        if (!Lint.isInAlphabeticalOrder(mapOwner)) {
            return null;
        }
        for (Map.Entry entry : mapOwner.getMappedValues().entrySet()) {
            String key = (String)entry.getKey();
            LintTomlValue value = (LintTomlValue)entry.getValue();
            if (StringsKt.compareTo((String)key, (String)name, (boolean)true) < 0) continue;
            return value;
        }
        return null;
    }

    private static final LintFix createAddVersionFix(LintTomlMapValue versionsMap, CharSequence source, LintTomlDocument document, String versionVariable, Dependency dependency) {
        int n;
        Object object = dependency.getVersion();
        if (object == null || (object = object.toIdentifier()) == null) {
            return null;
        }
        Object versionIdentifier = object;
        String separator = Lint.spaceAroundEquals(versionsMap) ? " = " : "=";
        String variableDeclaration = versionVariable + separator + "\"" + (String)versionIdentifier + "\"\n";
        boolean independent = true;
        LintTomlValue before = Lint.getBeforeIfAlphabeticOrder(versionsMap, versionVariable);
        if (before != null) {
            n = before.getKeyStartOffset();
        } else {
            LintTomlValue lastVersion;
            LintTomlMapValue lintTomlMapValue = versionsMap;
            Object object2 = lastVersion = lintTomlMapValue != null ? lintTomlMapValue.last() : null;
            if (lastVersion != null) {
                int it = Lint.findNextLineStart(source, lastVersion.getEndOffset());
                boolean bl = false;
                n = it == -1 ? source.length() : it;
            } else {
                int versionsIndex = StringsKt.indexOf$default((CharSequence)source, (String)"[versions]", (int)0, (boolean)false, (int)6, null);
                if (versionsIndex != -1) {
                    n = Lint.findNextLineStart(source, versionsIndex);
                } else {
                    return null;
                }
            }
        }
        int versionInsertOffset = n;
        return LintFix.Companion.create().replace().range(Location.Companion.create(document.getFile(), source, versionInsertOffset, versionInsertOffset)).beginning().with(variableDeclaration).autoFix(true, independent).build();
    }

    private static final LintFix createInsertLibraryFix(LintTomlMapValue librariesMap, CharSequence source, String libraryVariable, Dependency dependency, String versionVariable, LintTomlDocument document) {
        Object object;
        String group;
        String suffix;
        String prefix;
        int libraryInsertOffset;
        block23: {
            block22: {
                String string;
                int n;
                LintTomlValue before = Lint.getBeforeIfAlphabeticOrder(librariesMap, libraryVariable);
                if (before != null) {
                    n = before.getKeyStartOffset();
                } else {
                    LintTomlValue lastLibrary = librariesMap.last();
                    if (lastLibrary != null) {
                        n = Lint.findNextLineStart(source, lastLibrary.getEndOffset());
                    } else {
                        int librariesIndex = StringsKt.indexOf$default((CharSequence)source, (String)"[libraries]", (int)0, (boolean)false, (int)6, null);
                        if (librariesIndex != -1) {
                            n = Lint.findNextLineStart(source, librariesIndex);
                        } else {
                            return null;
                        }
                    }
                }
                libraryInsertOffset = n;
                prefix = "";
                suffix = "";
                if (libraryInsertOffset == -1) {
                    LintTomlValue nextSection = librariesMap.next();
                    if (nextSection != null) {
                        libraryInsertOffset = nextSection.getKeyStartOffset();
                        if (libraryInsertOffset == -1) {
                            libraryInsertOffset = nextSection.getStartOffset();
                        }
                        source.charAt(libraryInsertOffset);
                        while (libraryInsertOffset > 0 && source.charAt(libraryInsertOffset - 1) != '\n') {
                            --libraryInsertOffset;
                        }
                        prefix = "";
                        suffix = "\n";
                    } else {
                        libraryInsertOffset = source.length();
                    }
                }
                if (libraryInsertOffset > 0 && source.charAt(libraryInsertOffset - 1) != '\n') {
                    prefix = "\n";
                } else {
                    suffix = "\n";
                }
                if (versionVariable != null) {
                    string = "version.ref = \"" + versionVariable + "\"";
                } else {
                    RichVersion richVersion;
                    RichVersion richVersion2 = richVersion = dependency.getVersion();
                    if (richVersion2 != null) {
                        RichVersion it = richVersion2;
                        boolean bl = false;
                        String identifier = it.toIdentifier();
                        CharSequence charSequence = identifier;
                        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                            return null;
                        }
                        string = "version = \"" + it + "\"";
                    } else {
                        string = null;
                    }
                }
                String version = string;
                String string2 = dependency.getGroup();
                if (string2 == null) {
                    return null;
                }
                group = string2;
                object = version;
                if (object == null) break block22;
                String it = object;
                boolean bl = false;
                String string3 = ", " + it;
                object = string3;
                if (string3 != null) break block23;
            }
            object = "";
        }
        Object versionWithSeparator = object;
        String moduleDeclaration = prefix + libraryVariable + " = { module = \"" + group + ":" + dependency.getName() + "\"" + (String)versionWithSeparator + " }" + suffix;
        return LintFix.Companion.create().replace().range(Location.Companion.create(document.getFile(), source, libraryInsertOffset, libraryInsertOffset)).beginning().with(moduleDeclaration).autoFix().build();
    }

    private static final boolean spaceAroundEquals(LintTomlMapValue versionsMap) {
        LintTomlValue first;
        if (versionsMap == null) {
            return true;
        }
        LintTomlValue lintTomlValue = first = versionsMap.first();
        if (lintTomlValue == null) {
            return true;
        }
        int keyStart = lintTomlValue.getKeyStartOffset();
        int valueStart = first.getStartOffset();
        int indexOf = StringsKt.indexOf$default((CharSequence)first.getDocument().getSource(), (String)" =", (int)keyStart, (boolean)false, (int)4, null);
        return indexOf != -1 && indexOf < valueStart;
    }

    @VisibleForTesting
    @NotNull
    public static final String pickLibraryVariableName(@NotNull Dependency dependency, @NotNull Map<String, ? extends LintTomlValue> libraries, boolean includeVersionInKey) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter(libraries, (String)VC_LIBRARIES);
        TreeSet<String> reserved = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        Iterator<Map.Entry<String, ? extends LintTomlValue>> iterator = libraries.entrySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().getKey();
            reserved.add(key);
        }
        Set<String> reservedQuickfixNames = Lint.getReservedQuickfixNames(VC_LIBRARIES);
        for (String key : reservedQuickfixNames) {
            reserved.add(key);
        }
        String suggestion = VersionCatalogNamingUtilKt.pickLibraryVariableName((Dependency)dependency, (boolean)includeVersionInKey, (Set)reserved);
        reservedQuickfixNames.add(suggestion);
        return suggestion;
    }

    private static final boolean contains(LintTomlMapValue $this$contains, String name) {
        boolean bl;
        block4: {
            if ($this$contains == null) {
                return false;
            }
            Map $this$any$iv = $this$contains.getMappedValues();
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)((String)it.getKey()), (String)name, (boolean)true)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @VisibleForTesting
    @NotNull
    public static final String pickVersionVariableName(@NotNull Dependency dependency, @Nullable Map<String, ? extends LintTomlValue> versionsMap, @Nullable String versionVar, boolean allowExistingVersionVar) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        if (allowExistingVersionVar && versionVar != null) {
            return versionVar;
        }
        TreeSet<String> reserved = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        if (versionsMap != null) {
            Iterator<Map.Entry<String, ? extends LintTomlValue>> iterator = versionsMap.entrySet().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next().getKey();
                reserved.add(key);
            }
        }
        Set<String> reservedQuickfixNames = Lint.getReservedQuickfixNames(VC_VERSIONS);
        for (String key : reservedQuickfixNames) {
            reserved.add(key);
        }
        if (versionVar != null && !reserved.contains(versionVar)) {
            return versionVar;
        }
        String suggestion = VersionCatalogNamingUtilKt.pickVersionVariableName((Dependency)dependency, (Set)reserved);
        reservedQuickfixNames.add(suggestion);
        return suggestion;
    }

    public static /* synthetic */ String pickVersionVariableName$default(Dependency dependency, Map map, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return Lint.pickVersionVariableName(dependency, map, string, bl);
    }

    private static final Set<String> getReservedQuickfixNames(String key) {
        Map<String, Set<String>> reservedQuickfixNames;
        Object object;
        Object it;
        Object object2;
        Map<String, Set<String>> map = GradleDetector.Companion.getReservedQuickfixNames();
        if (map == null) {
            it = object2 = (Map)new LinkedHashMap();
            boolean bl = false;
            GradleDetector.Companion.setReservedQuickfixNames((Map<String, Set<String>>)it);
            map = object2;
        }
        if ((object = (reservedQuickfixNames = map).get(key)) == null) {
            it = object2 = (Set)new LinkedHashSet();
            boolean bl = false;
            reservedQuickfixNames.put(key, (Set<String>)it);
            object = object2;
        }
        return object;
    }
}

