/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J \u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/AccessibilityWindowStateChangedDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkSendAccessibilityEvent", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "checkTypeWindowStateChangedWithinOverride", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "getApplicableMethodNames", "", "", "getApplicableReferenceNames", "visitMethodCall", "method", "Lcom/intellij/psi/PsiMethod;", "visitReference", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nAccessibilityWindowStateChangedDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessibilityWindowStateChangedDetector.kt\ncom/android/tools/lint/checks/AccessibilityWindowStateChangedDetector\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,158:1\n18#2:159\n*S KotlinDebug\n*F\n+ 1 AccessibilityWindowStateChangedDetector.kt\ncom/android/tools/lint/checks/AccessibilityWindowStateChangedDetector\n*L\n94#1:159\n*E\n"})
public final class AccessibilityWindowStateChangedDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int TYPE_WINDOW_STATE_CHANGED = 32;
    @NotNull
    private static final String WINDOW_STATE_CHANGED_EVENT_MESSAGE = "Manually populating or sending TYPE_WINDOW_STATE_CHANGED events should be avoided. They may be ignored on certain versions of Android. Prefer setting UI metadata using `View.onInitializeAccessibilityNodeInfo`, `Activity.setTitle`, `ViewCompat.setAccessibilityPaneTitle`, etc. to inform users of crucial changes to the UI.";
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("AccessibilityWindowStateChangedEvent", "Use of accessibility window state change events", "\n          Sending or populating `TYPE_WINDOW_STATE_CHANGED` events in your code \\\n          is strongly discouraged. \\\n          Instead, prefer to use or extend system-provided widgets that are as far down Android's \\\n          class hierarchy as possible. \\\n          System-provided widgets that are far down the hierarchy already have most of the \\\n          accessibility capabilities your app needs. \\\n          If you must extend `View` or `Canvas` directly, then still prefer to: set UI metadata by \\\n          calling `Activity.setTitle`, `ViewCompat.setAccessibilityPaneTitle`, or \\\n          `ViewCompat.setAccessibilityLiveRegion`; \\\n          implement `View.onInitializeAccessibilityNodeInfo`; \\\n          and (for very specialized custom controls) implement \\\n          `View.getAccessibilityNodeProvider` to provide a virtual view hierarchy. \\\n          These approaches allow accessibility services to inspect the view \\\n          hierarchy, rather than relying on incomplete information provided by events. \\\n          Events like `TYPE_WINDOW_STATE_CHANGED` will be sent automatically when updating \\\n          this metadata, and so trying to manually send this event will result in duplicate \\\n          events, or the event may be ignored entirely.\n          ", Category.A11Y, 5, Severity.WARNING, new Implementation(AccessibilityWindowStateChangedDetector.class, Scope.JAVA_FILE_SCOPE));

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"sendAccessibilityEvent");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String[] stringArray = new String[]{"int"};
        if (AccessibilityWindowStateChangedDetector.visitMethodCall$isViewMethod(method, context, "sendAccessibilityEvent", stringArray)) {
            this.checkSendAccessibilityEvent(context, node);
        }
    }

    @NotNull
    public List<String> getApplicableReferenceNames() {
        return CollectionsKt.listOf((Object)"TYPE_WINDOW_STATE_CHANGED");
    }

    public void visitReference(@NotNull JavaContext context, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)referenced, (String)"referenced");
        this.checkTypeWindowStateChangedWithinOverride(context, reference, referenced);
    }

    private final void checkSendAccessibilityEvent(JavaContext context, UCallExpression node) {
        UExpression uExpression = node.getArgumentForParameter(0);
        if (uExpression == null) {
            return;
        }
        UExpression firstArg = uExpression;
        Object object = firstArg.evaluate();
        if (object == null) {
            return;
        }
        Object value = object;
        if (!Intrinsics.areEqual((Object)value, (Object)32)) {
            return;
        }
        JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getCallLocation(node, true, true), (String)WINDOW_STATE_CHANGED_EVENT_MESSAGE, null, (int)16, null);
    }

    private final void checkTypeWindowStateChangedWithinOverride(JavaContext context, UReferenceExpression reference, PsiElement referenced) {
        PsiField psiField = referenced instanceof PsiField ? (PsiField)referenced : null;
        if (psiField == null) {
            return;
        }
        PsiField field = psiField;
        if (!Intrinsics.areEqual((Object)field.getName(), (Object)"TYPE_WINDOW_STATE_CHANGED")) {
            return;
        }
        if (!context.getEvaluator().isMemberInClass((PsiMember)field, "android.view.accessibility.AccessibilityEvent")) {
            return;
        }
        UElement $this$getParentOfType_u24default$iv = (UElement)reference;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UMethod.class, (boolean)strict$iv);
        if (uMethod == null) {
            return;
        }
        Object[] objectArray = new String[]{"dispatchPopulateAccessibilityEvent", "onPopulateAccessibilityEvent"};
        UMethod parentMethod = uMethod;
        if (!ArraysKt.contains((Object[])objectArray, (Object)parentMethod.getName())) {
            return;
        }
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)parentMethod));
        if (uClass == null) {
            return;
        }
        UClass containingClass = uClass;
        if (!context.getEvaluator().extendsClass(containingClass.getJavaPsi(), "android.view.View", true)) {
            return;
        }
        if (!context.getEvaluator().isOverride(parentMethod, false)) {
            return;
        }
        JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)reference), (Location)context.getLocation((UElement)reference), (String)WINDOW_STATE_CHANGED_EVENT_MESSAGE, null, (int)16, null);
    }

    private static final boolean visitMethodCall$isViewMethod(PsiMethod $method, JavaContext $context, String methodName, String ... argumentTypes) {
        return Intrinsics.areEqual((Object)$method.getName(), (Object)methodName) && $context.getEvaluator().methodMatches($method, "android.view.View", true, Arrays.copyOf(argumentTypes, argumentTypes.length));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/AccessibilityWindowStateChangedDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "TYPE_WINDOW_STATE_CHANGED", "", "WINDOW_STATE_CHANGED_EVENT_MESSAGE", "", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

