/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u00020\u0005H\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u001c\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0016\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/checks/ExportedFlagDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "createSetToFalseFix", "Lcom/android/tools/lint/detector/api/LintFix;", "createSetToTrueFix", "filterIncident", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getApplicableElements", "", "", "isNonExportedLaunchable", "exported", "Lorg/w3c/dom/Attr;", "intentFilterTag", "Lorg/w3c/dom/Element;", "visitElement", "", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Companion", "lint-checks"})
public final class ExportedFlagDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String MAIN_ACTION = "android.intent.action.MAIN";
    @NotNull
    private static final String CATEGORY_LAUNCHER = "android.intent.category.LAUNCHER";
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableElements() {
        Object[] objectArray = new String[]{"activity", "activity-alias", "service", "receiver"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Element intentFilter = DomExtensions.subtag((Element)element, (String)"intent-filter");
        Element navGraph = DomExtensions.subtag((Element)element, (String)"nav-graph");
        Attr exported = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "exported");
        if ((intentFilter != null || navGraph != null) && exported == null) {
            Incident incident;
            String string;
            LintFix[] lintFixArray;
            String message2 = "As of Android 12, `android:exported` must be set; use `true` to make the activity \\\navailable to other apps, and `false` otherwise.";
            boolean bl = intentFilter != null && (lintFixArray = DomExtensions.subtag((Element)intentFilter, (String)"action")) != null && (string = lintFixArray.getAttributeNS("http://schemas.android.com/apk/res/android", "name")) != null ? string.equals(MAIN_ACTION) : false;
            if (bl) {
                incident = new Incident(ISSUE, (Object)element, context.getNameLocation((Node)element), message2 + " For launcher activities, this should be set to `true`.", this.createSetToTrueFix());
            } else {
                lintFixArray = new LintFix[]{this.createSetToTrueFix(), this.createSetToFalseFix()};
                Incident incident2 = new Incident(ISSUE, (Object)element, context.getNameLocation((Node)element), message2, LintFix.Companion.create().alternatives(lintFixArray));
                incident = incident2;
            }
            Incident incident3 = incident;
            context.report(incident3, this.map());
        } else if (this.isNonExportedLaunchable(exported, intentFilter)) {
            Intrinsics.checkNotNull((Object)exported);
            Incident incident = new Incident(ISSUE, (Object)exported, context.getLocation((Node)exported), "A launchable activity must be exported as of Android 12, which also makes it available to other apps.", this.createSetToTrueFix()).overrideSeverity(Severity.ERROR);
            context.report(incident, this.map());
        }
    }

    public boolean filterIncident(@NotNull Context context, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map, (String)"map");
        if (context.getMainProject().getTargetSdk() >= 31) {
            incident.overrideSeverity(Severity.ERROR);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNonExportedLaunchable(Attr exported, Element intentFilterTag) {
        Attr attr = exported;
        if (!Intrinsics.areEqual((Object)(attr != null ? attr.getValue() : null), (Object)"false")) return false;
        if (intentFilterTag == null) return false;
        Element element = DomExtensions.subtag((Element)intentFilterTag, (String)"action");
        if (element == null) return false;
        String string = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (string == null) return false;
        if (!string.equals(MAIN_ACTION)) return false;
        boolean bl = true;
        if (!bl) return false;
        element = DomExtensions.subtag((Element)intentFilterTag, (String)"category");
        if (element == null) return false;
        string = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (string == null) return false;
        if (!string.equals(CATEGORY_LAUNCHER)) return false;
        return true;
    }

    private final LintFix createSetToTrueFix() {
        return this.fix().set().android().attribute("exported").value("true").build();
    }

    private final LintFix createSetToFalseFix() {
        return this.fix().set().android().attribute("exported").value("false").build();
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(ExportedFlagDetector.class, Scope.MANIFEST_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"IntentFilterExportedReceiver", (String)"Unspecified `android:exported` in manifest", (String)"\n                Apps targeting Android 12 and higher are required to specify an explicit value \\\n                for `android:exported` when the corresponding component has an intent filter defined. \\\n                Otherwise, installation will fail. Set it to `true` to make this activity accessible \\\n                to other apps, and `false` to limit it to be used only by this app or the OS. For \\\n                launch activities, this should be set to true; otherwise, the app will fail to launch.\n\n                Previously, `android:exported` for components without any intent filters present \\\n                used to default to `false`, and when intent filters were present, the default was \\\n                `true`. Defaults which change value based on other values are confusing and lead to \\\n                apps accidentally exporting components as a side-effect of adding intent filters. \\\n                This is a security risk, and we have made this change to avoid introducing \\\n                accidental vulnerabilities.\n\n                While the default without intent filters remains unchanged, it is now required to \\\n                explicitly specify a value when intent filters are present. Any app failing to meet \\\n                this requirement will fail to install on any Android version after Android 11.\n\n                We recommend setting `android:exported` to false (even on previous versions of Android \\\n                prior to this requirement) unless you have a good reason to export a particular \\\n                component.\n            ", (Implementation)implementation, (String)"https://goo.gle/IntentFilterExportedReceiver", (Category)category, (int)5, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/ExportedFlagDetector$Companion;", "", "()V", "CATEGORY_LAUNCHER", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "MAIN_ACTION", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

