/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.RangeDetector;
import com.android.tools.lint.checks.TypedefDetector;
import com.android.tools.lint.client.api.AndroidPlatformAnnotations;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016JB\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J<\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00052\u0006\u0010\t\u001a\u00020\u000eH\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u000eH\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001e2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u000eH\u0002J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0016J\u001e\u0010#\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u000e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130\u0005H\u0002J2\u0010%\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002JX\u0010%\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0005H\u0002J \u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0006H\u0016J\u0018\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/H\u0002J(\u00100\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u0002032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u00104\u001a\u0004\u0018\u00010\u0013*\u00020\u000eH\u0002\u00a8\u00066"}, d2={"Lcom/android/tools/lint/checks/TypedefDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkTypeDefConstant", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "argument", "Lorg/jetbrains/uast/UElement;", "errorNode", "flag", "", "value", "", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "createQuickFix", "Lcom/android/tools/lint/detector/api/LintFix;", "node", "values", "Lorg/jetbrains/uast/UExpression;", "getResolvedValue", "expression", "getResolvedValues", "", "allowed", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "listAllowedValues", "allowedValues", "reportTypeDef", "unmatched", "sameMessage", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "new", "old", "variableIsChecked", "reference", "variable", "Lcom/intellij/psi/PsiVariable;", "visitAnnotationUsage", "element", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "getLiteralValue", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nTypedefDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypedefDetector.kt\ncom/android/tools/lint/checks/TypedefDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,994:1\n1747#2,3:995\n1603#2,9:1000\n1855#2:1009\n1856#2:1011\n1612#2:1012\n1747#2,3:1013\n18#3:998\n18#3:999\n1#4:1010\n37#5,2:1016\n*S KotlinDebug\n*F\n+ 1 TypedefDetector.kt\ncom/android/tools/lint/checks/TypedefDetector\n*L\n288#1:995,3\n693#1:1000,9\n693#1:1009\n693#1:1011\n693#1:1012\n735#1:1013,3\n436#1:998\n634#1:999\n693#1:1010\n859#1:1016,2\n*E\n"})
public final class TypedefDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(TypedefDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    private static final String COMPAT_SUFFIX = "Compat";
    @NotNull
    public static final String ATTR_OPEN = "open";
    @JvmField
    @NotNull
    public static final Issue TYPE_DEF;

    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{AndroidXConstants.INT_DEF_ANNOTATION.oldName(), AndroidXConstants.INT_DEF_ANNOTATION.newName(), AndroidXConstants.LONG_DEF_ANNOTATION.oldName(), AndroidXConstants.LONG_DEF_ANNOTATION.newName(), AndroidXConstants.STRING_DEF_ANNOTATION.oldName(), AndroidXConstants.STRING_DEF_ANNOTATION.newName(), AnnotationDetectorKt.INT_RANGE_ANNOTATION.oldName(), AnnotationDetectorKt.INT_RANGE_ANNOTATION.newName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return type != AnnotationUsageType.BINARY && type != AnnotationUsageType.DEFINITION && type != AnnotationUsageType.ASSIGNMENT_LHS;
    }

    public void visitAnnotationUsage(@NotNull JavaContext context, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        UAnnotation annotation = annotationInfo.getAnnotation();
        String string = annotationInfo.getQualifiedName();
        if (((Intrinsics.areEqual((Object)string, (Object)AndroidXConstants.INT_DEF_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AndroidXConstants.INT_DEF_ANNOTATION.newName())) ? true : Intrinsics.areEqual((Object)string, (Object)AndroidXConstants.LONG_DEF_ANNOTATION.oldName())) ? true : Intrinsics.areEqual((Object)string, (Object)AndroidXConstants.LONG_DEF_ANNOTATION.newName())) {
            Boolean flagAttribute = UastLintUtils.Companion.getAnnotationBooleanValue(annotation, "flag");
            boolean flag = flagAttribute != null && flagAttribute != false;
            this.checkTypeDefConstant(context, annotation, element, null, flag, usageInfo);
        } else if (Intrinsics.areEqual((Object)string, (Object)AndroidXConstants.STRING_DEF_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AndroidXConstants.STRING_DEF_ANNOTATION.newName())) {
            this.checkTypeDefConstant(context, annotation, element, null, false, usageInfo);
        } else if (Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.INT_RANGE_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)string, (Object)AnnotationDetectorKt.INT_RANGE_ANNOTATION.newName())) {
            // empty if block
        }
    }

    private final void checkTypeDefConstant(JavaContext context, UAnnotation annotation, UElement argument, UElement errorNode, boolean flag, AnnotationUsageInfo usageInfo) {
        if (argument == null) {
            return;
        }
        if (argument instanceof ULiteralExpression) {
            Object value = ((ULiteralExpression)argument).getValue();
            if (value == null) {
                return;
            }
            if (value instanceof String) {
                this.checkTypeDefConstant(context, annotation, argument, errorNode, false, value, usageInfo);
            } else if (value instanceof Number) {
                long v = ((Number)value).longValue();
                if (flag && v == 0L) {
                    return;
                }
                this.checkTypeDefConstant(context, annotation, argument, errorNode, flag, value, usageInfo);
            }
        } else if (UastLintUtils.Companion.isMinusOne(argument)) {
            if (!flag) {
                this.reportTypeDef(context, annotation, argument, errorNode, usageInfo);
            }
        } else if (argument instanceof UPrefixExpression) {
            if (flag) {
                this.checkTypeDefConstant(context, annotation, (UElement)((UPrefixExpression)argument).getOperand(), errorNode, true, usageInfo);
            } else {
                UastPrefixOperator operator = ((UPrefixExpression)argument).getOperator();
                if (operator == UastPrefixOperator.BITWISE_NOT) {
                    this.report(context, TYPE_DEF, argument, context.getLocation(argument), "Flag not allowed here");
                } else if (operator == UastPrefixOperator.UNARY_MINUS) {
                    this.reportTypeDef(context, annotation, argument, errorNode, usageInfo);
                }
            }
        } else if (argument instanceof UParenthesizedExpression) {
            UExpression expression = ((UParenthesizedExpression)argument).getExpression();
            this.checkTypeDefConstant(context, annotation, (UElement)expression, errorNode, flag, usageInfo);
        } else if (argument instanceof UIfExpression) {
            if (((UIfExpression)argument).getThenExpression() != null) {
                this.checkTypeDefConstant(context, annotation, (UElement)((UIfExpression)argument).getThenExpression(), errorNode, flag, usageInfo);
            }
            if (((UIfExpression)argument).getElseExpression() != null) {
                this.checkTypeDefConstant(context, annotation, (UElement)((UIfExpression)argument).getElseExpression(), errorNode, flag, usageInfo);
            }
        } else if (argument instanceof UPolyadicExpression) {
            if (flag) {
                if (((UPolyadicExpression)argument).getOperator() == UastBinaryOperator.BITWISE_AND) {
                    for (UExpression operand : ((UPolyadicExpression)argument).getOperands()) {
                        String resolvedName;
                        if (!(operand instanceof UReferenceExpression) || (resolvedName = ((UReferenceExpression)operand).getResolvedName()) == null || !StringsKt.contains((CharSequence)resolvedName, (CharSequence)"mask", (boolean)true)) continue;
                        return;
                    }
                }
                for (UExpression operand : ((UPolyadicExpression)argument).getOperands()) {
                    this.checkTypeDefConstant(context, annotation, (UElement)operand, errorNode, true, usageInfo);
                }
            } else {
                UastBinaryOperator operator = ((UPolyadicExpression)argument).getOperator();
                if (operator == UastBinaryOperator.BITWISE_AND || operator == UastBinaryOperator.BITWISE_OR || operator == UastBinaryOperator.BITWISE_XOR) {
                    this.report(context, TYPE_DEF, argument, context.getLocation(argument), "Flag not allowed here");
                }
            }
        } else if (argument instanceof UReferenceExpression) {
            PsiElement resolved = ((UReferenceExpression)argument).resolve();
            if (resolved instanceof PsiVariable) {
                if (((PsiVariable)resolved).getType() instanceof PsiArrayType) {
                    UElement uElement = errorNode;
                    if (uElement == null) {
                        uElement = argument;
                    }
                    this.checkTypeDefConstant(context, annotation, argument, uElement, flag, resolved, usageInfo);
                    return;
                }
                if (((PsiVariable)resolved).hasModifierProperty("static") && ((PsiVariable)resolved).hasModifierProperty("final")) {
                    UElement uElement = errorNode;
                    if (uElement == null) {
                        uElement = argument;
                    }
                    this.checkTypeDefConstant(context, annotation, argument, uElement, flag, resolved, usageInfo);
                } else {
                    UExpression lastAssignment = UastLintUtils.Companion.findLastAssignment((PsiVariable)resolved, argument);
                    if (lastAssignment != null) {
                        UElement uElement = (UElement)lastAssignment;
                        UElement uElement2 = errorNode;
                        if (uElement2 == null) {
                            uElement2 = argument;
                        }
                        this.checkTypeDefConstant(context, annotation, uElement, uElement2, flag, usageInfo);
                    } else if (usageInfo.getType() != AnnotationUsageType.VARIABLE_REFERENCE && usageInfo.getType() != AnnotationUsageType.FIELD_REFERENCE) {
                        boolean bl;
                        block60: {
                            Iterable $this$any$iv = JavaEvaluator.getAnnotations$default((JavaEvaluator)context.getEvaluator(), (PsiModifierListOwner)((PsiModifierListOwner)resolved), (boolean)true, null, (int)4, null);
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    UAnnotation it = (UAnnotation)element$iv;
                                    boolean bl2 = false;
                                    if (!Companion.isAnnotatedWithTypeDef(it)) continue;
                                    bl = true;
                                    break block60;
                                }
                                bl = false;
                            }
                        }
                        if (bl) {
                            UElement uElement = errorNode;
                            if (uElement == null) {
                                uElement = argument;
                            }
                            this.checkTypeDefConstant(context, annotation, argument, uElement, flag, resolved, usageInfo);
                        }
                    }
                }
            } else if (resolved instanceof PsiMethod) {
                UElement uElement = errorNode;
                if (uElement == null) {
                    uElement = argument;
                }
                this.checkTypeDefConstant(context, annotation, argument, uElement, flag, resolved, usageInfo);
            }
        } else if (argument instanceof UCallExpression) {
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument) || UastExpressionUtils.isArrayInitializer((UElement)argument)) {
                PsiType type = ((UCallExpression)argument).getExpressionType();
                if (type != null) {
                    type = type.getDeepComponentType();
                }
                if (Intrinsics.areEqual((Object)PsiTypes.intType(), (Object)type) || Intrinsics.areEqual((Object)PsiTypes.longType(), (Object)type)) {
                    for (UExpression expression : ((UCallExpression)argument).getValueArguments()) {
                        this.checkTypeDefConstant(context, annotation, (UElement)expression, errorNode, flag, usageInfo);
                    }
                }
            } else {
                PsiMethod resolved = ((UCallExpression)argument).resolve();
                if (resolved != null) {
                    UElement uElement = errorNode;
                    if (uElement == null) {
                        uElement = argument;
                    }
                    this.checkTypeDefConstant(context, annotation, argument, uElement, flag, resolved, usageInfo);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeDefConstant(JavaContext context, UAnnotation annotation, UElement argument, UElement errorNode, boolean flag, Object value, AnnotationUsageInfo usageInfo) {
        AnnotationInfo rangeAnnotation2 = usageInfo.findSameScope((Function1)checkTypeDefConstant.rangeAnnotation.1.INSTANCE);
        if (rangeAnnotation2 != null && !(value instanceof PsiField) && RangeDetector.Companion.getIntRangeError(context, rangeAnnotation2.getAnnotation(), argument, usageInfo) == null) {
            return;
        }
        UExpression uExpression = UastLintUtils.Companion.getAnnotationValue(annotation);
        if (uExpression == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null) {
            return;
        }
        UExpression allowed = uExpression;
        if (UastExpressionUtils.isArrayInitializer((UElement)((UElement)allowed))) {
            Object annotations;
            UElement uElement = argument;
            PsiElement resolvedArgument = uElement instanceof UReferenceExpression ? ((UReferenceExpression)argument).resolve() : (uElement instanceof UCallExpression ? (PsiElement)((UCallExpression)argument).resolve() : null);
            UExpression unmatched = null;
            if (resolvedArgument instanceof PsiModifierListOwner) {
                UExpression provided;
                Object paramValues;
                JavaEvaluator evaluator = context.getEvaluator();
                annotations = JavaEvaluator.getAnnotations$default((JavaEvaluator)evaluator, (PsiModifierListOwner)((PsiModifierListOwner)resolvedArgument), (boolean)true, null, (int)4, null);
                boolean hadTypeDef = false;
                for (UAnnotation a : JavaEvaluator.filterRelevantAnnotations$default((JavaEvaluator)evaluator, (List)annotations, (UElement)argument, null, (int)4, null)) {
                    UBinaryExpression condition;
                    UExpression uExpression2;
                    void $this$getParentOfType_u24default$iv;
                    Object equivalentName;
                    String qualifiedName = a.getQualifiedName();
                    if (!AndroidXConstants.INT_DEF_ANNOTATION.isEquals(qualifiedName) && !AndroidXConstants.LONG_DEF_ANNOTATION.isEquals(qualifiedName) && !AndroidXConstants.STRING_DEF_ANNOTATION.isEquals(qualifiedName)) continue;
                    hadTypeDef = true;
                    UExpression uExpression3 = UastLintUtils.Companion.getAnnotationValue(a);
                    paramValues = uExpression3 != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression3) : null;
                    if (paramValues == null) continue;
                    if (Intrinsics.areEqual((Object)paramValues, (Object)allowed)) {
                        return;
                    }
                    provided = this.getResolvedValues((UExpression)paramValues, argument);
                    List<Object> allowedValues = this.getResolvedValues(allowed, argument);
                    for (Object allowedValue : allowedValues) {
                        String fieldName;
                        Object object;
                        if (provided.remove(allowedValue) || !(allowedValue instanceof PsiField) || (object = ((PsiField)allowedValue).getContainingClass()) == null || (object = object.getName()) == null) continue;
                        Object containingClass = object;
                        equivalentName = StringsKt.endsWith$default((String)containingClass, (String)COMPAT_SUFFIX, (boolean)false, (int)2, null) ? StringsKt.removeSuffix((String)containingClass, (CharSequence)COMPAT_SUFFIX) : (String)containingClass + COMPAT_SUFFIX;
                        Intrinsics.checkNotNullExpressionValue((Object)((PsiField)allowedValue).getName(), (String)"getName(...)");
                        provided.removeIf(new Predicate(fieldName, (String)equivalentName, allowedValue){
                            final /* synthetic */ String $fieldName;
                            final /* synthetic */ String $equivalentName;
                            final /* synthetic */ Object $allowedValue;
                            {
                                this.$fieldName = $fieldName;
                                this.$equivalentName = $equivalentName;
                                this.$allowedValue = $allowedValue;
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final boolean test(@NotNull Object it) {
                                Object object;
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                if (!(it instanceof PsiField)) return false;
                                if (!Intrinsics.areEqual((Object)((PsiField)it).getName(), (Object)this.$fieldName)) return false;
                                PsiClass psiClass = ((PsiField)it).getContainingClass();
                                if (!Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getName() : null), (Object)this.$equivalentName)) return false;
                                Object object2 = ((PsiField)it).getContainingClass();
                                if (Intrinsics.areEqual((Object)(object2 != null && (object2 = object2.getQualifiedName()) != null ? Boolean.valueOf(StringsKt.startsWith$default((String)object2, (String)"androidx.", (boolean)false, (int)2, null)) : null), (object = ((PsiField)this.$allowedValue).getContainingClass()) != null && (object = object.getQualifiedName()) != null ? Boolean.valueOf(StringsKt.startsWith$default((String)object, (String)"androidx.", (boolean)false, (int)2, null)) : null)) return false;
                                return true;
                            }
                        });
                    }
                    if (provided.isEmpty()) {
                        return;
                    }
                    if (allowedValues.size() <= provided.size()) continue;
                    unmatched = provided;
                    if (provided.size() != 1) continue;
                    equivalentName = argument;
                    boolean strict$iv = true;
                    boolean $i$f$getParentOfType = false;
                    UIfExpression uIfExpression = (UIfExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UIfExpression.class, (boolean)strict$iv);
                    UExpression uExpression4 = uIfExpression != null && (uExpression2 = uIfExpression.getCondition()) != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression2) : null;
                    UBinaryExpression uBinaryExpression = condition = uExpression4 instanceof UBinaryExpression ? (UBinaryExpression)uExpression4 : null;
                    if (!Intrinsics.areEqual((Object)(uBinaryExpression != null ? uBinaryExpression.getOperator() : null), (Object)UastBinaryOperator.IDENTITY_NOT_EQUALS)) {
                        UBinaryExpression uBinaryExpression2 = condition;
                        if (!Intrinsics.areEqual((Object)(uBinaryExpression2 != null ? uBinaryExpression2.getOperator() : null), (Object)UastBinaryOperator.NOT_EQUALS)) continue;
                    }
                    if (!Intrinsics.areEqual(provided.get(0), (Object)this.getResolvedValue(condition.getRightOperand(), argument))) continue;
                    if (Intrinsics.areEqual((Object)condition.getLeftOperand().asSourceString(), (Object)argument.asSourceString())) {
                        return;
                    }
                    PsiElement psiElement = condition.getLeftOperand().getSourcePsi();
                    PsiElement psiElement2 = argument.getSourcePsi();
                    if (Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getText() : null), (Object)(psiElement2 != null ? psiElement2.getText() : null))) {
                        return;
                    }
                    if (!Intrinsics.areEqual((Object)UastUtils.tryResolve((UElement)((UElement)condition.getLeftOperand())), (Object)value)) continue;
                    return;
                }
                if (!hadTypeDef && resolvedArgument instanceof PsiMethod) {
                    UReturnExpression callArgument;
                    if (TypedefDetector.checkTypeDefConstant$isPrimitiveTypeConvertingMethod((PsiMethod)resolvedArgument) || TypedefDetector.checkTypeDefConstant$isPrimitiveTypeReturningMethod((PsiMethod)resolvedArgument)) {
                        UExpression receiver;
                        UQualifiedReferenceExpression uQualifiedReferenceExpression = argument instanceof UQualifiedReferenceExpression ? (UQualifiedReferenceExpression)argument : null;
                        Object object = receiver = uQualifiedReferenceExpression != null ? uQualifiedReferenceExpression.getReceiver() : null;
                        if (receiver != null) {
                            this.checkTypeDefConstant(context, annotation, (UElement)receiver, errorNode, flag, usageInfo);
                            int parameterCount = ((PsiMethod)resolvedArgument).getParameterList().getParametersCount();
                            if (parameterCount == 1) {
                                paramValues = ((UQualifiedReferenceExpression)argument).getSelector();
                                UCallExpression callExpression = paramValues instanceof UCallExpression ? (UCallExpression)paramValues : null;
                                Object object2 = callExpression;
                                callArgument = object2 != null && (object2 = object2.getValueArguments()) != null ? (UExpression)CollectionsKt.firstOrNull((List)object2) : null;
                                this.checkTypeDefConstant(context, annotation, (UElement)callArgument, errorNode, flag, usageInfo);
                            }
                        }
                        return;
                    }
                    UElement uMethod = UastContextKt.toUElement((PsiElement)resolvedArgument);
                    if (uMethod instanceof UMethod) {
                        UExpression retValue;
                        Object object;
                        UExpression body = ((UMethod)uMethod).getUastBody();
                        if (body instanceof UBlockExpression) {
                            if (((UBlockExpression)body).getExpressions().size() == 1) {
                                provided = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)((UBlockExpression)body).getExpressions().get(0)));
                                UReturnExpression uReturnExpression = callArgument = provided instanceof UReturnExpression ? (UReturnExpression)provided : null;
                                object = callArgument != null ? callArgument.getReturnExpression() : null;
                            } else {
                                object = null;
                            }
                        } else {
                            object = retValue = body;
                        }
                        if (retValue instanceof UReferenceExpression) {
                            PsiElement psiElement = ((UReferenceExpression)retValue).resolve();
                            if (psiElement == null) {
                                return;
                            }
                            PsiElement psiElement3 = psiElement;
                            if (psiElement3 instanceof PsiField) {
                                this.checkTypeDefConstant(context, annotation, (UElement)retValue, errorNode, flag, psiElement3, usageInfo);
                            }
                            return;
                        }
                        if (!(retValue instanceof ULiteralExpression)) {
                            return;
                        }
                    }
                }
            }
            ULiteralExpression uLiteralExpression = argument instanceof ULiteralExpression ? (ULiteralExpression)argument : null;
            annotations = UastUtils.skipParenthesizedExprUp((UElement)(uLiteralExpression != null ? uLiteralExpression.getUastParent() : null));
            UField fieldInitialization = annotations instanceof UField ? (UField)annotations : null;
            UCallExpression initializerExpression = (UCallExpression)allowed;
            List initializers = initializerExpression.getValueArguments();
            PsiElement psiValue = null;
            if (value instanceof PsiElement) {
                psiValue = (PsiElement)value;
            }
            for (UExpression initializer : initializers) {
                PsiElement resolved;
                UExpression expression = UastUtils.skipParenthesizedExprDown((UExpression)initializer);
                if (fieldInitialization != null && expression instanceof UReferenceExpression && (resolved = ((UReferenceExpression)expression).resolve()) != null && resolved.isEquivalentTo((PsiElement)fieldInitialization)) {
                    return;
                }
                if (!(expression instanceof ULiteralExpression ? Intrinsics.areEqual((Object)value, (Object)((ULiteralExpression)expression).getValue()) : psiValue != null && expression instanceof UReferenceExpression && (resolved = ((UReferenceExpression)expression).resolve()) != null && resolved.isEquivalentTo(psiValue))) continue;
                return;
            }
            if (value instanceof PsiField && rangeAnnotation2 == null) {
                UExpression initializer;
                UExpression uExpression5 = UastFacade.INSTANCE.getInitializerBody((PsiVariable)value);
                Object object = initializer = uExpression5 != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression5) : null;
                if (initializer != null && !(initializer instanceof ULiteralExpression) && !(initializer.getSourcePsi() instanceof PsiLiteralExpression)) {
                    this.checkTypeDefConstant(context, annotation, (UElement)initializer, errorNode, flag, usageInfo);
                    return;
                }
            }
            if (allowed instanceof PsiCompiledElement || annotation.getPsi() instanceof PsiCompiledElement) {
                return;
            }
            if (value instanceof PsiVariable && argument instanceof UReferenceExpression && Intrinsics.areEqual((Object)((UReferenceExpression)argument).resolve(), (Object)value) && this.variableIsChecked(argument, (PsiVariable)value)) {
                return;
            }
            this.reportTypeDef(context, argument, errorNode, flag, initializers, usageInfo, annotation, (List<? extends Object>)unmatched);
        }
    }

    private final boolean variableIsChecked(UElement reference, PsiVariable variable) {
        Ref.BooleanRef isChecked;
        block0: {
            UElement $this$getParentOfType_u24default$iv = reference;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            UMethod method = (UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UMethod.class, (boolean)strict$iv);
            isChecked = new Ref.BooleanRef();
            UMethod uMethod = method;
            if (uMethod == null) break block0;
            uMethod.accept((UastVisitor)new AbstractUastVisitor(variable, reference, isChecked){
                private boolean foundStart;
                private boolean foundTarget;
                final /* synthetic */ PsiVariable $variable;
                final /* synthetic */ UElement $reference;
                final /* synthetic */ Ref.BooleanRef $isChecked;
                {
                    this.$variable = $variable;
                    this.$reference = $reference;
                    this.$isChecked = $isChecked;
                }

                public boolean visitVariable(@NotNull UVariable node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (Intrinsics.areEqual((Object)node.getJavaPsi(), (Object)this.$variable)) {
                        this.foundStart = true;
                    }
                    return super.visitVariable(node);
                }

                public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    PsiElement resolved;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (Intrinsics.areEqual((Object)node, (Object)this.$reference)) {
                        this.foundTarget = true;
                    } else if (this.foundStart && !this.foundTarget && Intrinsics.areEqual((Object)(resolved = node.resolve()), (Object)this.$variable)) {
                        UElement parent = node.getUastParent();
                        if (parent instanceof UBinaryExpression && UastExpressionUtils.isAssignment((UElement)parent) && Intrinsics.areEqual((Object)((UBinaryExpression)parent).getLeftOperand(), (Object)node)) {
                            this.$isChecked.element = true;
                        } else {
                            UElement prev = (UElement)node;
                            while (parent != null) {
                                if (parent instanceof UIfExpression) {
                                    if (Intrinsics.areEqual((Object)prev, (Object)((UIfExpression)parent).getCondition())) {
                                        this.$isChecked.element = true;
                                        break;
                                    }
                                } else if (parent instanceof USwitchExpression && Intrinsics.areEqual((Object)prev, (Object)((USwitchExpression)parent).getExpression())) {
                                    this.$isChecked.element = true;
                                    break;
                                }
                                prev = parent;
                                if (parent.getUastParent() == null) break;
                            }
                        }
                    }
                    return super.visitSimpleNameReferenceExpression(node);
                }
            });
        }
        return isChecked.element;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Object> getResolvedValues(UExpression allowed, UElement context) {
        if (UastExpressionUtils.isArrayInitializer((UElement)((UElement)allowed))) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNull((Object)allowed, (String)"null cannot be cast to non-null type org.jetbrains.uast.UCallExpression");
            UCallExpression initializerExpression = (UCallExpression)allowed;
            List initializers = initializerExpression.getValueArguments();
            Iterable $this$mapNotNull$iv = initializers;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                UExpression it = (UExpression)element$iv$iv;
                boolean bl2 = false;
                if (this.getResolvedValue(it, context) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        }
        return new ArrayList();
    }

    private final Object getResolvedValue(UExpression expression, UElement context) {
        UExpression uExpression = expression;
        return uExpression instanceof ULiteralExpression ? ((ULiteralExpression)expression).getValue() : (uExpression instanceof UReferenceExpression ? ((UReferenceExpression)expression).resolve() : (uExpression instanceof UParenthesizedExpression ? this.getResolvedValue(((UParenthesizedExpression)expression).getExpression(), context) : null));
    }

    private final Object getLiteralValue(UElement $this$getLiteralValue) {
        if ($this$getLiteralValue instanceof ULiteralExpression || $this$getLiteralValue instanceof UPrefixExpression && ((UPrefixExpression)$this$getLiteralValue).getOperand() instanceof ULiteralExpression) {
            return ((UExpression)$this$getLiteralValue).evaluate();
        }
        return null;
    }

    private final void reportTypeDef(JavaContext context, UAnnotation annotation, UElement argument, UElement errorNode, AnnotationUsageInfo usageInfo) {
        UExpression allowed;
        UExpression uExpression = UastLintUtils.Companion.getAnnotationValue(annotation);
        Object object = allowed = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
        if (allowed != null && UastExpressionUtils.isArrayInitializer((UElement)((UElement)allowed))) {
            UCallExpression initializerExpression = (UCallExpression)allowed;
            List initializers = initializerExpression.getValueArguments();
            Object value = this.getLiteralValue(argument);
            if (value instanceof Number) {
                boolean bl;
                block6: {
                    Iterable $this$any$iv = initializers;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            UExpression it = (UExpression)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)value, (Object)this.getLiteralValue((UElement)it))) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return;
                }
            }
            this.reportTypeDef(context, argument, errorNode, false, initializers, usageInfo, annotation, null);
        }
    }

    private final void reportTypeDef(JavaContext context, UElement node, UElement errorNode, boolean flag, List<? extends UExpression> allowedValues, AnnotationUsageInfo usageInfo, UAnnotation annotation, List<? extends Object> unmatched) {
        UElement uElement;
        String rangeError;
        PsiElement psiElement;
        PsiField psiField;
        String message2;
        UVariable declaration;
        if (UastLintUtils.Companion.isZero(node) && (declaration = (UVariable)UastUtils.getParentOfType((UElement)node, UVariable.class, (boolean)true)) != null) {
            UExpression uExpression = declaration.getUastInitializer();
            if (Intrinsics.areEqual((Object)node, (Object)(uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null))) {
                return;
            }
        }
        if (Intrinsics.areEqual((Object)UastLintUtils.Companion.getAnnotationBooleanValue(annotation, ATTR_OPEN), (Object)true)) {
            return;
        }
        String values = this.listAllowedValues(node, allowedValues);
        String string = message2 = flag ? "Must be one or more of: " + values : "Must be one of: " + values;
        if (Intrinsics.areEqual((Object)values, (Object)"RecyclerView.HORIZONTAL, RecyclerView.VERTICAL") && errorNode instanceof UResolvable && Intrinsics.areEqual((Object)((psiField = (psiElement = ((UResolvable)errorNode).resolve()) instanceof PsiField ? (PsiField)psiElement : null) != null && (psiField = psiField.getContainingClass()) != null ? psiField.getName() : null), (Object)"LinearLayoutManager")) {
            return;
        }
        if (StringsKt.startsWith$default((String)values, (String)"MediaMetadataCompat.METADATA_KEY_", (boolean)false, (int)2, null)) {
            return;
        }
        AnnotationInfo rangeAnnotation2 = usageInfo.findSameScope((Function1)reportTypeDef.rangeAnnotation.1.INSTANCE);
        if (rangeAnnotation2 != null && (rangeError = RangeDetector.Companion.getIntRangeError(context, rangeAnnotation2.getAnnotation(), node, usageInfo)) != null && ((CharSequence)rangeError).length() > 0) {
            char c = Character.toLowerCase(rangeError.charAt(0));
            String string2 = rangeError.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            message2 = message2 + " or " + c + string2;
        }
        if (unmatched != null && !((Collection)unmatched).isEmpty()) {
            message2 = message2 + ", but could be " + this.listAllowedValues(node, unmatched);
        }
        if ((uElement = errorNode) == null) {
            uElement = node;
        }
        UElement locationNode = uElement;
        LintFix fix = this.createQuickFix(locationNode, allowedValues, node);
        this.report(context, TYPE_DEF, locationNode, context.getLocation(locationNode), message2, fix);
    }

    private final LintFix createQuickFix(UElement node, List<? extends UExpression> values, UElement context) {
        Object object;
        Object currentValue = null;
        if (node instanceof ULiteralExpression) {
            currentValue = ((ULiteralExpression)node).getValue();
        } else if (node instanceof UReferenceExpression) {
            object = ((UReferenceExpression)node).resolve();
            PsiField psiField = object instanceof PsiField ? (PsiField)object : null;
            if (psiField == null) {
                return null;
            }
            PsiField field = psiField;
            if (field.hasModifierProperty("final") && field.hasModifierProperty("static")) {
                currentValue = field.computeConstantValue();
            } else {
                return null;
            }
        }
        List fixes = new ArrayList();
        boolean foundCurrent = false;
        for (UExpression uExpression : values) {
            String qualifiedName;
            String containingClassName;
            PsiClass containingClass;
            PsiElement resolved = null;
            if (uExpression instanceof UReferenceExpression) {
                resolved = ((UReferenceExpression)uExpression).resolve();
            }
            if (!(resolved instanceof PsiField) || ((PsiField)resolved).getContainingClass() == null || containingClass.getName() == null || containingClass.getQualifiedName() == null) continue;
            String shortName = containingClassName + "." + ((PsiField)resolved).getName();
            String fullName = qualifiedName + "." + ((PsiField)resolved).getName();
            boolean current = !foundCurrent && Intrinsics.areEqual((Object)uExpression.evaluate(), (Object)currentValue);
            LintFix fix = this.fix().name("Change to " + shortName + (String)(current ? " (" + currentValue + ")" : "")).replace().all().with(fullName).shortenNames().build();
            if (current) {
                fixes.add(0, fix);
                foundCurrent = true;
                continue;
            }
            if (values.size() > 8) continue;
            fixes.add(fix);
        }
        if (!((Collection)fixes).isEmpty()) {
            Collection collection = fixes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = collection;
            object = thisCollection$iv.toArray(new LintFix[0]);
            return this.fix().alternatives((LintFix[])Arrays.copyOf(object, ((Object)object).length));
        }
        return null;
    }

    private final String listAllowedValues(UElement context, List<? extends Object> allowedValues) {
        StringBuilder sb = new StringBuilder();
        for (Object object : allowedValues) {
            Object s = null;
            PsiElement resolved = null;
            Object object2 = object;
            if (object2 instanceof UReferenceExpression) {
                resolved = ((UReferenceExpression)object).resolve();
            } else if (object2 instanceof PsiField) {
                resolved = (PsiElement)object;
            }
            if (resolved instanceof PsiField) {
                Object object3 = ((PsiField)resolved).getContainingClass();
                if (object3 == null || (object3 = object3.getName()) == null) continue;
                Object containingClassName = object3;
                s = (String)containingClassName + "." + ((PsiField)resolved).getName();
            }
            if (s == null) {
                Object object4;
                object2 = object;
                if (object2 instanceof UElement) {
                    object4 = ((UElement)object).asSourceString();
                } else if (object2 instanceof String) {
                    char c = '\"';
                    String string = (String)object;
                    object4 = c + string + "\"";
                } else {
                    object4 = s = object.toString();
                }
            }
            if (((CharSequence)sb).length() > 0) {
                sb.append(", ");
            }
            sb.append((String)s);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public boolean sameMessage(@NotNull Issue issue, @NotNull String string, @NotNull String old) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)string, (String)"new");
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        int oldListStart = StringsKt.indexOf$default((CharSequence)old, (String)": ", (int)0, (boolean)false, (int)6, null);
        int newListStart = StringsKt.indexOf$default((CharSequence)string, (String)": ", (int)0, (boolean)false, (int)6, null);
        if (oldListStart != newListStart || !StringsKt.regionMatches$default((String)string, (int)0, (String)old, (int)0, (int)newListStart, (boolean)false, (int)16, null)) {
            return false;
        }
        String string2 = old.substring(oldListStart + 2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String[] stringArray = new String[]{", "};
        List oldList = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string3 = string.substring(oldListStart + 2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String[] stringArray2 = new String[]{", "};
        List newList = StringsKt.split$default((CharSequence)string3, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        int j = 0;
        for (String element : oldList) {
            String newConstant;
            String oldConstant = ((Object)StringsKt.trim((CharSequence)element)).toString();
            if (j == newList.size()) {
                return false;
            }
            while (j < newList.size() && !Intrinsics.areEqual((Object)oldConstant, (Object)(newConstant = ((Object)StringsKt.trim((CharSequence)((String)newList.get(j++)))).toString()))) {
            }
        }
        return true;
    }

    private static final boolean checkTypeDefConstant$isPrimitiveTypeMethod(PsiMethod $this$checkTypeDefConstant_u24isPrimitiveTypeMethod, int paramCount, Function1<? super String, Boolean> nameFilter) {
        if ($this$checkTypeDefConstant_u24isPrimitiveTypeMethod.getReturnType() != null && !($this$checkTypeDefConstant_u24isPrimitiveTypeMethod.getReturnType() instanceof PsiPrimitiveType)) {
            return false;
        }
        if ($this$checkTypeDefConstant_u24isPrimitiveTypeMethod.getParameterList().getParametersCount() > paramCount) {
            return false;
        }
        String string = $this$checkTypeDefConstant_u24isPrimitiveTypeMethod.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return (Boolean)nameFilter.invoke((Object)string);
    }

    private static final boolean checkTypeDefConstant$isPrimitiveTypeConvertingMethod(PsiMethod $this$checkTypeDefConstant_u24isPrimitiveTypeConvertingMethod) {
        return TypedefDetector.checkTypeDefConstant$isPrimitiveTypeMethod($this$checkTypeDefConstant_u24isPrimitiveTypeConvertingMethod, 0, (Function1<? super String, Boolean>)((Function1)checkTypeDefConstant.isPrimitiveTypeConvertingMethod.1.INSTANCE));
    }

    private static final boolean checkTypeDefConstant$isPrimitiveTypeReturningMethod(PsiMethod $this$checkTypeDefConstant_u24isPrimitiveTypeReturningMethod) {
        return TypedefDetector.checkTypeDefConstant$isPrimitiveTypeMethod($this$checkTypeDefConstant_u24isPrimitiveTypeReturningMethod, 1, (Function1<? super String, Boolean>)((Function1)checkTypeDefConstant.isPrimitiveTypeReturningMethod.1.INSTANCE));
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        TYPE_DEF = Issue.Companion.create$default((Issue.Companion)companion, (String)"WrongConstant", (String)"Incorrect constant", (String)"\n                Ensures that when parameter in a method only allows a specific set of \\\n                constants, calls obey those rules.", (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0010\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/TypedefDetector$Companion;", "", "()V", "ATTR_OPEN", "", "COMPAT_SUFFIX", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "TYPE_DEF", "Lcom/android/tools/lint/detector/api/Issue;", "findTypeDef", "Lorg/jetbrains/uast/UAnnotation;", "annotations", "", "isAnnotatedWithTypeDef", "", "annotation", "isTypeDef", "qualifiedName", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nTypedefDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypedefDetector.kt\ncom/android/tools/lint/checks/TypedefDetector$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,994:1\n12474#2,2:995\n*S KotlinDebug\n*F\n+ 1 TypedefDetector.kt\ncom/android/tools/lint/checks/TypedefDetector$Companion\n*L\n977#1:995,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isTypeDef(@Nullable String qualifiedName) {
            if (qualifiedName == null) {
                return false;
            }
            if (AndroidXConstants.INT_DEF_ANNOTATION.isEquals(qualifiedName) || AndroidXConstants.LONG_DEF_ANNOTATION.isEquals(qualifiedName) || AndroidXConstants.STRING_DEF_ANNOTATION.isEquals(qualifiedName)) {
                return true;
            }
            if (AndroidPlatformAnnotations.Companion.isPlatformAnnotation(qualifiedName)) {
                return this.isTypeDef(AndroidPlatformAnnotations.Companion.toAndroidxAnnotation(qualifiedName));
            }
            return false;
        }

        public final boolean isAnnotatedWithTypeDef(@NotNull UAnnotation annotation) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            PsiAnnotation[] psiAnnotationArray = annotation.resolve();
            if (psiAnnotationArray != null && (psiAnnotationArray = psiAnnotationArray.getAnnotations()) != null) {
                boolean bl2;
                block4: {
                    PsiAnnotation[] $this$any$iv = psiAnnotationArray;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        PsiAnnotation element$iv;
                        PsiAnnotation resolvedAnnotation = element$iv = $this$any$iv[i];
                        boolean bl3 = false;
                        String string = resolvedAnnotation.getQualifiedName();
                        if (string == null) {
                            string = "";
                        }
                        String string2 = string;
                        Intrinsics.checkNotNull((Object)string2);
                        String qualifiedName = string2;
                        if (!Companion.isTypeDef(qualifiedName)) continue;
                        bl2 = true;
                        break block4;
                    }
                    bl2 = false;
                }
                bl = bl2;
            } else {
                bl = false;
            }
            return bl;
        }

        @Nullable
        public final UAnnotation findTypeDef(@NotNull List<? extends UAnnotation> annotations) {
            Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
            for (UAnnotation uAnnotation : annotations) {
                if (!this.isTypeDef(uAnnotation.getQualifiedName())) continue;
                return uAnnotation;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

