/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.AndroidXConstants;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/SplashScreenDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UClass;", "isActivityOrFragment", "", "cls", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nSplashScreenDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplashScreenDetector.kt\ncom/android/tools/lint/checks/SplashScreenDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1747#2,3:92\n*S KotlinDebug\n*F\n+ 1 SplashScreenDetector.kt\ncom/android/tools/lint/checks/SplashScreenDetector\n*L\n62#1:92,3\n*E\n"})
public final class SplashScreenDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> SPLASH_SCREEN_KEYWORDS;
    @NotNull
    private static final List<String> PROHIBITED_SUPERCLASSES;
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<Class<UClass>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UClass.class);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ SplashScreenDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void visitClass(@NotNull UClass node) {
                boolean bl;
                block7: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Iterable $this$any$iv = SplashScreenDetector.access$getSPLASH_SCREEN_KEYWORDS$cp();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            boolean bl2;
                            String string;
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            String string2 = string = node.getName();
                            if (string2 != null) {
                                Intrinsics.checkNotNull((Object)string2);
                                bl2 = StringsKt.contains((CharSequence)string, (CharSequence)it, (boolean)true);
                            } else {
                                bl2 = false;
                            }
                            if (!bl2) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (bl && SplashScreenDetector.access$isActivityOrFragment(this.this$0, this.$context, node)) {
                    if (node.getSourcePsi() == null) {
                        return;
                    }
                    Incident incident = new Incident(SplashScreenDetector.ISSUE, this.$context.getNameLocation(node), "The application should not provide its own launch screen");
                    this.$context.report(incident, Constraints.targetSdkAtLeast((int)31));
                }
            }
        };
    }

    private final boolean isActivityOrFragment(JavaContext context, UClass cls) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = PROHIBITED_SUPERCLASSES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    JavaEvaluator javaEvaluator = context.getEvaluator();
                    PsiClass psiClass = (PsiClass)cls;
                    Intrinsics.checkNotNull((Object)it);
                    if (!JavaEvaluator.extendsClass$default((JavaEvaluator)javaEvaluator, (PsiClass)psiClass, (String)it, (boolean)false, (int)4, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ List access$getSPLASH_SCREEN_KEYWORDS$cp() {
        return SPLASH_SCREEN_KEYWORDS;
    }

    public static final /* synthetic */ boolean access$isActivityOrFragment(SplashScreenDetector $this, JavaContext context, UClass cls) {
        return $this.isActivityOrFragment(context, cls);
    }

    static {
        String[] stringArray = new String[]{"SplashScreen", "SplashActivity", "LaunchActivity", "LaunchScreen"};
        SPLASH_SCREEN_KEYWORDS = CollectionsKt.listOf((Object[])stringArray);
        stringArray = new String[]{"android.app.Activity", AndroidXConstants.CLASS_V4_FRAGMENT.oldName(), AndroidXConstants.CLASS_V4_FRAGMENT.newName(), "android.view.View"};
        PROHIBITED_SUPERCLASSES = CollectionsKt.listOf((Object[])stringArray);
        stringArray = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(SplashScreenDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)stringArray, (String)"CustomSplashScreen", (String)"Application-defined Launch Screen", (String)"\n                Starting in Android 12 (API 31+), the application's Launch Screen is provided by \\\n                the system and the application should not create its own, otherwise the user will \\\n                see two splashscreens. Please check the `SplashScreen` class to check how the \\\n                Splash Screen can be controlled and customized.\n            ", (Implementation)implementation, null, (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null).addMoreInfo("https://developer.android.com/guide/topics/ui/splash-screen");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/SplashScreenDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "PROHIBITED_SUPERCLASSES", "", "", "kotlin.jvm.PlatformType", "SPLASH_SCREEN_KEYWORDS", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

