/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.WrongCommentTypeDetector;
import com.android.tools.lint.checks.WrongCommentTypeDetectorKt;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.tree.IElementType;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/WrongCommentTypeDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "sameMessage", "", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "new", "", "old", "Issues", "lint-checks"})
public final class WrongCommentTypeDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(WrongCommentTypeDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("WrongCommentType", "Wrong Comment Type", "\n          This check flags any block comments which look like they had been intended to \\\n          be KDoc or javadoc comments instead.\n\n          If you really want to use Javadoc-like constructs in a block comment, \\\n          there's a convention you can use: include `(non-Javadoc)` somewhere in \\\n          the comment, e.g.\n          ```\n            /* (non-Javadoc)\n             * @see org.xml.sax.helpers.DefaultHandler#setDocumentLocator(org.xml.sax.Locator)\n             */\n            @Override\n            public void setDocumentLocator(Locator locator) {\n          ```\n          (see https://stackoverflow.com/questions/5172841/non-javadoc-meaning)\n          ", Category.CORRECTNESS, 9, Severity.WARNING, IMPLEMENTATION);

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{UMethod.class, UClass.class, UField.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(context, this){
            @NotNull
            private final Set<PsiElement> seen;
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ WrongCommentTypeDetector this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
                this.seen = new LinkedHashSet<E>();
            }

            private final PsiElement findComment(PsiElement source) {
                PsiElement begin;
                PsiElement psiElement;
                PsiElement psiElement2 = source;
                if (psiElement2 instanceof PsiModifierListOwner) {
                    psiElement = (PsiElement)((PsiModifierListOwner)source).getModifierList();
                } else if (psiElement2 instanceof KtParameter) {
                    KtModifierList ktModifierList = ((KtParameter)source).getModifierList();
                    psiElement = (PsiElement)(ktModifierList == null ? (KtElementImplStub)source : (KtElementImplStub)ktModifierList);
                } else if (psiElement2 instanceof KtModifierListOwner) {
                    if (((KtModifierListOwner)source).getFirstChild() instanceof PsiComment) {
                        return ((KtModifierListOwner)source).getFirstChild();
                    }
                    psiElement = (PsiElement)((KtModifierListOwner)source);
                } else {
                    return null;
                }
                if ((begin = psiElement) == null) {
                    return null;
                }
                PsiElement curr = this.prev(begin);
                while (curr != null) {
                    PsiElement psiElement3 = curr;
                    if (psiElement3 instanceof PsiComment) {
                        return curr;
                    }
                    if (psiElement3 instanceof PsiWhiteSpace) {
                        curr = this.prev(curr);
                        continue;
                    }
                    return null;
                }
                return null;
            }

            private final boolean isPrivate(UElement element) {
                boolean bl;
                PsiElement source = element.getSourcePsi();
                if (source instanceof PsiModifierListOwner) {
                    bl = this.$context.getEvaluator().isPrivate((PsiModifierListOwner)source);
                } else if (source instanceof KtModifierListOwner) {
                    KtModifierList ktModifierList = ((KtModifierListOwner)source).getModifierList();
                    bl = ktModifierList != null ? ktModifierList.hasModifier(KtTokens.PRIVATE_KEYWORD) : false;
                } else {
                    bl = false;
                }
                return bl;
            }

            private final void checkComment(UElement element) {
                PsiElement psiElement = element.getSourcePsi();
                if (psiElement == null) {
                    return;
                }
                PsiElement source = psiElement;
                if (!this.seen.add(source)) {
                    return;
                }
                if (this.isPrivate(element)) {
                    return;
                }
                PsiElement psiElement2 = this.findComment(source);
                if (psiElement2 == null) {
                    return;
                }
                PsiElement comment = psiElement2;
                if (comment instanceof PsiDocComment || comment instanceof KDoc) {
                    return;
                }
                String text = comment.getText();
                Intrinsics.checkNotNull((Object)text);
                if (!StringsKt.startsWith$default((String)text, (String)"/*", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text, (String)"/**", (boolean)false, (int)2, null)) {
                    return;
                }
                if (StringsKt.contains$default((CharSequence)text, (CharSequence)"(non-Javadoc)", (boolean)false, (int)2, null)) {
                    return;
                }
                PsiElement psiElement3 = this.getFirstTag(comment, text);
                if (psiElement3 == null) {
                    return;
                }
                PsiElement tag = psiElement3;
                String commentType = Lint.isKotlin((Language)this.getLanguage(element)) ? "KDoc" : "javadoc";
                String string = tag.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String tagText = StringsKt.substringBefore$default((String)string, (String)"\n", null, (int)2, null);
                int delta = StringsKt.indexOf$default((CharSequence)text, (String)tagText, (int)0, (boolean)false, (int)6, null);
                Location location = delta != -1 ? this.$context.getRangeLocation(comment, delta, tagText.length()) : this.$context.getLocation(comment);
                this.$context.report(WrongCommentTypeDetector.ISSUE, comment, location, "This block comment looks like it was intended to be a " + commentType + " comment", WrongCommentTypeDetector.access$fix(this.this$0).replace().text("/*").with("/**").range(this.$context.getLocation(comment)).autoFix().build());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final PsiElement getFirstTag(PsiElement node, String comment) {
                if (!StringsKt.contains$default((CharSequence)comment, (CharSequence)"@", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)comment, (CharSequence)"[", (boolean)false, (int)2, null)) {
                    return null;
                }
                String[] stringArray = new String[]{"\n"};
                String content2 = "/**\n" + CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)StringsKt.removeSurrounding((String)comment, (CharSequence)"/*", (CharSequence)"*/"), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"\n", null, null, (int)0, null, (Function1)createUastHandler.getFirstTag.content.1.INSTANCE, (int)30, null) + "*/";
                try {
                    Object object;
                    Language language = node.getLanguage();
                    Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                    if (Lint.isKotlin((Language)language)) {
                        Project project = node.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        KDoc docComment = WrongCommentTypeDetectorKt.createKDocFromText(project, content2);
                        block7: for (KDocSection section : docComment.getAllSections()) {
                            if (section.getFirstChild() == null) {
                                return null;
                            }
                            PsiElement curr;
                            PsiElement tag;
                            while (!((tag = curr) instanceof KDocTag) || !this.isValidTagName(((KDocTag)tag).getName())) {
                                if (tag instanceof LeafPsiElement) {
                                    IElementType type;
                                    Intrinsics.checkNotNullExpressionValue((Object)((LeafPsiElement)tag).getElementType(), (String)"getElementType(...)");
                                    if (Intrinsics.areEqual((Object)type, (Object)KDocTokens.MARKDOWN_INLINE_LINK)) {
                                        return tag;
                                    }
                                }
                                if (curr.getNextSibling() == null) continue block7;
                            }
                            return tag;
                        }
                        return null;
                    }
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)node.getProject());
                    PsiDocComment psiDocComment = factory.createDocCommentFromText(content2);
                    Intrinsics.checkNotNullExpressionValue((Object)psiDocComment, (String)"createDocCommentFromText(...)");
                    PsiDocComment docComment = psiDocComment;
                    PsiElement[] psiElementArray = docComment.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                    PsiElement[] section = psiElementArray;
                    int n = section.length;
                    block9: for (int curr = 0; curr < n; ++curr) {
                        String name;
                        PsiElement child = section[curr];
                        if (!(child instanceof PsiInlineDocTag)) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)((PsiInlineDocTag)child).getName(), (String)"getName(...)");
                        switch (name.hashCode()) {
                            case -1034119619: {
                                if (name.equals("inheritDoc")) return child;
                                continue block9;
                            }
                            case 3321850: {
                                if (name.equals("link")) return child;
                                continue block9;
                            }
                            case -1608837616: {
                                if (!name.equals("linkplain")) continue block9;
                                return child;
                            }
                        }
                    }
                    PsiDocTag[] psiDocTagArray = docComment.getTags();
                    Intrinsics.checkNotNullExpressionValue((Object)psiDocTagArray, (String)"getTags(...)");
                    Object[] $this$firstOrNull$iv = psiDocTagArray;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiDocTag it = (PsiDocTag)element$iv;
                        boolean bl = false;
                        if (!this.isValidTagName(it.getName())) continue;
                        object = element$iv;
                        return (PsiElement)object;
                    }
                    object = null;
                    return (PsiElement)object;
                }
                catch (Throwable ignore) {
                    if (!LintClient.Companion.isUnitTest()) return null;
                    throw ignore;
                }
            }

            private final boolean isValidTagName(String name) {
                if (name == null) {
                    return false;
                }
                return Character.isLowerCase(name.charAt(0));
            }

            private final PsiElement prev(PsiElement $this$prev) {
                Object object = $this$prev.getPrevSibling();
                if (object == null) {
                    PsiElement psiElement = $this$prev.getParent();
                    object = psiElement != null ? this.prev(psiElement) : null;
                }
                return object;
            }

            private final Language getLanguage(UElement $this$getLanguage) {
                while (true) {
                    Language language;
                    Object object;
                    if ((object = $this$getLanguage.getSourcePsi()) != null && (language = object.getLanguage()) != null) {
                        Language it = language;
                        boolean bl = false;
                        return it;
                    }
                    object = this_;
                    Intrinsics.checkNotNull((Object)$this$getLanguage.getUastParent());
                    createUastHandler.1 this_ = object;
                    $this$getLanguage = language;
                }
            }

            public void visitClass(@NotNull UClass node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.checkComment((UElement)node);
            }

            public void visitMethod(@NotNull UMethod node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.checkComment((UElement)node);
            }

            public void visitField(@NotNull UField node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.checkComment((UElement)node);
            }
        };
    }

    public boolean sameMessage(@NotNull Issue issue, @NotNull String string, @NotNull String old) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)string, (String)"new");
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        return true;
    }

    public static final /* synthetic */ LintFix.Builder access$fix(WrongCommentTypeDetector $this) {
        return $this.fix();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/WrongCommentTypeDetector$Issues;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

