/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.AndroidPatternMatcher;
import com.android.tools.lint.checks.AppLinksValidDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.CharSequences;
import com.android.utils.DomExtensions;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 =2\u00020\u00012\u00020\u0002:\u0002=>B\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J>\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0002J$\u0010\u0019\u001a\u0004\u0018\u00010\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\rH\u0002J \u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0007J \u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0!H\u0016J\"\u0010\"\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0010\u0010%\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0010\u0010&\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0010\u0010'\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\rH\u0002J(\u0010(\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\tH\u0002J4\u0010.\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\t2\n\b\u0002\u0010/\u001a\u0004\u0018\u000100H\u0002J4\u00101\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\t2\n\b\u0002\u0010/\u001a\u0004\u0018\u000100H\u0002J$\u00102\u001a\u00020$2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010\tH\u0002J \u00106\u001a\u00020$2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\tH\u0016J0\u0010;\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\tH\u0002J\u0018\u0010<\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\rH\u0016\u00a8\u0006?"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "addAttribute", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "attributeName", "", "existing", "", "data", "Lorg/w3c/dom/Element;", "checkActivity", "element", "checkActivityIntentFiltersAndGetUriInfos", "", "Lcom/android/tools/lint/checks/AppLinksValidDetector$UriInfo;", "activity", "checkAndAddPathMatcher", "matcher", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$Path;", "intentFilter", "parent", "checkAndGetAttributeValue", "checkIntentFilter", "checkTestUrlMatchesAtLeastOneInfo", "testUrl", "Ljava/net/URL;", "infos", "ensureExported", "getApplicableElements", "", "handleIntentFilterInActivity", "hasActionView", "", "hasCategoryDefault", "isAutoVerify", "isBrowsable", "reportTestUrlFailure", "node", "Lorg/w3c/dom/Node;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "reportUrlError", "quickfixData", "Lcom/android/tools/lint/detector/api/LintFix;", "reportUrlWarning", "requireNonEmpty", "attribute", "Lorg/w3c/dom/Attr;", "value", "sameMessage", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "new", "old", "validateAttribute", "visitElement", "Companion", "UriInfo", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nAppLinksValidDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,1574:1\n1755#2,3:1575\n1734#2,3:1578\n1010#2,2:1581\n360#2,7:1583\n360#2,7:1590\n1567#2:1597\n1598#2,3:1598\n1601#2:1602\n1863#2,2:1603\n1734#2,3:1605\n1734#2,3:1608\n1557#2:1613\n1628#2,3:1614\n1#3:1601\n1251#4,2:1611\n*S KotlinDebug\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector\n*L\n129#1:1575,3\n137#1:1578,3\n153#1:1581,2\n158#1:1583,7\n159#1:1590,7\n185#1:1597\n185#1:1598,3\n185#1:1602\n211#1:1603,2\n464#1:1605,3\n654#1:1608,3\n945#1:1613\n945#1:1614,3\n739#1:1611,2\n*E\n"})
public final class AppLinksValidDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ACTION_VIEW = "android.intent.action.VIEW";
    @NotNull
    public static final String CATEGORY_BROWSABLE = "android.intent.category.BROWSABLE";
    @NotNull
    public static final String CATEGORY_DEFAULT = "android.intent.category.DEFAULT";
    @NotNull
    private static final List<String> PATH_ATTRIBUTES;
    @NotNull
    private static final String HTTP = "http";
    @NotNull
    private static final String HTTPS = "https";
    private static final int DEFAULT_INDENT_AMOUNT = 4;
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue TEST_URL;
    @JvmField
    @NotNull
    public static final Issue VALIDATION;
    @JvmField
    @NotNull
    public static final Issue APP_LINK_WARNING;
    @NotNull
    private static final Issue _OLD_ISSUE_URL;
    @JvmField
    @NotNull
    public static final Issue INTENT_FILTER_UNIQUE_DATA_ATTRIBUTES;
    @JvmField
    @NotNull
    public static final Issue APP_LINK_SPLIT_TO_WEB_AND_CUSTOM;
    @NotNull
    private static final String TAG_VALIDATION = "validation";
    @NotNull
    public static final String KEY_SHOW_APP_LINKS_ASSISTANT = "SHOW_APP_LINKS_ASSISTANT";
    @NotNull
    private static final List<String> INTENT_FILTER_DATA_SORT_REFERENCE;

    @NotNull
    public Collection<String> getApplicableElements() {
        Object[] objectArray = new String[]{"activity", "activity-alias", "intent-filter"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String tag = element.getTagName();
        if (tag == null) throw new IllegalStateException(("Unhandled tag " + tag).toString());
        int n = -1;
        switch (tag.hashCode()) {
            case -1655966961: {
                if (tag.equals("activity")) {
                    n = 1;
                }
                break;
            }
            case -1029793847: {
                if (tag.equals("intent-filter")) {
                    n = 2;
                }
                break;
            }
            case 790287890: {
                if (tag.equals("activity-alias")) {
                    n = 1;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                this.checkIntentFilter(context, element);
                return;
            }
            case 1: {
                this.checkActivity(context, element);
                return;
            }
            default: {
                throw new IllegalStateException(("Unhandled tag " + tag).toString());
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkIntentFilter(XmlContext context, Element intentFilter) {
        dataTag = null;
        v0 = XmlUtils.getFirstSubTagByName((Node)intentFilter, (String)"data");
        if (v0 == null) {
            return;
        }
        dataTag = v0;
        if (XmlUtils.getNextTagByName((Node)dataTag, (String)"data") == null) {
            return;
        }
        incidents = new ArrayList<E>();
        dataTagCount = 0;
        do {
            block32: {
                block31: {
                    block35: {
                        ++dataTagCount;
                        v1 = dataTag;
                        Intrinsics.checkNotNull((Object)v1);
                        length = v1.getAttributes().getLength();
                        attributes = new ArrayList<E>();
                        for (attributeIndex = 0; attributeIndex < length; ++attributeIndex) {
                            attribute = dataTag.getAttributes().item(attributeIndex);
                            if (Intrinsics.areEqual((Object)attribute.getNamespaceURI(), (Object)"http://schemas.android.com/tools")) continue;
                            ((Collection)attributes).add(attribute);
                        }
                        $this$any$iv = attributes;
                        $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block35;
                        v2 = false;
                        break block31;
                    }
                    for (Object element$iv : $this$any$iv) {
                        it = (Node)element$iv;
                        $i$a$-any-AppLinksValidDetector$checkIntentFilter$hasNonPath$1 = false;
                        if (!Intrinsics.areEqual((Object)it.getNamespaceURI(), (Object)"http://schemas.android.com/apk/res/android")) ** GOTO lbl-1000
                        v3 = it.getLocalName();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getLocalName(...)");
                        if (!StringsKt.startsWith$default((String)v3, (String)"path", (boolean)false, (int)2, null)) lbl-1000:
                        // 2 sources

                        {
                            v4 = true;
                        } else {
                            v4 = false;
                        }
                        if (!v4) continue;
                        v2 = true;
                        break block31;
                    }
                    v2 = hasNonPath = false;
                }
                if (!hasNonPath) ** GOTO lbl-1000
                $this$all$iv = attributes;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v5 = true;
                } else {
                    element$iv = $this$all$iv.iterator();
                    while (element$iv.hasNext()) {
                        element$iv = element$iv.next();
                        it = (Node)element$iv;
                        $i$a$-all-AppLinksValidDetector$checkIntentFilter$hasOnlyHostAndPort$1 = false;
                        if (Intrinsics.areEqual((Object)it.getNamespaceURI(), (Object)"http://schemas.android.com/apk/res/android") != false && (Intrinsics.areEqual((Object)it.getLocalName(), (Object)"host") != false || Intrinsics.areEqual((Object)it.getLocalName(), (Object)"port") != false)) continue;
                        v5 = false;
                        break block32;
                    }
                    v5 = true;
                }
            }
            if (v5) {
                v6 = true;
            } else lbl-1000:
            // 2 sources

            {
                v6 = hasOnlyHostAndPort = false;
            }
            if (!hasNonPath || hasOnlyHostAndPort) {
                --dataTagCount;
            } else if (attributes.size() > 1) {
                block34: {
                    block33: {
                        $this$sortBy$iv = attributes;
                        $i$f$sortBy = false;
                        if ($this$sortBy$iv.size() > 1) {
                            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                                public final int compare(T a, T b) {
                                    Node it = (Node)a;
                                    boolean bl = false;
                                    Integer n = AppLinksValidDetector.access$getINTENT_FILTER_DATA_SORT_REFERENCE$cp().indexOf(it.getLocalName());
                                    int it2 = ((Number)n).intValue();
                                    boolean bl2 = false;
                                    Integer n2 = it2 >= 0 ? n : null;
                                    it = (Node)b;
                                    Comparable comparable = Integer.valueOf(n2 != null ? n2 : Integer.MAX_VALUE);
                                    bl = false;
                                    n = AppLinksValidDetector.access$getINTENT_FILTER_DATA_SORT_REFERENCE$cp().indexOf(it.getLocalName());
                                    it2 = ((Number)n).intValue();
                                    bl2 = false;
                                    Integer n3 = it2 >= 0 ? n : null;
                                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(n3 != null ? n3 : Integer.MAX_VALUE));
                                }
                            });
                        }
                        if ((v7 = intentFilter.lookupPrefix("http://schemas.android.com/apk/res/android")) == null) {
                            v7 = "android";
                        }
                        namespace = v7;
                        $this$indexOfFirst$iv = attributes;
                        $i$f$indexOfFirst = false;
                        index$iv = 0;
                        for (Object item$iv : $this$indexOfFirst$iv) {
                            it = (Node)item$iv;
                            $i$a$-indexOfFirst-AppLinksValidDetector$checkIntentFilter$hostIndex$1 = false;
                            if (Intrinsics.areEqual((Object)it.getLocalName(), (Object)"host")) {
                                v8 = index$iv;
                                break block33;
                            }
                            ++index$iv;
                        }
                        v8 = -1;
                    }
                    hostIndex = v8;
                    $this$indexOfFirst$iv = attributes;
                    $i$f$indexOfFirst = false;
                    index$iv = 0;
                    item$iv = $this$indexOfFirst$iv.iterator();
                    while (item$iv.hasNext()) {
                        item$iv /* !! */  = item$iv.next();
                        it = (Node)item$iv /* !! */ ;
                        $i$a$-indexOfFirst-AppLinksValidDetector$checkIntentFilter$portIndex$1 = false;
                        if (Intrinsics.areEqual((Object)it.getLocalName(), (Object)"port")) {
                            v9 = index$iv;
                            break block34;
                        }
                        ++index$iv;
                    }
                    v9 = portIndex = -1;
                }
                if (hostIndex >= 0 && portIndex >= 0) {
                    host = null;
                    port = null;
                    if (hostIndex > portIndex) {
                        host = (Node)attributes.remove(hostIndex);
                        port = (Node)attributes.remove(portIndex);
                    } else {
                        port = (Node)attributes.remove(portIndex);
                        host = (Node)attributes.remove(hostIndex);
                    }
                    v10 = "<data " + namespace + ":" + host.getLocalName() + "=\"" + host.getNodeValue() + "\" " + namespace + ":" + port.getLocalName() + "=\"" + port.getNodeValue() + "\"/>\n";
                } else {
                    v10 = null;
                }
                firstLine = v10;
                location = context.getLocation(dataTag);
                v11 = location.getStart();
                indent = CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)0, (int)(v11 != null ? v11.getColumn() : 4))), (CharSequence)"", null, null, (int)0, null, (Function1)checkIntentFilter.indent.1.INSTANCE, (int)30, null);
                v12 = firstLine;
                if (v12 == null) {
                    v12 = "";
                }
                item$iv /* !! */  = attributes;
                var33_59 = v12;
                $i$f$mapIndexed = false;
                $i$a$-indexOfFirst-AppLinksValidDetector$checkIntentFilter$portIndex$1 = $this$mapIndexed$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                $i$f$mapIndexedTo = false;
                index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    if ((var25_51 = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    var26_52 = (Node)item$iv$iv;
                    var27_53 = var25_51;
                    var34_60 = destination$iv$iv;
                    $i$a$-mapIndexed-AppLinksValidDetector$checkIntentFilter$newText$1 = false;
                    it = var29_55 = indent;
                    $i$a$-takeIf-AppLinksValidDetector$checkIntentFilter$newText$1$lineIndent$1 = false;
                    v13 = (index > 0 || firstLine != null) != false ? var29_55 : null;
                    if (v13 == null) {
                        v13 = "";
                    }
                    lineIndent = v13;
                    var34_60.add(lineIndent + "<data " + namespace + ":" + it.getLocalName() + "=\"" + it.getNodeValue() + "\"/>");
                }
                newText = (String)var33_59 + CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                ((Collection)incidents).add(new Incident(AppLinksValidDetector.INTENT_FILTER_UNIQUE_DATA_ATTRIBUTES, "Consider splitting data tag into multiple tags with individual attributes to avoid confusion", location, (Object)dataTag, LintFix.Companion.create().replace().with(newText).autoFix().build()));
            }
            $this$checkIntentFilter_u24lambda_u248 = this;
            $i$a$-run-AppLinksValidDetector$checkIntentFilter$2 = false;
            dataTag = XmlUtils.getNextTagByName((Node)dataTag, (String)"data");
        } while (dataTag != null);
        if (dataTagCount > 1) {
            $this$forEach$iv = incidents;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                p0 = (Incident)element$iv;
                $i$f$checkIntentFilter$stub_for_inlining = false;
                $i$a$-forEach-AppLinksValidDetector$checkIntentFilter$3 = false;
                context.report(p0);
            }
        }
    }

    private final void checkActivity(XmlContext context, Element element) {
        List<UriInfo> infos = this.checkActivityIntentFiltersAndGetUriInfos(element, context);
        Element current = XmlUtils.getFirstSubTagByName((Node)element, (String)TAG_VALIDATION);
        while (current != null) {
            if (Intrinsics.areEqual((Object)"http://schemas.android.com/tools", (Object)current.getNamespaceURI())) {
                Attr testUrlAttr = current.getAttributeNode("testUrl");
                if (testUrlAttr == null) {
                    String message2 = "Expected `testUrl` attribute";
                    AppLinksValidDetector.reportUrlError$default(this, context, current, context.getLocation((Node)current), message2, null, 16, null);
                } else {
                    String testUrlString = testUrlAttr.getValue();
                    try {
                        URL testUrl = new URL(testUrlString);
                        String reason = this.checkTestUrlMatchesAtLeastOneInfo(testUrl, infos);
                        if (reason != null) {
                            this.reportTestUrlFailure(context, testUrlAttr, context.getValueLocation(testUrlAttr), reason);
                        }
                    }
                    catch (MalformedURLException e) {
                        String message3 = "Invalid test URL: " + e.getLocalizedMessage();
                        this.reportTestUrlFailure(context, testUrlAttr, context.getValueLocation(testUrlAttr), message3);
                    }
                }
            } else {
                this.reportTestUrlFailure(context, current, context.getNameLocation((Node)current), "Validation nodes should be in the `tools:` namespace to ensure they are removed from the manifest at build time");
            }
            current = XmlUtils.getNextTagByName((Node)current, (String)TAG_VALIDATION);
        }
    }

    private final void reportUrlError(XmlContext context, Node node, Location location, String message2, LintFix quickfixData) {
        if (context.getDriver().isSuppressed(context, _OLD_ISSUE_URL, node)) {
            return;
        }
        context.report(VALIDATION, node, location, message2, quickfixData);
    }

    static /* synthetic */ void reportUrlError$default(AppLinksValidDetector appLinksValidDetector, XmlContext xmlContext, Node node, Location location, String string, LintFix lintFix, int n, Object object) {
        if ((n & 0x10) != 0) {
            lintFix = null;
        }
        appLinksValidDetector.reportUrlError(xmlContext, node, location, string, lintFix);
    }

    private final void reportUrlWarning(XmlContext context, Node node, Location location, String message2, LintFix quickfixData) {
        context.report(APP_LINK_WARNING, node, location, message2, quickfixData);
    }

    static /* synthetic */ void reportUrlWarning$default(AppLinksValidDetector appLinksValidDetector, XmlContext xmlContext, Node node, Location location, String string, LintFix lintFix, int n, Object object) {
        if ((n & 0x10) != 0) {
            lintFix = null;
        }
        appLinksValidDetector.reportUrlWarning(xmlContext, node, location, string, lintFix);
    }

    private final void reportTestUrlFailure(XmlContext context, Node node, Location location, String message2) {
        XmlContext.report$default((XmlContext)context, (Issue)TEST_URL, (Node)node, (Location)location, (String)message2, null, (int)16, null);
    }

    @VisibleForTesting
    @NotNull
    public final List<UriInfo> checkActivityIntentFiltersAndGetUriInfos(@NotNull Element activity, @NotNull XmlContext context) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Element intent = XmlUtils.getFirstSubTagByName((Node)activity, (String)"intent-filter");
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
        List infos = arrayList;
        while (intent != null) {
            if (this.handleIntentFilterInActivity(context, intent, activity) != null) {
                UriInfo it;
                boolean bl = false;
                infos.add(it);
            }
            intent = XmlUtils.getNextTagByName((Node)intent, (String)"intent-filter");
        }
        return infos;
    }

    @VisibleForTesting
    @Nullable
    public final String checkTestUrlMatchesAtLeastOneInfo(@NotNull URL testUrl, @NotNull List<UriInfo> infos) {
        Intrinsics.checkNotNullParameter((Object)testUrl, (String)"testUrl");
        Intrinsics.checkNotNullParameter(infos, (String)"infos");
        List reasons = new ArrayList();
        for (UriInfo info : infos) {
            String reason;
            if (info.match(testUrl) == null) {
                return null;
            }
            if (reasons.contains(reason)) continue;
            reasons.add(reason);
        }
        return !((Collection)reasons).isEmpty() ? "Test URL " + Joiner.on((String)" or ").join((Iterable)reasons) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final UriInfo handleIntentFilterInActivity(XmlContext context, Element intentFilter, Element activity) {
        boolean showMissingUriCheck;
        boolean showMissingSchemeCheck;
        Companion.IntentFilterData intentFilterData;
        Object scheme2;
        boolean actionView = this.hasActionView(intentFilter);
        if (actionView) {
            this.ensureExported(context, activity, intentFilter);
        }
        Element firstData = XmlUtils.getFirstSubTagByName((Node)intentFilter, (String)"data");
        boolean browsable = this.isBrowsable(intentFilter);
        if (firstData == null) {
            if (actionView && browsable) {
                AppLinksValidDetector.reportUrlError$default(this, context, intentFilter, context.getLocation((Node)intentFilter), "Missing data element", null, 16, null);
            }
            return null;
        }
        Set schemes = new LinkedHashSet();
        Set hostPortPairs = new LinkedHashSet();
        Set paths2 = new LinkedHashSet();
        boolean hasMimeType = false;
        Element data = firstData;
        while (data != null) {
            Attr mimeType = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "mimeType");
            if (mimeType != null) {
                hasMimeType = true;
                String mimeTypeValue = mimeType.getValue();
                Project project = context.getProject();
                Intrinsics.checkNotNull((Object)mimeTypeValue);
                String resolved = Lint.resolvePlaceHolders((Project)project, (String)mimeTypeValue, null, (String)"");
                if (CharSequences.containsUpperCase((CharSequence)resolved)) {
                    Object message2 = "Mime-type matching is case sensitive and should only use lower-case characters";
                    if (!CharSequences.containsUpperCase((CharSequence)Lint.resolvePlaceHolders(null, (String)mimeTypeValue, null, (String)""))) {
                        message2 = (String)message2 + " (without placeholders, value is `" + resolved + "`)";
                    }
                    AppLinksValidDetector.reportUrlError$default(this, context, mimeType, context.getValueLocation(mimeType), (String)message2, null, 16, null);
                }
            }
            this.addAttribute(context, "scheme", schemes, data);
            String host = this.checkAndGetAttributeValue(context, "host", data);
            String port = this.checkAndGetAttributeValue(context, "port", data);
            if (host != null) {
                hostPortPairs.add(new Pair((Object)host, (Object)port));
            }
            this.checkAndAddPathMatcher(context, "path", paths2, data, intentFilter, intentFilter);
            this.checkAndAddPathMatcher(context, "pathPrefix", paths2, data, intentFilter, intentFilter);
            this.checkAndAddPathMatcher(context, "pathPattern", paths2, data, intentFilter, intentFilter);
            this.checkAndAddPathMatcher(context, "pathAdvancedPattern", paths2, data, intentFilter, intentFilter);
            this.checkAndAddPathMatcher(context, "pathSuffix", paths2, data, intentFilter, intentFilter);
            data = XmlUtils.getNextTagByName((Node)data, (String)"data");
        }
        boolean isHttp = false;
        boolean implicitSchemes = false;
        boolean hasSubstitutedScheme = false;
        if (schemes.isEmpty()) {
            if (hasMimeType) {
                schemes.add("content");
                schemes.add("file");
                implicitSchemes = true;
            }
        } else {
            for (Object scheme2 : schemes) {
                if (Intrinsics.areEqual((Object)HTTP, (Object)scheme2) || Intrinsics.areEqual((Object)HTTPS, (Object)scheme2)) {
                    isHttp = true;
                    continue;
                }
                if (!AppLinksValidDetector.Companion.isSubstituted((String)scheme2)) continue;
                hasSubstitutedScheme = true;
            }
        }
        boolean hasExplicitScheme = !((Collection)schemes).isEmpty() && !implicitSchemes;
        scheme2 = intentFilter.getAttributeNS("http://schemas.android.com/apk/res/android", "autoVerify");
        if ((scheme2 == null || StringsKt.isBlank((CharSequence)scheme2)) && !((Collection)schemes).isEmpty()) {
            boolean bl;
            block29: {
                void $this$all$iv;
                scheme2 = schemes;
                Companion companion = Companion;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String p0 = (String)element$iv;
                        boolean $i$f$handleIntentFilterInActivity$stub_for_inlining$10 = false;
                        boolean bl2 = false;
                        if (companion.isWebScheme(p0)) continue;
                        bl = false;
                        break block29;
                    }
                    bl = true;
                }
            }
            if (bl && !((Collection)hostPortPairs).isEmpty() && actionView && browsable && this.hasCategoryDefault(intentFilter)) {
                this.reportUrlWarning(context, intentFilter, context.getNameLocation((Node)intentFilter), "This intent filter has the format of an Android App Link but is \\\nmissing the `autoVerify` attribute; add `android:autoVerify=\"true\"` \\\nto ensure your domain will be validated and enable App Link-related \\\nLint warnings. If you do not want clicked URLs to bring the user to \\\nyour app, remove the `android.intent.category.BROWSABLE` category, or \\\nset `android:autoVerify=\"false\"` to make it clear this is not intended \\\nto be an Android App Link.", this.fix().set("http://schemas.android.com/apk/res/android", "autoVerify", "true").build());
            }
        }
        if (Companion.hasAutoVerifyButInvalidAppLink(intentFilterData = Companion.getIntentFilterData(new Companion.ElementWrapper(intentFilter, context))) && !AppLinksValidDetector.Companion.hasElementsRequiredForAppLinks(intentFilterData)) {
            LintFix lintFix;
            if (LintClient.Companion.isStudio()) {
                Object[] $i$f$all = new Object[]{KEY_SHOW_APP_LINKS_ASSISTANT, true};
                lintFix = this.fix().data($i$f$all);
            } else {
                lintFix = null;
            }
            LintFix fix = lintFix;
            this.reportUrlError(context, intentFilter, context.getLocation((Node)intentFilter), "Missing required elements/attributes for Android App Links", fix);
        }
        boolean bl = !hasExplicitScheme && (!((Collection)paths2).isEmpty() || !((Collection)hostPortPairs).isEmpty()) ? true : (showMissingSchemeCheck = false);
        if (showMissingSchemeCheck) {
            LintFix.SetAttributeBuilder fix = hostPortPairs.isEmpty() ? LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)this.fix().set(), (String)"http://schemas.android.com/apk/res/android", (String)"scheme", null, null, (int)12, null) : LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)this.fix().set(), (String)"http://schemas.android.com/apk/res/android", (String)"scheme", (String)HTTP, null, (int)8, null);
            this.reportUrlError(context, firstData, context.getLocation((Node)firstData), "At least one `scheme` must be specified", fix.build());
        }
        boolean bl3 = showMissingUriCheck = schemes.isEmpty() && actionView;
        if (!showMissingSchemeCheck && showMissingUriCheck) {
            LintFix[] lintFixArray = new LintFix[]{LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)this.fix().set(), (String)"http://schemas.android.com/apk/res/android", (String)"scheme", null, null, (int)12, null).build(), LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)this.fix().set(), (String)"http://schemas.android.com/apk/res/android", (String)"mimeType", null, null, (int)12, null).build()};
            this.reportUrlError(context, firstData, context.getLocation((Node)firstData), "VIEW actions require a URI", this.fix().alternatives(lintFixArray));
        }
        if (!((Collection)paths2).isEmpty()) {
            boolean bl4;
            block30: {
                Iterable $this$all$iv = hostPortPairs;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl4 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Pair pair = (Pair)element$iv;
                        boolean bl5 = false;
                        String host = (String)pair.component1();
                        CharSequence charSequence = host;
                        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                        bl4 = false;
                        break block30;
                    }
                    bl4 = true;
                }
            }
            if (bl4) {
                LintFix fix = LintFix.SetAttributeBuilder.todo$default((LintFix.SetAttributeBuilder)LintFix.Companion.create().set(), (String)"http://schemas.android.com/apk/res/android", (String)"host", null, null, (int)12, null).build();
                this.reportUrlError(context, firstData, context.getLocation((Node)firstData), "At least one `host` must be specified", fix);
            }
        }
        if (actionView && isHttp && !browsable) {
            AppLinksValidDetector.reportUrlError$default(this, context, intentFilter, context.getLocation((Node)intentFilter), "Activity supporting ACTION_VIEW is not set as BROWSABLE", null, 16, null);
        }
        return new UriInfo(schemes, hostPortPairs, paths2);
    }

    private final void ensureExported(XmlContext context, Element activity, Element intentFilter) {
        Attr attr = activity.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "exported");
        if (attr == null) {
            return;
        }
        Attr exported = attr;
        if (Intrinsics.areEqual((Object)"true", (Object)exported.getValue())) {
            return;
        }
        Element prevIntent = XmlUtils.getPreviousTagByName((Node)intentFilter, (String)"intent-filter");
        while (prevIntent != null) {
            if (this.hasActionView(prevIntent)) {
                return;
            }
            prevIntent = XmlUtils.getNextTagByName((Node)prevIntent, (String)"intent-filter");
        }
        AppLinksValidDetector.reportUrlError$default(this, context, activity, context.getLocation((Node)activity), "Activity supporting ACTION_VIEW is not exported", null, 16, null);
    }

    private final boolean hasActionView(Element intentFilter) {
        for (Element action : XmlUtils.getSubTagsByName((Node)intentFilter, (String)"action")) {
            Attr attr;
            if (!action.hasAttributeNS("http://schemas.android.com/apk/res/android", "name") || !Intrinsics.areEqual((Object)(attr = action.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")).getValue(), (Object)ACTION_VIEW)) continue;
            return true;
        }
        return false;
    }

    private final boolean isBrowsable(Element intentFilter) {
        for (Element e : XmlUtils.getSubTagsByName((Node)intentFilter, (String)"category")) {
            Attr attr;
            if (!e.hasAttributeNS("http://schemas.android.com/apk/res/android", "name") || !Intrinsics.areEqual((Object)(attr = e.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name")).getNodeValue(), (Object)CATEGORY_BROWSABLE)) continue;
            return true;
        }
        return false;
    }

    private final boolean isAutoVerify(Element intentFilter) {
        return Intrinsics.areEqual((Object)intentFilter.getAttributeNS("http://schemas.android.com/apk/res/android", "autoVerify"), (Object)"true");
    }

    private final boolean hasCategoryDefault(Element intentFilter) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.asSequence((Iterator)DomExtensions.iterator((Element)intentFilter));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Element it = (Element)element$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it.getTagName(), (Object)"category") && Intrinsics.areEqual((Object)it.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)CATEGORY_DEFAULT))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final String checkAndGetAttributeValue(XmlContext context, String attributeName, Element data) {
        block8: {
            String string;
            String value;
            Attr attribute;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            attribute = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
                            if (attribute == null) break block8;
                            value = attribute.getValue();
                            if (this.requireNonEmpty(context, attribute, value)) {
                                return null;
                            }
                            string = value;
                            Intrinsics.checkNotNull((Object)string);
                            if (StringsKt.startsWith$default((String)string, (String)"@", (boolean)false, (int)2, null)) break block9;
                            string = value;
                            Intrinsics.checkNotNull((Object)string);
                            if (!StringsKt.startsWith$default((String)string, (String)"?", (boolean)false, (int)2, null)) break block10;
                        }
                        string = value;
                        Intrinsics.checkNotNull((Object)string);
                        value = AppLinksValidDetector.Companion.replaceUrlWithValue(context, string);
                    }
                    string = value;
                    Intrinsics.checkNotNull((Object)string);
                    if (AppLinksValidDetector.Companion.isSubstituted(string)) break block11;
                    string = value;
                    Intrinsics.checkNotNull((Object)string);
                    if (StringsKt.startsWith$default((String)string, (String)"@", (boolean)false, (int)2, null)) break block11;
                    string = value;
                    Intrinsics.checkNotNull((Object)string);
                    if (!StringsKt.startsWith$default((String)string, (String)"?", (boolean)false, (int)2, null)) break block12;
                }
                return value;
            }
            if (context != null) {
                string = value;
                Intrinsics.checkNotNull((Object)string);
                this.validateAttribute(context, attributeName, data, attribute, string);
            }
            return value;
        }
        return null;
    }

    private final void addAttribute(XmlContext context, String attributeName, Set<String> existing, Element data) {
        block0: {
            String string = this.checkAndGetAttributeValue(context, attributeName, data);
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            existing.add(it);
        }
    }

    private final void validateAttribute(XmlContext context, String attributeName, Element data, Attr attribute, String value) {
        switch (attributeName) {
            case "scheme": {
                if (StringsKt.endsWith$default((String)value, (String)":", (boolean)false, (int)2, null)) {
                    AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "Don't include trailing colon in the `scheme` declaration", null, 16, null);
                    break;
                }
                if (!CharSequences.containsUpperCase((CharSequence)value)) break;
                AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "Scheme matching is case sensitive and should only use lower-case characters", null, 16, null);
                break;
            }
            case "host": {
                if (StringsKt.lastIndexOf$default((CharSequence)value, (char)'*', (int)0, (boolean)false, (int)6, null) > 0) {
                    AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "The host wildcard (`*`) can only be the first character", null, 16, null);
                    break;
                }
                if (!CharSequences.containsUpperCase((CharSequence)value)) break;
                AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "Host matching is case sensitive and should only use lower-case characters", null, 16, null);
                break;
            }
            case "port": {
                try {
                    int port = Integer.parseInt(value);
                    if (port < 1 || port > 65535) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "not a valid port number", null, 16, null);
                }
                if (data.hasAttributeNS("http://schemas.android.com/apk/res/android", "host")) break;
                AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "The port must be specified in the same `<data>` element as the `host`", null, 16, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAndAddPathMatcher(XmlContext context, String attributeName, Set<Companion.Path> matcher, Element data, Element intentFilter, Element parent) {
        block18: {
            Object[] value;
            Attr attribute;
            block20: {
                Object[] objectArray;
                block19: {
                    attribute = data.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
                    if (attribute == null) break block18;
                    value = attribute.getValue();
                    if (this.requireNonEmpty(context, attribute, (String)value)) {
                        return;
                    }
                    objectArray = value;
                    Intrinsics.checkNotNull((Object)objectArray);
                    if (StringsKt.startsWith$default((String)objectArray, (String)"@", (boolean)false, (int)2, null)) break block19;
                    objectArray = value;
                    Intrinsics.checkNotNull((Object)objectArray);
                    if (!StringsKt.startsWith$default((String)objectArray, (String)"?", (boolean)false, (int)2, null)) break block20;
                }
                objectArray = value;
                Intrinsics.checkNotNull((Object)objectArray);
                value = AppLinksValidDetector.Companion.replaceUrlWithValue(context, (String)objectArray);
            }
            Object[] objectArray = value;
            Intrinsics.checkNotNull((Object)objectArray);
            Companion.Path currentMatcher = new Companion.Path((String)objectArray, attributeName);
            matcher.add(currentMatcher);
            objectArray = value;
            Intrinsics.checkNotNull((Object)objectArray);
            if (!AppLinksValidDetector.Companion.isSubstituted((String)objectArray)) {
                objectArray = value;
                Intrinsics.checkNotNull((Object)objectArray);
                if (!StringsKt.startsWith$default((String)objectArray, (String)"@", (boolean)false, (int)2, null)) {
                    Object[] fix;
                    objectArray = value;
                    Intrinsics.checkNotNull((Object)objectArray);
                    if (!StringsKt.startsWith$default((String)objectArray, (String)"/", (boolean)false, (int)2, null) && SetsKt.setOf((Object[])(objectArray = new String[]{"path", "pathPrefix"})).contains(attributeName)) {
                        fix = LintFix.Companion.create().replace().text(attribute.getValue()).with("/" + (String)value).build();
                        this.reportUrlError(context, attribute, context.getValueLocation(attribute), "`" + attribute.getName() + "` attribute should start with `/`, but it is `" + (String)value + "`", (LintFix)fix);
                    }
                    fix = value;
                    Intrinsics.checkNotNull((Object)fix);
                    if (!StringsKt.startsWith$default((String)fix, (String)"/", (boolean)false, (int)2, null)) {
                        fix = value;
                        Intrinsics.checkNotNull((Object)fix);
                        if (!StringsKt.startsWith$default((String)fix, (String)".*", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)attributeName, (Object)"pathPattern")) {
                            AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), "`" + attribute.getName() + "` attribute should start with `/` or `.*`, but it is `" + (String)value + "`", null, 16, null);
                        }
                    }
                    if (this.isAutoVerify(intentFilter)) {
                        Object[] objectArray2 = value;
                        Intrinsics.checkNotNull((Object)objectArray2);
                        CharSequence charSequence = (CharSequence)objectArray2;
                        objectArray2 = new char[1];
                        objectArray2[0] = (LintFix)63;
                        Object[] it = StringsKt.split$default((CharSequence)charSequence, (char[])objectArray2, (boolean)false, (int)0, (int)6, null);
                        boolean bl = false;
                        objectArray2 = new char[1];
                        objectArray2[0] = 38;
                        Set queryParameters2 = SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)StringsKt.splitToSequence$default((CharSequence)StringsKt.substringBefore$default((String)(it.size() == 2 ? (String)it.get(1) : ""), (char)'#', null, (int)2, null), (char[])objectArray2, (boolean)false, (int)0, (int)6, null), (Function1)checkAndAddPathMatcher.queryParameters.2.INSTANCE));
                        it = value;
                        Intrinsics.checkNotNull((Object)it);
                        CharSequence charSequence2 = (CharSequence)it;
                        it = new char[1];
                        it[0] = 35;
                        List it2 = StringsKt.split$default((CharSequence)charSequence2, (char[])it, (boolean)false, (int)0, (int)6, null);
                        boolean bl2 = false;
                        String fragmentInUri = StringsKt.substringBefore$default((String)(it2.size() == 2 ? (String)it2.get(1) : ""), (char)'?', null, (int)2, null);
                        if (!((Collection)queryParameters2).isEmpty() || !StringsKt.isBlank((CharSequence)fragmentInUri)) {
                            String string;
                            void $this$mapTo$iv$iv;
                            String string2 = intentFilter.lookupPrefix("http://schemas.android.com/apk/res/android");
                            if (string2 == null) {
                                string2 = "android";
                            }
                            String namespace = string2;
                            Iterable $this$map$iv = CollectionsKt.sorted((Iterable)queryParameters2);
                            boolean $i$f$map22 = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void it3;
                                String string3 = (String)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl3 = false;
                                collection.add("<data " + namespace + ":query=\"" + (String)it3 + "\" />");
                            }
                            List queries = (List)destination$iv$iv;
                            Object[] $i$f$map22 = value;
                            Intrinsics.checkNotNull((Object)$i$f$map22);
                            CharSequence charSequence3 = (CharSequence)$i$f$map22;
                            $i$f$map22 = new char[2];
                            $i$f$map22[0] = 63;
                            $i$f$map22[1] = 35;
                            String pathBeforeQueryAndFragment = (String)StringsKt.split$default((CharSequence)charSequence3, (char[])$i$f$map22, (boolean)false, (int)0, (int)6, null).get(0);
                            Position position = context.getLocation((Node)data).getStart();
                            int dataIndent = position != null ? position.getColumn() : 4;
                            String string4 = parent.getTagName();
                            if (Intrinsics.areEqual((Object)string4, (Object)"uri-relative-filter-group")) {
                                String newLineAndDataIndent2 = "\n" + CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)0, (int)dataIndent)), (CharSequence)"", null, null, (int)0, null, (Function1)checkAndAddPathMatcher.fixText.newLineAndDataIndent.1.INSTANCE, (int)30, null);
                                String newLineAndIndentedFragment = Intrinsics.areEqual((Object)fragmentInUri, (Object)"") ? "" : newLineAndDataIndent2 + "<data " + namespace + ":fragment=\"" + fragmentInUri + "\" />";
                                string = "<data " + namespace + ":" + attributeName + "=" + pathBeforeQueryAndFragment + " />" + AppLinksValidDetector.Companion.concatenateWithIndent(queries, newLineAndDataIndent2) + newLineAndIndentedFragment;
                            } else if (Intrinsics.areEqual((Object)string4, (Object)"intent-filter")) {
                                Position position2 = context.getLocation((Node)parent).getStart();
                                int parentIndent = position2 != null ? position2.getColumn() : 0;
                                String startingIndent2 = CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)0, (int)dataIndent)), (CharSequence)"", null, null, (int)0, null, (Function1)checkAndAddPathMatcher.fixText.startingIndent.1.INSTANCE, (int)30, null);
                                int innerIndentAmount = 2 * dataIndent - parentIndent;
                                String newLineAndInnerIndent2 = "\n" + CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)0, (int)innerIndentAmount)), (CharSequence)"", null, null, (int)0, null, (Function1)checkAndAddPathMatcher.fixText.newLineAndInnerIndent.1.INSTANCE, (int)30, null);
                                String newLineAndIndentedFragment = Intrinsics.areEqual((Object)fragmentInUri, (Object)"") ? "" : newLineAndInnerIndent2 + "<data " + namespace + ":fragment=\"" + fragmentInUri + "\" />";
                                string = "<uri-relative-filter-group>" + newLineAndInnerIndent2 + "<data " + namespace + ":" + attributeName + "=\"" + pathBeforeQueryAndFragment + "\" />" + AppLinksValidDetector.Companion.concatenateWithIndent(queries, newLineAndInnerIndent2) + newLineAndIndentedFragment + "\n" + startingIndent2 + "</uri-relative-filter-group>";
                            } else {
                                string = null;
                            }
                            String fixText2 = string;
                            this.reportUrlError(context, data, context.getLocation((Node)data), "App link matching does not support query parameters or fragments, unless using `<uri-relative-filter-group>` (introduced in Android 15)", context.getProject().getBuildSdk() < 35 || context.getProject().getTargetSdk() < 35 || fixText2 == null ? null : this.fix().replace().with(fixText2).build());
                        }
                    }
                    objectArray = value;
                    Intrinsics.checkNotNull((Object)objectArray);
                    if (StringsKt.contains$default((CharSequence)((CharSequence)objectArray), (CharSequence)"?", (boolean)false, (int)2, null) && SetsKt.setOf((Object[])(objectArray = new String[]{"pathPattern", "pathAdvancedPattern"})).contains(attributeName)) {
                        AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getValueLocation(attribute), attributeName + " does not support `?` as a Regex character", null, 16, null);
                    }
                }
            }
        }
    }

    private final boolean requireNonEmpty(XmlContext context, Attr attribute, String value) {
        CharSequence charSequence;
        if (context != null && ((charSequence = (CharSequence)value) == null || charSequence.length() == 0)) {
            AppLinksValidDetector.reportUrlError$default(this, context, attribute, context.getLocation((Node)attribute), "`" + attribute.getName() + "` cannot be empty", null, 16, null);
            return true;
        }
        return false;
    }

    public boolean sameMessage(@NotNull Issue issue, @NotNull String string, @NotNull String old) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)string, (String)"new");
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        if (Intrinsics.areEqual((Object)issue, (Object)VALIDATION) && Intrinsics.areEqual((Object)old, (Object)"Missing URL") && Intrinsics.areEqual((Object)string, (Object)"VIEW actions require a URI")) {
            return true;
        }
        return super.sameMessage(issue, string, old);
    }

    public static final /* synthetic */ List access$getINTENT_FILTER_DATA_SORT_REFERENCE$cp() {
        return INTENT_FILTER_DATA_SORT_REFERENCE;
    }

    static {
        Object[] objectArray = new String[]{"path", "pathPrefix", "pathPattern", "pathAdvancedPattern", "pathSuffix"};
        PATH_ATTRIBUTES = CollectionsKt.listOf((Object[])objectArray);
        IMPLEMENTATION = new Implementation(AppLinksValidDetector.class, Scope.MANIFEST_SCOPE);
        TEST_URL = Issue.Companion.create("TestAppLink", "Unmatched URLs", "\n                Using one or more `tools:validation testUrl=\"some url\"/>` elements in your manifest allows \\\n                the link attributes in your intent filter to be checked for matches.\n                ", Category.CORRECTNESS, 5, Severity.FATAL, IMPLEMENTATION);
        objectArray = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        VALIDATION = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"AppLinkUrlError", (String)"URI invalid", (String)"\n                Ensure your intent filter has the documented elements for deep links, web links, or Android \\\n                App Links.", (Implementation)implementation, (String)"https://developer.android.com/training/app-links", (Category)category, (int)5, (Severity)severity, (boolean)false, null, null, null, (int)3840, null).addMoreInfo("https://g.co/AppIndexing/AndroidStudio");
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        APP_LINK_WARNING = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"AppLinkWarning", (String)"App Link warning", (String)"From Android 12, intent filters that use the HTTP and HTTPS schemes will no longer \\\n              bring the user to your app when the user clicks a link, unless the intent filter is \\\n              an Android App Link. Such intent filters must include certain elements, and at least \\\n              one Android App Link for each domain must have `android:autoVerify=\"true\"` to verify \\\n              ownership of the domain. We recommend adding `android:autoVerify=\"true\"` to any intent \\\n              filter that is intended to be an App Link, in case the other App Links are modified.", (Implementation)implementation, (String)"https://developer.android.com/training/app-links", (Category)category, (int)5, (Severity)severity, (boolean)false, null, null, null, (int)3840, null).addMoreInfo("https://g.co/AppIndexing/AndroidStudio");
        _OLD_ISSUE_URL = Issue.Companion.create("GoogleAppIndexingUrlError", "?", "?", Category.USABILITY, 5, Severity.ERROR, IMPLEMENTATION);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        INTENT_FILTER_UNIQUE_DATA_ATTRIBUTES = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"IntentFilterUniqueDataAttributes", (String)"Data tags should only declare unique attributes", (String)"\n                `<intent-filter>` `<data>` tags should only declare a single unique attribute \\\n                (i.e. scheme OR host, but not both). This better matches the runtime behavior of \\\n                intent filters, as they combine all of the declared data attributes into a single \\\n                matcher which is allowed to handle any combination across attribute types.\n\n                For example, the following two `<intent-filter>` declarations are the same:\n                ```xml\n                <intent-filter>\n                    <data android:scheme=\"http\" android:host=\"example.com\" />\n                    <data android:scheme=\"https\" android:host=\"example.org\" />\n                </intent-filter>\n                ```\n\n                ```xml\n                <intent-filter>\n                    <data android:scheme=\"http\"/>\n                    <data android:scheme=\"https\"/>\n                    <data android:host=\"example.com\" />\n                    <data android:host=\"example.org\" />\n                </intent-filter>\n                ```\n\n                They both handle all of the following:\n                * http://example.com\n                * https://example.com\n                * http://example.org\n                * https://example.org\n\n                The second one better communicates the combining behavior and is clearer to an \\\n                external reader that one should not rely on the scheme/host being self contained. \\\n                It is not obvious in the first that http://example.org is also matched, which can \\\n                lead to confusion (or incorrect behavior) with a more complex set of schemes/hosts.\n\n                Note that this does not apply to host + port, as those must be declared in the same \\\n                `<data>` tag and are only associated with each other.\n                ", (Implementation)implementation, (String)"https://developer.android.com/guide/components/intents-filters", (Category)category, (int)0, (Severity)severity, (boolean)false, null, null, null, (int)3904, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        APP_LINK_SPLIT_TO_WEB_AND_CUSTOM = Issue.Companion.create$default((Issue.Companion)objectArray, (String)"AppLinkSplitToWebAndCustom", (String)"Android App links should only use http(s) schemes", (String)"\n          In order for Android App Links to open in your app, Android must perform domain \\\n          verification. However, Android only sends domain verification requests for \\\n          `<intent-filter>`s that only contain http(s) schemes.\n\n          To ensure correct behavior, please split your http(s) schemes and other schemes \\\n          into two different `<intent-filter>`s.\n        ", (Implementation)implementation, (String)"https://developer.android.com/training/app-links/verify-android-applinks#add-intent-filters", (Category)category, (int)0, (Severity)severity, (boolean)false, null, null, null, (int)3904, null);
        objectArray = new String[]{"scheme", "host", "port", "path", "pathPrefix", "pathPattern", "pathSuffix", "pathAdvancedPattern", "mimeType"};
        INTENT_FILTER_DATA_SORT_REFERENCE = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0004>?@AB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u000bJ\u0015\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b J\u001e\u0010!\u001a\u00020\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010#\u001a\u00020\u0004H\u0002J\u001e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\b\u0002\u0010(\u001a\u00060)j\u0002`*H\u0002J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020,J\u000e\u0010/\u001a\u0002002\u0006\u0010-\u001a\u00020.J\u0010\u00102\u001a\u0002002\u0006\u00101\u001a\u00020,H\u0002J\u0010\u00103\u001a\u0002002\u0006\u00104\u001a\u00020\u0004H\u0002J\u000e\u00105\u001a\u0002002\u0006\u00106\u001a\u00020\u0004J.\u00107\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u000b2\f\b\u0002\u0010(\u001a\u00060)j\u0002`*H\u0002J\u001a\u0010:\u001a\u00020\u00042\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0002R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion;", "", "()V", "ACTION_VIEW", "", "APP_LINK_SPLIT_TO_WEB_AND_CUSTOM", "Lcom/android/tools/lint/detector/api/Issue;", "APP_LINK_WARNING", "CATEGORY_BROWSABLE", "CATEGORY_DEFAULT", "DEFAULT_INDENT_AMOUNT", "", "HTTP", "HTTPS", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "INTENT_FILTER_DATA_SORT_REFERENCE", "", "INTENT_FILTER_UNIQUE_DATA_ATTRIBUTES", "getINTENT_FILTER_UNIQUE_DATA_ATTRIBUTES$annotations", "KEY_SHOW_APP_LINKS_ASSISTANT", "PATH_ATTRIBUTES", "getPATH_ATTRIBUTES$lint_checks", "()Ljava/util/List;", "TAG_VALIDATION", "TEST_URL", "VALIDATION", "_OLD_ISSUE_URL", "androidPatternMatcherToAttr", "androidPatternMatcherConstant", "attrToAndroidPatternMatcher", "attr", "attrToAndroidPatternMatcher$lint_checks", "concatenateWithIndent", "inputs", "newLineAndIndentString", "copyTagWithAttributes", "", "element", "Lorg/w3c/dom/Element;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getIntentFilterData", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$IntentFilterData;", "intentFilter", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$TagWrapper;", "hasAutoVerifyButInvalidAppLink", "", "data", "hasElementsRequiredForAppLinks", "isSubstituted", "expression", "isWebScheme", "scheme", "recursivelyCopy", "startingIndentAmount", "indentDiff", "replaceUrlWithValue", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "str", "ElementWrapper", "IntentFilterData", "Path", "TagWrapper", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nAppLinksValidDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1574:1\n1#2:1575\n1755#3,3:1576\n1755#3,3:1579\n*S KotlinDebug\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector$Companion\n*L\n1336#1:1576,3\n1343#1:1579,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getPATH_ATTRIBUTES$lint_checks() {
            return PATH_ATTRIBUTES;
        }

        private final String replaceUrlWithValue(XmlContext context, String str) {
            String string;
            if (context == null) {
                return str;
            }
            LintClient client = context.getClient();
            ResourceUrl url = ResourceUrl.parse((String)str);
            if (url == null || url.isFramework()) {
                return str;
            }
            Project project = context.getProject();
            ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.ALL_DEPENDENCIES);
            List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.STRING, url.name);
            if (items.isEmpty()) {
                return str;
            }
            ResourceValue resourceValue = ((ResourceItem)items.get(0)).getResourceValue();
            if (resourceValue == null) {
                return str;
            }
            ResourceValue resourceValue2 = resourceValue;
            if (resourceValue2.getValue() == null) {
                string = str;
            } else {
                String string2 = resourceValue2.getValue();
                string = string2;
                Intrinsics.checkNotNull((Object)string2);
            }
            return string;
        }

        public final int attrToAndroidPatternMatcher$lint_checks(@NotNull String attr) {
            int n;
            Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
            switch (attr) {
                case "path": {
                    n = 0;
                    break;
                }
                case "pathPrefix": {
                    n = 1;
                    break;
                }
                case "pathPattern": {
                    n = 2;
                    break;
                }
                case "pathAdvancedPattern": {
                    n = 3;
                    break;
                }
                case "pathSuffix": {
                    n = 4;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Input was required to be one of the <data> path attributes, but was " + attr));
                }
            }
            return n;
        }

        @NotNull
        public final String androidPatternMatcherToAttr(int androidPatternMatcherConstant) {
            String string;
            switch (androidPatternMatcherConstant) {
                case 0: {
                    string = "path";
                    break;
                }
                case 1: {
                    string = "pathPrefix";
                    break;
                }
                case 2: {
                    string = "pathPattern";
                    break;
                }
                case 3: {
                    string = "pathAdvancedPattern";
                    break;
                }
                case 4: {
                    string = "pathSuffix";
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Input was required to be an AndroidPatternMatcher constant but was " + androidPatternMatcherConstant));
                }
            }
            return string;
        }

        public final boolean isWebScheme(@NotNull String scheme) {
            Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
            return Intrinsics.areEqual((Object)scheme, (Object)AppLinksValidDetector.HTTP) || Intrinsics.areEqual((Object)scheme, (Object)AppLinksValidDetector.HTTPS);
        }

        @NotNull
        public final IntentFilterData getIntentFilterData(@NotNull TagWrapper intentFilter) {
            int n;
            int n2;
            Intrinsics.checkNotNullParameter((Object)intentFilter, (String)"intentFilter");
            boolean autoVerify = Intrinsics.areEqual((Object)intentFilter.getSubstitutedAttributeValue("autoVerify"), (Object)"true");
            String string = intentFilter.getSubstitutedAttributeValue("order");
            if (string != null) {
                CharSequence charSequence;
                CharSequence charSequence2 = string;
                if (charSequence2.length() == 0) {
                    boolean bl = false;
                    charSequence = "0";
                } else {
                    charSequence = charSequence2;
                }
                n2 = Integer.parseInt((String)charSequence);
            } else {
                n2 = 0;
            }
            int order = n2;
            String string2 = intentFilter.getSubstitutedAttributeValue("priority");
            if (string2 != null) {
                CharSequence charSequence;
                CharSequence bl = string2;
                if (bl.length() == 0) {
                    boolean bl2 = false;
                    charSequence = "0";
                } else {
                    charSequence = bl;
                }
                n = Integer.parseInt((String)charSequence);
            } else {
                n = 0;
            }
            int priority = n;
            Set actions = new LinkedHashSet();
            Set categories = new LinkedHashSet();
            Set schemes = new LinkedHashSet();
            Set rawSchemes = new LinkedHashSet();
            Set hostPortPairs = new LinkedHashSet();
            Set rawHostPortPairs = new LinkedHashSet();
            Set paths2 = new LinkedHashSet();
            Set rawPaths = new LinkedHashSet();
            Set mimeTypes = new LinkedHashSet();
            Set rawMimeTypes = new LinkedHashSet();
            for (TagWrapper subTag : intentFilter.getSubTags()) {
                switch (subTag.getName()) {
                    case "action": {
                        String it;
                        if (subTag.getSubstitutedAttributeValue("name") != null) {
                            boolean bl = false;
                            actions.add(it);
                        }
                        break;
                    }
                    case "category": {
                        String it;
                        if (subTag.getSubstitutedAttributeValue("name") != null) {
                            boolean bl = false;
                            categories.add(it);
                        }
                        break;
                    }
                    case "data": {
                        String it;
                        if (subTag.getSubstitutedAttributeValue("scheme") != null) {
                            boolean bl = false;
                            schemes.add(it);
                        }
                        if (subTag.getRawAttributeValue("scheme") != null) {
                            boolean bl = false;
                            rawSchemes.add(it);
                        }
                        if (subTag.getSubstitutedAttributeValue("host") != null) {
                            boolean bl = false;
                            hostPortPairs.add(new Pair((Object)it, (Object)subTag.getSubstitutedAttributeValue("port")));
                        }
                        if (subTag.getRawAttributeValue("host") != null) {
                            boolean bl = false;
                            rawHostPortPairs.add(new Pair((Object)it, (Object)subTag.getRawAttributeValue("port")));
                        }
                        for (String pathAttribute : this.getPATH_ATTRIBUTES$lint_checks()) {
                            String it2;
                            if (subTag.getSubstitutedAttributeValue(pathAttribute) != null) {
                                boolean bl = false;
                                paths2.add(new Path(it2, pathAttribute));
                            }
                            if (subTag.getRawAttributeValue(pathAttribute) == null) continue;
                            boolean bl = false;
                            rawPaths.add(new Path(it2, pathAttribute));
                        }
                        if (subTag.getSubstitutedAttributeValue("mimeType") != null) {
                            boolean bl = false;
                            mimeTypes.add(it);
                        }
                        if (subTag.getRawAttributeValue("mimeType") != null) {
                            boolean bl = false;
                            rawMimeTypes.add(it);
                        }
                        break;
                    }
                }
            }
            return new IntentFilterData(autoVerify, order, priority, actions, categories, schemes, rawSchemes, hostPortPairs, rawHostPortPairs, paths2, rawPaths, mimeTypes, rawMimeTypes);
        }

        public final boolean hasAutoVerifyButInvalidAppLink(@NotNull TagWrapper intentFilter) {
            Intrinsics.checkNotNullParameter((Object)intentFilter, (String)"intentFilter");
            return this.hasAutoVerifyButInvalidAppLink(this.getIntentFilterData(intentFilter));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean hasAutoVerifyButInvalidAppLink(@NotNull IntentFilterData data) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (!data.getAutoVerify()) return false;
            if (!this.hasElementsRequiredForAppLinks(data)) return true;
            Iterable $this$any$iv = data.getSchemes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!Companion.isSubstituted(it) && !Companion.isWebScheme(it)) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasElementsRequiredForAppLinks(IntentFilterData data) {
            if (data.getActions().contains(AppLinksValidDetector.ACTION_VIEW) && data.getCategories().contains(AppLinksValidDetector.CATEGORY_DEFAULT) && data.getCategories().contains(AppLinksValidDetector.CATEGORY_BROWSABLE)) {
                boolean bl;
                block6: {
                    Iterable $this$any$iv = data.getSchemes();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!(Companion.isSubstituted(it) || Companion.isWebScheme(it))) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    if (!((Collection)data.getHostPortPairs()).isEmpty()) {
                        return true;
                    }
                    boolean bl3 = false;
                    if (bl3) return true;
                }
            }
            if (!data.getSchemes().isEmpty()) return false;
            if (((Collection)data.getHostPortPairs()).isEmpty()) return false;
            return true;
        }

        private final String concatenateWithIndent(List<String> inputs, String newLineAndIndentString) {
            return inputs.isEmpty() ? "" : CollectionsKt.joinToString$default((Iterable)inputs, (CharSequence)newLineAndIndentString, (CharSequence)newLineAndIndentString, null, (int)0, null, null, (int)60, null);
        }

        private final void copyTagWithAttributes(Element element, StringBuilder sb) {
            sb.append(element.getTagName());
            int n = element.getAttributes().getLength();
            for (int i = 0; i < n; ++i) {
                Node item = element.getAttributes().item(i);
                sb.append(" ");
                sb.append(item.getNodeName());
                sb.append("=\"");
                sb.append(item.getNodeValue());
                sb.append('\"');
            }
        }

        static /* synthetic */ void copyTagWithAttributes$default(Companion companion, Element element, StringBuilder stringBuilder, int n, Object object) {
            if ((n & 2) != 0) {
                stringBuilder = new StringBuilder();
            }
            companion.copyTagWithAttributes(element, stringBuilder);
        }

        private final void recursivelyCopy(Element element, int startingIndentAmount, int indentDiff, StringBuilder sb) {
            sb.append("<");
            this.copyTagWithAttributes(element, sb);
            if (DomExtensions.subtagCount((Element)element) == 0) {
                sb.append(" />");
                return;
            }
            sb.append(">");
            Iterator iterator = DomExtensions.iterator((Element)element);
            while (iterator.hasNext()) {
                Element subTag = (Element)iterator.next();
                sb.append("\n");
                int n = startingIndentAmount + indentDiff;
                for (int i = 0; i < n; ++i) {
                    sb.append(" ");
                }
                this.recursivelyCopy(subTag, startingIndentAmount + indentDiff, indentDiff, sb);
            }
            sb.append("\n");
            for (int i = 0; i < startingIndentAmount; ++i) {
                sb.append(" ");
            }
            sb.append("</" + element.getTagName() + ">");
        }

        static /* synthetic */ void recursivelyCopy$default(Companion companion, Element element, int n, int n2, StringBuilder stringBuilder, int n3, Object object) {
            if ((n3 & 8) != 0) {
                stringBuilder = new StringBuilder();
            }
            companion.recursivelyCopy(element, n, n2, stringBuilder);
        }

        public static /* synthetic */ void getINTENT_FILTER_UNIQUE_DATA_ATTRIBUTES$annotations() {
        }

        private final boolean isSubstituted(String expression) {
            return Lint.isDataBindingExpression((String)expression) || Lint.isManifestPlaceHolderExpression((String)expression);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$ElementWrapper;", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$TagWrapper;", "element", "Lorg/w3c/dom/Element;", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "(Lorg/w3c/dom/Element;Lcom/android/tools/lint/detector/api/XmlContext;)V", "name", "", "getName", "()Ljava/lang/String;", "subTags", "Lkotlin/sequences/Sequence;", "getSubTags", "()Lkotlin/sequences/Sequence;", "getRawAttributeValue", "attrName", "getSubstitutedAttributeValue", "lint-checks"})
        @SourceDebugExtension(value={"SMAP\nAppLinksValidDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector$Companion$ElementWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1574:1\n1#2:1575\n*E\n"})
        public static final class ElementWrapper
        implements TagWrapper {
            @NotNull
            private final Element element;
            @NotNull
            private final XmlContext context;
            @NotNull
            private final String name;
            @NotNull
            private final Sequence<ElementWrapper> subTags;

            public ElementWrapper(@NotNull Element element, @NotNull XmlContext context) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                this.element = element;
                this.context = context;
                String string = this.element.getTagName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTagName(...)");
                this.name = string;
                Iterable iterable = XmlUtils.getSubTags((Node)this.element);
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getSubTags(...)");
                this.subTags = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)iterable), (Function1)((Function1)new Function1<Element, ElementWrapper>(this){
                    final /* synthetic */ ElementWrapper this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final ElementWrapper invoke(Element it) {
                        Intrinsics.checkNotNull((Object)it);
                        return new ElementWrapper(it, ElementWrapper.access$getContext$p(this.this$0));
                    }
                }));
            }

            @Override
            @NotNull
            public String getName() {
                return this.name;
            }

            @Override
            @Nullable
            public String getSubstitutedAttributeValue(@NotNull String attrName) {
                Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
                Attr attr = this.element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attrName);
                String string = attr != null ? attr.getValue() : null;
                if (string == null) {
                    return null;
                }
                String value = string;
                if (StringsKt.startsWith$default((String)value, (String)"@", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"?", (boolean)false, (int)2, null)) {
                    return Companion.replaceUrlWithValue(this.context, value);
                }
                return value;
            }

            @Override
            @Nullable
            public String getRawAttributeValue(@NotNull String attrName) {
                String fallbackReturnValue;
                CharSequence charSequence;
                CharSequence charSequence2;
                Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
                String it = this.element.getAttributeNS("http://schemas.android.com/apk/res/android", attrName);
                boolean bl = false;
                CharSequence charSequence3 = it;
                if (StringsKt.isBlank((CharSequence)charSequence3)) {
                    boolean bl2 = false;
                    charSequence2 = null;
                } else {
                    charSequence2 = charSequence3;
                }
                if ((charSequence = (CharSequence)(fallbackReturnValue = (String)charSequence2)) == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    return fallbackReturnValue;
                }
                Attr attr = this.element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attrName);
                if (attr == null) {
                    return fallbackReturnValue;
                }
                Attr attributeNode = attr;
                try {
                    charSequence3 = this.context.getValueLocation(attributeNode);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    charSequence3 = null;
                }
                CharSequence charSequence4 = charSequence3;
                if (charSequence4 == null) {
                    return fallbackReturnValue;
                }
                CharSequence location = charSequence4;
                Position position = location.getStart();
                if (position == null) {
                    return fallbackReturnValue;
                }
                int start = position.getOffset();
                Position position2 = location.getEnd();
                if (position2 == null) {
                    return fallbackReturnValue;
                }
                int end = position2.getOffset();
                CharSequence charSequence5 = this.context.getContents();
                if (charSequence5 == null || (charSequence5 = ((Object)charSequence5.subSequence(start, end)).toString()) == null) {
                    charSequence5 = fallbackReturnValue;
                }
                return charSequence5;
            }

            @NotNull
            public Sequence<ElementWrapper> getSubTags() {
                return this.subTags;
            }

            public static final /* synthetic */ XmlContext access$getContext$p(ElementWrapper $this) {
                return $this.context;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b'\b\u0086\b\u0018\u00002\u00020\u0001B\u00c5\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u001a\u0010\r\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000e0\b\u0012\u001a\u0010\u000f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000e0\b\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\b\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u0015J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110\bH\u00c6\u0003J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110\bH\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\t\u0010,\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u000f\u00100\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\u001d\u00101\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000e0\bH\u00c6\u0003J\u001d\u00102\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000e0\bH\u00c6\u0003J\u00e3\u0001\u00103\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u001c\b\u0002\u0010\r\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000e0\b2\u001c\b\u0002\u0010\u000f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000e0\b2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b2\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\b2\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u00104\u001a\u00020\u00032\b\u00105\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00106\u001a\u00020\u0005H\u00d6\u0001J\t\u00107\u001a\u00020\tH\u00d6\u0001R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R%\u0010\r\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000e0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR%\u0010\u000f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000e0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0017R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0017R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0017R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0017\u00a8\u00068"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$IntentFilterData;", "", "autoVerify", "", "order", "", "priority", "actions", "", "", "categories", "schemes", "rawSchemes", "hostPortPairs", "Lkotlin/Pair;", "rawHostPortPairs", "paths", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$Path;", "rawPaths", "mimeTypes", "rawMimeTypes", "(ZIILjava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "getActions", "()Ljava/util/Set;", "getAutoVerify", "()Z", "getCategories", "getHostPortPairs", "getMimeTypes", "getOrder", "()I", "getPaths", "getPriority", "getRawHostPortPairs", "getRawMimeTypes", "getRawPaths", "getRawSchemes", "getSchemes", "component1", "component10", "component11", "component12", "component13", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "lint-checks"})
        public static final class IntentFilterData {
            private final boolean autoVerify;
            private final int order;
            private final int priority;
            @NotNull
            private final Set<String> actions;
            @NotNull
            private final Set<String> categories;
            @NotNull
            private final Set<String> schemes;
            @NotNull
            private final Set<String> rawSchemes;
            @NotNull
            private final Set<Pair<String, String>> hostPortPairs;
            @NotNull
            private final Set<Pair<String, String>> rawHostPortPairs;
            @NotNull
            private final Set<Path> paths;
            @NotNull
            private final Set<Path> rawPaths;
            @NotNull
            private final Set<String> mimeTypes;
            @NotNull
            private final Set<String> rawMimeTypes;

            public IntentFilterData(boolean autoVerify, int order, int priority, @NotNull Set<String> actions, @NotNull Set<String> categories, @NotNull Set<String> schemes, @NotNull Set<String> rawSchemes, @NotNull Set<Pair<String, String>> hostPortPairs, @NotNull Set<Pair<String, String>> rawHostPortPairs, @NotNull Set<Path> paths2, @NotNull Set<Path> rawPaths, @NotNull Set<String> mimeTypes, @NotNull Set<String> rawMimeTypes) {
                Intrinsics.checkNotNullParameter(actions, (String)"actions");
                Intrinsics.checkNotNullParameter(categories, (String)"categories");
                Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
                Intrinsics.checkNotNullParameter(rawSchemes, (String)"rawSchemes");
                Intrinsics.checkNotNullParameter(hostPortPairs, (String)"hostPortPairs");
                Intrinsics.checkNotNullParameter(rawHostPortPairs, (String)"rawHostPortPairs");
                Intrinsics.checkNotNullParameter(paths2, (String)"paths");
                Intrinsics.checkNotNullParameter(rawPaths, (String)"rawPaths");
                Intrinsics.checkNotNullParameter(mimeTypes, (String)"mimeTypes");
                Intrinsics.checkNotNullParameter(rawMimeTypes, (String)"rawMimeTypes");
                this.autoVerify = autoVerify;
                this.order = order;
                this.priority = priority;
                this.actions = actions;
                this.categories = categories;
                this.schemes = schemes;
                this.rawSchemes = rawSchemes;
                this.hostPortPairs = hostPortPairs;
                this.rawHostPortPairs = rawHostPortPairs;
                this.paths = paths2;
                this.rawPaths = rawPaths;
                this.mimeTypes = mimeTypes;
                this.rawMimeTypes = rawMimeTypes;
            }

            public final boolean getAutoVerify() {
                return this.autoVerify;
            }

            public final int getOrder() {
                return this.order;
            }

            public final int getPriority() {
                return this.priority;
            }

            @NotNull
            public final Set<String> getActions() {
                return this.actions;
            }

            @NotNull
            public final Set<String> getCategories() {
                return this.categories;
            }

            @NotNull
            public final Set<String> getSchemes() {
                return this.schemes;
            }

            @NotNull
            public final Set<String> getRawSchemes() {
                return this.rawSchemes;
            }

            @NotNull
            public final Set<Pair<String, String>> getHostPortPairs() {
                return this.hostPortPairs;
            }

            @NotNull
            public final Set<Pair<String, String>> getRawHostPortPairs() {
                return this.rawHostPortPairs;
            }

            @NotNull
            public final Set<Path> getPaths() {
                return this.paths;
            }

            @NotNull
            public final Set<Path> getRawPaths() {
                return this.rawPaths;
            }

            @NotNull
            public final Set<String> getMimeTypes() {
                return this.mimeTypes;
            }

            @NotNull
            public final Set<String> getRawMimeTypes() {
                return this.rawMimeTypes;
            }

            public final boolean component1() {
                return this.autoVerify;
            }

            public final int component2() {
                return this.order;
            }

            public final int component3() {
                return this.priority;
            }

            @NotNull
            public final Set<String> component4() {
                return this.actions;
            }

            @NotNull
            public final Set<String> component5() {
                return this.categories;
            }

            @NotNull
            public final Set<String> component6() {
                return this.schemes;
            }

            @NotNull
            public final Set<String> component7() {
                return this.rawSchemes;
            }

            @NotNull
            public final Set<Pair<String, String>> component8() {
                return this.hostPortPairs;
            }

            @NotNull
            public final Set<Pair<String, String>> component9() {
                return this.rawHostPortPairs;
            }

            @NotNull
            public final Set<Path> component10() {
                return this.paths;
            }

            @NotNull
            public final Set<Path> component11() {
                return this.rawPaths;
            }

            @NotNull
            public final Set<String> component12() {
                return this.mimeTypes;
            }

            @NotNull
            public final Set<String> component13() {
                return this.rawMimeTypes;
            }

            @NotNull
            public final IntentFilterData copy(boolean autoVerify, int order, int priority, @NotNull Set<String> actions, @NotNull Set<String> categories, @NotNull Set<String> schemes, @NotNull Set<String> rawSchemes, @NotNull Set<Pair<String, String>> hostPortPairs, @NotNull Set<Pair<String, String>> rawHostPortPairs, @NotNull Set<Path> paths2, @NotNull Set<Path> rawPaths, @NotNull Set<String> mimeTypes, @NotNull Set<String> rawMimeTypes) {
                Intrinsics.checkNotNullParameter(actions, (String)"actions");
                Intrinsics.checkNotNullParameter(categories, (String)"categories");
                Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
                Intrinsics.checkNotNullParameter(rawSchemes, (String)"rawSchemes");
                Intrinsics.checkNotNullParameter(hostPortPairs, (String)"hostPortPairs");
                Intrinsics.checkNotNullParameter(rawHostPortPairs, (String)"rawHostPortPairs");
                Intrinsics.checkNotNullParameter(paths2, (String)"paths");
                Intrinsics.checkNotNullParameter(rawPaths, (String)"rawPaths");
                Intrinsics.checkNotNullParameter(mimeTypes, (String)"mimeTypes");
                Intrinsics.checkNotNullParameter(rawMimeTypes, (String)"rawMimeTypes");
                return new IntentFilterData(autoVerify, order, priority, actions, categories, schemes, rawSchemes, hostPortPairs, rawHostPortPairs, paths2, rawPaths, mimeTypes, rawMimeTypes);
            }

            public static /* synthetic */ IntentFilterData copy$default(IntentFilterData intentFilterData, boolean bl, int n, int n2, Set set, Set set2, Set set3, Set set4, Set set5, Set set6, Set set7, Set set8, Set set9, Set set10, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    bl = intentFilterData.autoVerify;
                }
                if ((n3 & 2) != 0) {
                    n = intentFilterData.order;
                }
                if ((n3 & 4) != 0) {
                    n2 = intentFilterData.priority;
                }
                if ((n3 & 8) != 0) {
                    set = intentFilterData.actions;
                }
                if ((n3 & 0x10) != 0) {
                    set2 = intentFilterData.categories;
                }
                if ((n3 & 0x20) != 0) {
                    set3 = intentFilterData.schemes;
                }
                if ((n3 & 0x40) != 0) {
                    set4 = intentFilterData.rawSchemes;
                }
                if ((n3 & 0x80) != 0) {
                    set5 = intentFilterData.hostPortPairs;
                }
                if ((n3 & 0x100) != 0) {
                    set6 = intentFilterData.rawHostPortPairs;
                }
                if ((n3 & 0x200) != 0) {
                    set7 = intentFilterData.paths;
                }
                if ((n3 & 0x400) != 0) {
                    set8 = intentFilterData.rawPaths;
                }
                if ((n3 & 0x800) != 0) {
                    set9 = intentFilterData.mimeTypes;
                }
                if ((n3 & 0x1000) != 0) {
                    set10 = intentFilterData.rawMimeTypes;
                }
                return intentFilterData.copy(bl, n, n2, set, set2, set3, set4, set5, set6, set7, set8, set9, set10);
            }

            @NotNull
            public String toString() {
                return "IntentFilterData(autoVerify=" + this.autoVerify + ", order=" + this.order + ", priority=" + this.priority + ", actions=" + this.actions + ", categories=" + this.categories + ", schemes=" + this.schemes + ", rawSchemes=" + this.rawSchemes + ", hostPortPairs=" + this.hostPortPairs + ", rawHostPortPairs=" + this.rawHostPortPairs + ", paths=" + this.paths + ", rawPaths=" + this.rawPaths + ", mimeTypes=" + this.mimeTypes + ", rawMimeTypes=" + this.rawMimeTypes + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.autoVerify);
                result = result * 31 + Integer.hashCode(this.order);
                result = result * 31 + Integer.hashCode(this.priority);
                result = result * 31 + ((Object)this.actions).hashCode();
                result = result * 31 + ((Object)this.categories).hashCode();
                result = result * 31 + ((Object)this.schemes).hashCode();
                result = result * 31 + ((Object)this.rawSchemes).hashCode();
                result = result * 31 + ((Object)this.hostPortPairs).hashCode();
                result = result * 31 + ((Object)this.rawHostPortPairs).hashCode();
                result = result * 31 + ((Object)this.paths).hashCode();
                result = result * 31 + ((Object)this.rawPaths).hashCode();
                result = result * 31 + ((Object)this.mimeTypes).hashCode();
                result = result * 31 + ((Object)this.rawMimeTypes).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof IntentFilterData)) {
                    return false;
                }
                IntentFilterData intentFilterData = (IntentFilterData)other;
                if (this.autoVerify != intentFilterData.autoVerify) {
                    return false;
                }
                if (this.order != intentFilterData.order) {
                    return false;
                }
                if (this.priority != intentFilterData.priority) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.actions, intentFilterData.actions)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.categories, intentFilterData.categories)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.schemes, intentFilterData.schemes)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.rawSchemes, intentFilterData.rawSchemes)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.hostPortPairs, intentFilterData.hostPortPairs)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.rawHostPortPairs, intentFilterData.rawHostPortPairs)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.paths, intentFilterData.paths)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.rawPaths, intentFilterData.rawPaths)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.mimeTypes, intentFilterData.mimeTypes)) {
                    return false;
                }
                return Intrinsics.areEqual(this.rawMimeTypes, intentFilterData.rawMimeTypes);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0000H\u0096\u0002J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\nH\u00d6\u0001J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$Path;", "", "attributeValue", "", "attributeName", "(Ljava/lang/String;Ljava/lang/String;)V", "getAttributeName", "()Ljava/lang/String;", "getAttributeValue", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toPatternMatcher", "Lcom/android/tools/lint/checks/AndroidPatternMatcher;", "toString", "lint-checks"})
        public static final class Path
        implements Comparable<Path> {
            @NotNull
            private final String attributeValue;
            @NotNull
            private final String attributeName;

            public Path(@NotNull String attributeValue, @NotNull String attributeName) {
                Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
                Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
                this.attributeValue = attributeValue;
                this.attributeName = attributeName;
            }

            @NotNull
            public final String getAttributeValue() {
                return this.attributeValue;
            }

            @NotNull
            public final String getAttributeName() {
                return this.attributeName;
            }

            @NotNull
            public final AndroidPatternMatcher toPatternMatcher() {
                return new AndroidPatternMatcher(this.attributeValue, Companion.attrToAndroidPatternMatcher$lint_checks(this.attributeName));
            }

            @Override
            public int compareTo(@NotNull Path other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                if (this.attributeName.compareTo(other.attributeName) < 0) {
                    return -1;
                }
                return this.attributeValue.compareTo(other.attributeValue);
            }

            @NotNull
            public String toString() {
                String string;
                switch (this.attributeName) {
                    case "path": {
                        string = "literal ";
                        break;
                    }
                    case "pathPrefix": {
                        string = "prefix ";
                        break;
                    }
                    case "pathPattern": {
                        string = "glob ";
                        break;
                    }
                    case "pathSuffix": {
                        string = "suffix ";
                        break;
                    }
                    case "pathAdvancedPattern": {
                        string = "advanced ";
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Expected attributeName to be a path attribute but was " + this.attributeName));
                    }
                }
                return string + this.attributeValue;
            }

            @NotNull
            public final String component1() {
                return this.attributeValue;
            }

            @NotNull
            public final String component2() {
                return this.attributeName;
            }

            @NotNull
            public final Path copy(@NotNull String attributeValue, @NotNull String attributeName) {
                Intrinsics.checkNotNullParameter((Object)attributeValue, (String)"attributeValue");
                Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
                return new Path(attributeValue, attributeName);
            }

            public static /* synthetic */ Path copy$default(Path path, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = path.attributeValue;
                }
                if ((n & 2) != 0) {
                    string2 = path.attributeName;
                }
                return path.copy(string, string2);
            }

            public int hashCode() {
                int result = this.attributeValue.hashCode();
                result = result * 31 + this.attributeName.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Path)) {
                    return false;
                }
                Path path = (Path)other;
                if (!Intrinsics.areEqual((Object)this.attributeValue, (Object)path.attributeValue)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.attributeName, (Object)path.attributeName);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0003H&J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0003H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\r\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$TagWrapper;", "", "name", "", "getName", "()Ljava/lang/String;", "subTags", "Lkotlin/sequences/Sequence;", "getSubTags", "()Lkotlin/sequences/Sequence;", "getRawAttributeValue", "attrName", "getSubstitutedAttributeValue", "lint-checks"})
        public static interface TagWrapper {
            @NotNull
            public String getName();

            @NotNull
            public Sequence<TagWrapper> getSubTags();

            @Nullable
            public String getSubstitutedAttributeValue(@NotNull String var1);

            @Nullable
            public String getRawAttributeValue(@NotNull String var1);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B?\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u001c\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002R$\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/checks/AppLinksValidDetector$UriInfo;", "", "schemes", "", "", "hostPortPairs", "Lkotlin/Pair;", "paths", "Lcom/android/tools/lint/checks/AppLinksValidDetector$Companion$Path;", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "containsUpperCase", "", "matchers", "match", "testUrl", "Ljava/net/URL;", "matchesHost", "actualHost", "hostPattern", "lint-checks"})
    @SourceDebugExtension(value={"SMAP\nAppLinksValidDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector$UriInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1574:1\n1755#2,3:1575\n1755#2,2:1578\n1757#2:1581\n1755#2,3:1582\n1863#2,2:1585\n1755#2,3:1587\n1#3:1580\n*S KotlinDebug\n*F\n+ 1 AppLinksValidDetector.kt\ncom/android/tools/lint/checks/AppLinksValidDetector$UriInfo\n*L\n1048#1:1575,3\n1054#1:1578,2\n1054#1:1581\n1067#1:1582,3\n1070#1:1585,2\n1085#1:1587,3\n*E\n"})
    public static final class UriInfo {
        @NotNull
        private final Set<String> schemes;
        @NotNull
        private final Set<Pair<String, String>> hostPortPairs;
        @NotNull
        private final Set<Companion.Path> paths;

        public UriInfo(@NotNull Set<String> schemes, @NotNull Set<Pair<String, String>> hostPortPairs, @NotNull Set<Companion.Path> paths2) {
            Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
            Intrinsics.checkNotNullParameter(hostPortPairs, (String)"hostPortPairs");
            Intrinsics.checkNotNullParameter(paths2, (String)"paths");
            this.schemes = schemes;
            this.hostPortPairs = hostPortPairs;
            this.paths = paths2;
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final String match(@NotNull URL testUrl) {
            block23: {
                block21: {
                    block24: {
                        block20: {
                            Intrinsics.checkNotNullParameter((Object)testUrl, (String)"testUrl");
                            $this$any$iv = this.schemes;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v0 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    scheme = (String)element$iv;
                                    $i$a$-any-AppLinksValidDetector$UriInfo$match$schemeOk$1 = false;
                                    if (!(Intrinsics.areEqual((Object)scheme, (Object)testUrl.getProtocol()) != false || com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, scheme) != false)) continue;
                                    v0 = true;
                                    break block20;
                                }
                                v0 = schemeOk = false;
                            }
                        }
                        if (!schemeOk) {
                            return "did not match scheme " + Joiner.on((String)", ").join((Iterable)this.schemes);
                        }
                        if (!(((Collection)this.hostPortPairs).isEmpty() == false)) break block23;
                        $this$any$iv = this.hostPortPairs;
                        $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block24;
                        v1 = false;
                        break block21;
                    }
                    for (Object element$iv : $this$any$iv) {
                        $i$a$-any-AppLinksValidDetector$UriInfo$match$schemeOk$1 = (Pair)element$iv;
                        $i$a$-any-AppLinksValidDetector$UriInfo$match$hostOk$1 = false;
                        host = (String)$i$a$-any-AppLinksValidDetector$UriInfo$match$schemeOk$1.component1();
                        port = (String)$i$a$-any-AppLinksValidDetector$UriInfo$match$schemeOk$1.component2();
                        if (host != null) {
                            $i$a$-let-AppLinksValidDetector$UriInfo$match$hostOk$1$1 = false;
                            v2 = testUrl.getHost();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getHost(...)");
                            v3 = this.matchesHost(v2, it) || com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, it);
                        } else {
                            v3 = true;
                        }
                        if (!v3) ** GOTO lbl-1000
                        if (port != null) {
                            $i$a$-let-AppLinksValidDetector$UriInfo$match$hostOk$1$2 = false;
                            v4 = Intrinsics.areEqual((Object)String.valueOf(testUrl.getPort()), (Object)port) || com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, port);
                        } else {
                            v4 = true;
                        }
                        if (v4) {
                            v5 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v5 = false;
                        }
                        if (!v5) continue;
                        v1 = true;
                        break block21;
                    }
                    v1 = hostOk = false;
                }
                if (!hostOk) {
                    return "did not match" + (this.hostPortPairs.size() > 1 ? " any of" : "") + " " + CollectionsKt.joinToString$default((Iterable)this.hostPortPairs, (CharSequence)", ", null, null, (int)0, null, (Function1)match.1.INSTANCE, (int)30, null);
                }
            }
            if (((Collection)this.paths).isEmpty() == false) {
                block22: {
                    testPath = testUrl.getPath();
                    $this$any$iv = this.paths;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v6 = false;
                    } else {
                        for (E element$iv : $this$any$iv) {
                            it = (Companion.Path)element$iv;
                            $i$a$-any-AppLinksValidDetector$UriInfo$match$pathOk$1 = false;
                            if (!(com.android.tools.lint.checks.AppLinksValidDetector$Companion.access$isSubstituted(AppLinksValidDetector.Companion, it.getAttributeValue()) != false || it.toPatternMatcher().match(testPath) != false)) continue;
                            v6 = true;
                            break block22;
                        }
                        v6 = pathOk = false;
                    }
                }
                if (!pathOk) {
                    sb = new StringBuilder();
                    $this$forEach$iv = this.paths;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (Companion.Path)element$iv;
                        $i$a$-forEach-AppLinksValidDetector$UriInfo$match$2 = false;
                        sb.append("path ").append(it.toString()).append(", ");
                    }
                    if (CharSequences.endsWith((CharSequence)sb, (CharSequence)", ", (boolean)true)) {
                        sb.setLength(sb.length() - 2);
                    }
                    message = "did not match " + sb;
                    if (this.containsUpperCase(this.paths) || CharSequences.containsUpperCase((CharSequence)testPath)) {
                        message = message + " Note that matching is case sensitive.";
                    }
                    return message;
                }
            }
            return null;
        }

        private final boolean containsUpperCase(Set<Companion.Path> matchers) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = matchers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Companion.Path it = (Companion.Path)element$iv;
                        boolean bl2 = false;
                        if (!CharSequences.containsUpperCase((CharSequence)it.getAttributeValue())) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean matchesHost(String actualHost, String hostPattern) {
            boolean bl;
            if (!StringsKt.startsWith$default((String)hostPattern, (String)"*", (boolean)false, (int)2, null)) {
                bl = Intrinsics.areEqual((Object)actualHost, (Object)hostPattern);
            } else {
                boolean bl2;
                try {
                    String string = hostPattern.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    Regex pattern = new Regex(".*" + Pattern.quote(string));
                    bl2 = pattern.matches((CharSequence)actualHost);
                }
                catch (Throwable ignore) {
                    bl2 = false;
                }
                bl = bl2;
            }
            return bl;
        }
    }
}

