/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.LintMapUtilsKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.PartialResult;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/CredentialManagerSignInWithGoogleDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "checkPartialResults", "partialResults", "Lcom/android/tools/lint/detector/api/PartialResult;", "getApplicableReferenceNames", "", "", "visitReference", "Lcom/android/tools/lint/detector/api/JavaContext;", "reference", "Lorg/jetbrains/uast/UReferenceExpression;", "referenced", "Lcom/intellij/psi/PsiElement;", "Companion", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nCredentialManagerSignInWithGoogleDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CredentialManagerSignInWithGoogleDetector.kt\ncom/android/tools/lint/checks/CredentialManagerSignInWithGoogleDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1755#2,3:140\n1611#2,9:143\n1863#2:152\n1864#2:154\n1620#2:155\n1381#2:156\n1469#2,5:157\n1#3:153\n*S KotlinDebug\n*F\n+ 1 CredentialManagerSignInWithGoogleDetector.kt\ncom/android/tools/lint/checks/CredentialManagerSignInWithGoogleDetector\n*L\n74#1:140,3\n83#1:143,9\n83#1:152\n83#1:154\n83#1:155\n85#1:156\n85#1:157,5\n83#1:153\n*E\n"})
public final class CredentialManagerSignInWithGoogleDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String KEY_OPTION_REFS = "OPTION_REFS";
    @NotNull
    private static final String KEY_SAW_TOKEN_REF = "SAW_TOKEN_REF";
    @NotNull
    private static final String GOOGLE_ID_PACKAGE_DOT = "com.google.android.libraries.identity.googleid.";
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(CredentialManagerSignInWithGoogleDetector.class, EnumSet.of((Enum)Scope.ALL_JAVA_FILES));
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @NotNull
    public List<String> getApplicableReferenceNames() {
        Object[] objectArray = new String[]{"GetGoogleIdOption", "GetSignInWithGoogleOption", "GoogleIdTokenCredential"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void visitReference(@NotNull JavaContext context, @NotNull UReferenceExpression reference, @NotNull PsiElement referenced) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)referenced, (String)"referenced");
        v0 /* !! */  = referenced instanceof PsiClass != false ? (PsiClass)referenced : null;
        if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .getQualifiedName()) == null) {
            return;
        }
        qualifiedName /* !! */  = v0 /* !! */ ;
        if (!StringsKt.startsWith$default((String)qualifiedName /* !! */ , (String)"com.google.android.libraries.identity.googleid.", (boolean)false, (int)2, null)) {
            return;
        }
        className = StringsKt.removePrefix((String)qualifiedName /* !! */ , (CharSequence)"com.google.android.libraries.identity.googleid.");
        if (!this.getApplicableReferenceNames().contains(className)) {
            return;
        }
        partialResults = context.getPartialResults(CredentialManagerSignInWithGoogleDetector.ISSUE).map();
        var7_7 = className;
        switch (var7_7.hashCode()) {
            case 161239724: {
                if (!var7_7.equals("GetSignInWithGoogleOption")) {
                    ** break;
                }
                ** GOTO lbl25
            }
            case 1818582844: {
                if (var7_7.equals("GoogleIdTokenCredential")) break;
                ** break;
            }
            case -960329825: {
                if (!var7_7.equals("GetGoogleIdOption")) ** break;
lbl25:
                // 2 sources

                if (context.getDriver().isSuppressed(context, CredentialManagerSignInWithGoogleDetector.ISSUE, (UElement)reference)) {
                    return;
                }
                LintMapUtilsKt.appendLocation(LintMapUtilsKt.getOrPutLintMap(partialResults, "OPTION_REFS"), context.getLocation((UElement)reference));
                ** break;
            }
        }
        partialResults.put("SAW_TOKEN_REF", true);
lbl32:
        // 6 sources

    }

    /*
     * WARNING - void declaration
     */
    public void checkPartialResults(@NotNull Context context, @NotNull PartialResult partialResults) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object element$iv2;
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)partialResults, (String)"partialResults");
            if (context.getProject().isLibrary()) {
                return;
            }
            Iterable $this$any$iv = partialResults.maps();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    LintMap it = (LintMap)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)LintMap.getBoolean$default((LintMap)it, (String)KEY_SAW_TOKEN_REF, null, (int)2, null), (Object)true)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Iterable $i$f$any = partialResults.maps();
        boolean $i$f$mapNotNull = false;
        element$iv2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LintMap it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl3 = false;
            LintMap it = (LintMap)element$iv$iv;
            boolean bl4 = false;
            if (it.getMap(KEY_OPTION_REFS) == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$flatMapSequence = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LintMap it = (LintMap)element$iv$iv;
            boolean bl6 = false;
            Sequence<Location> list$iv$iv = LintMapUtilsKt.asLocationSequence(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
        }
        List locations2 = (List)destination$iv$iv;
        for (Location location : locations2) {
            Context.report$default((Context)context, (Issue)ISSUE, (Location)location, (String)"Use of `:googleid` classes without use of `GoogleIdTokenCredential`", null, (int)8, null);
        }
    }

    public void afterCheckRootProject(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isGlobalAnalysis()) {
            this.checkPartialResults(context, context.getPartialResults(ISSUE));
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"CredentialManagerSignInWithGoogle", (String)"Misuse of Sign in with Google API", (String)"\n          When using `:googleid` classes like `GetGoogleIdOption` and `GetSignInWithGoogleOption`, \\\n          you typically must handle the response using \\\n          `GoogleIdTokenCredential.TYPE_GOOGLE_ID_TOKEN_CREDENTIAL` or \\\n          `GoogleIdTokenCredential.TYPE_GOOGLE_ID_TOKEN_SIWG_CREDENTIAL`.\n\n          This check reports all uses of these `:googleid` classes if there are no \\\n          references to `GoogleIdTokenCredential`.\n          ", (Implementation)implementation, (String)"https://developer.android.com/identity/sign-in/credential-manager-siwg#create-sign", (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/CredentialManagerSignInWithGoogleDetector$Companion;", "", "()V", "GOOGLE_ID_PACKAGE_DOT", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "KEY_OPTION_REFS", "KEY_SAW_TOKEN_REF", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

