/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/WebViewClientDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableSuperClasses", "", "", "visitClass", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "Companion", "OnReceivedSslErrorBodyVisitor", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nWebViewClientDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebViewClientDetector.kt\ncom/android/tools/lint/checks/WebViewClientDetector\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,94:1\n3829#2:95\n4344#2,2:96\n*S KotlinDebug\n*F\n+ 1 WebViewClientDetector.kt\ncom/android/tools/lint/checks/WebViewClientDetector\n*L\n39#1:95\n39#1:96,2\n*E\n"})
public final class WebViewClientDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(WebViewClientDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue PROCEEDS_ON_RECEIVED_SSL_ERROR;

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)"android.webkit.WebViewClient");
    }

    /*
     * WARNING - void declaration
     */
    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        JavaEvaluator evaluator = context.getEvaluator();
        UMethod[] $this$filter$iv = declaration.getMethods();
        boolean $i$f$filter = false;
        UMethod[] uMethodArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"onReceivedSslError")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (UMethod method : (List)destination$iv$iv) {
            if (evaluator.isAbstract((PsiModifierListOwner)method)) continue;
            OnReceivedSslErrorBodyVisitor visitor2 = new OnReceivedSslErrorBodyVisitor(context);
            method.accept((UastVisitor)visitor2);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        PROCEEDS_ON_RECEIVED_SSL_ERROR = Issue.Companion.create$default((Issue.Companion)companion, (String)"WebViewClientOnReceivedSslError", (String)"Proceeds with the HTTPS connection despite SSL errors", (String)"This check looks for `onReceivedSslError` implementations that invoke `SslErrorHandler#proceed`.", (Implementation)implementation, (String)"https://goo.gle/WebViewClientOnReceivedSslError", (Category)category, (int)5, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3328, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/lint/checks/WebViewClientDetector$Companion;", "", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "PROCEEDS_ON_RECEIVED_SSL_ERROR", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/WebViewClientDetector$OnReceivedSslErrorBodyVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "visitCallExpression", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "lint-checks"})
    private static final class OnReceivedSslErrorBodyVisitor
    extends AbstractUastVisitor {
        @NotNull
        private final JavaContext context;

        public OnReceivedSslErrorBodyVisitor(@NotNull JavaContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (UastExpressionUtils.isMethodCall((UElement)((UElement)node))) {
                UExpression receiver;
                UExpression uExpression = receiver = node.getReceiver();
                PsiType receiverType = uExpression != null ? uExpression.getExpressionType() : null;
                String methodName = node.getMethodName();
                if (receiverType != null && methodName != null && Intrinsics.areEqual((Object)receiverType.getCanonicalText(), (Object)"android.webkit.SslErrorHandler") && Intrinsics.areEqual((Object)methodName, (Object)"proceed")) {
                    String message2 = "Permitting connections with SSL-related errors could allow eavesdroppers to intercept data sent by your app, which impacts the privacy of your users. Consider canceling the connections by invoking `SslErrorHandler#cancel()`.";
                    JavaContext.report$default((JavaContext)this.context, (Issue)PROCEEDS_ON_RECEIVED_SSL_ERROR, (UElement)((UElement)node), (Location)this.context.getLocation((UElement)node), (String)message2, null, (int)16, null);
                }
            }
            return super.visitCallExpression(node);
        }
    }
}

