/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.signatures.KaVariableSignature;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.ULocalVariableEx;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0001?B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u0012*\u0004\u0018\u00010\u0013H\u0002J(\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\u00020\u0012*\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u001e\u001a\u00020\u0012*\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\u000e\u0010!\u001a\u00020\u0012*\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001fH\u0002J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&H\u0002J$\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010(\u001a\u00020\u001fH\u0002J&\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00160\u00062\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u000202H\u0002J\u0012\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u00105\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00106\u001a\u0002072\u0006\u00101\u001a\u000208H\u0002J(\u00109\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00106\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020:H\u0002J(\u0010;\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00106\u001a\u00020\u00162\u0006\u0010<\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020:H\u0002J\u0018\u0010=\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020>2\u0006\u0010%\u001a\u00020&H\u0002\u00a8\u0006@"}, d2={"Lcom/android/tools/lint/checks/SamDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "checkRemoveMethod", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "hasLambdaType", "", "Lcom/intellij/psi/PsiType;", "checkRemoveLambda", "argument", "Lorg/jetbrains/uast/UExpression;", "isSamConversion", "call", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "getParameterType", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "hasWordPrefix", "", "prefix", "isRemoveMethodName", "getPairedName", "methodName", "isInstanceRemoval", "parameter", "Lcom/intellij/psi/PsiParameter;", "methodParameterMatches", "samType", "createLambdaVariableFix", "Lcom/android/tools/lint/detector/api/LintFix;", "declaration", "Lorg/jetbrains/uast/UVariable;", "findPostCalls", "container", "Lorg/jetbrains/uast/UClass;", "className", "variable", "Lcom/intellij/psi/PsiElement;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "checkCalls", "lambda", "Lorg/jetbrains/uast/ULambdaExpression;", "Lcom/intellij/psi/PsiLocalVariable;", "checkLambda", "Lorg/jetbrains/uast/UReferenceExpression;", "reportError", "type", "instanceComparesLambda", "Lorg/jetbrains/uast/UMethod;", "Issues", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nSamDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SamDetector.kt\ncom/android/tools/lint/checks/SamDetector\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 5 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,548:1\n18#2:549\n18#2:570\n1#3:550\n28#4,2:551\n36#5,13:553\n12567#6:566\n12567#6,2:567\n12568#6:569\n*S KotlinDebug\n*F\n+ 1 SamDetector.kt\ncom/android/tools/lint/checks/SamDetector\n*L\n166#1:549\n480#1:570\n216#1:551,2\n216#1:553,13\n305#1:566\n306#1:567,2\n305#1:569\n*E\n"})
public final class SamDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String HANDLER_CLASS = "android.os.Handler";
    @NotNull
    private static final String DRAWABLE_CALLBACK_CLASS = "android.graphics.drawable.Drawable.Callback";
    @NotNull
    private static final String RUNNABLE_CLASS = "java.lang.Runnable";

    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{ULambdaExpression.class, UCallableReferenceExpression.class, UCallExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final void checkRemoveMethod(JavaContext context, UCallExpression node, PsiMethod method) {
        List arguments = node.getValueArguments();
        for (UExpression argument : arguments) {
            String methodName;
            PsiParameter parameter;
            UElement selector;
            if (argument instanceof UCallableReferenceExpression) continue;
            if (this.hasLambdaType(argument.getExpressionType())) {
                if (!this.checkRemoveLambda(context, node, method, argument)) continue;
                return;
            }
            if (arguments.size() != 1 || !((selector = UastLintUtilsKt.findSelector((UElement)((UElement)argument))) instanceof UCallExpression) || !UastExpressionUtils.isConstructorCall((UElement)selector)) continue;
            if (UastUtils.getParameterForArgument((UCallExpression)node, (UExpression)argument) == null) {
                return;
            }
            if (!this.isInstanceRemoval(method, parameter)) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)method.getName(), (String)"getName(...)");
            Location location = context.getLocation(selector);
            JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)selector, (Location)location, (String)("This argument is a new instance so `" + methodName + "` will not remove anything"), null, (int)16, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasLambdaType(PsiType $this$hasLambdaType) {
        if (!($this$hasLambdaType instanceof PsiClassType)) return false;
        String string = ((PsiClassType)$this$hasLambdaType).getCanonicalText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"kotlin.jvm.functions.Function", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkRemoveLambda(JavaContext context, UCallExpression node, PsiMethod method, UExpression argument) {
        String string;
        String secondary;
        boolean isHandler;
        if (!this.isSamConversion(node, argument)) {
            return false;
        }
        PsiParameter psiParameter = UastUtils.getParameterForArgument((UCallExpression)node, (UExpression)argument);
        if (psiParameter == null) {
            return false;
        }
        PsiParameter parameter = psiParameter;
        if (!this.isInstanceRemoval(method, parameter)) {
            return false;
        }
        Location location = context.getLocation((UElement)argument);
        PsiElement variable = UastUtils.tryResolve((UElement)((UElement)argument));
        UElement $this$getParentOfType_u24default$iv = (UElement)node;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        UClass container = (UClass)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
        PsiClass psiClass = method.getContainingClass();
        String qualifiedName = psiClass != null ? psiClass.getQualifiedName() : null;
        boolean bl = isHandler = Intrinsics.areEqual((Object)qualifiedName, (Object)HANDLER_CLASS) || Intrinsics.areEqual((Object)qualifiedName, (Object)"android.view.View");
        if (variable != null) {
            UClass uClass = container;
            if ((uClass != null ? uClass.getSourcePsi() : null) != null) {
                List<UExpression> list;
                if (isHandler) {
                    String string2 = qualifiedName;
                    Intrinsics.checkNotNull((Object)string2);
                    list = this.findPostCalls(container, string2, variable);
                } else {
                    list = CollectionsKt.emptyList();
                }
                List<UExpression> posts = list;
                Object last = location;
                for (UExpression post : posts) {
                    secondary = context.getLocation((UElement)post);
                    Location.withSecondary$default((Location)last, (Location)secondary, (String)("Different instance than the one for `" + method.getName() + "()` due to SAM conversion; wrap with a shared `Runnable`"), (boolean)false, (int)4, null);
                    last = secondary;
                }
            }
        }
        PsiElement psiElement = argument.getSourcePsi();
        String argumentName = psiElement != null ? psiElement.getText() : null;
        PsiType psiType = parameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
        PsiType samType = psiType;
        String string3 = samType.getPresentableText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPresentableText(...)");
        String samTypeString = string3;
        secondary = StringsKt.substringBefore$default((String)samTypeString, (String)"<", null, (int)2, null);
        if (((CharSequence)secondary).length() > 0) {
            void it22;
            char c = secondary.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.lowercase((char)it22, (Locale)locale));
            String it22 = secondary;
            n = 1;
            String string4 = it22.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string = stringBuilder2.append(string4).toString();
        } else {
            string = secondary;
        }
        String samTypeVar = string;
        LintFix fix = null;
        if (variable instanceof PsiVariable) {
            PsiElement psiElement2 = node.getSourcePsi();
            if (((PsiVariable)variable).getContainingFile() == (psiElement2 != null ? psiElement2.getContainingFile() : null)) {
                UElement n = UastContextKt.toUElement((PsiElement)variable);
                UVariable declaration = n instanceof UVariable ? (UVariable)n : null;
                fix = this.createLambdaVariableFix(context, declaration, samTypeString);
            }
        }
        String addVerb = isHandler ? "post" : "add";
        String example = argument instanceof ULambdaExpression ? "val " + samTypeVar + " = " + samTypeString + " " + argumentName : "val " + samTypeVar + " = " + samTypeString + " { " + argumentName + "() }";
        String message2 = "`" + argumentName + "` is an implicit SAM conversion, so the instance you are removing here will not match anything. To fix this, use for example `" + example + "` and " + addVerb + " and remove the `" + samTypeVar + "` val instead.";
        context.report(ISSUE, (UElement)argument, location, message2, fix);
        return true;
    }

    private final boolean isSamConversion(UCallExpression call, UExpression argument) {
        PsiElement sourcePsi = call.getSourcePsi();
        if (!(sourcePsi instanceof KtCallExpression)) {
            return false;
        }
        return this.isSamConversion((KtCallExpression)sourcePsi, argument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean isSamConversion(KtCallExpression callExpression, UExpression argument) {
        boolean bl;
        void this_$iv$iv;
        boolean $i$f$analyze = false;
        Project project = ((KtElement)callExpression).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)callExpression);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)callExpression);
        try {
            boolean bl2;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                boolean bl3 = false;
                KaSession $this$isSamConversion_u24lambda_u241 = analysisSession$iv$iv;
                boolean bl4 = false;
                bl2 = this.isSamConversion($this$isSamConversion_u24lambda_u241, callExpression, argument);
            }
            bl = bl2;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)callExpression);
        }
        return bl;
    }

    private final boolean isSamConversion(KaSession $this$isSamConversion, KtCallExpression callExpression, UExpression argument) {
        KaType kaType = this.getParameterType($this$isSamConversion, callExpression, argument);
        if (kaType == null) {
            return false;
        }
        KaType type = kaType;
        return $this$isSamConversion.isFunctionalInterface(type);
    }

    private final KaType getParameterType(KaSession $this$getParameterType, KtCallExpression callExpression, UExpression argument) {
        KaCallInfo kaCallInfo = $this$getParameterType.resolveToCall((KtElement)callExpression);
        if (kaCallInfo == null || (kaCallInfo = KaCallInfoKt.singleFunctionCallOrNull((KaCallInfo)kaCallInfo)) == null) {
            return null;
        }
        KaCallInfo callInfo = kaCallInfo;
        Map mapping = callInfo.getArgumentMapping();
        KaVariableSignature kaVariableSignature = (KaVariableSignature)mapping.get(argument.getSourcePsi());
        if (kaVariableSignature == null && (kaVariableSignature = (KaVariableSignature)mapping.get(UastUtils.skipParenthesizedExprDown((UExpression)argument).getSourcePsi())) == null) {
            return null;
        }
        KaVariableSignature parameterSignature = kaVariableSignature;
        return parameterSignature.getReturnType();
    }

    private final boolean hasWordPrefix(String $this$hasWordPrefix, String prefix) {
        if (StringsKt.startsWith$default((String)$this$hasWordPrefix, (String)prefix, (boolean)false, (int)2, null)) {
            int length = prefix.length();
            return $this$hasWordPrefix.length() == length || Character.isUpperCase($this$hasWordPrefix.charAt(length));
        }
        return false;
    }

    private final boolean isRemoveMethodName(String $this$isRemoveMethodName) {
        if ($this$isRemoveMethodName == null) {
            return false;
        }
        return this.hasWordPrefix($this$isRemoveMethodName, "remove") || this.hasWordPrefix($this$isRemoveMethodName, "unregister") || this.hasWordPrefix($this$isRemoveMethodName, "stop");
    }

    private final String getPairedName(String methodName) {
        Object object;
        switch (methodName) {
            case "removeAll": 
            case "remove": {
                object = "add";
                break;
            }
            case "removeCallbacks": {
                object = "postDelayed";
                break;
            }
            case "unregister": {
                object = "register";
                break;
            }
            default: {
                if (StringsKt.startsWith$default((String)methodName, (String)"remove", (boolean)false, (int)2, null)) {
                    object = "add" + StringsKt.removePrefix((String)methodName, (CharSequence)"remove");
                    break;
                }
                if (StringsKt.startsWith$default((String)methodName, (String)"unregister", (boolean)false, (int)2, null)) {
                    String string = methodName.substring(2);
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    break;
                }
                object = StringsKt.startsWith$default((String)methodName, (String)"stop", (boolean)false, (int)2, null) ? "start" + StringsKt.removePrefix((String)methodName, (CharSequence)"stop") : "";
            }
        }
        String pairedName = object;
        return pairedName;
    }

    private final boolean isInstanceRemoval(PsiMethod method, PsiParameter parameter) {
        boolean bl;
        block6: {
            String string = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String methodName = string;
            String pairedName = this.getPairedName(methodName);
            if (StringsKt.endsWith$default((String)methodName, (String)"Listener", (boolean)false, (int)2, null)) {
                return true;
            }
            PsiClass psiClass = method.getContainingClass();
            PsiMethod[] methods = psiClass != null ? psiClass.findMethodsByName(pairedName, false) : null;
            PsiMethod[] psiMethodArray = methods;
            if (psiMethodArray == null || psiMethodArray.length == 0) {
                return false;
            }
            PsiType psiType = parameter.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
            PsiType samType = psiType;
            if (!(samType instanceof PsiClassType)) {
                return false;
            }
            PsiType samTypeErasure = samType;
            PsiMethod[] $this$any$iv = methods;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                boolean bl2;
                block5: {
                    PsiMethod element$iv;
                    PsiMethod it = element$iv = $this$any$iv[i];
                    boolean bl3 = false;
                    PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
                    Object[] $this$any$iv2 = psiParameterArray;
                    boolean $i$f$any2 = false;
                    for (Object element$iv2 : $this$any$iv2) {
                        PsiParameter parameter2 = (PsiParameter)element$iv2;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)parameter2);
                        if (!this.methodParameterMatches(samTypeErasure, parameter2)) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
                if (!bl2) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean methodParameterMatches(PsiType samType, PsiParameter parameter) {
        PsiType psiType = parameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
        PsiType parameterType = psiType;
        return Intrinsics.areEqual((Object)parameterType, (Object)samType);
    }

    private final LintFix createLambdaVariableFix(JavaContext context, UVariable declaration, String samType) {
        if (declaration != null) {
            String name = declaration.getName();
            UExpression initializer = declaration.getUastInitializer();
            if (initializer instanceof ULambdaExpression) {
                return this.fix().name("Explicitly create " + samType + " instance").replace().pattern(name + "(.*)\\{", 32).range(context.getLocation((UElement)declaration)).with(" = " + samType + " ").reformat(true).build();
            }
        }
        return null;
    }

    private final List<UExpression> findPostCalls(UClass container, String className, PsiElement variable) {
        List matches = new ArrayList();
        container.accept((UastVisitor)new AbstractUastVisitor(className, variable, matches){
            final /* synthetic */ String $className;
            final /* synthetic */ PsiElement $variable;
            final /* synthetic */ List<UExpression> $matches;
            {
                this.$className = $className;
                this.$variable = $variable;
                this.$matches = $matches;
            }

            public boolean visitCallExpression(UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiMethod psiMethod = node.resolve();
                if (psiMethod == null) {
                    return super.visitCallExpression(node);
                }
                PsiMethod resolved = psiMethod;
                String string = resolved.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.startsWith$default((String)string, (String)"post", (boolean)false, (int)2, null)) {
                    PsiClass psiClass = resolved.getContainingClass();
                    if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)this.$className)) {
                        PsiElement postedVariable;
                        UExpression posted;
                        UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)node.getValueArguments());
                        UExpression uExpression2 = posted = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
                        Object object = postedVariable = uExpression2 != null ? UastUtils.tryResolve((UElement)((UElement)uExpression2)) : null;
                        if (Intrinsics.areEqual((Object)postedVariable, (Object)this.$variable)) {
                            this.$matches.add(posted);
                        }
                    }
                }
                return super.visitCallExpression(node);
            }
        });
        return matches;
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        UFile uFile = context.getUastFile();
        if (uFile == null || (uFile = uFile.getSourcePsi()) == null) {
            return null;
        }
        UFile psi = uFile;
        Language language = psi.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        if (Lint.isJava((Language)language)) {
            return null;
        }
        return new UElementHandler(this, context){
            final /* synthetic */ SamDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void visitLambdaExpression(ULambdaExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UElement uElement = node.getUastParent();
                if (uElement == null) {
                    return;
                }
                UElement parent = uElement;
                if (parent instanceof ULocalVariable) {
                    PsiElement psiElement = parent.getSourcePsi();
                    Object object = psiElement instanceof PsiLocalVariable ? (PsiLocalVariable)psiElement : null;
                    if (object == null) {
                        UElement uElement2 = parent;
                        ULocalVariableEx uLocalVariableEx = uElement2 instanceof ULocalVariableEx ? (ULocalVariableEx)uElement2 : null;
                        object = uLocalVariableEx != null ? uLocalVariableEx.getJavaPsi() : null;
                        if (object == null) {
                            return;
                        }
                    }
                    PsiLocalVariable psiVar = object;
                    SamDetector.access$checkCalls(this.this$0, this.$context, node, psiVar);
                } else if (UastExpressionUtils.isAssignment((UElement)parent)) {
                    PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)((UBinaryExpression)parent).getLeftOperand()));
                    if (psiElement == null) {
                        return;
                    }
                    PsiElement v = psiElement;
                    PsiLocalVariable psiLocalVariable = v instanceof PsiLocalVariable ? (PsiLocalVariable)v : null;
                    if (psiLocalVariable == null) {
                        return;
                    }
                    PsiLocalVariable psiVar = psiLocalVariable;
                    SamDetector.access$checkCalls(this.this$0, this.$context, node, psiVar);
                }
            }

            public void visitCallableReferenceExpression(UCallableReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UElement uElement = node.getUastParent();
                UCallExpression uCallExpression = uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
                if (uCallExpression == null) {
                    return;
                }
                UCallExpression call = uCallExpression;
                SamDetector.access$checkLambda(this.this$0, this.$context, (UExpression)node, call, (UReferenceExpression)node);
            }

            public void visitCallExpression(UCallExpression node) {
                PsiMethod resolved;
                String name;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UIdentifier uIdentifier = node.getMethodIdentifier();
                String string = name = uIdentifier != null ? uIdentifier.getName() : null;
                if (SamDetector.access$isRemoveMethodName(this.this$0, name) && (resolved = node.resolve()) != null) {
                    SamDetector.access$checkRemoveMethod(this.this$0, this.$context, node, resolved);
                }
            }
        };
    }

    private final void checkCalls(JavaContext context, ULambdaExpression lambda, PsiLocalVariable variable) {
        UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)lambda));
        if (uMethod == null) {
            return;
        }
        UMethod method = uMethod;
        method.accept((UastVisitor)new AbstractUastVisitor(variable, this, context, lambda){
            final /* synthetic */ PsiLocalVariable $variable;
            final /* synthetic */ SamDetector this$0;
            final /* synthetic */ JavaContext $context;
            final /* synthetic */ ULambdaExpression $lambda;
            {
                this.$variable = $variable;
                this.this$0 = $receiver;
                this.$context = $context;
                this.$lambda = $lambda;
            }

            public boolean visitCallExpression(UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                for (UExpression argument : node.getValueArguments()) {
                    if (!(argument instanceof UReferenceExpression) || !Intrinsics.areEqual((Object)((UReferenceExpression)argument).resolve(), (Object)this.$variable)) continue;
                    SamDetector.access$checkLambda(this.this$0, this.$context, (UExpression)this.$lambda, node, (UReferenceExpression)argument);
                }
                return super.visitCallExpression(node);
            }
        });
    }

    private final void checkLambda(JavaContext context, UExpression lambda, UCallExpression call, UReferenceExpression argument) {
        PsiMethod psiMethod = call.resolve();
        if (psiMethod == null) {
            return;
        }
        PsiMethod psiMethod2 = psiMethod;
        JavaEvaluator evaluator = context.getEvaluator();
        if (psiMethod2 instanceof PsiCompiledElement) {
            PsiClass containingClass = psiMethod2.getContainingClass();
            if (this.isRemoveMethodName(psiMethod2.getName()) && (evaluator.isMemberInClass((PsiMember)psiMethod2, HANDLER_CLASS) || evaluator.inheritsFrom(containingClass, "android.view.View", false) || evaluator.inheritsFrom(containingClass, "android.view.ViewTreeObserver", false) || evaluator.inheritsFrom(containingClass, DRAWABLE_CALLBACK_CLASS, false))) {
                PsiParameter psiParameter = UastUtils.getParameterForArgument((UCallExpression)call, (UExpression)lambda);
                if (psiParameter == null) {
                    return;
                }
                PsiParameter psiParameter2 = psiParameter;
                String string = psiParameter2.getType().getCanonicalText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
                String typeString2 = string;
                if (Intrinsics.areEqual((Object)typeString2, (Object)RUNNABLE_CLASS)) {
                    this.reportError(context, lambda, typeString2, argument);
                }
            }
            return;
        }
        Language language = psiMethod2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        if (!Lint.isJava((Language)language) || !this.isSamConversion(call, (UExpression)argument)) {
            return;
        }
        PsiParameter psiParameter = UastUtils.getParameterForArgument((UCallExpression)call, (UExpression)((UExpression)argument));
        if (psiParameter == null) {
            return;
        }
        PsiParameter psiParameter3 = psiParameter;
        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)((PsiElement)psiMethod2), UMethod.class);
        if (uMethod == null) {
            return;
        }
        UMethod method = uMethod;
        if (this.instanceComparesLambda(method, psiParameter3) && !context.getDriver().isSuppressed(context, ISSUE, (UElement)method)) {
            String string = psiParameter3.getType().getCanonicalText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalText(...)");
            String typeString3 = string;
            this.reportError(context, lambda, typeString3, argument);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void reportError(JavaContext context, UExpression lambda, String type, UReferenceExpression argument) {
        block3: {
            block2: {
                location = context.getLocation((UElement)argument);
                simpleType = StringsKt.substringBefore$default((String)StringsKt.substringAfterLast$default((String)type, (char)'.', null, (int)2, null), (String)"<", null, (int)2, null);
                range = context.getLocation((UElement)lambda);
                $this$getParentOfType_u24default$iv = (UElement)argument;
                strict$iv = true;
                $i$f$getParentOfType = false;
                parentVar = (UVariable)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UVariable.class, (boolean)strict$iv);
                if (!(lambda instanceof ULambdaExpression)) break block2;
                if (parentVar == null) ** GOTO lbl-1000
                v0 = parentVar.getUastInitializer();
                if (Intrinsics.areEqual((Object)(v0 != null ? UastUtils.skipParenthesizedExprDown((UExpression)v0) : null), (Object)lambda)) {
                    v1 = this.createLambdaVariableFix(context, parentVar, simpleType);
                } else lbl-1000:
                // 2 sources

                {
                    v1 = this.fix().name("Explicitly create " + simpleType + " instance").replace().beginning().with(simpleType + " ").range(range).build();
                }
                break block3;
            }
            v1 = null;
        }
        fix = v1;
        context.report(SamDetector.ISSUE, (UElement)argument, location, "Implicit new `" + simpleType + "` instance being passed to method which ends up checking instance equality; this can lead to subtle bugs", fix);
    }

    private final boolean instanceComparesLambda(UMethod method, PsiParameter parameter) {
        Ref.BooleanRef storesLambda = new Ref.BooleanRef();
        method.accept((UastVisitor)new AbstractUastVisitor(parameter, this, storesLambda){
            final /* synthetic */ PsiParameter $parameter;
            final /* synthetic */ SamDetector this$0;
            final /* synthetic */ Ref.BooleanRef $storesLambda;
            {
                this.$parameter = $parameter;
                this.this$0 = $receiver;
                this.$storesLambda = $storesLambda;
            }

            public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement resolved = node.resolve();
                if (Intrinsics.areEqual((Object)resolved, (Object)this.$parameter)) {
                    UastBinaryOperator kind;
                    UElement parent = node.getUastParent();
                    if (parent instanceof UCallExpression) {
                        String methodName = ((UCallExpression)parent).getMethodName();
                        if (SamDetector.access$isRemoveMethodName(this.this$0, methodName)) {
                            this.$storesLambda.element = true;
                        }
                    } else if (parent instanceof UBinaryExpression && (Intrinsics.areEqual((Object)(kind = ((UBinaryExpression)parent).getOperator()), (Object)UastBinaryOperator.IDENTITY_EQUALS) || Intrinsics.areEqual((Object)kind, (Object)UastBinaryOperator.IDENTITY_NOT_EQUALS)) && !UastLiteralUtils.isNullLiteral((UElement)((UElement)((UBinaryExpression)parent).getRightOperand()))) {
                        this.$storesLambda.element = true;
                    }
                }
                return super.visitSimpleNameReferenceExpression(node);
            }
        });
        return storesLambda.element;
    }

    public static final /* synthetic */ void access$checkCalls(SamDetector $this, JavaContext context, ULambdaExpression lambda, PsiLocalVariable variable) {
        $this.checkCalls(context, lambda, variable);
    }

    public static final /* synthetic */ void access$checkLambda(SamDetector $this, JavaContext context, UExpression lambda, UCallExpression call, UReferenceExpression argument) {
        $this.checkLambda(context, lambda, call, argument);
    }

    public static final /* synthetic */ boolean access$isRemoveMethodName(SamDetector $this, String $receiver) {
        return $this.isRemoveMethodName($receiver);
    }

    public static final /* synthetic */ void access$checkRemoveMethod(SamDetector $this, JavaContext context, UCallExpression node, PsiMethod method) {
        $this.checkRemoveMethod(context, node, method);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(SamDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"ImplicitSamInstance", (String)"Implicit SAM Instances", (String)"\n          Kotlin's support for SAM (single abstract method) interfaces lets you pass \\\n          a lambda to the interface. This will create a new instance on the fly even \\\n          though there is no explicit constructor call. If you pass one of these \\\n          lambdas or method references into a method which (for example) stores or \\\n          compares the object identity, unexpected results may happen.\n\n          In particular, passing a lambda variable in as a listener, and then later \\\n          attempting to remove the listener will not work because a different \\\n          instance is passed in.\n          ", (Implementation)implementation, (String)"https://kotlinlang.org/docs/fun-interfaces.html#sam-conversions", (Category)category, (int)6, (Severity)severity, (boolean)false, null, null, null, (int)3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/SamDetector$Issues;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "HANDLER_CLASS", "", "DRAWABLE_CALLBACK_CLASS", "RUNNABLE_CLASS", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

