/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnalysisApiLintUtilsKt;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaImplicitReceiverValue;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/BuildListDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Issues", "lint-checks"})
@SourceDebugExtension(value={"SMAP\nBuildListDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildListDetector.kt\ncom/android/tools/lint/checks/BuildListDetector\n+ 2 JavaEvaluator.kt\ncom/android/tools/lint/client/api/JavaEvaluator\n*L\n1#1,131:1\n128#2,5:132\n*S KotlinDebug\n*F\n+ 1 BuildListDetector.kt\ncom/android/tools/lint/checks/BuildListDetector\n*L\n73#1:132,5\n*E\n"})
public final class BuildListDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(BuildListDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("BuildListAdds", "Missing `add` call in `buildList`", "\n          The `buildList { }` standard library function is a convenient way to \\\n          build lists, but you need to actually call `add` on the items.\n          ", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);
    @NotNull
    private static final String BUILD_LIST_OWNER_CLASS_PART = "kotlin.collections.CollectionsKt__CollectionsKt";
    @NotNull
    private static final String BUILD_LIST_OWNER_FACADE = "kotlin.collections.CollectionsKt";

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"buildList");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        JavaEvaluator evaluator = context.getEvaluator();
        if (node.getValueArgumentCount() == 1) {
            Object fqName;
            Object containingClass$iv;
            boolean bl;
            JavaEvaluator this_$iv = evaluator;
            boolean $i$f$isMemberInClass = false;
            PsiMember cfr_ignored_0 = (PsiMember)method;
            Object object = ((PsiMember)method).getContainingClass();
            if (object == null || (object = object.getQualifiedName()) == null) {
                bl = false;
            } else {
                fqName = containingClass$iv = object;
                boolean bl2 = false;
                bl = Intrinsics.areEqual((Object)fqName, (Object)BUILD_LIST_OWNER_CLASS_PART) || Intrinsics.areEqual((Object)fqName, (Object)BUILD_LIST_OWNER_FACADE);
            }
            if (bl) {
                containingClass$iv = node.getValueArguments().get(0);
                ULambdaExpression uLambdaExpression = containingClass$iv instanceof ULambdaExpression ? (ULambdaExpression)containingClass$iv : null;
                if (uLambdaExpression == null) {
                    return;
                }
                ULambdaExpression argument = uLambdaExpression;
                fqName = argument.getSourcePsi();
                KtLambdaExpression ktLambdaExpression = fqName instanceof KtLambdaExpression ? (KtLambdaExpression)fqName : null;
                if (ktLambdaExpression == null) {
                    return;
                }
                KtLambdaExpression lambda = ktLambdaExpression;
                Ref.BooleanRef isAdding = new Ref.BooleanRef();
                KtFunctionLiteral ktFunctionLiteral = lambda.getFunctionLiteral();
                Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
                KtFunctionLiteral literal = ktFunctionLiteral;
                lambda.accept((PsiElementVisitor)new KtTreeVisitor<Void>(literal, isAdding){
                    final /* synthetic */ KtFunctionLiteral $literal;
                    final /* synthetic */ Ref.BooleanRef $isAdding;
                    {
                        this.$literal = $literal;
                        this.$isAdding = $isAdding;
                    }

                    public Void visitCallExpression(KtCallExpression expression, Void data) {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        this.checkImplicitReceiver((KtExpression)expression);
                        return (Void)super.visitCallExpression(expression, (Object)data);
                    }

                    public Void visitDoubleColonExpression(KtDoubleColonExpression expression, Void data) {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        this.checkImplicitReceiver((KtExpression)expression);
                        return (Void)super.visitDoubleColonExpression(expression, (Object)data);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    private final void checkImplicitReceiver(KtExpression ktExpression) {
                        void this_$iv$iv;
                        KtFunctionLiteral ktFunctionLiteral = this.$literal;
                        Ref.BooleanRef booleanRef = this.$isAdding;
                        boolean $i$f$analyze = false;
                        Project project = ((KtElement)ktExpression).getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                        boolean $i$f$analyze2 = false;
                        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)ktExpression);
                        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)ktExpression);
                        try {
                            Unit unit;
                            Object lock$iv$iv;
                            Object object = lock$iv$iv = new Object();
                            synchronized (object) {
                                PsiElement psi;
                                KaImplicitReceiverValue receiverVal;
                                boolean bl = false;
                                KaSession $this$checkImplicitReceiver_u24lambda_u240 = analysisSession$iv$iv;
                                boolean bl2 = false;
                                KaImplicitReceiverValue kaImplicitReceiverValue = receiverVal = AnalysisApiLintUtilsKt.getImplicitReceiverValue($this$checkImplicitReceiver_u24lambda_u240, ktExpression);
                                Object object2 = psi = kaImplicitReceiverValue != null ? AnalysisApiLintUtilsKt.getImplicitReceiverPsi(kaImplicitReceiverValue) : null;
                                if (Intrinsics.areEqual((Object)psi, (Object)ktFunctionLiteral)) {
                                    booleanRef.element = true;
                                }
                                unit = Unit.INSTANCE;
                            }
                            Unit unit2 = unit;
                        }
                        finally {
                            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)ktExpression);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public Void visitThisExpression(KtThisExpression expression, Void data) {
                        void this_$iv$iv;
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        KtFunctionLiteral ktFunctionLiteral = this.$literal;
                        Ref.BooleanRef booleanRef = this.$isAdding;
                        boolean $i$f$analyze = false;
                        Project project = ((KtElement)expression).getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                        boolean $i$f$analyze2 = false;
                        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)expression);
                        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)expression);
                        try {
                            Unit unit;
                            Object lock$iv$iv;
                            Object object = lock$iv$iv = new Object();
                            synchronized (object) {
                                PsiElement psi;
                                KtReference ktReference;
                                boolean bl = false;
                                KaSession $this$visitThisExpression_u24lambda_u241 = analysisSession$iv$iv;
                                boolean bl2 = false;
                                KtSimpleNameExpression ktSimpleNameExpression = expression.getTargetLabel();
                                if (ktSimpleNameExpression != null && (ktSimpleNameExpression = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)ktSimpleNameExpression)) != null) {
                                    ktReference = (KtReference)ktSimpleNameExpression;
                                } else {
                                    KtReferenceExpression ktReferenceExpression = expression.getInstanceReference();
                                    Intrinsics.checkNotNullExpressionValue((Object)ktReferenceExpression, (String)"getInstanceReference(...)");
                                    ktReference = ReferenceUtilsKt.getMainReference((KtReferenceExpression)ktReferenceExpression);
                                }
                                KtReference reference = ktReference;
                                KaSymbol kaSymbol = $this$visitThisExpression_u24lambda_u241.resolveToSymbol(reference);
                                Object object2 = psi = kaSymbol != null ? kaSymbol.getPsi() : null;
                                if (Intrinsics.areEqual((Object)psi, (Object)ktFunctionLiteral)) {
                                    booleanRef.element = true;
                                }
                                unit = Unit.INSTANCE;
                            }
                            Unit unit2 = unit;
                        }
                        finally {
                            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)expression);
                        }
                        return (Void)super.visitThisExpression(expression, (Object)data);
                    }
                });
                if (!isAdding.element) {
                    String message2 = "No `add` calls within `buildList` lambda; this is usually a mistake";
                    JavaContext.report$default((JavaContext)context, (Issue)ISSUE, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)message2, null, (int)16, null);
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/lint/checks/BuildListDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "BUILD_LIST_OWNER_CLASS_PART", "", "BUILD_LIST_OWNER_FACADE", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

