/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/ByteOrderMarkDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/GradleScanner;", "<init>", "()V", "beforeCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "visitDocument", "Lcom/android/tools/lint/detector/api/XmlContext;", "document", "Lorg/w3c/dom/Document;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "Lcom/android/tools/lint/detector/api/JavaContext;", "run", "customVisitor", "", "getCustomVisitor", "()Z", "Issues", "lint-checks"})
public final class ByteOrderMarkDetector
extends ResourceXmlDetector
implements SourceCodeScanner,
GradleScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @JvmField
    @NotNull
    public static final Issue BOM;

    public void beforeCheckFile(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context instanceof XmlContext && ((XmlContext)context).getResourceFolderType() == ResourceFolderType.RAW) {
            return;
        }
        CharSequence charSequence = context.getContents();
        if (charSequence == null) {
            return;
        }
        CharSequence source = charSequence;
        int max = source.length();
        for (int i = 1; i < max; ++i) {
            char c = source.charAt(i);
            if (c != '\ufeff') continue;
            Location location = Location.Companion.create(context.file, source, i, i + 1);
            String message2 = "Found byte-order-mark in the middle of a file";
            if (context instanceof XmlContext) {
                Node leaf = ((XmlContext)context).getParser().findNodeAt((XmlContext)context, i);
                if (leaf != null) {
                    XmlContext.report$default((XmlContext)((XmlContext)context), (Issue)BOM, (Node)leaf, (Location)location, (String)message2, null, (int)16, null);
                    continue;
                }
            } else if (context instanceof JavaContext) {
                PsiElement psi;
                UFile file;
                UFile uFile = file = ((JavaContext)context).getUastFile();
                Object object = psi = uFile != null ? uFile.getJavaPsi() : null;
                if (psi != null) {
                    PsiElement closest = psi.findElementAt(i);
                    if (closest == null && !((Collection)file.getClasses()).isEmpty()) {
                        closest = (PsiElement)file.getClasses().get(0);
                    }
                    if (closest != null) {
                        JavaContext.report$default((JavaContext)((JavaContext)context), (Issue)BOM, (PsiElement)closest, (Location)location, (String)message2, null, (int)16, null);
                        continue;
                    }
                }
            }
            Context.report$default((Context)context, (Issue)BOM, (Location)location, (String)message2, null, (int)8, null);
        }
    }

    public void visitDocument(@NotNull XmlContext context, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return null;
    }

    public void run(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    public boolean getCustomVisitor() {
        return true;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.I18N;
        Severity severity = Severity.ERROR;
        Object[] objectArray = new Scope[]{Scope.RESOURCE_FILE, Scope.JAVA_FILE, Scope.GRADLE_FILE, Scope.PROPERTY_FILE, Scope.PROGUARD_FILE};
        EnumSet<Enum[]> enumSet = EnumSet.of((Enum)Scope.MANIFEST, (Enum[])objectArray);
        objectArray = new EnumSet[]{Scope.RESOURCE_FILE_SCOPE, Scope.JAVA_FILE_SCOPE, Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE, Scope.GRADLE_SCOPE, Scope.PROPERTY_SCOPE, Scope.PROGUARD_SCOPE};
        Implementation implementation = new Implementation(ByteOrderMarkDetector.class, enumSet, (EnumSet[])objectArray);
        BOM = Issue.Companion.create$default((Issue.Companion)companion, (String)"ByteOrderMark", (String)"Byte order mark inside files", (String)"\n            Lint will flag any byte-order-mark (BOM) characters it finds in the middle of a file. Since we \\\n            expect files to be encoded with UTF-8 (see the EnforceUTF8 issue), the BOM characters are not \\\n            necessary, and they are not handled correctly by all tools. For example, if you have a BOM as \\\n            part of a resource name in one particular translation, that name will not be considered identical \\\n            to the base resource's name and the translation will not be used.", (Implementation)implementation, (String)"https://en.wikipedia.org/wiki/Byte_order_mark", (Category)category, (int)8, (Severity)severity, (boolean)false, null, null, null, (int)3840, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/ByteOrderMarkDetector$Issues;", "", "<init>", "()V", "BOM", "Lcom/android/tools/lint/detector/api/Issue;", "lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

