/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.FloatRangeConstraint;
import com.android.tools.lint.checks.RangeConstraint;
import com.android.tools.lint.detector.api.UastLintUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0010\u0018\u0000 #2\u00020\u0001:\u0001#B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0014J\u0015\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0014H\u0016J\u0013\u0010\u001d\u001a\u00020\u00012\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0004J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001e\u001a\u00020\u0001H\u0016J\b\u0010 \u001a\u00020\u0014H\u0016J\u0017\u0010!\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\u0001H\u0016\u00a2\u0006\u0002\u0010\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0010\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/checks/IntRangeConstraint;", "Lcom/android/tools/lint/checks/RangeConstraint;", "from", "", "to", "<init>", "(JJ)V", "range", "Lcom/android/tools/lint/checks/FloatRangeConstraint;", "(Lcom/android/tools/lint/checks/FloatRangeConstraint;)V", "getFrom", "()J", "getTo", "isValid", "", "value", "infinite", "getInfinite", "()Z", "describe", "", "actualValue", "(Ljava/lang/Long;)Ljava/lang/String;", "prefix", "(Ljava/lang/Long;Ljava/lang/String;)Ljava/lang/String;", "describeDelta", "actual", "actualLabel", "allowedLabel", "and", "other", "remove", "toString", "contains", "(Lcom/android/tools/lint/checks/RangeConstraint;)Ljava/lang/Boolean;", "Companion", "lint-checks"})
public final class IntRangeConstraint
extends RangeConstraint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long from;
    private final long to;

    private IntRangeConstraint(long from, long to) {
        this.from = from;
        this.to = to;
    }

    public final long getFrom() {
        return this.from;
    }

    public final long getTo() {
        return this.to;
    }

    public IntRangeConstraint(@NotNull FloatRangeConstraint range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(range.getFrom() == Double.NEGATIVE_INFINITY ? Long.MIN_VALUE : (!range.getFromInclusive() ? (long)range.getFrom() + 1L : (long)range.getFrom()), range.getTo() == Double.POSITIVE_INFINITY ? Long.MAX_VALUE : (!range.getToInclusive() ? (long)range.getTo() - 1L : (long)range.getTo()));
    }

    public final boolean isValid(long value) {
        long l = this.from;
        return value <= this.to ? l <= value : false;
    }

    @Override
    public boolean getInfinite() {
        return this.from == Long.MIN_VALUE || this.to == Long.MAX_VALUE;
    }

    @NotNull
    public final String describe() {
        return this.describe(null);
    }

    @NotNull
    public final String describe(@Nullable Long actualValue) {
        return this.describe(actualValue, "Value must be ");
    }

    @NotNull
    public final String describe(@Nullable Long actualValue, @NotNull String prefix) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        StringBuilder sb = new StringBuilder(20);
        sb.append(prefix);
        if (actualValue != null && !this.isValid(actualValue)) {
            StringBuilder stringBuilder2;
            long value = actualValue;
            if (value < this.from) {
                sb.append("\u2265 ");
                stringBuilder2 = sb.append(String.valueOf(this.from));
            } else {
                boolean bl;
                boolean bl2 = bl = value > this.to;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                sb.append("\u2264 ");
                stringBuilder2 = sb.append(String.valueOf(this.to));
            }
            sb.append(" (was ").append(value).append(')');
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        if (this.to == Long.MAX_VALUE) {
            sb.append("\u2265 ");
            stringBuilder = sb.append(String.valueOf(this.from));
        } else if (this.from == Long.MIN_VALUE) {
            sb.append("\u2264 ");
            stringBuilder = sb.append(String.valueOf(this.to));
        } else if (this.from == this.to) {
            stringBuilder = sb.append(String.valueOf(this.from));
        } else {
            sb.append("\u2265 ");
            sb.append(String.valueOf(this.from));
            sb.append(" and \u2264 ");
            sb.append(String.valueOf(this.to));
            if (this.from > this.to) {
                sb.append(" (not possible)");
            }
            stringBuilder = Unit.INSTANCE;
        }
        if (actualValue != null) {
            sb.append(" (is ").append(actualValue).append(')');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String describeDelta(@NotNull RangeConstraint actual, @NotNull String actualLabel, @NotNull String allowedLabel) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)actualLabel, (String)"actualLabel");
        Intrinsics.checkNotNullParameter((Object)allowedLabel, (String)"allowedLabel");
        if (!(actual instanceof IntRangeConstraint)) {
            return actual instanceof FloatRangeConstraint ? this.describeDelta(new IntRangeConstraint((FloatRangeConstraint)actual), actualLabel, allowedLabel) : this.describe();
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder stringBuilder2 = ((CharSequence)allowedLabel).length() > 0 ? sb.append(this.describe(null, allowedLabel + " must be ")) : sb.append(this.describe(null));
        sb.append(" but ");
        if (((CharSequence)actualLabel).length() > 0) {
            sb.append(actualLabel).append(' ');
        }
        if (((IntRangeConstraint)actual).from < this.from) {
            stringBuilder = ((IntRangeConstraint)actual).from == Long.MIN_VALUE ? sb.append("can be < " + this.from) : sb.append("can be " + ((IntRangeConstraint)actual).from);
        } else if (((IntRangeConstraint)actual).to > this.to) {
            stringBuilder = ((IntRangeConstraint)actual).to == Long.MAX_VALUE ? sb.append("can be > " + this.to) : sb.append("can be " + ((IntRangeConstraint)actual).to);
        } else {
            throw new IllegalStateException("There's no delta".toString());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public RangeConstraint and(@Nullable RangeConstraint other) {
        IntRangeConstraint intRangeConstraint;
        if (other == null) {
            return this;
        }
        RangeConstraint rangeConstraint = other;
        if (rangeConstraint instanceof IntRangeConstraint) {
            intRangeConstraint = (IntRangeConstraint)other;
        } else if (rangeConstraint instanceof FloatRangeConstraint) {
            intRangeConstraint = new IntRangeConstraint((FloatRangeConstraint)other);
        } else {
            String string = other.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = string;
            throw new IllegalStateException(string2.toString());
        }
        IntRangeConstraint range = intRangeConstraint;
        long start = Math.max(this.from, range.from);
        long end = Math.min(this.to, range.to);
        return new IntRangeConstraint(start, end);
    }

    @Override
    @Nullable
    public RangeConstraint remove(@NotNull RangeConstraint other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other instanceof IntRangeConstraint) {
            if (this.from <= ((IntRangeConstraint)other).to) {
                if (((IntRangeConstraint)other).to != Long.MAX_VALUE && this.to > ((IntRangeConstraint)other).to + 1L) {
                    return new IntRangeConstraint(((IntRangeConstraint)other).to + 1L, this.to);
                }
                if (((IntRangeConstraint)other).from != Long.MAX_VALUE && this.from < ((IntRangeConstraint)other).from - 1L) {
                    return new IntRangeConstraint(this.from, ((IntRangeConstraint)other).from - 1L);
                }
            }
        } else if (other instanceof FloatRangeConstraint) {
            return new FloatRangeConstraint(this).remove(other);
        }
        return super.remove(other);
    }

    @NotNull
    public String toString() {
        return this.describe(null);
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull RangeConstraint other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other instanceof IntRangeConstraint) {
            return ((IntRangeConstraint)other).from >= this.from && ((IntRangeConstraint)other).to <= this.to;
        }
        if (other instanceof FloatRangeConstraint) {
            if (!((FloatRangeConstraint)other).getFromInclusive() && ((FloatRangeConstraint)other).getFrom() == (double)this.from || !((FloatRangeConstraint)other).getToInclusive() && ((FloatRangeConstraint)other).getTo() == (double)this.to) {
                return false;
            }
            if (((FloatRangeConstraint)other).getTo() > (double)this.to && (!Double.isInfinite(((FloatRangeConstraint)other).getTo()) || this.to != Long.MAX_VALUE)) {
                return false;
            }
            return !(((FloatRangeConstraint)other).getFrom() < (double)this.from) || Double.isInfinite(((FloatRangeConstraint)other).getFrom()) && this.from == Long.MIN_VALUE;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final IntRangeConstraint create(@NotNull UAnnotation annotation) {
        return Companion.create(annotation);
    }

    @JvmStatic
    @NotNull
    public static final IntRangeConstraint atLeast(long value) {
        return Companion.atLeast(value);
    }

    @JvmStatic
    @NotNull
    public static final IntRangeConstraint atMost(long value) {
        return Companion.atMost(value);
    }

    @JvmStatic
    @NotNull
    public static final IntRangeConstraint range(long from, long to) {
        return Companion.range(from, to);
    }

    public /* synthetic */ IntRangeConstraint(long from, long to, DefaultConstructorMarker $constructor_marker) {
        this(from, to);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/IntRangeConstraint$Companion;", "", "<init>", "()V", "create", "Lcom/android/tools/lint/checks/IntRangeConstraint;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "atLeast", "value", "", "atMost", "range", "from", "to", "lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IntRangeConstraint create(@NotNull UAnnotation annotation) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            boolean bl = AnnotationDetectorKt.INT_RANGE_ANNOTATION.isEquals(annotation.getQualifiedName());
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            long from = UastLintUtils.Companion.getAnnotationLongValue(annotation, "from", Long.MIN_VALUE);
            long to = UastLintUtils.Companion.getAnnotationLongValue(annotation, "to", Long.MAX_VALUE);
            return new IntRangeConstraint(from, to, null);
        }

        @JvmStatic
        @NotNull
        public final IntRangeConstraint atLeast(long value) {
            return new IntRangeConstraint(value, Long.MAX_VALUE, null);
        }

        @JvmStatic
        @NotNull
        public final IntRangeConstraint atMost(long value) {
            return new IntRangeConstraint(Long.MIN_VALUE, value, null);
        }

        @JvmStatic
        @NotNull
        public final IntRangeConstraint range(long from, long to) {
            return new IntRangeConstraint(from, to, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

