/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.gradle.api;

import com.android.tools.lint.gradle.api.DelegatingClassLoader;
import com.android.tools.lint.gradle.api.ExtractAnnotationRequest;
import com.android.tools.lint.gradle.api.LintExecutionRequest;
import com.google.common.base.Throwables;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.invocation.Gradle;
import org.gradle.initialization.BuildCompletionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ$\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/gradle/api/ReflectiveLintRunner;", "", "()V", "extractAnnotations", "", "gradle", "Lorg/gradle/api/invocation/Gradle;", "request", "Lcom/android/tools/lint/gradle/api/ExtractAnnotationRequest;", "lintClassPath", "", "Ljava/io/File;", "runLint", "Lcom/android/tools/lint/gradle/api/LintExecutionRequest;", "wrapExceptionAsString", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "t", "", "Companion", "ExtractErrorException", "lint-gradle-api"})
public final class ReflectiveLintRunner {
    @Nullable
    private static DelegatingClassLoader loader;
    private static boolean buildCompletionListenerRegistered;
    public static final Companion Companion;

    public final void runLint(@NotNull Gradle gradle, @NotNull LintExecutionRequest request, @NotNull Set<? extends File> lintClassPath) {
        Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(lintClassPath, (String)"lintClassPath");
        try {
            ClassLoader loader = ReflectiveLintRunner.Companion.getLintClassLoader(gradle, lintClassPath);
            Class<?> cls = loader.loadClass("com.android.tools.lint.gradle.LintGradleExecution");
            Constructor<?> constructor = cls.getConstructor(LintExecutionRequest.class);
            Object driver = constructor.newInstance(request);
            Method analyzeMethod = driver.getClass().getDeclaredMethod("analyze", new Class[0]);
            analyzeMethod.invoke(driver, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof GradleException) {
                Throwable throwable = e.getTargetException();
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"e.targetException");
                throw throwable;
            }
            throw (Throwable)this.wrapExceptionAsString(e);
        }
        catch (Throwable t) {
            throw (Throwable)this.wrapExceptionAsString(t);
        }
    }

    public final void extractAnnotations(@NotNull Gradle gradle, @NotNull ExtractAnnotationRequest request, @NotNull Set<? extends File> lintClassPath) {
        Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(lintClassPath, (String)"lintClassPath");
        try {
            ClassLoader loader = ReflectiveLintRunner.Companion.getLintClassLoader(gradle, lintClassPath);
            Class<?> cls = loader.loadClass("com.android.tools.lint.gradle.LintExtractAnnotations");
            Object driver = cls.newInstance();
            Method analyzeMethod = driver.getClass().getDeclaredMethod("extractAnnotations", ExtractAnnotationRequest.class);
            analyzeMethod.invoke(driver, request);
        }
        catch (ExtractErrorException e) {
            throw (Throwable)new GradleException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof GradleException) {
                Throwable throwable = e.getTargetException();
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"e.targetException");
                throw throwable;
            }
            throw (Throwable)this.wrapExceptionAsString(e);
        }
        catch (Throwable t) {
            throw (Throwable)this.wrapExceptionAsString(t);
        }
    }

    private final RuntimeException wrapExceptionAsString(Throwable t) {
        return new RuntimeException("Lint infrastructure error\nCaused by: " + Throwables.getStackTraceAsString((Throwable)t) + '\n');
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/gradle/api/ReflectiveLintRunner$ExtractErrorException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "lint-gradle-api"})
    public static final class ExtractErrorException
    extends RuntimeException {
        @NotNull
        private final String message;

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        public ExtractErrorException(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            super(message);
            this.message = message;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u001e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/gradle/api/ReflectiveLintRunner$Companion;", "", "()V", "buildCompletionListenerRegistered", "", "loader", "Lcom/android/tools/lint/gradle/api/DelegatingClassLoader;", "getLoader", "()Lcom/android/tools/lint/gradle/api/DelegatingClassLoader;", "setLoader", "(Lcom/android/tools/lint/gradle/api/DelegatingClassLoader;)V", "computeUrlsFallback", "", "Ljava/net/URL;", "lintClassPath", "", "Ljava/io/File;", "computeUrlsFromClassLoaderDelta", "getLibrary", "", "uri", "Ljava/net/URI;", "getLintClassLoader", "Ljava/lang/ClassLoader;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "lint-gradle-api"})
    public static final class Companion {
        @Nullable
        public final DelegatingClassLoader getLoader() {
            return loader;
        }

        public final void setLoader(@Nullable DelegatingClassLoader delegatingClassLoader) {
            loader = delegatingClassLoader;
        }

        /*
         * WARNING - void declaration
         */
        private final ClassLoader getLintClassLoader(Gradle gradle, Set<? extends File> lintClassPath) {
            void l;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = this.getLoader();
            if ((DelegatingClassLoader)l.element == null) {
                URL[] uRLArray;
                void $receiver$iv;
                List<URL> list = this.computeUrlsFromClassLoaderDelta(lintClassPath);
                if (list == null) {
                    list = this.computeUrlsFallback(lintClassPath);
                }
                List<URL> urls = list;
                Collection collection = urls;
                void var8_6 = l;
                void v1 = $receiver$iv;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                void thisCollection$iv = v1;
                URL[] uRLArray2 = thisCollection$iv.toArray(new URL[0]);
                if (uRLArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                URL[] uRLArray3 = uRLArray = uRLArray2;
                var8_6.element = new DelegatingClassLoader(uRLArray3);
                this.setLoader((DelegatingClassLoader)l.element);
            }
            if (!buildCompletionListenerRegistered) {
                buildCompletionListenerRegistered = true;
                gradle.addListener((Object)new BuildCompletionListener((Ref.ObjectRef)l){
                    final /* synthetic */ Ref.ObjectRef $l;

                    public final void completed() {
                        Class<?> cls = ((DelegatingClassLoader)this.$l.element).loadClass("com.android.tools.lint.LintCoreApplicationEnvironment");
                        Method disposeMethod = cls.getDeclaredMethod("disposeApplicationEnvironment", new Class[0]);
                        disposeMethod.invoke(null, new Object[0]);
                        ReflectiveLintRunner.access$setBuildCompletionListenerRegistered$cp(false);
                    }
                    {
                        this.$l = objectRef;
                    }
                });
            }
            return (DelegatingClassLoader)l.element;
        }

        private final List<URL> computeUrlsFromClassLoaderDelta(Set<? extends File> lintClassPath) {
            String name;
            Object object;
            Object uri;
            HashMap uriMap = new HashMap(2 * lintClassPath.size());
            Iterable $receiver$iv = lintClassPath;
            for (Object element$iv : $receiver$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                uri = it.toURI();
                URI uRI = uri;
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"uri");
                if (Companion.getLibrary(uRI) == null) {
                    return null;
                }
                object = uriMap;
                URI uRI2 = uri;
                object.put(name, uRI2);
            }
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (!(classLoader instanceof URLClassLoader)) {
                classLoader = null;
            }
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
            if (uRLClassLoader == null) {
                return null;
            }
            URLClassLoader gradleClassLoader = uRLClassLoader;
            Object object2 = gradleClassLoader.getURLs();
            int n = ((URL[])object2).length;
            for (int element$iv = 0; element$iv < n; ++element$iv) {
                URL url = object2[element$iv];
                uri = url.toURI();
                URI uRI = uri;
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"uri");
                if (this.getLibrary(uRI) == null) {
                    return null;
                }
                uriMap.remove(name);
            }
            ArrayList<URL> urls = new ArrayList<URL>(uriMap.size());
            boolean seenLint = false;
            uri = uriMap;
            Iterator iterator = uri.entrySet().iterator();
            while (iterator.hasNext()) {
                object = object2 = iterator.next();
                String name2 = (String)object.getKey();
                object = object2;
                URI uri2 = (URI)object.getValue();
                if (StringsKt.startsWith$default((String)name2, (String)"lint-api", (boolean)false, (int)2, null)) {
                    seenLint = true;
                } else if (StringsKt.startsWith$default((String)name2, (String)"builder-model", (boolean)false, (int)2, null)) {
                    return null;
                }
                urls.add(uri2.toURL());
            }
            if (!seenLint) {
                return null;
            }
            return urls;
        }

        private final String getLibrary(URI uri) {
            String path = uri.getPath();
            String string = uri.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri.path");
            int index = StringsKt.lastIndexOf$default((CharSequence)string, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (index == -1) {
                return null;
            }
            String string2 = path;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
            int dash = StringsKt.indexOf$default((CharSequence)string2, (char)'-', (int)index, (boolean)false, (int)4, null);
            while (dash != -1 && dash < path.length()) {
                char c = path.charAt(dash + 1);
                if (Character.isDigit(c)) {
                    String string3 = path;
                    int n = index + 1;
                    String string4 = string3.substring(n, dash);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    return string4;
                }
                dash = StringsKt.indexOf$default((CharSequence)path, (char)'-', (int)(dash + 1), (boolean)false, (int)4, null);
            }
            String string5 = path;
            int n = index + 1;
            int n2 = dash != -1 ? dash : path.length();
            String string6 = string5.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string6;
        }

        private final List<URL> computeUrlsFallback(Set<? extends File> lintClassPath) {
            List urls = new ArrayList();
            for (File file : lintClassPath) {
                String name;
                String string = name = file.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                if (!StringsKt.startsWith$default((String)string, (String)"uast-", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"intellij-core-", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"kotlin-compiler-", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"asm-", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"kxml2-", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"trove4j-", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"groovy-all-", (boolean)false, (int)2, null) && (!StringsKt.startsWith$default((String)name, (String)"lint-", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"lint-gradle-api-", (boolean)false, (int)2, null))) continue;
                URL uRL = file.toURI().toURL();
                Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"file.toURI().toURL()");
                urls.add(uRL);
            }
            return urls;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

