/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.gradle.api;

import com.android.tools.lint.gradle.api.DelegatingClassLoader;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0004J\u0016\u0010\u000e\u001a\u00020\r2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/lint/gradle/api/LintClassLoaderProvider;", "", "()V", "computeUrlsFallback", "", "Ljava/net/URL;", "lintClassPath", "", "Ljava/io/File;", "computeUrlsFromClassLoaderDelta", "disposeApplicationEnvironment", "", "classLoader", "Ljava/lang/ClassLoader;", "getClassLoader", "getLibrary", "", "uri", "Ljava/net/URI;", "lint-gradle-api"})
public class LintClassLoaderProvider {
    @NotNull
    public ClassLoader getClassLoader(@NotNull Set<? extends File> lintClassPath) {
        Intrinsics.checkParameterIsNotNull(lintClassPath, (String)"lintClassPath");
        List<URL> list = this.computeUrlsFromClassLoaderDelta(lintClassPath);
        if (list == null) {
            list = this.computeUrlsFallback(lintClassPath);
        }
        List<URL> urls = list;
        Collection $this$toTypedArray$iv = urls;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        if (uRLArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return new DelegatingClassLoader(uRLArray);
    }

    protected final void disposeApplicationEnvironment(@NotNull ClassLoader classLoader) {
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        Class<?> cls = classLoader.loadClass("com.android.tools.lint.UastEnvironment");
        Method disposeMethod = cls.getDeclaredMethod("disposeApplicationEnvironment", new Class[0]);
        disposeMethod.invoke(null, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final List<URL> computeUrlsFromClassLoaderDelta(Set<? extends File> lintClassPath) {
        HashMap uriMap = new HashMap(2 * lintClassPath.size());
        Iterable $this$forEach$iv = lintClassPath;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name;
            URI uri;
            File it = (File)element$iv;
            boolean bl = false;
            URI uRI = uri = it.toURI();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"uri");
            if (this.getLibrary(uRI) == null) {
                return null;
            }
            ((Map)uriMap).put(name, uri);
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            classLoader = null;
        }
        URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
        if (uRLClassLoader == null) {
            return null;
        }
        URLClassLoader gradleClassLoader = uRLClassLoader;
        Object object = gradleClassLoader.getURLs();
        int n = ((URL[])object).length;
        for (int i = 0; i < n; ++i) {
            String name;
            URI uri;
            URL url = object[i];
            URI uRI = uri = url.toURI();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"uri");
            if (this.getLibrary(uRI) == null) {
                return null;
            }
            if (StringsKt.startsWith$default((String)name, (String)"kotlin-stdlib", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"kotlin-reflect", (boolean)false, (int)2, null)) continue;
            uriMap.remove(name);
        }
        ArrayList<URL> urls = new ArrayList<URL>(uriMap.size());
        boolean seenLint = false;
        Object uri = uriMap;
        boolean name = false;
        Iterator iterator = uri.entrySet().iterator();
        while (iterator.hasNext()) {
            void name2;
            Object object2 = object = iterator.next();
            boolean bl = false;
            uri = (String)object2.getKey();
            object2 = object;
            bl = false;
            URI uri2 = (URI)object2.getValue();
            if (StringsKt.startsWith$default((String)name2, (String)"lint-api", (boolean)false, (int)2, null)) {
                seenLint = true;
            } else if (StringsKt.startsWith$default((String)name2, (String)"builder-model", (boolean)false, (int)2, null)) {
                return null;
            }
            urls.add(uri2.toURL());
        }
        if (!seenLint) {
            return null;
        }
        return urls;
    }

    private final String getLibrary(URI uri) {
        int n;
        String path = uri.getPath();
        String string = uri.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri.path");
        int index = StringsKt.lastIndexOf$default((CharSequence)string, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            return null;
        }
        String string2 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        int dash = StringsKt.indexOf$default((CharSequence)string2, (char)'-', (int)index, (boolean)false, (int)4, null);
        while (dash != -1 && dash < path.length()) {
            char c = path.charAt(dash + 1);
            n = 0;
            if (Character.isDigit(c)) {
                String string3 = path;
                n = index + 1;
                boolean bl = false;
                String string4 = string3.substring(n, dash);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string4;
            }
            dash = StringsKt.indexOf$default((CharSequence)path, (char)'-', (int)(dash + 1), (boolean)false, (int)4, null);
        }
        String string5 = path;
        n = index + 1;
        int n2 = dash != -1 ? dash : path.length();
        boolean bl = false;
        String string6 = string5.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string6;
    }

    private final List<URL> computeUrlsFallback(Set<? extends File> lintClassPath) {
        boolean bl = false;
        List urls = new ArrayList();
        for (File file : lintClassPath) {
            String name;
            String string = name = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            if (!StringsKt.startsWith$default((String)string, (String)"uast-", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"intellij-core-", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"kotlin-compiler-", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"asm-", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"kxml2-", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"trove4j-", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)name, (String)"groovy-all-", (boolean)false, (int)2, null) && (!StringsKt.startsWith$default((String)name, (String)"lint-", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"lint-gradle-api-", (boolean)false, (int)2, null))) continue;
            URL uRL = file.toURI().toURL();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"file.toURI().toURL()");
            urls.add(uRL);
        }
        return urls;
    }
}

