/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.gradle;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.LintOptions;
import com.android.builder.model.Variant;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.gradle.GroovyGradleDetector;
import com.android.tools.lint.gradle.LintGradleClient;
import com.android.tools.lint.gradle.NonAndroidIssueRegistry;
import com.android.tools.lint.gradle.SyncOptions;
import com.android.tools.lint.gradle.api.LintExecutionRequest;
import com.android.tools.lint.gradle.api.VariantInputs;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class LintGradleExecution {
    private final LintExecutionRequest descriptor;

    public LintGradleExecution(LintExecutionRequest descriptor) {
        this.descriptor = descriptor;
    }

    public void analyze() throws IOException {
        ToolingModelBuilderRegistry toolingRegistry = this.descriptor.getToolingRegistry();
        if (toolingRegistry != null) {
            AndroidProject modelProject = LintGradleExecution.createAndroidProject(this.descriptor.getProject(), toolingRegistry);
            String variantName = this.descriptor.getVariantName();
            if (variantName != null) {
                for (Variant variant : modelProject.getVariants()) {
                    if (!variant.getName().equals(variantName)) continue;
                    this.lintSingleVariant(variant);
                    return;
                }
            } else {
                this.lintAllVariants(modelProject);
            }
        } else {
            this.lintNonAndroid();
        }
    }

    private LintOptions getLintOptions() {
        return this.descriptor.getLintOptions();
    }

    private File getSdkHome() {
        return this.descriptor.getSdkHome();
    }

    private boolean isFatalOnly() {
        return this.descriptor.isFatalOnly();
    }

    private File getReportsDir() {
        return this.descriptor.getReportsDir();
    }

    private void abort(LintGradleClient client, List<Warning> warnings, boolean isAndroid) {
        List<Object> errors;
        String message = isAndroid ? (this.isFatalOnly() ? "Lint found fatal errors while assembling a release target.\n\nTo proceed, either fix the issues identified by lint, or modify your build script as follows:\n...\nandroid {\n    lintOptions {\n        checkReleaseBuilds false\n        // Or, if you prefer, you can continue to check for errors in release builds,\n        // but continue the build even when errors are found:\n        abortOnError false\n    }\n}\n..." : "Lint found errors in the project; aborting build.\n\nFix the issues identified by lint, or add the following to your build script to proceed with errors:\n...\nandroid {\n    lintOptions {\n        abortOnError false\n    }\n}\n...") : "Lint found errors in the project; aborting build.\n\nFix the issues identified by lint, or add the following to your build script to proceed with errors:\n...\nlintOptions {\n    abortOnError false\n}\n...";
        if (warnings != null && client != null && client.getFlags().getReporters().stream().noneMatch(reporter -> reporter instanceof TextReporter) && !(errors = warnings.stream().filter(warning -> warning.severity.isError()).collect(Collectors.toList())).isEmpty()) {
            String prefix = "Errors found:\n\n";
            if (errors.size() > 3) {
                prefix = "The first 3 errors (out of " + errors.size() + ") were:\n";
                errors = Arrays.asList((Warning)errors.get(0), (Warning)errors.get(1), (Warning)errors.get(2));
            }
            StringWriter writer = new StringWriter();
            LintCliFlags flags = client.getFlags();
            flags.setExplainIssues(false);
            TextReporter reporter2 = Reporter.createTextReporter((LintCliClient)client, (LintCliFlags)flags, null, (Writer)writer, (boolean)false);
            try {
                Reporter.Stats stats = new Reporter.Stats(errors.size(), 0);
                reporter2.setWriteStats(false);
                reporter2.write(stats, errors);
                message = message + "\n\n" + prefix + writer.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new GradleException(message);
    }

    private Pair<List<Warning>, LintBaseline> runLint(Variant variant, VariantInputs variantInputs, boolean report, boolean isAndroid) {
        Pair<List<Warning>, LintBaseline> warnings;
        LintOptions lintOptions;
        BuiltinIssueRegistry registry = LintGradleExecution.createIssueRegistry(isAndroid);
        LintCliFlags flags = new LintCliFlags();
        LintGradleClient client = new LintGradleClient(this.descriptor.getGradlePluginVersion(), (IssueRegistry)registry, flags, this.descriptor.getProject(), this.descriptor.getSdkHome(), variant, variantInputs, this.descriptor.getBuildTools(), isAndroid);
        boolean fatalOnly = this.descriptor.isFatalOnly();
        if (fatalOnly) {
            flags.setFatalOnly(true);
        }
        if ((lintOptions = this.descriptor.getLintOptions()) != null) {
            LintGradleExecution.syncOptions(lintOptions, client, flags, variant, this.descriptor.getProject(), this.descriptor.getReportsDir(), report, fatalOnly);
        } else {
            flags.getReporters().add(Reporter.createTextReporter((LintCliClient)client, (LintCliFlags)flags, null, (Writer)new PrintWriter(System.out, true), (boolean)false));
            File html = SyncOptions.validateOutputFile(SyncOptions.createOutputPath(this.descriptor.getProject(), null, ".html", null, flags.isFatalOnly()));
            File xml = SyncOptions.validateOutputFile(SyncOptions.createOutputPath(this.descriptor.getProject(), null, ".xml", null, flags.isFatalOnly()));
            try {
                flags.getReporters().add(Reporter.createHtmlReporter((LintCliClient)client, (File)html, (LintCliFlags)flags));
                flags.getReporters().add(Reporter.createXmlReporter((LintCliClient)client, (File)xml, (boolean)false));
            }
            catch (IOException e) {
                throw new GradleException(e.getMessage(), (Throwable)e);
            }
        }
        if (!report || fatalOnly) {
            flags.setQuiet(true);
        }
        flags.setWriteBaselineIfMissing(report && !fatalOnly);
        try {
            warnings = client.run((IssueRegistry)registry);
        }
        catch (IOException e) {
            throw new GradleException("Invalid arguments.", (Throwable)e);
        }
        if (report && client.haveErrors() && flags.isSetExitCode()) {
            this.abort(client, (List)warnings.getFirst(), isAndroid);
        }
        return warnings;
    }

    private static void syncOptions(LintOptions options, LintGradleClient client, LintCliFlags flags, Variant variant, Project project, File reportsDir, boolean report, boolean fatalOnly) {
        if (options != null) {
            SyncOptions.syncTo(options, client, flags, variant != null ? variant.getName() : null, project, reportsDir, report);
        }
        boolean displayEmpty = !fatalOnly && !flags.isQuiet();
        for (Reporter reporter : flags.getReporters()) {
            reporter.setDisplayEmpty(displayEmpty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static AndroidProject createAndroidProject(Project gradleProject, ToolingModelBuilderRegistry toolingRegistry) {
        String modelName = AndroidProject.class.getName();
        ToolingModelBuilder modelBuilder = toolingRegistry.getBuilder(modelName);
        ExtraPropertiesExtension ext = gradleProject.getExtensions().getExtraProperties();
        ext.set("android.injected.build.model.only.versioned", (Object)Integer.toString(3));
        ext.set("android.injected.build.model.disable.src.download", (Object)true);
        try {
            AndroidProject androidProject = (AndroidProject)modelBuilder.buildAll(modelName, gradleProject);
            return androidProject;
        }
        finally {
            ext.set("android.injected.build.model.only.versioned", null);
            ext.set("android.injected.build.model.disable.src.download", null);
        }
    }

    private static BuiltinIssueRegistry createIssueRegistry(boolean isAndroid) {
        if (isAndroid) {
            return new LintGradleIssueRegistry();
        }
        return new NonAndroidIssueRegistry();
    }

    public void lintSingleVariant(Variant variant) {
        VariantInputs variantInputs = this.descriptor.getVariantInputs(variant.getName());
        if (variantInputs != null) {
            this.runLint(variant, variantInputs, true, true);
        }
    }

    public void lintNonAndroid() {
        VariantInputs variantInputs = this.descriptor.getVariantInputs("");
        if (variantInputs != null) {
            this.runLint(null, variantInputs, true, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void lintAllVariants(AndroidProject modelProject) throws IOException {
        void var7_12;
        UnusedResourceDetector.sIncludeInactiveReferences = false;
        HashMap warningMap = Maps.newHashMap();
        ArrayList baselines = Lists.newArrayList();
        for (Variant variant : modelProject.getVariants()) {
            VariantInputs variantInputs = this.descriptor.getVariantInputs(variant.getName());
            if (variantInputs == null) continue;
            Pair<List<Warning>, LintBaseline> pair = this.runLint(variant, variantInputs, false, true);
            List warnings = (List)pair.getFirst();
            warningMap.put(variant, warnings);
            LintBaseline baseline = (LintBaseline)pair.getSecond();
            if (baseline == null) continue;
            baselines.add(baseline);
        }
        LintOptions lintOptions = this.getLintOptions();
        boolean quiet = false;
        if (lintOptions != null) {
            quiet = lintOptions.isQuiet();
        }
        for (Map.Entry entry : warningMap.entrySet()) {
            Variant variant = (Variant)entry.getKey();
            List warnings = (List)entry.getValue();
            if (this.isFatalOnly() || quiet) continue;
            this.descriptor.warn("Ran lint on variant {}: {} issues found", new Object[]{variant.getName(), warnings.size()});
        }
        List<Warning> mergedWarnings = LintGradleClient.merge(warningMap, modelProject);
        boolean bl = false;
        int warningCount = 0;
        for (Warning warning : mergedWarnings) {
            if (warning.severity == Severity.ERROR || warning.severity == Severity.FATAL) {
                ++var7_12;
                continue;
            }
            if (warning.severity != Severity.WARNING) continue;
            ++warningCount;
        }
        if (!modelProject.getVariants().isEmpty()) {
            TreeSet allVariants = Sets.newTreeSet(Comparator.comparing(Variant::getName));
            allVariants.addAll(modelProject.getVariants());
            Variant variant = (Variant)allVariants.iterator().next();
            BuiltinIssueRegistry registry = new BuiltinIssueRegistry();
            LintCliFlags flags = new LintCliFlags();
            VariantInputs variantInputs = this.descriptor.getVariantInputs(variant.getName());
            assert (variantInputs != null) : variant.getName();
            LintGradleClient client = new LintGradleClient(this.descriptor.getGradlePluginVersion(), (IssueRegistry)registry, flags, this.descriptor.getProject(), this.getSdkHome(), variant, variantInputs, this.descriptor.getBuildTools(), true);
            LintGradleExecution.syncOptions(lintOptions, client, flags, null, this.descriptor.getProject(), this.getReportsDir(), true, this.isFatalOnly());
            int baselineErrorCount = 0;
            int baselineWarningCount = 0;
            int fixedCount = 0;
            if (!baselines.isEmpty()) {
                for (Object baseline : baselines) {
                    baselineErrorCount = Math.max(baselineErrorCount, baseline.getFoundErrorCount());
                    baselineWarningCount = Math.max(baselineWarningCount, baseline.getFoundWarningCount());
                    fixedCount = Math.max(fixedCount, baseline.getFixedCount());
                }
            }
            Reporter.Stats stats = new Reporter.Stats((int)var7_12, warningCount, baselineErrorCount, baselineWarningCount, fixedCount);
            for (Reporter reporter : flags.getReporters()) {
                reporter.write(stats, mergedWarnings);
            }
            File baselineFile = flags.getBaselineFile();
            if (baselineFile != null && !baselineFile.exists()) {
                File dir = baselineFile.getParentFile();
                boolean ok = true;
                if (!dir.isDirectory()) {
                    ok = dir.mkdirs();
                }
                if (!ok) {
                    System.err.println("Couldn't create baseline folder " + dir);
                } else {
                    Reporter reporter = Reporter.createXmlReporter((LintCliClient)client, (File)baselineFile, (boolean)true);
                    reporter.write(stats, mergedWarnings);
                    System.err.println("Created baseline file " + baselineFile);
                    if (LintGradleClient.continueAfterBaseLineCreated()) {
                        return;
                    }
                    System.err.println("(Also breaking build in case this was not intentional.)");
                    String message = "Created baseline file " + baselineFile + "\n\nAlso breaking the build in case this was not intentional. If you\ndeliberately created the baseline file, re-run the build and this\ntime it should succeed without warnings.\n\nIf not, investigate the baseline path in the lintOptions config\nor verify that the baseline file has been checked into version\ncontrol.\n\nYou can set the system property lint.baselines.continue=true\nif you want to create many missing baselines in one go.";
                    throw new GradleException(message);
                }
            }
            if (baselineErrorCount > 0 || baselineWarningCount > 0) {
                System.out.println(String.format("%1$s were filtered out because they were listed in the baseline file, %2$s\n", LintUtils.describeCounts((int)baselineErrorCount, (int)baselineWarningCount, (boolean)false, (boolean)true), baselineFile));
            }
            if (fixedCount > 0) {
                System.out.println(String.format("%1$d errors/warnings were listed in the baseline file (%2$s) but not found in the project; perhaps they have been fixed?\n", fixedCount, baselineFile));
            }
            if (flags.isSetExitCode() && var7_12 > 0) {
                this.abort(client, mergedWarnings, true);
            }
        }
    }

    private static class LintGradleIssueRegistry
    extends BuiltinIssueRegistry {
        private boolean mInitialized;

        public List<Issue> getIssues() {
            List issues = super.getIssues();
            if (!this.mInitialized) {
                this.mInitialized = true;
                for (Issue issue : issues) {
                    if (issue.getImplementation().getDetectorClass() != GradleDetector.class) continue;
                    issue.setImplementation(GroovyGradleDetector.IMPLEMENTATION);
                }
            }
            return issues;
        }

        public int getApi() {
            return 1;
        }
    }
}

