/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.gradle;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.LintOptions;
import com.android.builder.model.Variant;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeAndroidProjectImpl;
import com.android.ide.common.gradle.model.level2.IdeDependenciesFactory;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.LintFixPerformer;
import com.android.tools.lint.LintStats;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.TextReporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.XmlReporter;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.checks.UnusedResourceDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.gradle.KotlinSourceFoldersResolver;
import com.android.tools.lint.gradle.LintGradleClient;
import com.android.tools.lint.gradle.NonAndroidIssueRegistry;
import com.android.tools.lint.gradle.SyncOptions;
import com.android.tools.lint.gradle.api.LintExecutionRequest;
import com.android.tools.lint.gradle.api.VariantInputs;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function2;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class LintGradleExecution {
    private final LintExecutionRequest descriptor;

    public LintGradleExecution(LintExecutionRequest descriptor) {
        this.descriptor = descriptor;
    }

    public void analyze() throws IOException {
        ToolingModelBuilderRegistry toolingRegistry = this.descriptor.getToolingRegistry();
        if (toolingRegistry != null) {
            IdeAndroidProject modelProject = LintGradleExecution.createAndroidProject(this.descriptor.getProject(), toolingRegistry);
            String variantName = this.descriptor.getVariantName();
            if (variantName != null) {
                for (Variant variant : modelProject.getVariants()) {
                    if (!variant.getName().equals(variantName)) continue;
                    this.lintSingleVariant(variant);
                    return;
                }
            } else {
                this.lintAllVariants(modelProject);
            }
        } else {
            this.lintNonAndroid();
        }
    }

    private LintOptions getLintOptions() {
        return this.descriptor.getLintOptions();
    }

    private File getSdkHome() {
        return this.descriptor.getSdkHome();
    }

    private boolean isFatalOnly() {
        return this.descriptor.isFatalOnly();
    }

    private File getReportsDir() {
        return this.descriptor.getReportsDir();
    }

    private void abort(LintGradleClient client, List<Warning> warnings, boolean isAndroid) {
        List<Object> errors;
        String message = isAndroid ? (this.isFatalOnly() ? "Lint found fatal errors while assembling a release target.\n\nTo proceed, either fix the issues identified by lint, or modify your build script as follows:\n...\nandroid {\n    lintOptions {\n        checkReleaseBuilds false\n        // Or, if you prefer, you can continue to check for errors in release builds,\n        // but continue the build even when errors are found:\n        abortOnError false\n    }\n}\n..." : "Lint found errors in the project; aborting build.\n\nFix the issues identified by lint, or add the following to your build script to proceed with errors:\n...\nandroid {\n    lintOptions {\n        abortOnError false\n    }\n}\n...") : "Lint found errors in the project; aborting build.\n\nFix the issues identified by lint, or add the following to your build script to proceed with errors:\n...\nlintOptions {\n    abortOnError false\n}\n...";
        if (warnings != null && client != null && client.getFlags().getReporters().stream().noneMatch(reporter -> reporter instanceof TextReporter) && !(errors = warnings.stream().filter(warning -> warning.severity.isError()).collect(Collectors.toList())).isEmpty()) {
            String prefix = "Errors found:\n\n";
            if (errors.size() > 3) {
                prefix = "The first 3 errors (out of " + errors.size() + ") were:\n";
                errors = Arrays.asList((Warning)errors.get(0), (Warning)errors.get(1), (Warning)errors.get(2));
            }
            StringWriter writer = new StringWriter();
            LintCliFlags flags = client.getFlags();
            flags.setExplainIssues(false);
            TextReporter reporter2 = Reporter.createTextReporter((LintCliClient)client, (LintCliFlags)flags, null, (Writer)writer, (boolean)false);
            try {
                LintStats stats = LintStats.Companion.create(errors.size(), 0);
                reporter2.setWriteStats(false);
                reporter2.write(stats, errors);
                message = message + "\n\n" + prefix + writer.toString();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new GradleException(message);
    }

    private Pair<List<Warning>, LintBaseline> runLint(Variant variant, VariantInputs variantInputs, boolean report, boolean isAndroid, boolean allowFix) {
        Pair<List<Warning>, LintBaseline> warnings;
        BuiltinIssueRegistry registry = LintGradleExecution.createIssueRegistry(isAndroid);
        LintCliFlags flags = new LintCliFlags();
        LintGradleClient client = new LintGradleClient(this.descriptor.getGradlePluginVersion(), (IssueRegistry)registry, flags, this.descriptor.getProject(), this.descriptor.getSdkHome(), variant, variantInputs, this.descriptor.getBuildToolsRevision(), new KotlinSourceFoldersResolver((Function2<? super String, ? super Project, ? extends List<? extends File>>)((Function2)(arg_0, arg_1) -> ((LintExecutionRequest)this.descriptor).getKotlinSourceFolders(arg_0, arg_1))), isAndroid, variant != null ? variant.getName() : null);
        boolean fatalOnly = this.descriptor.isFatalOnly();
        if (fatalOnly) {
            flags.setFatalOnly(true);
        }
        boolean autoFixing = allowFix & this.descriptor.getAutoFix();
        LintOptions lintOptions = this.descriptor.getLintOptions();
        boolean fix = false;
        if (lintOptions != null) {
            LintGradleExecution.syncOptions(lintOptions, client, flags, variant, this.descriptor.getProject(), this.descriptor.getReportsDir(), report, fatalOnly, allowFix);
        } else {
            flags.getReporters().add(Reporter.createTextReporter((LintCliClient)client, (LintCliFlags)flags, null, (Writer)new PrintWriter(System.out, true), (boolean)false));
            if (!autoFixing) {
                File html = SyncOptions.validateOutputFile(SyncOptions.createOutputPath(this.descriptor.getProject(), null, ".html", null, flags.isFatalOnly()));
                File xml = SyncOptions.validateOutputFile(SyncOptions.createOutputPath(this.descriptor.getProject(), null, ".xml", null, flags.isFatalOnly()));
                try {
                    flags.getReporters().add(Reporter.createHtmlReporter((LintCliClient)client, (File)html, (LintCliFlags)flags));
                    flags.getReporters().add(Reporter.createXmlReporter((LintCliClient)client, (File)xml, (boolean)false, (boolean)flags.isIncludeXmlFixes()));
                }
                catch (IOException e) {
                    throw new GradleException(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (!report || fatalOnly) {
            flags.setQuiet(true);
        }
        flags.setWriteBaselineIfMissing(report && !fatalOnly && !autoFixing);
        if (autoFixing) {
            flags.setAutoFix(true);
            flags.setSetExitCode(false);
        }
        try {
            warnings = client.run((IssueRegistry)registry);
        }
        catch (IOException e) {
            throw new GradleException("Invalid arguments.", (Throwable)e);
        }
        if (report && client.haveErrors() && flags.isSetExitCode()) {
            this.abort(client, (List)warnings.getFirst(), isAndroid);
        }
        return warnings;
    }

    private static void syncOptions(LintOptions options, LintGradleClient client, LintCliFlags flags, Variant variant, Project project, File reportsDir, boolean report, boolean fatalOnly, boolean allowAutoFix) {
        if (options != null) {
            SyncOptions.syncTo(options, client, flags, variant != null ? variant.getName() : null, project, reportsDir, report);
        }
        client.syncConfigOptions();
        if (!allowAutoFix && flags.isAutoFix()) {
            flags.setAutoFix(false);
        }
        boolean displayEmpty = !fatalOnly && !flags.isQuiet();
        for (Reporter reporter : flags.getReporters()) {
            reporter.setDisplayEmpty(displayEmpty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IdeAndroidProject createAndroidProject(Project gradleProject, ToolingModelBuilderRegistry toolingRegistry) {
        ExtraPropertiesExtension ext;
        String modelName = AndroidProject.class.getName();
        ToolingModelBuilder modelBuilder = toolingRegistry.getBuilder(modelName);
        assert (modelBuilder.canBuild(modelName)) : modelName;
        ExtraPropertiesExtension extraPropertiesExtension = ext = gradleProject.getExtensions().getExtraProperties();
        synchronized (extraPropertiesExtension) {
            IdeAndroidProjectImpl ideAndroidProjectImpl;
            ext.set("android.injected.build.model.only.versioned", (Object)Integer.toString(3));
            try {
                AndroidProject project = (AndroidProject)modelBuilder.buildAll(modelName, gradleProject);
                ideAndroidProjectImpl = IdeAndroidProjectImpl.create((AndroidProject)project, (IdeDependenciesFactory)new IdeDependenciesFactory(), (Collection)project.getVariants(), null);
            }
            catch (Throwable throwable) {
                ext.set("android.injected.build.model.only.versioned", null);
                throw throwable;
            }
            ext.set("android.injected.build.model.only.versioned", null);
            return ideAndroidProjectImpl;
        }
    }

    private static BuiltinIssueRegistry createIssueRegistry(boolean isAndroid) {
        if (isAndroid) {
            return new BuiltinIssueRegistry();
        }
        return new NonAndroidIssueRegistry();
    }

    public void lintSingleVariant(Variant variant) {
        VariantInputs variantInputs = this.descriptor.getVariantInputs(variant.getName());
        if (variantInputs != null) {
            this.runLint(variant, variantInputs, true, true, true);
        }
    }

    public void lintNonAndroid() {
        VariantInputs variantInputs = this.descriptor.getVariantInputs("");
        if (variantInputs != null) {
            this.runLint(null, variantInputs, true, false, true);
        }
    }

    public void lintAllVariants(IdeAndroidProject modelProject) throws IOException {
        UnusedResourceDetector.sIncludeInactiveReferences = false;
        HashMap warningMap = Maps.newHashMap();
        ArrayList baselines = Lists.newArrayList();
        boolean first = true;
        for (Variant variant : modelProject.getVariants()) {
            VariantInputs variantInputs = this.descriptor.getVariantInputs(variant.getName());
            if (variantInputs == null) continue;
            Pair<List<Warning>, LintBaseline> pair = this.runLint(variant, variantInputs, false, true, first);
            first = false;
            List warnings = (List)pair.getFirst();
            warningMap.put(variant, warnings);
            LintBaseline baseline = (LintBaseline)pair.getSecond();
            if (baseline == null) continue;
            baselines.add(baseline);
        }
        LintOptions lintOptions = this.getLintOptions();
        boolean quiet = false;
        if (lintOptions != null) {
            quiet = lintOptions.isQuiet();
        }
        for (Map.Entry entry : warningMap.entrySet()) {
            Variant variant = (Variant)entry.getKey();
            List warnings = (List)entry.getValue();
            if (this.isFatalOnly() || quiet) continue;
            this.descriptor.warn("Ran lint on variant {}: {} issues found", new Object[]{variant.getName(), warnings.size()});
        }
        List<Warning> mergedWarnings = LintGradleClient.merge(warningMap, modelProject);
        LintStats lintStats = LintStats.Companion.create(mergedWarnings, (List)baselines);
        int errorCount = lintStats.getErrorCount();
        if (!modelProject.getVariants().isEmpty()) {
            LintBaseline firstBaseline;
            TreeSet allVariants = Sets.newTreeSet(Comparator.comparing(Variant::getName));
            allVariants.addAll(modelProject.getVariants());
            Variant variant = (Variant)allVariants.iterator().next();
            BuiltinIssueRegistry registry = new BuiltinIssueRegistry();
            LintCliFlags flags = new LintCliFlags();
            VariantInputs variantInputs = this.descriptor.getVariantInputs(variant.getName());
            assert (variantInputs != null) : variant.getName();
            LintGradleClient client = new LintGradleClient(this.descriptor.getGradlePluginVersion(), (IssueRegistry)registry, flags, this.descriptor.getProject(), this.getSdkHome(), variant, variantInputs, this.descriptor.getBuildToolsRevision(), new KotlinSourceFoldersResolver((Function2<? super String, ? super Project, ? extends List<? extends File>>)((Function2)(arg_0, arg_1) -> ((LintExecutionRequest)this.descriptor).getKotlinSourceFolders(arg_0, arg_1))), true, this.isFatalOnly() ? "fatal" : "all");
            LintGradleExecution.syncOptions(lintOptions, client, flags, null, this.descriptor.getProject(), this.getReportsDir(), true, this.isFatalOnly(), true);
            if (flags.isAutoFix()) {
                flags.setSetExitCode(false);
                new LintFixPerformer((LintCliClient)client, !flags.isQuiet()).fix(mergedWarnings);
            }
            for (Reporter reporter : flags.getReporters()) {
                reporter.write(lintStats, mergedWarnings);
            }
            File baselineFile = flags.getBaselineFile();
            if (baselineFile != null && !baselineFile.exists() && !flags.isAutoFix()) {
                File dir = baselineFile.getParentFile();
                boolean ok = true;
                if (!dir.isDirectory()) {
                    ok = dir.mkdirs();
                }
                if (!ok) {
                    System.err.println("Couldn't create baseline folder " + dir);
                } else {
                    XmlReporter reporter = Reporter.createXmlReporter((LintCliClient)client, (File)baselineFile, (boolean)true, (boolean)false);
                    reporter.setBaselineAttributes((LintClient)client, flags.isFatalOnly() ? "fatal" : "all");
                    reporter.write(lintStats, mergedWarnings);
                    System.err.println("Created baseline file " + baselineFile);
                    if (LintGradleClient.continueAfterBaseLineCreated()) {
                        return;
                    }
                    System.err.println("(Also breaking build in case this was not intentional.)");
                    String message = client.getBaselineCreationMessage(baselineFile);
                    throw new GradleException(message);
                }
            }
            LintBaseline lintBaseline = firstBaseline = baselines.isEmpty() ? null : (LintBaseline)baselines.get(0);
            if (baselineFile != null && firstBaseline != null) {
                client.emitBaselineDiagnostics(firstBaseline, baselineFile, lintStats);
            }
            if (flags.isSetExitCode() && errorCount > 0) {
                this.abort(client, mergedWarnings, true);
            }
        }
    }
}

