/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.gradle;

import com.android.builder.model.Variant;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.gradle.model.IdeLintOptions;
import com.android.repository.Revision;
import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Warning;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.GradleVisitor;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintBaseline;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.gradle.GroovyGradleVisitor;
import com.android.tools.lint.gradle.KotlinSourceFoldersResolver;
import com.android.tools.lint.gradle.LintGradleProject;
import com.android.tools.lint.gradle.SyncOptions;
import com.android.tools.lint.gradle.api.VariantInputs;
import com.android.utils.Pair;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.w3c.dom.Document;

public class LintGradleClient
extends LintCliClient {
    private final Variant variant;
    private final Project gradleProject;
    private final String version;
    private File sdkHome;
    private final VariantInputs variantInputs;
    private String baselineVariantName;
    private final Revision buildToolInfoRevision;
    private final boolean isAndroid;
    private final KotlinSourceFoldersResolver resolver;

    public LintGradleClient(String version, IssueRegistry registry, LintCliFlags flags, Project gradleProject, File sdkHome, Variant variant, VariantInputs variantInputs, Revision buildToolInfoRevision, KotlinSourceFoldersResolver resolver, boolean isAndroid, String baselineVariantName) {
        super(flags, "gradle");
        this.version = version;
        this.gradleProject = gradleProject;
        this.sdkHome = sdkHome;
        this.variantInputs = variantInputs;
        this.baselineVariantName = baselineVariantName;
        this.registry = registry;
        this.buildToolInfoRevision = buildToolInfoRevision;
        this.resolver = resolver;
        this.variant = variant;
        this.isAndroid = isAndroid;
    }

    public List<File> getKotlinSourceFolders(String projectPath) {
        if (projectPath == null || this.variant == null) {
            return Collections.emptyList();
        }
        return this.resolver.getKotlinSourceFolders(this.variant.getName(), this.gradleProject.findProject(projectPath));
    }

    public List<File> getKotlinSourceFolders(Project project) {
        if (this.variant == null) {
            return Collections.emptyList();
        }
        return this.resolver.getKotlinSourceFolders(this.variant.getName(), project);
    }

    public String getClientRevision() {
        return this.version;
    }

    public Configuration getConfiguration(com.android.tools.lint.detector.api.Project project, LintDriver driver) {
        if (this.overrideConfiguration != null) {
            return this.overrideConfiguration;
        }
        IdeAndroidProject gradleProjectModel = project.getGradleProjectModel();
        if (gradleProjectModel != null) {
            Map overrides;
            IdeLintOptions lintOptions = gradleProjectModel.getLintOptions();
            File lintXml = lintOptions.getLintConfig();
            if (lintXml == null) {
                lintXml = new File(project.getDir(), "lint.xml");
            }
            if ((overrides = lintOptions.getSeverityOverrides()) != null && !overrides.isEmpty()) {
                return new LintCliClient.CliConfiguration(lintXml, this.getConfiguration(), project, this.flags.isFatalOnly()){

                    public Severity getSeverity(Issue issue) {
                        if (issue.getSuppressNames() != null) {
                            return this.getDefaultSeverity(issue);
                        }
                        Integer optionSeverity = (Integer)overrides.get(issue.getId());
                        if (optionSeverity != null) {
                            Severity severity = SyncOptions.getSeverity(issue, optionSeverity);
                            if (LintGradleClient.this.flags.isFatalOnly() && severity != Severity.FATAL) {
                                return Severity.IGNORE;
                            }
                            return severity;
                        }
                        return super.getSeverity(issue);
                    }
                };
            }
        }
        return super.getConfiguration(project, driver);
    }

    public File findResource(String relativePath) {
        if (!this.isAndroid) {
            return null;
        }
        return super.findResource(relativePath);
    }

    public Iterable<File> findRuleJars(com.android.tools.lint.detector.api.Project project) {
        return this.variantInputs.getRuleJars().getAsFileTree().filter(File::isFile).getFiles();
    }

    protected com.android.tools.lint.detector.api.Project createProject(File dir, File referenceDir) {
        throw new IllegalStateException();
    }

    public File getSdkHome() {
        if (this.sdkHome != null) {
            return this.sdkHome;
        }
        return super.getSdkHome();
    }

    public File getCacheDir(String name, boolean create) {
        File dir;
        String relative = "intermediates" + File.separator + "lint-cache";
        if (name != null) {
            relative = relative + File.separator + name;
        }
        if ((dir = new File(this.gradleProject.getRootProject().getBuildDir(), relative)).exists() || create && dir.mkdirs()) {
            return dir;
        }
        return super.getCacheDir(name, create);
    }

    public GradleVisitor getGradleVisitor() {
        return new GroovyGradleVisitor();
    }

    protected LintRequest createLintRequest(List<File> files) {
        LintRequest lintRequest = new LintRequest((LintClient)this, files);
        LintGradleProject.ProjectSearch search = new LintGradleProject.ProjectSearch();
        com.android.tools.lint.detector.api.Project project = search.getProject(this, this.gradleProject, this.variant != null ? this.variant.getName() : null);
        lintRequest.setProjects(Collections.singletonList(project));
        this.registerProject(project.getDir(), project);
        for (com.android.tools.lint.detector.api.Project dependency : project.getAllLibraries()) {
            this.registerProject(dependency.getDir(), dependency);
        }
        return lintRequest;
    }

    protected LintDriver createDriver(IssueRegistry registry, LintRequest request) {
        LintDriver driver = super.createDriver(registry, request);
        driver.setPlatforms(this.isAndroid ? Platform.ANDROID_SET : Platform.JDK_SET);
        return driver;
    }

    public static boolean continueAfterBaseLineCreated() {
        return "true".equals(System.getProperty("lint.baselines.continue"));
    }

    public Pair<List<Warning>, LintBaseline> run(IssueRegistry registry) throws IOException {
        int exitCode = this.run(registry, Collections.emptyList());
        if (exitCode == 6) {
            if (LintGradleClient.continueAfterBaseLineCreated()) {
                return Pair.of(Collections.emptyList(), (Object)this.driver.getBaseline());
            }
            throw new GradleException("Aborting build since new baseline file was created");
        }
        if (exitCode == 7) {
            throw new GradleException("Aborting build since sources were modified to apply quickfixes after compilation");
        }
        return Pair.of((Object)this.warnings, (Object)this.driver.getBaseline());
    }

    public static List<Warning> merge(Map<Variant, List<Warning>> warningMap, IdeAndroidProject project) {
        if (warningMap.size() == 1) {
            return warningMap.values().iterator().next();
        }
        int maxCount = 0;
        for (List<Warning> warnings : warningMap.values()) {
            int size = warnings.size();
            maxCount = Math.max(size, maxCount);
        }
        if (maxCount == 0) {
            return Collections.emptyList();
        }
        int totalVariantCount = project.getVariants().size();
        ArrayList merged = Lists.newArrayListWithExpectedSize((int)(2 * maxCount));
        HashMap map = Maps.newHashMapWithExpectedSize((int)(2 * maxCount));
        for (Map.Entry<Variant, List<Warning>> entry : warningMap.entrySet()) {
            Variant variant = entry.getKey();
            List<Warning> warnings = entry.getValue();
            for (Warning warning : warnings) {
                File parent;
                File file;
                Map fileMap;
                Map columnMap;
                Map lineMap;
                Map messageMap = (Map)map.get(warning.issue);
                if (messageMap == null) {
                    messageMap = Maps.newHashMap();
                    map.put(warning.issue, messageMap);
                }
                if ((lineMap = (Map)messageMap.get(warning.message)) == null) {
                    lineMap = Maps.newHashMap();
                    messageMap.put(warning.message, lineMap);
                }
                if ((columnMap = (Map)lineMap.get(warning.line)) == null) {
                    columnMap = Maps.newHashMap();
                    lineMap.put(warning.line, columnMap);
                }
                if ((fileMap = (Map)columnMap.get(warning.offset)) == null) {
                    fileMap = Maps.newHashMap();
                    columnMap.put(warning.offset, fileMap);
                }
                String fileName = (file = warning.file) != null ? ((parent = file.getParentFile()) != null ? parent.getName() + "/" + file.getName() : file.getName()) : "<unknown>";
                Warning canonical = (Warning)fileMap.get(fileName);
                if (canonical == null) {
                    canonical = warning;
                    fileMap.put(fileName, canonical);
                    canonical.variants = Sets.newHashSet();
                    canonical.gradleProject = project;
                    merged.add(canonical);
                }
                canonical.variants.add(variant);
            }
        }
        for (Warning warning : merged) {
            if (warning.variants == null || warning.variants.size() != totalVariantCount) continue;
            warning.variants = null;
        }
        Collections.sort(merged);
        return merged;
    }

    protected void addProgressPrinter() {
    }

    public Revision getBuildToolsRevision(com.android.tools.lint.detector.api.Project project) {
        return this.buildToolInfoRevision;
    }

    protected String getBaselineVariantName() {
        return this.baselineVariantName;
    }

    public void report(Context context, Issue issue, Severity severity, Location location, String message, TextFormat format, LintFix fix) {
        if (issue == IssueRegistry.LINT_ERROR && message.startsWith("No `.class` files were found in project")) {
            return;
        }
        super.report(context, issue, severity, location, message, format, fix);
    }

    public File getMergedManifest() {
        return this.variantInputs.getMergedManifest();
    }

    public Document getMergedManifest(com.android.tools.lint.detector.api.Project project) {
        File manifest = this.variantInputs.getMergedManifest();
        if (manifest == null) {
            return null;
        }
        try {
            String xml = Files.asCharSource((File)manifest, (Charset)Charsets.UTF_8).read();
            Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
            if (document != null) {
                File manifestMergeReport = this.variantInputs.getManifestMergeReport();
                if (manifestMergeReport != null) {
                    this.resolveMergeManifestSources(document, manifestMergeReport);
                }
                return document;
            }
        }
        catch (IOException ioe) {
            this.log(ioe, "Could not read %1$s", new Object[]{manifest});
        }
        return super.getMergedManifest(project);
    }
}

