/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0000J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u0007J\u001a\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\n2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\fJ\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u0007J$\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\f2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u0017\u001a\u00020\u000eJ$\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0017\u001a\u00020\u000eJ\b\u0010\u0019\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/model/PathVariables;", "", "()V", "pathVariables", "", "Lcom/android/tools/lint/model/PathVariables$PathVariable;", "add", "", "other", "name", "", "dir", "Ljava/io/File;", "sort", "", "any", "clear", "fromPathString", "path", "relativeTo", "normalize", "toPathString", "file", "unix", "fullPath", "toString", "Companion", "PathVariable", "lint-model"})
public final class PathVariables {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PathVariable> pathVariables;
    @NotNull
    private static final String CANONICALIZED = "_canonical";
    @NotNull
    private static final Comparator<PathVariable> PATH_COMPARATOR = new Comparator<PathVariable>(){

        public int compare(@NotNull PathVariable v1, @NotNull PathVariable v2) {
            int c2;
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            String p1 = v1.getDir().getPath();
            String p2 = v2.getDir().getPath();
            int c1 = StringsKt.endsWith$default((String)v1.getName(), (String)"_canonical", (boolean)false, (int)2, null) ? 1 : 0;
            int n = c2 = StringsKt.endsWith$default((String)v2.getName(), (String)"_canonical", (boolean)false, (int)2, null) ? 1 : 0;
            if (c1 != c2) {
                return c1 - c2;
            }
            if (p2.length() != p1.length()) {
                return p2.length() - p1.length();
            }
            Intrinsics.checkNotNullExpressionValue((Object)p2, (String)"p2");
            int delta = p1.compareTo(p2);
            if (delta != 0) {
                return delta;
            }
            return v1.getName().compareTo(v2.getName());
        }
    };

    public PathVariables() {
        boolean bl = false;
        this.pathVariables = new ArrayList();
    }

    @JvmOverloads
    public final void add(@NotNull String name, @NotNull File dir, boolean sort) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        PathVariables.Companion.checkPathVariableName(name);
        PathVariable variable = new PathVariable(name, dir);
        this.pathVariables.add(variable);
        if (sort) {
            this.sort();
        }
    }

    public static /* synthetic */ void add$default(PathVariables pathVariables, String string, File file, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        pathVariables.add(string, file, bl);
    }

    public final void sort() {
        CollectionsKt.sortWith(this.pathVariables, PATH_COMPARATOR);
    }

    public final void clear() {
        this.pathVariables.clear();
    }

    @NotNull
    public final String toPathString(@NotNull File file, @Nullable File relativeTo, boolean unix) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.path");
        String string = object;
        object = relativeTo;
        return this.toPathString(string, object == null ? null : ((File)object).getPath(), unix);
    }

    public static /* synthetic */ String toPathString$default(PathVariables pathVariables, File file, File file2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            file2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return pathVariables.toPathString(file, file2, bl);
    }

    @NotNull
    public final String toPathString(@NotNull String fullPath, @Nullable String relativeTo, boolean unix) {
        Object it;
        Object object;
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        for (PathVariable pathVariable : this.pathVariables) {
            String prefix = pathVariable.component1();
            File root = pathVariable.component2();
            String string = root.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"root.path");
            if (!StringsKt.startsWith$default((String)fullPath, (String)string, (boolean)false, (int)2, null)) continue;
            if (Intrinsics.areEqual((Object)fullPath, (Object)root.getPath())) {
                return Intrinsics.stringPlus((String)"$", (Object)StringsKt.removeSuffix((String)prefix, (CharSequence)CANONICALIZED));
            }
            if (fullPath.length() <= root.getPath().length() || fullPath.charAt(root.getPath().length()) != File.separatorChar) continue;
            String string2 = fullPath;
            int n = root.getPath().length();
            boolean bl = false;
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String relative = string3;
            string2 = '$' + StringsKt.removeSuffix((String)prefix, (CharSequence)CANONICALIZED) + relative;
            n = 0;
            bl = false;
            String it2 = string2;
            boolean bl2 = false;
            return unix ? StringsKt.replace$default((String)it2, (char)'\\', (char)'/', (boolean)false, (int)4, null) : it2;
        }
        if (relativeTo != null && StringsKt.startsWith$default((String)fullPath, (String)relativeTo, (boolean)false, (int)2, null) && fullPath.length() > relativeTo.length() && fullPath.charAt(relativeTo.length()) == File.separatorChar) {
            object = fullPath;
            int n = relativeTo.length() + 1;
            boolean bl = false;
            String string = ((String)object).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            object = string;
            n = 0;
            bl = false;
            it = object;
            boolean bl3 = false;
            return unix ? StringsKt.replace$default((String)it, (char)'\\', (char)'/', (boolean)false, (int)4, null) : it;
        }
        object = fullPath;
        boolean bl = false;
        boolean bl4 = false;
        it = object;
        boolean bl5 = false;
        return unix ? StringsKt.replace$default((String)it, (char)'\\', (char)'/', (boolean)false, (int)4, null) : it;
    }

    public static /* synthetic */ String toPathString$default(PathVariables pathVariables, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return pathVariables.toPathString(string, string2, bl);
    }

    @NotNull
    public final File fromPathString(@NotNull String path, @Nullable File relativeTo) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (StringsKt.startsWith$default((String)path, (String)"$", (boolean)false, (int)2, null)) {
            Object v4;
            String name;
            Object object;
            block11: {
                char c;
                int i;
                boolean hasBraces = path.length() > 1 && path.charAt(1) == '{';
                int n = 1;
                int n2 = path.length();
                if (n < n2) {
                    do {
                        boolean bl;
                        Object v1;
                        Object $this$firstOrNull$iv;
                        String varName;
                        block10: {
                            i = n++;
                            c = path.charAt(i);
                            if (!hasBraces || path.charAt(i - 1) != '}') {
                                if (hasBraces) continue;
                                char c2 = c;
                                boolean bl2 = false;
                                if (Character.isJavaIdentifierPart(c2)) continue;
                            }
                            String string = path;
                            int n3 = 1;
                            boolean bl3 = false;
                            String string2 = string.substring(n3, i);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            varName = string2;
                            $this$firstOrNull$iv = this.pathVariables;
                            boolean $i$f$firstOrNull = false;
                            Iterator iterator = $this$firstOrNull$iv.iterator();
                            while (iterator.hasNext()) {
                                Object element$iv = iterator.next();
                                PathVariable it = (PathVariable)element$iv;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)varName)) continue;
                                v1 = element$iv;
                                break block10;
                            }
                            v1 = null;
                        }
                        PathVariable pathVariable = v1;
                        if (pathVariable == null) {
                            $this$firstOrNull$iv = "Path variable $" + varName + " referenced in " + path + " not provided to serialization";
                            bl = false;
                            throw (Throwable)new IllegalStateException($this$firstOrNull$iv.toString());
                        }
                        File dir = pathVariable.getDir();
                        int relativeStart = c == '/' || c == '\\' ? i + 1 : i;
                        $this$firstOrNull$iv = path;
                        bl = false;
                        String string = ((String)$this$firstOrNull$iv).substring(relativeStart);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                        return new File(dir, string);
                    } while (n < n2);
                }
                object = path;
                i = 1;
                c = '\u0000';
                String string = ((String)object).substring(i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                name = string;
                Iterable $this$firstOrNull$iv = this.pathVariables;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PathVariable it = (PathVariable)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    v4 = element$iv;
                    break block11;
                }
                v4 = null;
            }
            object = v4;
            if (object == null) {
                String string = "Path variable $" + name + " referenced in " + path + " not provided to serialization";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return ((PathVariable)object).getDir();
        }
        File file = new File(path);
        if (relativeTo != null && !file.isAbsolute()) {
            File parentFile;
            if ((StringsKt.startsWith$default((String)path, (String)"../", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path, (String)"..\\", (boolean)false, (int)2, null)) && (parentFile = relativeTo.getParentFile()) != null) {
                String string = path;
                int n = 3;
                boolean bl = false;
                String string3 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                return new File(parentFile, string3);
            }
            return new File(relativeTo, path);
        }
        return file;
    }

    public static /* synthetic */ File fromPathString$default(PathVariables pathVariables, String string, File file, int n, Object object) {
        if ((n & 2) != 0) {
            file = null;
        }
        return pathVariables.fromPathString(string, file);
    }

    public final void add(@NotNull PathVariables other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        for (PathVariable variable : other.pathVariables) {
            Object v0;
            block3: {
                String name = variable.getName();
                PathVariables.Companion.checkPathVariableName(name);
                Iterable $this$firstOrNull$iv = this.pathVariables;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PathVariable it = (PathVariable)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            PathVariable pathVariable = v0;
            if (pathVariable != null) {
                PathVariable pathVariable2 = pathVariable;
                boolean bl = false;
                boolean bl2 = false;
                PathVariable it = pathVariable2;
                boolean bl3 = false;
                this.pathVariables.remove(it);
            }
            this.pathVariables.add(variable);
        }
        this.sort();
    }

    public final void normalize() {
        if (this.pathVariables.isEmpty()) {
            return;
        }
        for (PathVariable variable : CollectionsKt.toList((Iterable)this.pathVariables)) {
            try {
                boolean bl = !StringsKt.endsWith$default((String)variable.getName(), (String)CANONICALIZED, (boolean)false, (int)2, null);
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                File canonical = variable.getDir().getCanonicalFile();
                if (Intrinsics.areEqual((Object)canonical.getPath(), (Object)variable.getDir().getPath())) continue;
                String string = Intrinsics.stringPlus((String)variable.getName(), (Object)CANONICALIZED);
                Intrinsics.checkNotNullExpressionValue((Object)canonical, (String)"canonical");
                this.add(string, canonical, false);
            }
            catch (IOException iOException) {}
        }
        this.sort();
    }

    public final boolean any() {
        Collection collection = this.pathVariables;
        boolean bl = false;
        return !collection.isEmpty();
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.pathVariables, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @JvmOverloads
    public final void add(@NotNull String name, @NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        PathVariables.add$default(this, name, dir, false, 4, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/model/PathVariables$PathVariable;", "", "name", "", "dir", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "getDir", "()Ljava/io/File;", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "lint-model"})
    private static final class PathVariable {
        @NotNull
        private final String name;
        @NotNull
        private final File dir;

        public PathVariable(@NotNull String name, @NotNull File dir) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            this.name = name;
            this.dir = dir;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final File getDir() {
            return this.dir;
        }

        @NotNull
        public String toString() {
            return this.name + '=' + this.dir;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final File component2() {
            return this.dir;
        }

        @NotNull
        public final PathVariable copy(@NotNull String name, @NotNull File dir) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            return new PathVariable(name, dir);
        }

        public static /* synthetic */ PathVariable copy$default(PathVariable pathVariable, String string, File file, int n, Object object) {
            if ((n & 1) != 0) {
                string = pathVariable.name;
            }
            if ((n & 2) != 0) {
                file = pathVariable.dir;
            }
            return pathVariable.copy(string, file);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.dir.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PathVariable)) {
                return false;
            }
            PathVariable pathVariable = (PathVariable)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)pathVariable.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.dir, (Object)pathVariable.dir);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/model/PathVariables$Companion;", "", "()V", "CANONICALIZED", "", "PATH_COMPARATOR", "Ljava/util/Comparator;", "Lcom/android/tools/lint/model/PathVariables$PathVariable;", "Lkotlin/Comparator;", "checkPathVariableName", "", "name", "parse", "Lcom/android/tools/lint/model/PathVariables;", "s", "lint-model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PathVariables parse(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            PathVariables variables = new PathVariables();
            boolean bl = false;
            Set names = new LinkedHashSet();
            char[] cArray = new char[]{';'};
            for (String pair : StringsKt.split$default((CharSequence)s, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
                if (StringsKt.isBlank((CharSequence)pair)) continue;
                int index = StringsKt.indexOf$default((CharSequence)pair, (char)'=', (int)0, (boolean)false, (int)6, null);
                if (index <= 0 || index == pair.length() - 1 || StringsKt.startsWith$default((String)pair, (String)"$$", (boolean)false, (int)2, null)) {
                    String string = "Invalid path descriptor " + pair + ", expected name=path-prefix";
                    boolean bl2 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                String string = pair;
                int n = 0;
                int n2 = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n, index);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string = string3;
                n = 0;
                String string4 = string;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String name = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                if (!names.add(name)) continue;
                String string5 = pair;
                n2 = index + 1;
                boolean bl3 = false;
                String string6 = string5;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                string5 = string7;
                n2 = 0;
                String string8 = string5;
                if (string8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                File prefix = new File(((Object)StringsKt.trim((CharSequence)string8)).toString());
                variables.add(name, prefix, false);
            }
            variables.sort();
            return variables;
        }

        /*
         * WARNING - void declaration
         */
        private final void checkPathVariableName(String name) {
            if (StringsKt.startsWith$default((CharSequence)name, (char)'{', (boolean)false, (int)2, null)) {
                if (!StringsKt.endsWith$default((CharSequence)name, (char)'}', (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)name, (String)"}_canonical", (boolean)false, (int)2, null)) {
                    String string = "Invalid path variable name " + name + ", missing ending \"}\".";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            } else {
                boolean bl;
                boolean bl2;
                char c;
                char it;
                Sequence $this$any$iv;
                block6: {
                    $this$any$iv = StringsKt.asSequence((CharSequence)name);
                    boolean $i$f$any = false;
                    for (Object element$iv2 : $this$any$iv) {
                        it = ((Character)element$iv2).charValue();
                        boolean bl3 = false;
                        c = it;
                        bl2 = false;
                        boolean bl4 = !Character.isJavaIdentifierPart(c);
                        if (!bl4) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
                if (bl) {
                    StringBuilder stringBuilder;
                    Object element$iv2;
                    block7: {
                        void $this$first$iv;
                        $this$any$iv = StringsKt.asSequence((CharSequence)name);
                        stringBuilder = new StringBuilder().append("Invalid path variable name ").append(name).append(". Contains illegal character \"");
                        boolean $i$f$first = false;
                        for (Object element$iv2 : $this$first$iv) {
                            it = ((Character)element$iv2).charValue();
                            boolean bl5 = false;
                            c = it;
                            bl2 = false;
                            boolean bl6 = !Character.isJavaIdentifierPart(c);
                            if (!bl6) continue;
                            break block7;
                        }
                        throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                    }
                    Object e = element$iv2;
                    String string = stringBuilder.append(((Character)e).charValue()).append("\".").toString();
                    boolean bl7 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

