/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.api;

import com.android.repository.api.ProgressIndicator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;

public interface Downloader {
    public InputStream downloadAndStream(URL var1, ProgressIndicator var2) throws IOException;

    public Path downloadFully(URL var1, ProgressIndicator var2) throws IOException;

    public void downloadFully(URL var1, File var2, String var3, ProgressIndicator var4) throws IOException;

    @VisibleForTesting
    public static String hash(InputStream in, long fileSize, ProgressIndicator progress) throws IOException {
        int bytesRead;
        progress.setText("Checking existing file...");
        Hasher sha1 = Hashing.sha1().newHasher();
        byte[] buf = new byte[5120];
        long totalRead = 0L;
        while ((bytesRead = in.read(buf)) > 0) {
            sha1.putBytes(buf, 0, bytesRead);
            progress.setFraction((double)totalRead / (double)fileSize);
        }
        return sha1.hash().toString();
    }
}

