/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.manager;

import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.Downloader;
import com.android.repository.api.FallbackLocalRepoLoader;
import com.android.repository.api.FallbackRemoteRepoLoader;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.RepositorySourceProvider;
import com.android.repository.api.SchemaModule;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.manager.LocalRepoLoader;
import com.android.repository.impl.manager.LocalRepoLoaderImpl;
import com.android.repository.impl.manager.RemoteRepoLoader;
import com.android.repository.impl.manager.RemoteRepoLoaderImpl;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.impl.meta.SchemaModuleUtil;
import com.android.repository.io.FileOp;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.w3c.dom.ls.LSResourceResolver;

public class RepoManagerImpl
extends RepoManager {
    private final List<SchemaModule<?>> mModules = new ArrayList();
    private FallbackLocalRepoLoader mFallbackLocalRepoLoader;
    private File mLocalPath;
    private FallbackRemoteRepoLoader mFallbackRemoteRepoLoader;
    private Set<RepositorySourceProvider> mSourceProviders = Sets.newHashSet();
    private RepositoryPackages mPackages = new RepositoryPackages();
    private long mLastRemoteRefreshMs;
    private long mLastLocalRefreshMs;
    private LoadTask mTask;
    private long mTaskCreateTime;
    private final Object mTaskLock = new Object();
    private final FileOp mFop;
    private final List<RepoManager.RepoLoadedCallback> mLocalListeners = Lists.newArrayList();
    private final List<RepoManager.RepoLoadedCallback> mRemoteListeners = Lists.newArrayList();
    private static final long TASK_TIMEOUT = TimeUnit.MINUTES.toMillis(3L);
    private final Map<RepoPackage, PackageOperation> mInProgressInstalls = Maps.newHashMap();
    private final LocalRepoLoaderFactory mLocalRepoLoaderFactory;
    private final RemoteRepoLoaderFactory mRemoteRepoLoaderFactory;

    public RepoManagerImpl(FileOp fop) {
        this(fop, null, null);
    }

    @VisibleForTesting
    public RepoManagerImpl(FileOp fop, LocalRepoLoaderFactory localFactory, RemoteRepoLoaderFactory remoteFactory) {
        this.mFop = fop;
        this.registerSchemaModule(RepoManagerImpl.getCommonModule());
        this.registerSchemaModule(RepoManagerImpl.getGenericModule());
        this.mLocalRepoLoaderFactory = localFactory == null ? new LocalRepoLoaderFactoryImpl() : localFactory;
        this.mRemoteRepoLoaderFactory = remoteFactory == null ? new RemoteRepoLoaderFactoryImpl() : remoteFactory;
    }

    @Override
    public File getLocalPath() {
        return this.mLocalPath;
    }

    @Override
    public void setFallbackLocalRepoLoader(FallbackLocalRepoLoader fallback) {
        this.mFallbackLocalRepoLoader = fallback;
        this.markInvalid();
    }

    @Override
    public void setFallbackRemoteRepoLoader(FallbackRemoteRepoLoader remote) {
        this.mFallbackRemoteRepoLoader = remote;
        this.markInvalid();
    }

    @Override
    public void setLocalPath(File path) {
        this.mLocalPath = path;
        this.markInvalid();
    }

    @Override
    public void registerSourceProvider(RepositorySourceProvider provider) {
        this.mSourceProviders.add(provider);
        this.markInvalid();
    }

    @Override
    @VisibleForTesting
    public Set<RepositorySourceProvider> getSourceProviders() {
        return this.mSourceProviders;
    }

    @Override
    public Set<RepositorySource> getSources(Downloader downloader, ProgressIndicator progress, boolean forceRefresh) {
        HashSet result = Sets.newHashSet();
        for (RepositorySourceProvider provider : this.mSourceProviders) {
            result.addAll(provider.getSources(downloader, progress, forceRefresh));
        }
        return result;
    }

    @Override
    public List<SchemaModule<?>> getSchemaModules() {
        return this.mModules;
    }

    @Override
    public void registerSchemaModule(SchemaModule module) {
        this.mModules.add(module);
        this.markInvalid();
    }

    @Override
    public void markInvalid() {
        this.mLastRemoteRefreshMs = 0L;
        this.mLastLocalRefreshMs = 0L;
    }

    @Override
    public void markLocalCacheInvalid() {
        this.mLastLocalRefreshMs = 0L;
    }

    @Override
    public LSResourceResolver getResourceResolver(ProgressIndicator progress) {
        ImmutableSet allModules = ImmutableSet.builder().addAll(this.getSchemaModules()).add(RepoManagerImpl.getCommonModule()).add(RepoManagerImpl.getGenericModule()).build();
        return SchemaModuleUtil.createResourceResolver(allModules, progress);
    }

    @Override
    public RepositoryPackages getPackages() {
        return this.mPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(long cacheExpirationMs, List<RepoManager.RepoLoadedCallback> onLocalComplete, List<RepoManager.RepoLoadedCallback> onSuccess, List<Runnable> onError, ProgressRunner runner, Downloader downloader, SettingsController settings, boolean sync) {
        if (onLocalComplete == null) {
            onLocalComplete = ImmutableList.of();
        }
        if (onSuccess == null) {
            onSuccess = ImmutableList.of();
        }
        if (onError == null) {
            onError = ImmutableList.of();
        }
        Semaphore completed = new Semaphore(1);
        try {
            completed.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean createdTask = false;
        Object object = this.mTaskLock;
        synchronized (object) {
            long taskTimeout = System.currentTimeMillis() - TASK_TIMEOUT;
            if (this.mTask != null && this.mTaskCreateTime > taskTimeout) {
                this.mTask.addCallbacks((List<RepoManager.RepoLoadedCallback>)onLocalComplete, (List<RepoManager.RepoLoadedCallback>)onSuccess, (List<Runnable>)onError, runner);
                if (sync) {
                    this.mTask.addCallbacks((List<RepoManager.RepoLoadedCallback>)ImmutableList.of(), (List<RepoManager.RepoLoadedCallback>)ImmutableList.of(packages -> completed.release()), (List<Runnable>)ImmutableList.of(completed::release), new RepoManager.DummyProgressRunner(new ConsoleProgressIndicator()));
                }
            } else {
                this.mTask = new LoadTask(cacheExpirationMs, (List<RepoManager.RepoLoadedCallback>)onLocalComplete, (List<RepoManager.RepoLoadedCallback>)onSuccess, (List<Runnable>)onError, downloader, settings);
                this.mTaskCreateTime = System.currentTimeMillis();
                createdTask = true;
            }
        }
        if (createdTask) {
            if (sync) {
                runner.runSyncWithProgress(this.mTask);
            } else {
                runner.runAsyncWithProgress(this.mTask);
            }
        } else if (sync) {
            runner.runSyncWithProgress((indicator, runner2) -> {
                try {
                    completed.acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
        }
    }

    @Override
    public boolean reloadLocalIfNeeded(ProgressIndicator progress) {
        LocalRepoLoader local = this.mLocalRepoLoaderFactory.createLocalRepoLoader();
        if (local == null) {
            return false;
        }
        if (local.needsUpdate(this.mLastLocalRefreshMs, true)) {
            this.mLastLocalRefreshMs = 0L;
        }
        return this.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, progress, null, null);
    }

    @Override
    public void registerLocalChangeListener(RepoManager.RepoLoadedCallback listener) {
        this.mLocalListeners.add(listener);
    }

    @Override
    public void registerRemoteChangeListener(RepoManager.RepoLoadedCallback listener) {
        this.mRemoteListeners.add(listener);
    }

    @Override
    public void installBeginning(RepoPackage remotePackage, PackageOperation installer) {
        this.mInProgressInstalls.put(remotePackage, installer);
    }

    @Override
    public void installEnded(RepoPackage remotePackage) {
        this.mInProgressInstalls.remove(remotePackage);
    }

    @Override
    public PackageOperation getInProgressInstallOperation(RepoPackage remotePackage) {
        return this.mInProgressInstalls.get(remotePackage);
    }

    private static class CallbackRunnable
    implements Runnable {
        RepoManager.RepoLoadedCallback mCallback;
        RepositoryPackages mPackages;

        public CallbackRunnable(RepoManager.RepoLoadedCallback callback, RepositoryPackages packages) {
            this.mCallback = callback;
            this.mPackages = packages;
        }

        @Override
        public void run() {
            this.mCallback.doRun(this.mPackages);
        }
    }

    private class RemoteRepoLoaderFactoryImpl
    implements RemoteRepoLoaderFactory {
        private RemoteRepoLoaderFactoryImpl() {
        }

        @Override
        public RemoteRepoLoader createRemoteRepoLoader(ProgressIndicator progress) {
            return new RemoteRepoLoaderImpl(RepoManagerImpl.this.mSourceProviders, RepoManagerImpl.this.getResourceResolver(progress), RepoManagerImpl.this.mFallbackRemoteRepoLoader);
        }
    }

    private class LocalRepoLoaderFactoryImpl
    implements LocalRepoLoaderFactory {
        private LocalRepoLoaderFactoryImpl() {
        }

        @Override
        public LocalRepoLoader createLocalRepoLoader() {
            if (RepoManagerImpl.this.mLocalPath != null && RepoManagerImpl.this.mFop != null) {
                return new LocalRepoLoaderImpl(RepoManagerImpl.this.mLocalPath, RepoManagerImpl.this, RepoManagerImpl.this.mFallbackLocalRepoLoader, RepoManagerImpl.this.mFop);
            }
            return null;
        }
    }

    @VisibleForTesting
    public static interface RemoteRepoLoaderFactory {
        public RemoteRepoLoader createRemoteRepoLoader(ProgressIndicator var1);
    }

    static interface LocalRepoLoaderFactory {
        public LocalRepoLoader createLocalRepoLoader();
    }

    private class LoadTask
    implements ProgressRunner.ProgressRunnable {
        private final List<Callback> mOnSuccesses = Lists.newArrayList();
        private final List<Runnable> mOnErrors = Lists.newArrayList();
        private final Queue<Callback> mOnLocalCompletes = new ConcurrentLinkedQueue<Callback>();
        private final Downloader mDownloader;
        private final SettingsController mSettings;
        private final long mCacheExpirationMs;

        public LoadTask(long cacheExpirationMs, List<RepoManager.RepoLoadedCallback> onLocalComplete, List<RepoManager.RepoLoadedCallback> onSuccess, List<Runnable> onError, Downloader downloader, SettingsController settings) {
            this.addCallbacks(onLocalComplete, onSuccess, onError, null);
            this.mDownloader = downloader;
            this.mSettings = settings;
            this.mCacheExpirationMs = cacheExpirationMs;
        }

        public void addCallbacks(List<RepoManager.RepoLoadedCallback> onLocalComplete, List<RepoManager.RepoLoadedCallback> onSuccess, List<Runnable> onError, ProgressRunner runner) {
            for (RepoManager.RepoLoadedCallback local : onLocalComplete) {
                this.mOnLocalCompletes.add(new Callback(local, runner));
            }
            for (RepoManager.RepoLoadedCallback success : onSuccess) {
                this.mOnSuccesses.add(new Callback(success, runner));
            }
            this.mOnErrors.addAll(onError);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(ProgressIndicator indicator, ProgressRunner runner) {
            Iterator<Object> newLocals;
            boolean success = false;
            boolean localSuccess = false;
            boolean wasIndeterminate = indicator.isIndeterminate();
            indicator.setIndeterminate(false);
            try {
                LocalRepoLoader local = RepoManagerImpl.this.mLocalRepoLoaderFactory.createLocalRepoLoader();
                if (local != null && (RepoManagerImpl.this.mLastLocalRefreshMs + this.mCacheExpirationMs <= System.currentTimeMillis() || local.needsUpdate(RepoManagerImpl.this.mLastLocalRefreshMs, false))) {
                    if (RepoManagerImpl.this.mFallbackLocalRepoLoader != null) {
                        RepoManagerImpl.this.mFallbackLocalRepoLoader.refresh();
                    }
                    indicator.setText("Loading local repository...");
                    newLocals = local.getPackages(indicator);
                    boolean fireListeners = !newLocals.equals(RepoManagerImpl.this.mPackages.getLocalPackages());
                    RepoManagerImpl.this.mPackages.setLocalPkgInfos(newLocals.values());
                    RepoManagerImpl.this.mLastLocalRefreshMs = System.currentTimeMillis();
                    if (fireListeners) {
                        for (RepoManager.RepoLoadedCallback listener : RepoManagerImpl.this.mLocalListeners) {
                            listener.doRun(RepoManagerImpl.this.mPackages);
                        }
                    }
                }
                indicator.setFraction(0.25);
                if (indicator.isCanceled()) {
                    return;
                }
                localSuccess = true;
                Callback onLocalComplete = this.mOnLocalCompletes.poll();
                while (onLocalComplete != null) {
                    onLocalComplete.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onLocalComplete.mCallback, RepoManagerImpl.this.mPackages));
                    onLocalComplete = this.mOnLocalCompletes.poll();
                }
                indicator.setText("Fetch remote repository...");
                indicator.setSecondaryText("");
                if (!RepoManagerImpl.this.mSourceProviders.isEmpty() && this.mDownloader != null && RepoManagerImpl.this.mLastRemoteRefreshMs + this.mCacheExpirationMs <= System.currentTimeMillis()) {
                    RemoteRepoLoader remoteLoader = RepoManagerImpl.this.mRemoteRepoLoaderFactory.createRemoteRepoLoader(indicator);
                    Map<String, RemotePackage> remotes = remoteLoader.fetchPackages(indicator.createSubProgress(0.75), this.mDownloader, this.mSettings);
                    indicator.setText("Computing updates...");
                    indicator.setFraction(0.75);
                    boolean fireListeners = !remotes.equals(RepoManagerImpl.this.mPackages.getRemotePackages());
                    RepoManagerImpl.this.mPackages.setRemotePkgInfos(remotes.values());
                    RepoManagerImpl.this.mLastRemoteRefreshMs = System.currentTimeMillis();
                    if (fireListeners) {
                        for (RepoManager.RepoLoadedCallback callback : RepoManagerImpl.this.mRemoteListeners) {
                            callback.doRun(RepoManagerImpl.this.mPackages);
                        }
                    }
                }
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setSecondaryText("");
                indicator.setFraction(1.0);
                if (indicator.isCanceled()) {
                    return;
                }
                success = true;
            }
            finally {
                indicator.setIndeterminate(wasIndeterminate);
                newLocals = RepoManagerImpl.this.mTaskLock;
                synchronized (newLocals) {
                    RepoManagerImpl.this.mTask = null;
                }
                if (localSuccess) {
                    for (Callback onLocalComplete : this.mOnLocalCompletes) {
                        onLocalComplete.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onLocalComplete.getCallback(), RepoManagerImpl.this.mPackages));
                    }
                }
                if (success) {
                    for (Callback onSuccess : this.mOnSuccesses) {
                        onSuccess.getRunner(runner).runSyncWithoutProgress(new CallbackRunnable(onSuccess.getCallback(), RepoManagerImpl.this.mPackages));
                    }
                } else {
                    for (Runnable onError : this.mOnErrors) {
                        onError.run();
                    }
                }
            }
        }

        private class Callback {
            private RepoManager.RepoLoadedCallback mCallback;
            private ProgressRunner mRunner;

            public Callback(RepoManager.RepoLoadedCallback callback, ProgressRunner runner) {
                this.mCallback = callback;
                this.mRunner = runner;
            }

            public ProgressRunner getRunner(ProgressRunner defaultRunner) {
                return this.mRunner == null ? defaultRunner : this.mRunner;
            }

            public RepoManager.RepoLoadedCallback getCallback() {
                return this.mCallback;
            }
        }
    }
}

