/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.installer;

import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractPackageOperation;
import com.android.repository.io.FileOp;
import com.android.repository.util.InstallerUtil;
import java.io.File;
import java.io.IOException;

public abstract class AbstractInstaller
extends AbstractPackageOperation
implements Installer {
    private final RemotePackage mPackage;
    private final Downloader mDownloader;
    private File mInstallLocation = null;

    public AbstractInstaller(RemotePackage p, RepoManager manager, Downloader downloader, FileOp fop) {
        super(manager, fop);
        this.mPackage = p;
        this.mDownloader = downloader;
        this.registerStateChangeListener((op, progress) -> {
            if (this.getInstallStatus() == PackageOperation.InstallStatus.COMPLETE) {
                try {
                    InstallerUtil.writePackageXml(this.getPackage(), this.getLocation(progress), this.getRepoManager(), this.mFop, progress);
                }
                catch (IOException e) {
                    progress.logWarning("Failed to update package.xml", e);
                    throw new PackageOperation.StatusChangeListenerException(e);
                }
            }
        });
    }

    @Override
    public RemotePackage getPackage() {
        return this.mPackage;
    }

    @Override
    public final File getLocation(ProgressIndicator progress) {
        if (this.mInstallLocation == null) {
            this.mInstallLocation = this.computeInstallLocation(progress);
        }
        return this.mInstallLocation;
    }

    private File computeInstallLocation(ProgressIndicator progress) {
        LocalPackage existing = this.getRepoManager().getPackages().getLocalPackages().get(this.mPackage.getPath());
        if (existing != null) {
            return existing.getLocation();
        }
        return this.getNonConflictingPath(progress);
    }

    private File getNonConflictingPath(ProgressIndicator progress) {
        File dir = this.mPackage.getInstallDir(this.getRepoManager(), progress);
        if (!this.mFop.exists(dir)) {
            return dir;
        }
        if (this.mFop.isDirectory(dir)) {
            File[] files = this.mFop.listFiles(dir);
            if (files.length == 0) {
                return dir;
            }
            if (files.length == 1 && files[0].getName().equals(".installer")) {
                return dir;
            }
        }
        LocalPackage conflicting = this.findConflictingPackage(dir, progress);
        String warning = "Package \"" + this.mPackage + "\" (" + this.mPackage.getPath() + ") should be installed in \n\"" + dir + "\" but \n";
        if (conflicting != null) {
            warning = warning + "\"" + conflicting.getDisplayName() + "\" (" + conflicting.getPath() + ") is already installed ";
            warning = conflicting.getLocation().equals(dir) ? warning + "there." : warning + "in \n\"" + conflicting.getLocation() + "\".";
        } else {
            warning = warning + "it already exists.";
        }
        File parent = dir.getParentFile();
        String leaf = dir.getName();
        int n = 2;
        while (this.mFop.exists(dir = new File(parent, leaf + "-" + n))) {
            ++n;
        }
        warning = warning + "\nInstalling in \"" + dir + "\" instead.";
        progress.logWarning(warning);
        return dir;
    }

    private LocalPackage findConflictingPackage(File dir, ProgressIndicator progress) {
        for (LocalPackage existing : this.getRepoManager().getPackages().getLocalPackages().values()) {
            try {
                String newLocation;
                String existingLocation = existing.getLocation().getCanonicalPath();
                if (!existingLocation.startsWith(newLocation = dir.getCanonicalPath()) && !newLocation.startsWith(existingLocation)) continue;
                return existing;
            }
            catch (IOException e) {
                progress.logWarning("Error while trying to check install path", e);
                return existing;
            }
        }
        return null;
    }

    protected Downloader getDownloader() {
        return this.mDownloader;
    }

    @Override
    public String getName() {
        return String.format("Install %1$s (revision: %2$s)", this.mPackage.getDisplayName(), this.mPackage.getVersion().toString());
    }
}

