/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.io;

import com.android.io.CancellableFileIo;
import com.android.repository.api.ProgressIndicator;
import com.android.utils.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class FileOpUtils {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");

    public static void recursiveCopy(Path src, Path dest, boolean merge, Predicate<Path> fileFilter, ProgressIndicator progress) throws IOException {
        if (CancellableFileIo.exists((Path)dest, (LinkOption[])new LinkOption[0])) {
            if (!merge) {
                throw new IOException(dest + " already exists!");
            }
            if (CancellableFileIo.isDirectory((Path)src, (LinkOption[])new LinkOption[0]) != CancellableFileIo.isDirectory((Path)dest, (LinkOption[])new LinkOption[0])) {
                throw new IOException(String.format("%s already exists but %s a directory!", dest, CancellableFileIo.isDirectory((Path)dest, (LinkOption[])new LinkOption[0]) ? "is" : "is not"));
            }
        }
        if (progress.isCanceled()) {
            throw new IOException("Operation cancelled");
        }
        if (fileFilter != null && !fileFilter.test(src)) {
            return;
        }
        if (CancellableFileIo.isDirectory((Path)src, (LinkOption[])new LinkOption[0])) {
            Files.createDirectories(dest, new FileAttribute[0]);
            for (Path child : FileOpUtils.listFiles(src)) {
                Path newDest = dest.resolve(child.getFileName());
                FileOpUtils.recursiveCopy(child, newDest, merge, fileFilter, progress);
            }
        } else if (CancellableFileIo.isRegularFile((Path)src, (LinkOption[])new LinkOption[0]) && !CancellableFileIo.exists((Path)dest, (LinkOption[])new LinkOption[0])) {
            Files.copy(src, dest, new CopyOption[0]);
            if (!FileOpUtils.isWindows() && CancellableFileIo.isExecutable((Path)src)) {
                FileOpUtils.setExecutablePermission(dest);
            }
        }
    }

    public static Path[] listFiles(Path file) {
        Path[] pathArray;
        block8: {
            Stream children = CancellableFileIo.list((Path)file);
            try {
                pathArray = (Path[])children.toArray(Path[]::new);
                if (children == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (children != null) {
                        try {
                            children.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return new Path[0];
                }
            }
            children.close();
        }
        return pathArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void safeRecursiveOverwrite(Path src, Path dest, ProgressIndicator progress) throws IOException {
        Path destBackup;
        block22: {
            boolean success;
            block21: {
                destBackup = FileOpUtils.getTempDir(dest, "backup");
                success = false;
                try {
                    if (!CancellableFileIo.exists((Path)dest, (LinkOption[])new LinkOption[0])) break block21;
                    FileOpUtils.moveOrCopyAndDelete(dest, destBackup, progress);
                    if (CancellableFileIo.exists((Path)dest, (LinkOption[])new LinkOption[0])) {
                        throw new IOException(String.format("Failed to move away or delete existing target file: %s%nMove it away manually and try again.", dest));
                    }
                    success = true;
                }
                catch (Throwable throwable) {
                    if (!success && CancellableFileIo.exists((Path)destBackup, (LinkOption[])new LinkOption[0])) {
                        try {
                            FileOpUtils.recursiveCopy(destBackup, dest, true, null, progress);
                            FileOpUtils.deleteFileOrFolder(destBackup);
                        }
                        catch (IOException e) {
                            progress.logWarning(String.format("Failed to move original content of %s back into place! It should be available at %s", dest, destBackup), e);
                        }
                    }
                    throw throwable;
                }
            }
            if (!success && CancellableFileIo.exists((Path)destBackup, (LinkOption[])new LinkOption[0])) {
                try {
                    FileOpUtils.recursiveCopy(destBackup, dest, true, null, progress);
                    FileOpUtils.deleteFileOrFolder(destBackup);
                }
                catch (IOException e) {
                    progress.logWarning(String.format("Failed to move original content of %s back into place! It should be available at %s", dest, destBackup), e);
                }
            }
            success = false;
            try {
                FileOpUtils.moveOrCopyAndDelete(src, dest, progress);
                success = true;
                if (success) break block22;
            }
            catch (Throwable throwable) {
                if (!success) {
                    FileOpUtils.deleteFileOrFolder(dest);
                    if (CancellableFileIo.exists((Path)dest, (LinkOption[])new LinkOption[0])) {
                        Path toDelete = FileOpUtils.getTempDir(dest, "delete");
                        Files.move(dest, toDelete, new CopyOption[0]);
                        PathUtils.addRemovePathHook((Path)toDelete);
                    }
                    try {
                        if (CancellableFileIo.exists((Path)dest, (LinkOption[])new LinkOption[0])) {
                            FileOpUtils.recursiveCopy(destBackup, dest, true, null, progress);
                        } else {
                            FileOpUtils.moveOrCopyAndDelete(destBackup, dest, progress);
                        }
                    }
                    catch (IOException e) {
                        progress.logWarning(String.format("Failed to move original content of %s back into place! It should be available at %s", dest, destBackup), e);
                    }
                }
                throw throwable;
            }
            FileOpUtils.deleteFileOrFolder(dest);
            if (CancellableFileIo.exists((Path)dest, (LinkOption[])new LinkOption[0])) {
                Path toDelete = FileOpUtils.getTempDir(dest, "delete");
                Files.move(dest, toDelete, new CopyOption[0]);
                PathUtils.addRemovePathHook((Path)toDelete);
            }
            try {
                if (CancellableFileIo.exists((Path)dest, (LinkOption[])new LinkOption[0])) {
                    FileOpUtils.recursiveCopy(destBackup, dest, true, null, progress);
                    break block22;
                }
                FileOpUtils.moveOrCopyAndDelete(destBackup, dest, progress);
            }
            catch (IOException e) {
                progress.logWarning(String.format("Failed to move original content of %s back into place! It should be available at %s", dest, destBackup), e);
            }
        }
        FileOpUtils.deleteFileOrFolder(destBackup);
    }

    private static void moveOrCopyAndDelete(Path src, Path dest, ProgressIndicator progress) throws IOException {
        block2: {
            try {
                Files.move(src, dest, new CopyOption[0]);
            }
            catch (IOException ignore) {
                FileOpUtils.recursiveCopy(src, dest, true, null, progress);
                if (FileOpUtils.deleteFileOrFolder(src)) break block2;
                throw new IOException("Failed to delete" + src);
            }
        }
    }

    private static Path getTempDir(Path orig, String suffix) {
        Path result = orig.getFileSystem().getPath(orig + "." + suffix, new String[0]);
        int i = 1;
        while (CancellableFileIo.exists((Path)result, (LinkOption[])new LinkOption[0])) {
            FileOpUtils.deleteFileOrFolder(result);
            if (!CancellableFileIo.exists((Path)result, (LinkOption[])new LinkOption[0])) break;
            result = orig.getFileSystem().getPath(result + "-" + i++, new String[0]);
        }
        return result;
    }

    public static Path getNewTempDir(String base, FileSystem fileSystem) {
        for (int i = 1; i < 100; ++i) {
            Path rootTempDir = fileSystem.getPath(System.getProperty("java.io.tmpdir"), new String[0]);
            Path folder = rootTempDir.resolve(String.format(Locale.US, "%1$s%2$02d", base, i));
            if (!CancellableFileIo.notExists((Path)folder, (LinkOption[])new LinkOption[0])) continue;
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
                return folder;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static File append(File base, String ... segments) {
        for (String segment : segments) {
            base = new File(base, segment);
        }
        return base;
    }

    public static String makeRelative(File baseDir, File toBeRelative) throws IOException {
        return FileOpUtils.makeRelativeImpl(baseDir.getCanonicalPath(), toBeRelative.getCanonicalPath(), File.separator);
    }

    @VisibleForTesting
    static String makeRelativeImpl(String path1, String path2, String dirSeparator) throws IOException {
        int start;
        if (FileOpUtils.isWindows()) {
            char drive2;
            char drive1 = path1.length() >= 2 && path1.charAt(1) == ':' ? path1.charAt(0) : (char)'\u0000';
            char c = drive2 = path2.length() >= 2 && path2.charAt(1) == ':' ? path2.charAt(0) : (char)'\u0000';
            if (drive1 != drive2) {
                throw new IOException("makeRelative: incompatible drive letters");
            }
        }
        String[] segments1 = path1.split(Pattern.quote(dirSeparator));
        String[] segments2 = path2.split(Pattern.quote(dirSeparator));
        int len1 = segments1.length;
        int len2 = segments2.length;
        int len = Math.min(len1, len2);
        for (start = 0; start < len && (!FileOpUtils.isWindows() || segments1[start].equalsIgnoreCase(segments2[start])) && (FileOpUtils.isWindows() || segments1[start].equals(segments2[start])); ++start) {
        }
        StringBuilder result = new StringBuilder();
        for (int i = start; i < len1; ++i) {
            result.append("..").append(dirSeparator);
        }
        while (start < len2) {
            result.append(segments2[start]);
            if (++start >= len2) continue;
            result.append(dirSeparator);
        }
        return result.toString();
    }

    private FileOpUtils() {
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean deleteFileOrFolder(Path fileOrFolder) {
        final boolean[] sawException = new boolean[1];
        try {
            CancellableFileIo.walkFileTree((Path)fileOrFolder, (FileVisitor)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException ignore) {
                        sawException[0] = true;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    sawException[0] = true;
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    try {
                        Files.delete(dir);
                    }
                    catch (IOException ignore) {
                        sawException[0] = true;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            return false;
        }
        return !sawException[0];
    }

    public static void setExecutablePermission(Path path) throws IOException {
        EnumSet<PosixFilePermission> permissions = EnumSet.copyOf(Files.getPosixFilePermissions(path, new LinkOption[0]));
        permissions.add(PosixFilePermission.OWNER_EXECUTE);
        permissions.add(PosixFilePermission.GROUP_EXECUTE);
        permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        Files.setPosixFilePermissions(path, permissions);
    }

    public static File toFile(Path path) {
        if (path.getFileSystem() == FileSystems.getDefault()) {
            return path.toFile();
        }
        return new File(path.toString());
    }
}

