/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.api;

import com.android.annotations.concurrency.Slow;
import com.android.repository.api.Downloader;
import com.android.repository.api.FallbackLocalRepoLoader;
import com.android.repository.api.FallbackRemoteRepoLoader;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.RepositorySource;
import com.android.repository.api.RepositorySourceProvider;
import com.android.repository.api.SchemaModule;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.manager.RepoManagerImpl;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.GenericFactory;
import com.android.repository.impl.meta.RepositoryPackages;
import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.ls.LSResourceResolver;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 H2\u00020\u0001:\u0003FGHB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H&J\u0012\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H&J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H&J(\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH&J\u0012\u0010 \u001a\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\"H&Jf\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%2\u0010\b\u0002\u0010&\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010\t2\u0010\b\u0002\u0010(\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010\t2\u0010\b\u0002\u0010)\u001a\n\u0012\u0004\u0012\u00020*\u0018\u00010\t2\u0006\u0010+\u001a\u00020,2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.H&Jf\u0010/\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%2\u0010\b\u0002\u0010&\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010\t2\u0010\b\u0002\u0010(\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010\t2\u0010\b\u0002\u0010)\u001a\n\u0012\u0004\u0012\u00020*\u0018\u00010\t2\u0006\u0010+\u001a\u00020,2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.H'J0\u0010/\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.H\u0007J\b\u00100\u001a\u00020\u0005H&J\b\u00101\u001a\u00020\u0005H&J\u0010\u00102\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH&J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\u001c\u001a\u00020\u001dH&J\u0010\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020'H&J\u0010\u0010;\u001a\u00020\u00052\u0006\u0010:\u001a\u00020'H&J\u0010\u0010<\u001a\u00020\u00052\u0006\u0010:\u001a\u00020'H&J\u0010\u0010=\u001a\u00020\u00052\u0006\u0010:\u001a\u00020'H&J\u0018\u0010>\u001a\u00020\u00052\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH&J\u0010\u0010C\u001a\u00020\u00052\u0006\u0010?\u001a\u00020@H&J\u0012\u0010D\u001a\u0004\u0018\u00010B2\u0006\u0010E\u001a\u00020@H&R\u001c\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u0004\u0018\u00010\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000bR\u0012\u00103\u001a\u000204X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u0006I"}, d2={"Lcom/android/repository/api/RepoManager;", "", "<init>", "()V", "registerSchemaModule", "", "module", "Lcom/android/repository/api/SchemaModule;", "schemaModules", "", "getSchemaModules", "()Ljava/util/List;", "localPath", "Ljava/nio/file/Path;", "getLocalPath", "()Ljava/nio/file/Path;", "setFallbackLocalRepoLoader", "local", "Lcom/android/repository/api/FallbackLocalRepoLoader;", "registerSourceProvider", "provider", "Lcom/android/repository/api/RepositorySourceProvider;", "sourceProviders", "getSourceProviders", "getSources", "Lcom/android/repository/api/RepositorySource;", "downloader", "Lcom/android/repository/api/Downloader;", "progress", "Lcom/android/repository/api/ProgressIndicator;", "forceRefresh", "", "setFallbackRemoteRepoLoader", "remote", "Lcom/android/repository/api/FallbackRemoteRepoLoader;", "load", "cacheExpirationMs", "", "onLocalComplete", "Lcom/android/repository/api/RepoManager$RepoLoadedListener;", "onSuccess", "onError", "Ljava/lang/Runnable;", "runner", "Lcom/android/repository/api/ProgressRunner;", "settings", "Lcom/android/repository/api/SettingsController;", "loadSynchronously", "markInvalid", "markLocalCacheInvalid", "reloadLocalIfNeeded", "packages", "Lcom/android/repository/impl/meta/RepositoryPackages;", "getPackages", "()Lcom/android/repository/impl/meta/RepositoryPackages;", "getResourceResolver", "Lorg/w3c/dom/ls/LSResourceResolver;", "addLocalChangeListener", "listener", "removeLocalChangeListener", "addRemoteChangeListener", "removeRemoteChangeListener", "installBeginning", "repoPackage", "Lcom/android/repository/api/RepoPackage;", "installer", "Lcom/android/repository/api/PackageOperation;", "installEnded", "getInProgressInstallOperation", "remotePackage", "RepoLoadedListener", "DirectProgressRunner", "Companion", "repository"})
public abstract class RepoManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public static final long DEFAULT_EXPIRATION_PERIOD_MS = TimeUnit.DAYS.toMillis(1L);
    @NotNull
    private static final String COMMON_XSD_PATTERN = "/xsd/repo-common-%02d.xsd";
    @NotNull
    private static final String COMMON_OBJECT_FACTORY_PATTERN = "com.android.repository.impl.generated.v%d.ObjectFactory";
    @NotNull
    private static final String GENERIC_XSD_PATTERN = "/xsd/generic-%02d.xsd";
    @NotNull
    private static final String GENERIC_OBJECT_FACTORY_PATTERN = "com.android.repository.impl.generated.generic.v%d.ObjectFactory";
    @NotNull
    private static final SchemaModule<CommonFactory> commonModule = new SchemaModule("com.android.repository.impl.generated.v%d.ObjectFactory", "/xsd/repo-common-%02d.xsd", RepoManager.class);
    @NotNull
    private static final SchemaModule<GenericFactory> genericModule = new SchemaModule("com.android.repository.impl.generated.generic.v%d.ObjectFactory", "/xsd/generic-%02d.xsd", RepoManager.class);

    public abstract void registerSchemaModule(@NotNull SchemaModule<?> var1);

    @NotNull
    public abstract List<SchemaModule<?>> getSchemaModules();

    @Nullable
    public abstract Path getLocalPath();

    public abstract void setFallbackLocalRepoLoader(@Nullable FallbackLocalRepoLoader var1);

    public abstract void registerSourceProvider(@NotNull RepositorySourceProvider var1);

    @VisibleForTesting
    @NotNull
    public abstract List<RepositorySourceProvider> getSourceProviders();

    @NotNull
    public abstract List<RepositorySource> getSources(@Nullable Downloader var1, @NotNull ProgressIndicator var2, boolean var3);

    public abstract void setFallbackRemoteRepoLoader(@Nullable FallbackRemoteRepoLoader var1);

    public abstract void load(long var1, @Nullable List<? extends RepoLoadedListener> var3, @Nullable List<? extends RepoLoadedListener> var4, @Nullable List<? extends Runnable> var5, @NotNull ProgressRunner var6, @Nullable Downloader var7, @Nullable SettingsController var8);

    public static /* synthetic */ void load$default(RepoManager repoManager, long l, List list, List list2, List list3, ProgressRunner progressRunner, Downloader downloader, SettingsController settingsController, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: load");
        }
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            list2 = null;
        }
        if ((n & 8) != 0) {
            list3 = null;
        }
        if ((n & 0x20) != 0) {
            downloader = null;
        }
        if ((n & 0x40) != 0) {
            settingsController = null;
        }
        repoManager.load(l, list, list2, list3, progressRunner, downloader, settingsController);
    }

    @Slow
    public abstract void loadSynchronously(long var1, @Nullable List<? extends RepoLoadedListener> var3, @Nullable List<? extends RepoLoadedListener> var4, @Nullable List<? extends Runnable> var5, @NotNull ProgressRunner var6, @Nullable Downloader var7, @Nullable SettingsController var8);

    public static /* synthetic */ void loadSynchronously$default(RepoManager repoManager, long l, List list, List list2, List list3, ProgressRunner progressRunner, Downloader downloader, SettingsController settingsController, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadSynchronously");
        }
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            list2 = null;
        }
        if ((n & 8) != 0) {
            list3 = null;
        }
        if ((n & 0x20) != 0) {
            downloader = null;
        }
        if ((n & 0x40) != 0) {
            settingsController = null;
        }
        repoManager.loadSynchronously(l, list, list2, list3, progressRunner, downloader, settingsController);
    }

    @Slow
    public final boolean loadSynchronously(long cacheExpirationMs, @NotNull ProgressIndicator progress, @Nullable Downloader downloader, @Nullable SettingsController settings) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        AtomicBoolean result = new AtomicBoolean(true);
        RepoManager.loadSynchronously$default(this, cacheExpirationMs, null, null, CollectionsKt.listOf((Object)new Runnable(result){
            final /* synthetic */ AtomicBoolean $result;
            {
                this.$result = $result;
            }

            public final void run() {
                this.$result.set(false);
            }
        }), new DirectProgressRunner(progress), downloader, settings, 6, null);
        return result.get();
    }

    public static /* synthetic */ boolean loadSynchronously$default(RepoManager repoManager, long l, ProgressIndicator progressIndicator, Downloader downloader, SettingsController settingsController, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadSynchronously");
        }
        if ((n & 4) != 0) {
            downloader = null;
        }
        if ((n & 8) != 0) {
            settingsController = null;
        }
        return repoManager.loadSynchronously(l, progressIndicator, downloader, settingsController);
    }

    public abstract void markInvalid();

    public abstract void markLocalCacheInvalid();

    public abstract boolean reloadLocalIfNeeded(@NotNull ProgressIndicator var1);

    @NotNull
    public abstract RepositoryPackages getPackages();

    @Nullable
    public abstract LSResourceResolver getResourceResolver(@NotNull ProgressIndicator var1);

    public abstract void addLocalChangeListener(@NotNull RepoLoadedListener var1);

    public abstract void removeLocalChangeListener(@NotNull RepoLoadedListener var1);

    public abstract void addRemoteChangeListener(@NotNull RepoLoadedListener var1);

    public abstract void removeRemoteChangeListener(@NotNull RepoLoadedListener var1);

    public abstract void installBeginning(@NotNull RepoPackage var1, @NotNull PackageOperation var2);

    public abstract void installEnded(@NotNull RepoPackage var1);

    @Nullable
    public abstract PackageOperation getInProgressInstallOperation(@NotNull RepoPackage var1);

    @NotNull
    public static final SchemaModule<CommonFactory> getCommonModule() {
        return Companion.getCommonModule();
    }

    @NotNull
    public static final SchemaModule<GenericFactory> getGenericModule() {
        return Companion.getGenericModule();
    }

    @JvmStatic
    @NotNull
    public static final RepoManager create(@Nullable Path localPath) {
        return Companion.create(localPath);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0003\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0003\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lcom/android/repository/api/RepoManager$Companion;", "", "<init>", "()V", "DEFAULT_EXPIRATION_PERIOD_MS", "", "COMMON_XSD_PATTERN", "", "COMMON_OBJECT_FACTORY_PATTERN", "GENERIC_XSD_PATTERN", "GENERIC_OBJECT_FACTORY_PATTERN", "commonModule", "Lcom/android/repository/api/SchemaModule;", "Lcom/android/repository/impl/meta/CommonFactory;", "getCommonModule$annotations", "getCommonModule", "()Lcom/android/repository/api/SchemaModule;", "genericModule", "Lcom/android/repository/impl/meta/GenericFactory;", "getGenericModule$annotations", "getGenericModule", "create", "Lcom/android/repository/api/RepoManager;", "localPath", "Ljava/nio/file/Path;", "repository"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SchemaModule<CommonFactory> getCommonModule() {
            return commonModule;
        }

        @JvmStatic
        public static /* synthetic */ void getCommonModule$annotations() {
        }

        @NotNull
        public final SchemaModule<GenericFactory> getGenericModule() {
            return genericModule;
        }

        @JvmStatic
        public static /* synthetic */ void getGenericModule$annotations() {
        }

        @JvmStatic
        @NotNull
        public final RepoManager create(@Nullable Path localPath) {
            return new RepoManagerImpl(localPath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/repository/api/RepoManager$DirectProgressRunner;", "Lcom/android/repository/api/ProgressRunner;", "progress", "Lcom/android/repository/api/ProgressIndicator;", "<init>", "(Lcom/android/repository/api/ProgressIndicator;)V", "runAsyncWithProgress", "", "r", "Lcom/android/repository/api/ProgressRunner$ProgressRunnable;", "runSyncWithProgress", "runSyncWithoutProgress", "Ljava/lang/Runnable;", "repository"})
    protected static final class DirectProgressRunner
    implements ProgressRunner {
        @NotNull
        private final ProgressIndicator progress;

        public DirectProgressRunner(@NotNull ProgressIndicator progress) {
            Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
            this.progress = progress;
        }

        @Override
        public void runAsyncWithProgress(@NotNull ProgressRunner.ProgressRunnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            r.run(this.progress, this);
        }

        @Override
        public void runSyncWithProgress(@NotNull ProgressRunner.ProgressRunnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            r.run(this.progress, this);
        }

        @Override
        public void runSyncWithoutProgress(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            r.run();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/repository/api/RepoManager$RepoLoadedListener;", "", "loaded", "", "packages", "Lcom/android/repository/impl/meta/RepositoryPackages;", "repository"})
    public static interface RepoLoadedListener {
        public void loaded(@NotNull RepositoryPackages var1);
    }
}

