/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import com.android.ide.common.util.JvmWideVariable;
import com.android.ide.common.util.ReadWriteThreadLock;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class ReadWriteProcessLock {
    private final Lock readLock = new ReadLock();
    private final Lock writeLock = new WriteLock();
    private static final JvmWideVariable<ConcurrentMap<Path, FileChannel>> fileChannelMap = new JvmWideVariable(ReadWriteProcessLock.class.getName(), "fileChannelMap", ReadWriteProcessLock.concurrentMapToken(Path.class, FileChannel.class), new ConcurrentHashMap());
    private static final JvmWideVariable<ConcurrentMap<Path, FileLock>> fileLockMap = new JvmWideVariable(ReadWriteProcessLock.class.getName(), "fileLockMap", ReadWriteProcessLock.concurrentMapToken(Path.class, FileLock.class), new ConcurrentHashMap());
    private final Path lockFile;
    private final ReadWriteThreadLock readWriteThreadLock;
    private final AtomicInteger numOfReadingActions;

    public ReadWriteProcessLock(Path lockFile) {
        Path normalizedLockFile;
        this.lockFile = normalizedLockFile = lockFile.normalize();
        this.readWriteThreadLock = new ReadWriteThreadLock(normalizedLockFile);
        JvmWideVariable map = new JvmWideVariable(ReadWriteProcessLock.class.getName(), "numOfReadingActions", ReadWriteProcessLock.concurrentMapToken(Path.class, AtomicInteger.class), new ConcurrentHashMap());
        this.numOfReadingActions = ((ConcurrentMap)map.get()).computeIfAbsent(lockFile, Path2 -> new AtomicInteger(0));
    }

    public Lock readLock() {
        return this.readLock;
    }

    public Lock writeLock() {
        return this.writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireReadLock() throws IOException {
        this.readWriteThreadLock.readLock().lock();
        try {
            AtomicInteger atomicInteger = this.numOfReadingActions;
            synchronized (atomicInteger) {
                if (this.numOfReadingActions.get() == 0) {
                    this.acquireFileLock(true);
                }
                this.numOfReadingActions.getAndIncrement();
            }
        }
        catch (Throwable throwable) {
            this.readWriteThreadLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseReadLock() throws IOException {
        try {
            AtomicInteger atomicInteger = this.numOfReadingActions;
            synchronized (atomicInteger) {
                if (this.numOfReadingActions.decrementAndGet() == 0) {
                    this.releaseFileLock();
                }
            }
        }
        finally {
            this.readWriteThreadLock.readLock().unlock();
        }
    }

    private void acquireWriteLock() throws IOException {
        this.readWriteThreadLock.writeLock().lock();
        try {
            this.acquireFileLock(false);
        }
        catch (Throwable throwable) {
            this.readWriteThreadLock.writeLock().unlock();
            throw throwable;
        }
    }

    private void releaseWriteLock() throws IOException {
        try {
            this.releaseFileLock();
        }
        finally {
            this.readWriteThreadLock.writeLock().unlock();
        }
    }

    private void acquireFileLock(boolean shared) throws IOException {
        Map channelMap = fileChannelMap.get();
        Map lockMap = fileLockMap.get();
        Preconditions.checkState((!channelMap.containsKey(this.lockFile) && !lockMap.containsKey(this.lockFile) ? 1 : 0) != 0, (Object)"acquireFileLock() must not be called twice (ReadWriteProcessLock is not reentrant)");
        FileChannel fileChannel = FileChannel.open(this.lockFile, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        FileLock fileLock = fileChannel.lock(0L, Long.MAX_VALUE, shared);
        channelMap.put(this.lockFile, fileChannel);
        lockMap.put(this.lockFile, fileLock);
    }

    private void releaseFileLock() throws IOException {
        Map channelMap = fileChannelMap.get();
        Map lockMap = fileLockMap.get();
        FileChannel fileChannel = (FileChannel)channelMap.get(this.lockFile);
        FileLock fileLock = (FileLock)lockMap.get(this.lockFile);
        Preconditions.checkNotNull((Object)fileChannel);
        Preconditions.checkNotNull((Object)fileLock);
        fileLock.release();
        fileChannel.close();
        channelMap.remove(this.lockFile);
        lockMap.remove(this.lockFile);
    }

    private static <K, V> TypeToken<ConcurrentMap<K, V>> concurrentMapToken(Class<K> keyClass, Class<V> valueClass) {
        return new TypeToken<ConcurrentMap<K, V>>(){}.where(new TypeParameter<K>(){}, TypeToken.of(keyClass)).where(new TypeParameter<V>(){}, TypeToken.of(valueClass));
    }

    private final class WriteLock
    implements Lock {
        private WriteLock() {
        }

        @Override
        public void lock() throws IOException {
            ReadWriteProcessLock.this.acquireWriteLock();
        }

        @Override
        public void unlock() throws IOException {
            ReadWriteProcessLock.this.releaseWriteLock();
        }
    }

    private final class ReadLock
    implements Lock {
        private ReadLock() {
        }

        @Override
        public void lock() throws IOException {
            ReadWriteProcessLock.this.acquireReadLock();
        }

        @Override
        public void unlock() throws IOException {
            ReadWriteProcessLock.this.releaseReadLock();
        }
    }

    public static interface Lock {
        public void lock() throws IOException;

        public void unlock() throws IOException;
    }
}

