/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import com.android.ide.common.util.JvmWideVariable;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class BuildSessionVariable<T> {
    private static boolean buildStarted = false;
    private static JvmWideVariable<ConcurrentMap<String, AtomicReference<Object>>> jvmWideVariableTable = null;
    private static Boolean variableTableCreatedByThisClass = null;
    private static Set<BuildSessionVariable> buildSessionVariableSet = Sets.newConcurrentHashSet();
    private AtomicReference<T> variable;
    private final String fullName;
    private final Supplier<T> defaultValueSupplier;

    public BuildSessionVariable(String group, String name, TypeToken<T> typeToken, Supplier<T> defaultValueSupplier) {
        Type type = typeToken.getType();
        for (Class<?> clazz : JvmWideVariable.collectComponentClasses(type)) {
            Preconditions.checkArgument((clazz.getClassLoader() == null ? 1 : 0) != 0, (String)"Type %s used to define build session variable %s:%s must be loaded by the bootstrap class loader but is loaded by %s", clazz, (Object)group, (Object)name, (Object)clazz.getClassLoader());
        }
        if (!buildStarted) {
            BuildSessionVariable.buildStarted();
        }
        Preconditions.checkNotNull(jvmWideVariableTable);
        ConcurrentMap<String, AtomicReference<Object>> variableTable = jvmWideVariableTable.get();
        Preconditions.checkNotNull(variableTable);
        this.fullName = group + ":" + name;
        this.variable = variableTable.computeIfAbsent(this.fullName, any -> new AtomicReference(defaultValueSupplier.get()));
        this.defaultValueSupplier = defaultValueSupplier;
        buildSessionVariableSet.add(this);
    }

    public BuildSessionVariable(String group, String name, Class<T> type, T defaultValue) {
        this(group, name, TypeToken.of(type), () -> defaultValue);
    }

    public static synchronized void buildStarted() {
        if (buildStarted) {
            return;
        }
        buildStarted = true;
        Preconditions.checkState((jvmWideVariableTable == null ? 1 : 0) != 0);
        Preconditions.checkState((variableTableCreatedByThisClass == null ? 1 : 0) != 0);
        variableTableCreatedByThisClass = false;
        jvmWideVariableTable = new JvmWideVariable<ConcurrentMap>(BuildSessionVariable.class.getName(), "jvmWideVariableTable", new TypeToken<ConcurrentMap<String, AtomicReference<Object>>>(){}, () -> {
            variableTableCreatedByThisClass = true;
            return new ConcurrentHashMap();
        });
        ConcurrentMap<String, AtomicReference<Object>> variableTable = jvmWideVariableTable.get();
        Preconditions.checkNotNull(variableTable);
        for (BuildSessionVariable buildSessionVariable : buildSessionVariableSet) {
            Preconditions.checkState((buildSessionVariable.variable == null ? 1 : 0) != 0);
            buildSessionVariable.variable = variableTable.computeIfAbsent(buildSessionVariable.fullName, any -> new AtomicReference(buildSessionVariable.defaultValueSupplier.get()));
        }
    }

    public static synchronized void buildFinished() {
        if (!buildStarted) {
            return;
        }
        buildStarted = false;
        Preconditions.checkNotNull(jvmWideVariableTable);
        Preconditions.checkNotNull((Object)variableTableCreatedByThisClass);
        if (variableTableCreatedByThisClass.booleanValue()) {
            jvmWideVariableTable.unregister();
        }
        jvmWideVariableTable = null;
        variableTableCreatedByThisClass = null;
        for (BuildSessionVariable buildSessionVariable : buildSessionVariableSet) {
            Preconditions.checkNotNull(buildSessionVariable.variable);
            buildSessionVariable.variable = null;
        }
    }

    public T get() {
        Preconditions.checkNotNull(this.variable);
        return this.variable.get();
    }

    public void set(T value) {
        Preconditions.checkNotNull(this.variable);
        this.variable.set(value);
    }

    public <V> V executeCallableSynchronously(Callable<V> action) throws ExecutionException {
        Preconditions.checkNotNull(this.variable);
        AtomicReference<T> atomicReference = this.variable;
        synchronized (atomicReference) {
            try {
                return action.call();
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
    }

    void unregister() {
        Preconditions.checkNotNull(jvmWideVariableTable);
        ConcurrentMap<String, AtomicReference<Object>> variableTable = jvmWideVariableTable.get();
        Preconditions.checkNotNull(variableTable);
        if (variableTable.containsKey(this.fullName)) {
            variableTable.remove(this.fullName);
        }
        Preconditions.checkNotNull(this.variable);
        this.variable = null;
        Preconditions.checkState((boolean)buildSessionVariableSet.contains(this));
        buildSessionVariableSet.remove(this);
    }
}

