/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.PathParser;
import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.SvgNode;
import com.android.ide.common.vectordrawable.SvgTree;
import com.android.ide.common.vectordrawable.VdPath;
import com.google.common.collect.ImmutableMap;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

class SvgLeafNode
extends SvgNode {
    private static final Logger logger = Logger.getLogger(SvgLeafNode.class.getSimpleName());
    private String mPathData;
    public static final ImmutableMap<String, String> colorMap = ImmutableMap.builder().put((Object)"aliceblue", (Object)"#f0f8ff").put((Object)"antiquewhite", (Object)"#faebd7").put((Object)"aqua", (Object)"#00ffff").put((Object)"aquamarine", (Object)"#7fffd4").put((Object)"azure", (Object)"#f0ffff").put((Object)"beige", (Object)"#f5f5dc").put((Object)"bisque", (Object)"#ffe4c4").put((Object)"black", (Object)"#000000").put((Object)"blanchedalmond", (Object)"#ffebcd").put((Object)"blue", (Object)"#0000ff").put((Object)"blueviolet", (Object)"#8a2be2").put((Object)"brown", (Object)"#a52a2a").put((Object)"burlywood", (Object)"#deb887").put((Object)"cadetblue", (Object)"#5f9ea0").put((Object)"chartreuse", (Object)"#7fff00").put((Object)"chocolate", (Object)"#d2691e").put((Object)"coral", (Object)"#ff7f50").put((Object)"cornflowerblue", (Object)"#6495ed").put((Object)"cornsilk", (Object)"#fff8dc").put((Object)"crimson", (Object)"#dc143c").put((Object)"cyan", (Object)"#00ffff").put((Object)"darkblue", (Object)"#00008b").put((Object)"darkcyan", (Object)"#008b8b").put((Object)"darkgoldenrod", (Object)"#b8860b").put((Object)"darkgray", (Object)"#a9a9a9").put((Object)"darkgrey", (Object)"#a9a9a9").put((Object)"darkgreen", (Object)"#006400").put((Object)"darkkhaki", (Object)"#bdb76b").put((Object)"darkmagenta", (Object)"#8b008b").put((Object)"darkolivegreen", (Object)"#556b2f").put((Object)"darkorange", (Object)"#ff8c00").put((Object)"darkorchid", (Object)"#9932cc").put((Object)"darkred", (Object)"#8b0000").put((Object)"darksalmon", (Object)"#e9967a").put((Object)"darkseagreen", (Object)"#8fbc8f").put((Object)"darkslateblue", (Object)"#483d8b").put((Object)"darkslategray", (Object)"#2f4f4f").put((Object)"darkslategrey", (Object)"#2f4f4f").put((Object)"darkturquoise", (Object)"#00ced1").put((Object)"darkviolet", (Object)"#9400d3").put((Object)"deeppink", (Object)"#ff1493").put((Object)"deepskyblue", (Object)"#00bfff").put((Object)"dimgray", (Object)"#696969").put((Object)"dimgrey", (Object)"#696969").put((Object)"dodgerblue", (Object)"#1e90ff").put((Object)"firebrick", (Object)"#b22222").put((Object)"floralwhite", (Object)"#fffaf0").put((Object)"forestgreen", (Object)"#228b22").put((Object)"fuchsia", (Object)"#ff00ff").put((Object)"gainsboro", (Object)"#dcdcdc").put((Object)"ghostwhite", (Object)"#f8f8ff").put((Object)"gold", (Object)"#ffd700").put((Object)"goldenrod", (Object)"#daa520").put((Object)"gray", (Object)"#808080").put((Object)"grey", (Object)"#808080").put((Object)"green", (Object)"#008000").put((Object)"greenyellow", (Object)"#adff2f").put((Object)"honeydew", (Object)"#f0fff0").put((Object)"hotpink", (Object)"#ff69b4").put((Object)"indianred", (Object)"#cd5c5c").put((Object)"indigo", (Object)"#4b0082").put((Object)"ivory", (Object)"#fffff0").put((Object)"khaki", (Object)"#f0e68c").put((Object)"lavender", (Object)"#e6e6fa").put((Object)"lavenderblush", (Object)"#fff0f5").put((Object)"lawngreen", (Object)"#7cfc00").put((Object)"lemonchiffon", (Object)"#fffacd").put((Object)"lightblue", (Object)"#add8e6").put((Object)"lightcoral", (Object)"#f08080").put((Object)"lightcyan", (Object)"#e0ffff").put((Object)"lightgoldenrodyellow", (Object)"#fafad2").put((Object)"lightgray", (Object)"#d3d3d3").put((Object)"lightgrey", (Object)"#d3d3d3").put((Object)"lightgreen", (Object)"#90ee90").put((Object)"lightpink", (Object)"#ffb6c1").put((Object)"lightsalmon", (Object)"#ffa07a").put((Object)"lightseagreen", (Object)"#20b2aa").put((Object)"lightskyblue", (Object)"#87cefa").put((Object)"lightslategray", (Object)"#778899").put((Object)"lightslategrey", (Object)"#778899").put((Object)"lightsteelblue", (Object)"#b0c4de").put((Object)"lightyellow", (Object)"#ffffe0").put((Object)"lime", (Object)"#00ff00").put((Object)"limegreen", (Object)"#32cd32").put((Object)"linen", (Object)"#faf0e6").put((Object)"magenta", (Object)"#ff00ff").put((Object)"maroon", (Object)"#800000").put((Object)"mediumaquamarine", (Object)"#66cdaa").put((Object)"mediumblue", (Object)"#0000cd").put((Object)"mediumorchid", (Object)"#ba55d3").put((Object)"mediumpurple", (Object)"#9370db").put((Object)"mediumseagreen", (Object)"#3cb371").put((Object)"mediumslateblue", (Object)"#7b68ee").put((Object)"mediumspringgreen", (Object)"#00fa9a").put((Object)"mediumturquoise", (Object)"#48d1cc").put((Object)"mediumvioletred", (Object)"#c71585").put((Object)"midnightblue", (Object)"#191970").put((Object)"mintcream", (Object)"#f5fffa").put((Object)"mistyrose", (Object)"#ffe4e1").put((Object)"moccasin", (Object)"#ffe4b5").put((Object)"navajowhite", (Object)"#ffdead").put((Object)"navy", (Object)"#000080").put((Object)"oldlace", (Object)"#fdf5e6").put((Object)"olive", (Object)"#808000").put((Object)"olivedrab", (Object)"#6b8e23").put((Object)"orange", (Object)"#ffa500").put((Object)"orangered", (Object)"#ff4500").put((Object)"orchid", (Object)"#da70d6").put((Object)"palegoldenrod", (Object)"#eee8aa").put((Object)"palegreen", (Object)"#98fb98").put((Object)"paleturquoise", (Object)"#afeeee").put((Object)"palevioletred", (Object)"#db7093").put((Object)"papayawhip", (Object)"#ffefd5").put((Object)"peachpuff", (Object)"#ffdab9").put((Object)"peru", (Object)"#cd853f").put((Object)"pink", (Object)"#ffc0cb").put((Object)"plum", (Object)"#dda0dd").put((Object)"powderblue", (Object)"#b0e0e6").put((Object)"purple", (Object)"#800080").put((Object)"rebeccapurple", (Object)"#663399").put((Object)"red", (Object)"#ff0000").put((Object)"rosybrown", (Object)"#bc8f8f").put((Object)"royalblue", (Object)"#4169e1").put((Object)"saddlebrown", (Object)"#8b4513").put((Object)"salmon", (Object)"#fa8072").put((Object)"sandybrown", (Object)"#f4a460").put((Object)"seagreen", (Object)"#2e8b57").put((Object)"seashell", (Object)"#fff5ee").put((Object)"sienna", (Object)"#a0522d").put((Object)"silver", (Object)"#c0c0c0").put((Object)"skyblue", (Object)"#87ceeb").put((Object)"slateblue", (Object)"#6a5acd").put((Object)"slategray", (Object)"#708090").put((Object)"slategrey", (Object)"#708090").put((Object)"snow", (Object)"#fffafa").put((Object)"springgreen", (Object)"#00ff7f").put((Object)"steelblue", (Object)"#4682b4").put((Object)"tan", (Object)"#d2b48c").put((Object)"teal", (Object)"#008080").put((Object)"thistle", (Object)"#d8bfd8").put((Object)"tomato", (Object)"#ff6347").put((Object)"turquoise", (Object)"#40e0d0").put((Object)"violet", (Object)"#ee82ee").put((Object)"wheat", (Object)"#f5deb3").put((Object)"white", (Object)"#ffffff").put((Object)"whitesmoke", (Object)"#f5f5f5").put((Object)"yellow", (Object)"#ffff00").put((Object)"yellowgreen", (Object)"#9acd32").build();

    public SvgLeafNode(SvgTree svgTree, Node node, String nodeName) {
        super(svgTree, node, nodeName);
    }

    private String getAttributeValues(ImmutableMap<String, String> presentationMap) {
        this.parsePathOpacity();
        StringBuilder sb = new StringBuilder("/>\n");
        for (String key : this.mVdAttributesMap.keySet()) {
            String vectorDrawableAttr = (String)presentationMap.get((Object)key);
            String svgValue = (String)this.mVdAttributesMap.get(key);
            String vdValue = svgValue.trim();
            if ("none".equals(vdValue)) {
                vdValue = "#00000000";
            } else if (vdValue.endsWith("px")) {
                vdValue = vdValue.substring(0, vdValue.length() - 2);
            } else if (vdValue.startsWith("rgb")) {
                String vdValueRGB = vdValue = vdValue.substring(3, vdValue.length());
                if ((vdValue = this.convertRGBToHex(vdValue)) == null) {
                    this.getTree().logErrorLine("Unsupported Color format " + vdValueRGB, this.getDocumentNode(), SvgTree.SvgLogLevel.ERROR);
                }
            } else if (colorMap.containsKey((Object)vdValue.toLowerCase())) {
                vdValue = (String)colorMap.get((Object)vdValue.toLowerCase());
            }
            String attr = "\n        " + vectorDrawableAttr + "=\"" + vdValue + "\"";
            sb.insert(0, attr);
        }
        return sb.toString();
    }

    private float getOpacityValueFromMap(String key) {
        float result = 1.0f;
        String opacity = (String)this.mVdAttributesMap.get(key);
        if (opacity != null) {
            try {
                result = Float.parseFloat(opacity);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Math.min(Math.max(result, 0.0f), 1.0f);
    }

    private void parsePathOpacity() {
        float opacityInFloat = this.getOpacityValueFromMap("opacity");
        if (opacityInFloat < 1.0f) {
            DecimalFormat df = new DecimalFormat("#.##");
            float fillOpacity = this.getOpacityValueFromMap("fill-opacity");
            float strokeOpacity = this.getOpacityValueFromMap("stroke-opacity");
            this.mVdAttributesMap.put("fill-opacity", df.format(fillOpacity * opacityInFloat));
            this.mVdAttributesMap.put("stroke-opacity", df.format(strokeOpacity * opacityInFloat));
        }
        this.mVdAttributesMap.remove("opacity");
    }

    public static int clamp(int val, int min, int max) {
        return Math.max(min, Math.min(max, val));
    }

    private String convertRGBToHex(String svgValue) {
        String functionValue = svgValue.trim();
        String[] numbers = (functionValue = svgValue.substring(1, functionValue.length() - 1)).split(",");
        if (numbers.length != 3) {
            return null;
        }
        int[] color = new int[3];
        for (int i = 0; i < 3; ++i) {
            String number = numbers[i];
            if ((number = number.trim()).endsWith("%")) {
                float value = Float.parseFloat(number.substring(0, number.length() - 1));
                color[i] = SvgLeafNode.clamp((int)(value * 255.0f / 100.0f), 0, 255);
                continue;
            }
            int value = Integer.parseInt(number);
            color[i] = SvgLeafNode.clamp(value, 0, 255);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("#");
        for (int i = 0; i < 3; ++i) {
            builder.append(String.format("%02X", color[i]));
        }
        String result = builder.toString();
        assert (result.length() == 7);
        return result;
    }

    @Override
    public void dumpNode(String indent) {
        logger.log(Level.FINE, indent + (this.mPathData != null ? this.mPathData : " null pathData ") + (this.mName != null ? this.mName : " null name "));
    }

    public void setPathData(String pathData) {
        this.mPathData = pathData;
    }

    @Override
    public boolean isGroupNode() {
        return false;
    }

    @Override
    public void transformIfNeeded(AffineTransform rootTransform) {
        if (this.mPathData == null) {
            return;
        }
        VdPath.Node[] n = PathParser.parsePath(this.mPathData);
        AffineTransform finalTransform = new AffineTransform(rootTransform);
        finalTransform.concatenate(this.mStackedTransform);
        boolean needsConvertRelativeMoveAfterClose = VdPath.Node.hasRelMoveAfterClose(n);
        if (!finalTransform.isIdentity() || needsConvertRelativeMoveAfterClose) {
            VdPath.Node.transform(finalTransform, n);
        }
        String decimalFormatString = this.getDecimalFormatString();
        this.mPathData = VdPath.Node.NodeListToString(n, decimalFormatString);
    }

    private String getDecimalFormatString() {
        float viewportWidth = this.getTree().getViewportWidth();
        float viewportHeight = this.getTree().getViewportHeight();
        float minSize = Math.min(viewportHeight, viewportWidth);
        float exponent = Math.round(Math.log10(minSize));
        int decimalPlace = (int)Math.floor(exponent - 4.0f);
        StringBuilder decimalFormatStringBuilder = new StringBuilder("#");
        if (decimalPlace < 0) {
            if (decimalPlace < -6) {
                decimalPlace = -6;
            }
            decimalFormatStringBuilder.append('.');
            for (int i = 0; i < -decimalPlace; ++i) {
                decimalFormatStringBuilder.append('#');
            }
        }
        return decimalFormatStringBuilder.toString();
    }

    @Override
    public void flattern(AffineTransform transform) {
        this.mStackedTransform.setTransform(transform);
        this.mStackedTransform.concatenate(this.mLocalTransform);
        if (this.mVdAttributesMap.containsKey("stroke-width") && (this.mStackedTransform.getType() | 6) != 0) {
            this.getTree().logErrorLine("We don't scale the stroke width!", this.getDocumentNode(), SvgTree.SvgLogLevel.WARNING);
        }
    }

    @Override
    public void writeXML(OutputStreamWriter writer) throws IOException {
        boolean nothingToDraw;
        String fillColor = (String)this.mVdAttributesMap.get("fill");
        String strokeColor = (String)this.mVdAttributesMap.get("stroke");
        logger.log(Level.FINE, "fill color " + fillColor);
        boolean emptyFill = fillColor != null && ("none".equals(fillColor) || "#0000000".equals(fillColor));
        boolean emptyStroke = strokeColor == null || "none".equals(strokeColor);
        boolean emptyPath = this.mPathData == null;
        boolean bl = nothingToDraw = emptyPath || emptyFill && emptyStroke;
        if (nothingToDraw) {
            return;
        }
        writer.write("    <path\n");
        if (!this.mVdAttributesMap.containsKey("fill")) {
            logger.log(Level.FINE, "ADDING FILL SVG_FILL_COLOR");
            writer.write("        android:fillColor=\"#FF000000\"\n");
        }
        if (!emptyStroke && !this.mVdAttributesMap.containsKey("stroke-width")) {
            logger.log(Level.FINE, "Adding default stroke width");
            writer.write("        android:strokeWidth=\"1\"\n");
        }
        writer.write("        android:pathData=\"" + this.mPathData + "\"");
        writer.write(this.getAttributeValues(Svg2Vector.presentationMap));
    }

    public void fillPresentationAttributes(String name, String value) {
        if (name.equals("fill-rule")) {
            if (value.equals("nonzero")) {
                value = "nonZero";
            } else if (value.equals("evenodd")) {
                value = "evenOdd";
            }
        }
        this.fillPresentationAttributes(name, value, logger);
    }
}

