/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ResourceVisibilityLookup {
    public static final ResourceVisibilityLookup NONE = new ResourceVisibilityLookup(){

        @Override
        public boolean isPrivate(ResourceType type, String name) {
            return false;
        }

        @Override
        public boolean isKnown(ResourceType type, String name) {
            return false;
        }

        @Override
        public boolean isPublic(ResourceType type, String name) {
            return false;
        }

        @Override
        public AndroidLibrary getPrivateIn(ResourceType type, String name) {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };

    public abstract boolean isPrivate(ResourceType var1, String var2);

    public abstract boolean isPublic(ResourceType var1, String var2);

    protected abstract boolean isKnown(ResourceType var1, String var2);

    public boolean isPrivate(ResourceUrl url) {
        assert (!url.framework);
        return this.isPrivate(url.type, url.name);
    }

    public abstract AndroidLibrary getPrivateIn(ResourceType var1, String var2);

    public abstract boolean isEmpty();

    public static ResourceVisibilityLookup create(AndroidLibrary library) {
        return new LibraryResourceVisibility(library, new SymbolProvider());
    }

    public static ResourceVisibilityLookup create(List<AndroidLibrary> libraries, Provider provider) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)libraries.size());
        for (AndroidLibrary library : libraries) {
            ResourceVisibilityLookup v = provider != null ? provider.get(library) : new LibraryResourceVisibility(library, new SymbolProvider());
            if (v.isEmpty()) continue;
            list.add(v);
        }
        return new MultipleLibraryResourceVisibility(list);
    }

    private static String getMapKey(AndroidLibrary library) {
        MavenCoordinates c = library.getResolvedCoordinates();
        if (c != null) {
            return c.getGroupId() + ':' + c.getArtifactId() + ':' + c.getVersion();
        }
        return library.getBundle().getPath();
    }

    private static String getMapKey(AndroidArtifact artifact) {
        return artifact.getApplicationId();
    }

    private static String getMapKey(Variant variant) {
        return ResourceVisibilityLookup.getMapKey(variant.getMainArtifact()) + '-' + variant.getName();
    }

    private static List<AndroidLibrary> getTransitiveDependencies(AndroidLibrary library) {
        ArrayList result = Lists.newArrayList();
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            ResourceVisibilityLookup.addLibraries(result, new HashSet<String>(), dependency);
        }
        return result;
    }

    private static void addLibraries(List<AndroidLibrary> result, Set<String> seen, AndroidLibrary library) {
        String key = ResourceVisibilityLookup.getMapKey(library);
        if (seen.contains(key)) {
            return;
        }
        seen.add(key);
        result.add(library);
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            ResourceVisibilityLookup.addLibraries(result, seen, dependency);
        }
    }

    static class SymbolProvider {
        private Map<String, Multimap<String, ResourceType>> mCache = Maps.newHashMap();

        SymbolProvider() {
        }

        Multimap<String, ResourceType> getSymbols(AndroidLibrary library) {
            String mapKey = ResourceVisibilityLookup.getMapKey(library);
            Multimap<String, ResourceType> map = this.mCache.get(mapKey);
            if (map != null) {
                return map;
            }
            File symbolFile = new File(library.getPublicResources().getParentFile(), "R.txt");
            if (!symbolFile.exists()) {
                ImmutableListMultimap empty = ImmutableListMultimap.of();
                this.mCache.put(mapKey, (Multimap<String, ResourceType>)empty);
                return empty;
            }
            try {
                List lines = Files.readLines((File)symbolFile, (Charset)Charsets.UTF_8);
                ArrayListMultimap result = ArrayListMultimap.create((int)lines.size(), (int)2);
                ResourceType previousType = null;
                String previousTypeString = "";
                int count = lines.size();
                for (int lineIndex = 1; lineIndex <= count; ++lineIndex) {
                    ResourceType type;
                    String line = (String)lines.get(lineIndex - 1);
                    if (!line.startsWith("int ")) continue;
                    int typeStart = 4;
                    int typeEnd = line.indexOf(32, typeStart);
                    String typeString = line.substring(typeStart, typeEnd);
                    if (typeString.equals(previousTypeString)) {
                        type = previousType;
                    } else {
                        type = ResourceType.getEnum((String)typeString);
                        previousTypeString = typeString;
                        previousType = type;
                    }
                    if (type == null) continue;
                    int nameStart = typeEnd + 1;
                    int nameEnd = line.indexOf(32, nameStart);
                    String name = line.substring(nameStart, nameEnd);
                    result.put((Object)name, (Object)type);
                }
                if (!result.isEmpty()) {
                    for (AndroidLibrary dependency : ResourceVisibilityLookup.getTransitiveDependencies(library)) {
                        Multimap<String, ResourceType> imported = this.getSymbols(dependency);
                        if (imported.isEmpty()) continue;
                        for (Map.Entry entry : imported.entries()) {
                            result.remove(entry.getKey(), entry.getValue());
                        }
                    }
                }
                this.mCache.put(mapKey, (Multimap<String, ResourceType>)result);
                return result;
            }
            catch (IOException ignore) {
                ImmutableListMultimap empty = ImmutableListMultimap.of();
                this.mCache.put(mapKey, (Multimap<String, ResourceType>)empty);
                return empty;
            }
        }
    }

    private static class LibraryResourceVisibility
    extends ResourceVisibilityLookup {
        private final AndroidLibrary mLibrary;
        private final Multimap<String, ResourceType> mAll;
        private final Multimap<String, ResourceType> mPublic;

        private LibraryResourceVisibility(AndroidLibrary library, SymbolProvider symbols) {
            this.mLibrary = library;
            this.mPublic = this.computeVisibilityMap();
            this.mAll = this.mPublic != null ? symbols.getSymbols(library) : null;
        }

        public String toString() {
            return ResourceVisibilityLookup.getMapKey(this.mLibrary);
        }

        @Override
        public boolean isEmpty() {
            return this.mPublic == null;
        }

        @Override
        public AndroidLibrary getPrivateIn(ResourceType type, String name) {
            if (this.isPrivate(type, name)) {
                return this.mLibrary;
            }
            return null;
        }

        private Multimap<String, ResourceType> computeVisibilityMap() {
            File publicResources = this.mLibrary.getPublicResources();
            if (!publicResources.exists()) {
                return null;
            }
            try {
                List lines = Files.readLines((File)publicResources, (Charset)Charsets.UTF_8);
                ArrayListMultimap result = ArrayListMultimap.create((int)lines.size(), (int)2);
                for (String line : lines) {
                    String typeString;
                    ResourceType type;
                    int index = line.indexOf(32);
                    if (index == -1 || line.isEmpty() || (type = ResourceType.getEnum((String)(typeString = line.substring(0, index)))) == null) continue;
                    String name = line.substring(index + 1);
                    name = name.replace('.', '_');
                    result.put((Object)name, (Object)type);
                }
                return result;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        public boolean isPrivate(ResourceType type, String name) {
            if (this.mPublic == null) {
                return false;
            }
            if (!this.mAll.containsEntry((Object)name, (Object)type)) {
                return false;
            }
            return !this.mPublic.containsEntry((Object)name, (Object)type);
        }

        @Override
        public boolean isKnown(ResourceType type, String name) {
            return this.mAll.containsEntry((Object)name, (Object)type);
        }

        @Override
        public boolean isPublic(ResourceType type, String name) {
            return this.isKnown(type, name) && (this.mPublic == null || this.mPublic.containsEntry((Object)name, (Object)type));
        }
    }

    public static class Provider {
        private Map<Object, ResourceVisibilityLookup> mInstances = Maps.newHashMap();
        private SymbolProvider mSymbols = new SymbolProvider();

        public ResourceVisibilityLookup get(AndroidLibrary library) {
            String key = ResourceVisibilityLookup.getMapKey(library);
            ResourceVisibilityLookup visibility = this.mInstances.get(key);
            if (visibility == null) {
                List dependsOn;
                visibility = new LibraryResourceVisibility(library, this.mSymbols);
                if (visibility.isEmpty()) {
                    visibility = NONE;
                }
                if (!(dependsOn = library.getLibraryDependencies()).isEmpty()) {
                    ArrayList list = Lists.newArrayListWithExpectedSize((int)(dependsOn.size() + 1));
                    list.add(visibility);
                    for (AndroidLibrary d : dependsOn) {
                        ResourceVisibilityLookup v = this.get(d);
                        if (v.isEmpty()) continue;
                        list.add(v);
                    }
                    if (list.size() > 1) {
                        visibility = new MultipleLibraryResourceVisibility(list);
                    }
                }
                this.mInstances.put(key, visibility);
            }
            return visibility;
        }

        public ResourceVisibilityLookup get(AndroidArtifact artifact) {
            String key = ResourceVisibilityLookup.getMapKey(artifact);
            ResourceVisibilityLookup visibility = this.mInstances.get(key);
            if (visibility == null) {
                Collection dependsOn = artifact.getDependencies().getLibraries();
                ArrayList list = Lists.newArrayListWithExpectedSize((int)(dependsOn.size() + 1));
                for (AndroidLibrary d : dependsOn) {
                    ResourceVisibilityLookup v = this.get(d);
                    if (v.isEmpty()) continue;
                    list.add(v);
                }
                int size = list.size();
                visibility = size == 0 ? NONE : (size == 1 ? (ResourceVisibilityLookup)list.get(0) : new MultipleLibraryResourceVisibility(list));
                this.mInstances.put(key, visibility);
            }
            return visibility;
        }

        public static boolean isVisibilityAwareModel(AndroidProject project) {
            String modelVersion = project.getModelVersion();
            return !modelVersion.startsWith("1.0") && !modelVersion.startsWith("1.1") && project.getApiVersion() >= 3;
        }

        public ResourceVisibilityLookup get(AndroidProject project, Variant variant) {
            String key = ResourceVisibilityLookup.getMapKey(variant);
            ResourceVisibilityLookup visibility = this.mInstances.get(key);
            if (visibility == null) {
                if (Provider.isVisibilityAwareModel(project)) {
                    AndroidArtifact artifact = variant.getMainArtifact();
                    visibility = this.get(artifact);
                } else {
                    visibility = NONE;
                }
                this.mInstances.put(key, visibility);
            }
            return visibility;
        }
    }

    private static class MultipleLibraryResourceVisibility
    extends ResourceVisibilityLookup {
        private final List<ResourceVisibilityLookup> mRepositories;

        public MultipleLibraryResourceVisibility(List<ResourceVisibilityLookup> repositories) {
            this.mRepositories = repositories;
        }

        @Override
        public boolean isPrivate(ResourceType type, String name) {
            int n = this.mRepositories.size();
            for (int i = 0; i < n; ++i) {
                ResourceVisibilityLookup lookup = this.mRepositories.get(i);
                if (!lookup.isPublic(type, name)) continue;
                return false;
            }
            return this.isKnown(type, name);
        }

        @Override
        public boolean isKnown(ResourceType type, String name) {
            int n = this.mRepositories.size();
            for (int i = 0; i < n; ++i) {
                ResourceVisibilityLookup lookup = this.mRepositories.get(i);
                if (!lookup.isKnown(type, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isPublic(ResourceType type, String name) {
            int n = this.mRepositories.size();
            for (int i = 0; i < n; ++i) {
                ResourceVisibilityLookup lookup = this.mRepositories.get(i);
                if (!lookup.isPublic(type, name) || !lookup.isKnown(type, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            int n = this.mRepositories.size();
            for (int i = 0; i < n; ++i) {
                if (this.mRepositories.get(i).isEmpty()) continue;
                return false;
            }
            return true;
        }

        @Override
        public AndroidLibrary getPrivateIn(ResourceType type, String name) {
            int n = this.mRepositories.size();
            for (int i = 0; i < n; ++i) {
                ResourceVisibilityLookup r = this.mRepositories.get(i);
                if (!r.isPrivate(type, name)) continue;
                return r.getPrivateIn(type, name);
            }
            return null;
        }

        public String toString() {
            return this.mRepositories.toString();
        }
    }
}

