/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.MavenRepositories;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public enum SdkMavenRepository {
    ANDROID("android"),
    GOOGLE("google");

    private final String mDir;

    private SdkMavenRepository(String dir) {
        this.mDir = dir;
    }

    public File getRepositoryLocation(File sdkHome, boolean requireExists, FileOp fileOp) {
        if (sdkHome != null) {
            File dir = new File(sdkHome, "extras" + File.separator + this.mDir + File.separator + "m2repository");
            if (!requireExists || fileOp.isDirectory(dir)) {
                return dir;
            }
        }
        return null;
    }

    public boolean isInstalled(File sdkHome, FileOp fileOp) {
        return this.getRepositoryLocation(sdkHome, true, fileOp) != null;
    }

    public boolean isInstalled(AndroidSdkHandler sdkHandler) {
        if (sdkHandler != null) {
            ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
            RepoManager mgr = sdkHandler.getSdkManager((ProgressIndicator)progress);
            return mgr.getPackages().getLocalPackages().containsKey(this.getPackageId());
        }
        return false;
    }

    public String getPackageId() {
        return String.format("extras;%s;%s", this.mDir, "m2repository");
    }

    @Deprecated
    public GradleCoordinate getHighestInstalledVersion(File sdkHome, String groupId, String artifactId, String filter, boolean allowPreview) {
        return this.getHighestInstalledVersion(sdkHome, groupId, artifactId, filter, allowPreview, FileOpUtils.create());
    }

    public GradleCoordinate getHighestInstalledVersion(File sdkHome, String groupId, String artifactId, String filter, boolean allowPreview, FileOp fileOp) {
        File repository = this.getRepositoryLocation(sdkHome, true, fileOp);
        if (repository != null) {
            return MavenRepositories.getHighestInstalledVersion(groupId, artifactId, repository, filter, allowPreview, fileOp);
        }
        return null;
    }

    public static SdkMavenRepository find(File sdkLocation, String groupId, String artifactId, FileOp fileOp) {
        for (SdkMavenRepository repository : SdkMavenRepository.values()) {
            File artifactIdDirectory;
            File repositoryLocation = repository.getRepositoryLocation(sdkLocation, true, fileOp);
            if (repositoryLocation == null || !fileOp.exists(artifactIdDirectory = MavenRepositories.getArtifactIdDirectory(repositoryLocation, groupId, artifactId))) continue;
            return repository;
        }
        return null;
    }

    public String getDirName() {
        return this.mDir;
    }

    public static GradleCoordinate getCoordinateFromSdkPath(String path) {
        String prefix = String.join((CharSequence)Character.toString(';'), "extras", "m2repository", "");
        if (!path.startsWith(prefix)) {
            return null;
        }
        ArrayList components = Lists.newArrayList((Object[])path.split(Character.toString(';')));
        String version = (String)components.remove(components.size() - 1);
        String artifact = (String)components.remove(components.size() - 1);
        String group = String.join((CharSequence)".", components.subList(2, components.size()));
        List<GradleCoordinate.RevisionComponent> revisionComponents = GradleCoordinate.parseRevisionNumber(version);
        return new GradleCoordinate(group, artifact, revisionComponents.toArray(new GradleCoordinate.RevisionComponent[revisionComponents.size()]));
    }

    public static RepoPackage findBestPackageMatching(GradleCoordinate coordinate, Collection<? extends RepoPackage> packages) {
        RepoPackage result = null;
        GradleCoordinate resultCoordinate = null;
        for (RepoPackage repoPackage : packages) {
            GradleCoordinate test = SdkMavenRepository.getCoordinateFromSdkPath(repoPackage.getPath());
            if (test == null || !test.matches(coordinate) || resultCoordinate != null && GradleCoordinate.COMPARE_PLUS_LOWER.compare(test, resultCoordinate) <= 0) continue;
            result = repoPackage;
            resultCoordinate = test;
        }
        return result;
    }

    public static LocalPackage findLatestLocalVersion(GradleCoordinate coordinate, AndroidSdkHandler sdkHandler, ProgressIndicator progress) {
        if (coordinate.getGroupId() == null || coordinate.getArtifactId() == null) {
            return null;
        }
        String prefix = DetailsTypes.MavenType.getRepositoryPath((String)coordinate.getGroupId(), (String)coordinate.getArtifactId(), null);
        return sdkHandler.getLatestLocalPackageForPrefix(prefix, coordinate.isPreview(), GradleCoordinate::parseVersionOnly, GradleCoordinate.COMPARE_PLUS_LOWER, progress);
    }

    public static RemotePackage findLatestRemoteVersion(GradleCoordinate coordinate, AndroidSdkHandler sdkHandler, ProgressIndicator progress) {
        if (coordinate.getGroupId() == null || coordinate.getArtifactId() == null) {
            return null;
        }
        String prefix = DetailsTypes.MavenType.getRepositoryPath((String)coordinate.getGroupId(), (String)coordinate.getArtifactId(), null);
        return sdkHandler.getLatestRemotePackageForPrefix(prefix, coordinate.isPreview(), GradleCoordinate::parseVersionOnly, GradleCoordinate.COMPARE_PLUS_LOWER, progress);
    }

    public static RepoPackage findLatestVersion(GradleCoordinate coordinate, AndroidSdkHandler sdkHandler, ProgressIndicator progress) {
        GradleCoordinate remoteCoordinate;
        LocalPackage local = SdkMavenRepository.findLatestLocalVersion(coordinate, sdkHandler, progress);
        RemotePackage remote = SdkMavenRepository.findLatestRemoteVersion(coordinate, sdkHandler, progress);
        if (local == null) {
            return remote;
        }
        if (remote == null) {
            return local;
        }
        GradleCoordinate localCoordinate = SdkMavenRepository.getCoordinateFromSdkPath(local.getPath());
        if (GradleCoordinate.COMPARE_PLUS_LOWER.compare(localCoordinate, remoteCoordinate = SdkMavenRepository.getCoordinateFromSdkPath(remote.getPath())) < 0) {
            return remote;
        }
        return local;
    }
}

