/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import com.android.ide.common.util.BuildSessionVariable;
import com.android.ide.common.util.ReadWriteThreadLock;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class ReadWriteProcessLock {
    private final Lock readLock = new ReadLock();
    private final Lock writeLock = new WriteLock();
    private static final BuildSessionVariable<ConcurrentMap<File, FileChannel>> fileChannelMap = new BuildSessionVariable<ConcurrentMap>(ReadWriteProcessLock.class.getName(), "fileChannelMap", new TypeToken<ConcurrentMap<File, FileChannel>>(){}, ConcurrentHashMap::new);
    private static final BuildSessionVariable<ConcurrentMap<File, FileLock>> fileLockMap = new BuildSessionVariable<ConcurrentMap>(ReadWriteProcessLock.class.getName(), "fileLockMap", new TypeToken<ConcurrentMap<File, FileLock>>(){}, ConcurrentHashMap::new);
    private static final BuildSessionVariable<ConcurrentMap<File, AtomicInteger>> numOfReadingActionsMap = new BuildSessionVariable<ConcurrentMap>(ReadWriteProcessLock.class.getName(), "numOfReadingActionsMap", new TypeToken<ConcurrentMap<File, AtomicInteger>>(){}, ConcurrentHashMap::new);
    private final File lockFile;
    private final ReadWriteThreadLock readWriteThreadLock;
    private final AtomicInteger numOfReadingActions;

    public ReadWriteProcessLock(File lockFile) {
        try {
            lockFile = lockFile.getCanonicalFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Preconditions.checkArgument((boolean)FileUtils.parentDirExists((File)lockFile), (Object)("Parent directory of " + lockFile.getAbsolutePath() + " does not exist"));
        Preconditions.checkArgument((!lockFile.exists() || lockFile.isFile() && lockFile.length() == 0L ? 1 : 0) != 0, (Object)("Unexpected lock file found: " + lockFile.getAbsolutePath() + " with length=" + lockFile.length()));
        this.lockFile = lockFile;
        this.readWriteThreadLock = new ReadWriteThreadLock(lockFile);
        ConcurrentMap<File, AtomicInteger> map = numOfReadingActionsMap.get();
        Preconditions.checkNotNull(map);
        this.numOfReadingActions = map.computeIfAbsent(lockFile, any -> new AtomicInteger(0));
    }

    public Lock readLock() {
        return this.readLock;
    }

    public Lock writeLock() {
        return this.writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireReadLock() throws IOException {
        this.readWriteThreadLock.readLock().lock();
        try {
            AtomicInteger atomicInteger = this.numOfReadingActions;
            synchronized (atomicInteger) {
                if (this.numOfReadingActions.get() == 0) {
                    this.acquireFileLock(true);
                }
                this.numOfReadingActions.getAndIncrement();
            }
        }
        catch (Throwable throwable) {
            this.readWriteThreadLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseReadLock() throws IOException {
        try {
            AtomicInteger atomicInteger = this.numOfReadingActions;
            synchronized (atomicInteger) {
                if (this.numOfReadingActions.decrementAndGet() == 0) {
                    this.releaseFileLock();
                }
            }
        }
        finally {
            this.readWriteThreadLock.readLock().unlock();
        }
    }

    private void acquireWriteLock() throws IOException {
        this.readWriteThreadLock.writeLock().lock();
        try {
            this.acquireFileLock(false);
        }
        catch (Throwable throwable) {
            this.readWriteThreadLock.writeLock().unlock();
            throw throwable;
        }
    }

    private void releaseWriteLock() throws IOException {
        try {
            this.releaseFileLock();
        }
        finally {
            this.readWriteThreadLock.writeLock().unlock();
        }
    }

    private void acquireFileLock(boolean shared) throws IOException {
        Map channelMap = fileChannelMap.get();
        Map lockMap = fileLockMap.get();
        Preconditions.checkNotNull((Object)channelMap);
        Preconditions.checkNotNull((Object)lockMap);
        Preconditions.checkState((!channelMap.containsKey(this.lockFile) && !lockMap.containsKey(this.lockFile) ? 1 : 0) != 0, (Object)"acquireFileLock() must not be called twice (ReadWriteProcessLock is not reentrant)");
        FileChannel fileChannel = FileChannel.open(this.lockFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        FileLock fileLock = fileChannel.lock(0L, Long.MAX_VALUE, shared);
        channelMap.put(this.lockFile, fileChannel);
        lockMap.put(this.lockFile, fileLock);
    }

    private void releaseFileLock() throws IOException {
        Map channelMap = fileChannelMap.get();
        Map lockMap = fileLockMap.get();
        Preconditions.checkNotNull((Object)channelMap);
        Preconditions.checkNotNull((Object)lockMap);
        FileChannel fileChannel = (FileChannel)channelMap.get(this.lockFile);
        FileLock fileLock = (FileLock)lockMap.get(this.lockFile);
        Preconditions.checkNotNull((Object)fileChannel);
        Preconditions.checkNotNull((Object)fileLock);
        fileLock.release();
        fileChannel.close();
        channelMap.remove(this.lockFile);
        lockMap.remove(this.lockFile);
    }

    private final class WriteLock
    implements Lock {
        private WriteLock() {
        }

        @Override
        public void lock() throws IOException {
            ReadWriteProcessLock.this.acquireWriteLock();
        }

        @Override
        public void unlock() throws IOException {
            ReadWriteProcessLock.this.releaseWriteLock();
        }
    }

    private final class ReadLock
    implements Lock {
        private ReadLock() {
        }

        @Override
        public void lock() throws IOException {
            ReadWriteProcessLock.this.acquireReadLock();
        }

        @Override
        public void unlock() throws IOException {
            ReadWriteProcessLock.this.releaseReadLock();
        }
    }

    public static interface Lock {
        public void lock() throws IOException;

        public void unlock() throws IOException;
    }
}

